# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bento',
 'bento.commands',
 'bento.content',
 'bento.extra',
 'bento.formatter',
 'bento.tool',
 'bento.tool.runner']

package_data = \
{'': ['*'], 'bento': ['configs/*'], 'bento.extra': ['eslint/*']}

install_requires = \
['PyYAML>=5.1.2',
 'attrs>=18.2.0,<=19.3.0',
 'click>=7.0,<8.0',
 'docker>=3.7,<4.0',
 'frozendict>=1.2,<2.0',
 'gitpython>=2.1,<3.0',
 'packaging>=14.0',
 'pre-commit>=1.0.0,<=1.18.3',
 'psutil>=5.6.3,<5.7.0',
 'pymmh3>=0.0.5,<0.1.0',
 'semantic-version>=2.8.0,<2.9.0',
 'tqdm>=4.36.1,<4.37.0',
 'validate-email>=1.3,<2.0']

entry_points = \
{'console_scripts': ['bento = bento.__main__:main']}

setup_kwargs = {
    'name': 'bento-cli',
    'version': '0.13.0b1',
    'description': 'Free program analysis focused on bugs that matter to you.',
    'long_description': '<p align="center">\n    <img src="https://raw.githubusercontent.com/returntocorp/bento/master/bento-logo.png" height="100" alt="Bento logo"/>\n</p>\n<h3 align="center">\n  Find Python web-app bugs delightfully fast, without changing your workflow\n</h3>\n\n<p align="center">\n  <a href="#installation">Installation</a>\n  <span> · </span>\n  <a href="#motivations">Motivations</a>\n  <span> · </span>\n  <a href="#code-checks">Code Checks</a>\n  <span> · </span>\n  <a href="#usage">Usage</a>\n  <br/>\n  <a href="#workflows">Workflows</a>\n  <span> · </span>\n  <a href="#running-in-cicd">Integrations</a>\n  <span> · </span>\n  <a href="#help-and-community">Help & Community</a>\n</p>\n\n<p align="center">\n  <a href="https://pypi.org/project/bento-cli/">\n    <img alt="PyPI" src="https://img.shields.io/pypi/v/bento-cli?style=flat-square&color=blue">\n  </a>\n  <a href="https://pypi.org/project/bento-cli/">\n    <img alt="PyPI - Downloads" src="https://img.shields.io/pypi/dm/bento-cli?style=flat-square&color=green">\n  </a>\n  <a href="https://github.com/returntocorp/bento/issues/new/choose">\n    <img src="https://img.shields.io/badge/issues-welcome-green?style=flat-square" alt="Issues welcome!" />\n  </a>\n  <a href="https://twitter.com/intent/follow?screen_name=r2cdev">\n    <img src="https://img.shields.io/twitter/follow/r2cdev?label=Follow%20r2cdev&style=social&color=blue" alt="Follow @r2cdev" />\n  </a>\n</p>\n\nInspired by tools like the ESLint plugin for React, Bento was created for Flask and Django. With Bento you’ll:\n\n- **Find bugs that matter.** Checks find security and reliability bugs in your code. They’re vetted across thousands of open source projects and never nit your style.\n- **Upgrade your tooling.** You don’t have to fix existing bugs to adopt Bento. It’s diff-centric, finding new bugs introduced by your changes. And there’s zero config.\n- **Go delightfully fast.** Run Bento automatically locally or in CI. Either way, it runs offline and never sends your code anywhere.\n\n<p align="center">\n    <img src="https://web-assets.r2c.dev/bento-demo.gif" width="100%" alt="Demonstrating Bento running in a terminal"/>\n</p>\n\n## Installation\n\nBento is free and requires [Python 3.6+](https://www.python.org/downloads/) and [Docker 19.03+](https://docs.docker.com/get-docker/). It runs on macOS and Linux.\n\nIn a Git project directory:\n\n```bash\n$ pip3 install bento-cli && bento init\n```\n\nGo forth and write great code!\n\n## Motivations\n\n> See our [Bento introductory blog post](https://bento.dev/blog/2019/our-quest-to-make-world-class-security-and-bugfinding-available-to-all-developers/) to learn the full story.\n\nBento is part of a quest to make world-class security and bugfinding available to all developers, for free. We’ve learned that most developers have never heard of—let alone tried—tools that find deep flaws in code: like Codenomicon, which found [Heartbleed](http://heartbleed.com/), or Zoncolan at Facebook, which finds more [top-severity security issues](https://cacm.acm.org/magazines/2019/8/238344-scaling-static-analyses-at-facebook/fulltext) than any human effort. These tools find severe issues and also save tons of time, identifying [hundreds of thousands of issues](https://static.googleusercontent.com/media/research.google.com/en//pubs/archive/43322.pdf) before humans can. Bento is a step towards universal access to tools like these.\n\nWe’re also big proponents of opinionated tools like [Black](https://github.com/psf/black) and [Prettier](https://github.com/prettier/prettier). This has two implications: Bento ignores style-related issues and the bikeshedding that comes with them, and it ships with a curated set of checks that we believe are high signal and bug-worthy. See [Three things your linter shouldn’t tell you](https://bento.dev/blog/2019/three-things-your-linter-shouldnt-tell-you/) for more about our decision making process.\n\n## Code Checks\n\nBento’s check focus on security and reliability bugs in Flask and Django projects.\n\n|                              |                                      |                                                      |\n| ---------------------------- | ------------------------------------ | ---------------------------------------------------- |\n| **Flask**                    | **Jinja**                            | **Django**                                           |\n| missing JWT token            | href template variable               | _coming soon_                                        |\n| secure set cookie            | missing noopener                     |                                                      |\n| send file open               | missing noreferrer                   | **Docker**                                           |\n| unescaped file extension     | missing csrf protection              | [Hadolint](https://github.com/hadolint/hadolint)     |\n| use blueprint for modularity | missing doctype                      |                                                      |\n| use jsonify                  | meta charset                         | **Shell**                                            |\n| avoid hardcoded config       | meta content-type                    | [ShellCheck](https://github.com/koalaman/shellcheck) |\n|                              | unquoted attribute template variable |\n| **Requests**                 |                                      |\n| no auth over http            | **SQLAlchemy**                       |                                                      |\n| use scheme                   | _coming soon_                        |                                                      |\n| use timeout                  |                                      |\n\nSee the full list of [Bento’s specialty checks](https://bento.dev/checks/).\n\n## Usage\n\nOut-of-the-box, Bento is configured for your personal use. See [Team Use](#team-use) to setup Bento for all contributors.\n\n### Upgrading\n\n```bash\n$ pip3 install --upgrade bento-cli\n```\n\n### Command Line Options\n\n```\n$ bento --help\nUsage: bento [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  -h, --help    Show this message and exit.\n  --version     Show the version and exit.\n  --agree       Automatically agree to terms of service.\n  --email TEXT  Email address to use while running this command without global\n                configs e.g. in CI\n\nCommands:\n  archive  Suppress current findings.\n  check    Checks for new findings.\n  disable  Turn OFF a Bento feature for this project.\n  enable   Turn ON a Bento feature for this project.\n  init     Autodetects and installs tools.\n\n  To get help for a specific command, run `bento COMMAND --help`\n```\n\n### Exit Codes\n\n`bento check` may exit with the following exit codes:\n\n- `0`: Bento ran successfully and found no errors\n- `2`: Bento ran successfully and found issues in your code\n- `3`: Bento or one of its underlying tools failed to run\n\n## Workflows\n\n### Individual Use\n\nBento understands the importance of getting out of the way so you can write your code. It runs at commit-time on your diffs and only affects you; it won’t change anything for other project contributors or modify Git state.\n\nInitialization enables `autorun` behind the scenes. By default `autorun` blocks the commit if Bento returns findings. To make it non-blocking:\n\n```bash\n$ bento enable autorun --no-block\n```\n\nYou can always manually run Bento on staged files or directories via:\n\n```bash\n$ bento check [PATHS]\n```\n\nThis will show only new findings introduced by these files AND that are not in the archive (`.bento/archive.json`). Use `--all` to check all Git tracked files, not just those that are staged:\n\n```bash\n$ bento check --all [PATHS]\n```\n\nThis feature makes use of Git hooks. If the Bento hook incorrectly blocks your commit, you can skip it by passing the `--no-verify` flag to Git at commit-time (please use this sparingly since all hooks will be skipped):\n\n```bash\n$ git commit --no-verify\n```\n\n### Team Use\n\n#### Running Locally\n\nTo setup Bento for all project contributors, add Bento’s configuration to Git (it’s ignored by default):\n\n```bash\n$ cd <PROJECT DIRECTORY>\n# Add Bento\'s cache to the project\'s .gitignore\n$ echo ".bento/cache" >> .gitignore\n# Commit Bento\'s config to your project\n$ git add --force .bento .bentoignore\n```\n\nContributors can run Bento for themselves using the project’s configuration via:\n\n```bash\n$ bento init\n```\n\n#### Running in CI/CD\n\nBento has first-class support for checking pull requests with GitHub Actions.\nSuch checks will report only on the bugs introduced by the changes in the pull request.\n\nTo get started, just run `bento enable ci` in your project directory.\nThis will add a CI configuration file to your repository.\n\n#### Advanced CI/CD configuration\n\nYou can also configure Bento in CI to analyze your entire project,\ninstead of only the changes from a pull request.\nSo that you don’t have to fix all existing issues before making Bento blocking,\nits `archive` feature allows historical issues to be tracked and ignored during CI.\n\nTo use the `archive` feature so Bento returns a non-zero exit code only for new issues, rather than all existing issues, first create the archive:\n\n```bash\n$ cd <PROJECT DIRECTORY>\n$ bento archive .\n```\n\nCommit Bento’s configuration to the project:\n\n```bash\n# Add Bento\'s cache to the project\'s .gitignore\n$ echo ".bento/cache" >> .gitignore\n# Commit Bento\'s config to your project\n$ git add --force .bento .bentoignore\n```\n\nYou can then add Bento to your CI scripts:\n\n```bash\n$ pip3 install bento-cli && bento --version\n$ bento --agree --email=<YOUR_EMAIL> check --all 2>&1 | cat\n```\n\nWe pipe through `cat` to disable Bento\'s interactive tty features (e.g. progress bars, using a pager for many findings).\n\nIf you use CircleCI, the above commands become:\n\n```yaml\nversion: 2.1\n\njobs:\n  bentoCheck:\n  executor: circleci/python:3.7.4-stretch-node\n  steps:\n    - checkout\n    - run:\n        name: "Install Bento"\n        command: pip3 install bento-cli && bento --version\n    - run:\n        name: "Run Bento check"\n        command: bento --agree --email=<YOUR_EMAIL> check --all 2>&1 | cat\n```\n\n`bento check` will exit with a non-zero exit code if it finds issues in your code (see [Exit Codes](#exit-codes)).\n\nIf you need help setting up Bento with another CI provider please [open an issue](https://github.com/returntocorp/bento/issues/new?template=feature_request.md). Documentation PRs welcome if you set up Bento with a CI provider that isn’t documented here!\n\n## Help and Community\n\nNeed help or want to share feedback? We’d love to hear from you!\n\n- Email us at [support@r2c.dev](mailto:support@r2c.dev)\n- Join #bento in our [community Slack](https://join.slack.com/t/r2c-community/shared_invite/enQtNjU0NDYzMjAwODY4LWE3NTg1MGNhYTAwMzk5ZGRhMjQ2MzVhNGJiZjI1ZWQ0NjQ2YWI4ZGY3OGViMGJjNzA4ODQ3MjEzOWExNjZlNTA)\n- [File an issue](https://github.com/returntocorp/bento/issues/new?assignees=&labels=bug&template=bug_report.md&title=) or [submit a feature request](https://github.com/returntocorp/bento/issues/new?assignees=&labels=feature-request&template=feature_request.md&title=) directly on GitHub &mdash; we welcome them all!\n\nWe’re constantly shipping new features and improvements.\n\n- [Sign up for the Bento newsletter](http://eepurl.com/gDeFvL) &mdash; we promise not to spam and you can unsubscribe at any time\n- See past announcements, releases, and issues [here](https://us18.campaign-archive.com/home/?u=ee2dc8f77e27d3739cf4df9ef&id=d13f5e938e)\n\nWe’re fortunate to benefit from the contributions of the open source community and great projects such as [Bandit](https://pypi.org/project/bandit/), [ESLint](https://eslint.org/), [Flake8](https://pypi.org/project/flake8/), and their plugins. 🙏\n\n## License and Legal\n\nPlease refer to the [terms and privacy document](https://github.com/returntocorp/bento/blob/master/PRIVACY.md).\n\n</br>\n</br>\n<p align="center">\n    <img src="https://web-assets.r2c.dev/r2c-logo-silhouette.png?gh" height="24" alt="r2c logo"/>\n</p>\n<p align="center">\n    Copyright (c) <a href="https://r2c.dev">r2c</a>.\n</p>\n',
    'author': 'Return To Corporation',
    'author_email': 'hello@r2c.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://bento.dev',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
