# AUTOGENERATED! DO NOT EDIT! File to edit: 04_odds_ratio.ipynb (unless otherwise specified).

__all__ = ['RsidComboInfo', 'get_geno_combination_df']

# Cell
import pandas as pd
from typing import Any, Dict, List, Optional, Literal, Union
from dataclasses import dataclass

# Cell

@dataclass
class RsidComboInfo():
    df: pd.DataFrame
    rsid_list: List[str]
    NA_val: str

    def query(self, **rsid_dict):
        if not all([rsid in self.rsid_list for rsid in rsid_dict.keys()]):
            raise ValueError("Some Rsid are not in the dataframe")
        filtered_df = self.df.copy()
        for rsid, geno in rsid_dict.items():
            filtered_df = filtered_df.query(f"{rsid} == '{geno}'")
        return filtered_df

    def get_all_genos(self, rsid:str):
        return self.df[rsid].unique()

    @property
    def total_samples_with_NA(self):
        return self.df.unique_samples_count.sum()

    @property
    def num_samples_NA(self):
        return self.df.loc[(self.df[self.rsid_list] == self.NA_val).any(axis=1)].unique_samples_count.sum()
    @property
    def total_samples_no_NA(self):
        return self.total_samples_with_NA  - self.num_samples_NA

    def __repr__(self):
        return f"{self.__class__}(rsid_list = {self.rsid_list}, NA_val = '{self.NA_val}')"

def get_geno_combination_df(geno_each_sample_df: pd.DataFrame, rsid_list:List[str], NA_val="NA", as_df= False):
    #geno_each_sample_df[["rs77948203", "rs1014626", "rs1004237"]].reset_index().groupby(["rs77948203", "rs1014626", "rs1004237"])["sample_id"].unique().reset_index()
    geno_combination_df = geno_each_sample_df[rsid_list].fillna(NA_val).reset_index().groupby(rsid_list)["sample_id"].agg(**{"unique_samples_id":"unique", "unique_samples_count": "nunique"}).reset_index()
    if as_df:
        return geno_combination_df
    else:
        info_obj = RsidComboInfo(df= geno_combination_df, rsid_list = rsid_list, NA_val= NA_val)
    return info_obj
