# AUTOGENERATED! DO NOT EDIT! File to edit: datasets_schemas.ipynb (unless otherwise specified).

__all__ = ['SingleFilePathSchema', 'MultipleFilePathSchema', 'CaseControlFilePathSchema']

# Cell

from typing import Any, Dict, List, Optional, Literal, Union

from pydantic import BaseModel
from pydantic.dataclasses import dataclass
from dataclasses import InitVar, asdict
from kedro.io.core import (
    get_protocol_and_path,
)
from pathlib import Path
from fastcore.meta import delegates

# Cell

class SingleFilePathSchema(BaseModel):
    folder: Union[str, Path]
    full_file_name: Union[str, Path]
    file_name: Optional[str] = None
    extension: Optional[str] = None
    split_by_chromosome: Optional[bool] = None

    def __init__(self, **data: Any):
        super().__init__(**data)
        if self.file_name is None or self.extension is None:
            self.file_name, *_, self.extension = self.full_file_name.split(".")

    def get_full_file_path(self, chrom:Optional[int]=None):
        if self.split_by_chromosome and chrom is None:
            raise ValueError("Need chrom number")
        else:
            formatted_file_name = self.full_file_name.format(chrom_num=chrom)
            return (Path(self.folder)/formatted_file_name)

    @property
    def file_path_obj(self):
        return self

    @property
    def protocol_and_path(self):
        return get_protocol_and_path(self.get_full_file_path(chrom="test").as_posix())

    @property
    def protocol(self):
        return self.protocol_and_path[0]

    #validate full file name when split by chrom here
    #throw error when files doesn't have an extension

class MultipleFilePathSchema():
    def __getattr__(self, attr, *args, **kwargs):
        initial_dict = {
            k: getattr(v, attr)
            for k, v in self.to_dict().items()
        }

        first_ele = list(initial_dict.values())[0]

        #if we are accessing a function
        if callable(first_ele):
            return self.func_factory(initial_dict, first_ele)
        else:
            return initial_dict

    @staticmethod
    def func_factory(func_dict, sample_func):
        @delegates(sample_func)
        def returned_func(**kwargs):
            return {
                k: func(**kwargs) for k,func in func_dict.items()
            }
        return returned_func

    def to_dict(self):
        return asdict(self)

    def apply_func(self, func, **kwargs):
        print(func)
        print(self.to_dict().items())
        return {
            k: func(v, **kwargs) for k, v in self.to_dict().items()
        }

@dataclass
class CaseControlFilePathSchema(MultipleFilePathSchema):
    case: SingleFilePathSchema
    control: SingleFilePathSchema
    common_folder : InitVar(Optional[str]) = None

    def __post_init__(self, common_folder):
        if common_folder is not None:
            self.case = SingleFilePathSchema(folder=common_folder, **self.case)
            self.control = SingleFilePathSchema(folder=common_folder, **self.control)

    @property
    def protocol(self):
        if self.case.protocol != self.control.protocol:
            raise ValueError(f"Currently only the same file system for case and control file is supported.\n Case is located in {self.case.protocol} system. Control is located in {self.control.protocol} ")
        return self.case.protocol


#     def __post_init_post_parse__(self, common_folder):
#         self.protocol, _ = self.case.protocol_and_path

