# AUTOGENERATED! DO NOT EDIT! File to edit: 03_datasets_sample_file.ipynb (unless otherwise specified).

__all__ = ['SampleFileFormat']

# Cell
from .schemas import SingleFilePathSchema
from typing import Any, Dict, List, Optional, Literal, Union
from pydantic import BaseModel
from pathlib import Path, PosixPath
from fastcore.meta import delegates
import pandas as pd
from copy import deepcopy

# from enum import Enum
# import numpy as np
# from kedro.io import AbstractVersionedDataSet

# from pydantic.dataclasses import dataclass
# from dataclasses import InitVar, asdict
# from corradin_ovp_utils.datasets import genetic_datasets
# from kedro.io.core import (
#     AbstractVersionedDataSet,
#     DataSetError,
#     Version,
#     get_filepath_str,
#     get_protocol_and_path,
# )
# import fsspec


# from types import SimpleNamespace

# Cell

class SampleFileFormat(BaseModel):
    file_path: SingleFilePathSchema
    pandas_args: Dict[str, Any]
    sample_id_col: str
    cov_cols: List[str]
    missing_col: Optional[str]


    @delegates(pd.read_csv)
    def load(self, **kwargs):
        df = pd.read_csv(filepath_or_buffer = self.filepath, **self.load_args, **kwargs)
        return df

    @property
    def load_args(self):
        load_args = deepcopy(self.pandas_args)
        load_args["index_col"] = self.sample_id_col
        return load_args