# AUTOGENERATED! DO NOT EDIT! File to edit: datasets_genetic_file.ipynb (unless otherwise specified).

__all__ = ['GeneticFileFormat', 'row_vectorize', 'triplicate_converter', 'get_possible_geno_combinations']

# Cell
from ..schemas import SingleFilePathSchema
from typing import Any, Dict, List, Optional, Literal, Union, Protocol
from pydantic import BaseModel
from pathlib import Path, PosixPath

# Cell
class GeneticFileFormat(BaseModel):
    file_path: SingleFilePathSchema#Union[str, Path, Dict[int, Union[str, Path]]]

    def get_resolved_file_path(self, chrom=None):
        return self.file_path.get_full_file_path(chrom=chrom)

def row_vectorize(f):
    @wraps(f)
    def wrapped_f(X, **kwargs):
        rows = X.reshape(-1, X.shape[-1])
        return np.reshape([f(row, **kwargs) for row in rows],
                          X.shape[:-1] + (-1,))
    return wrapped_f


def triplicate_converter(sample_df, *, genotype_df, sample_id, high_lim=.9, low_lim=0.3, NA_val = "NA"):
        """
        takes in allele_list in gen triplicate format and
        return new_list in letter format
        """


        rsid_genotype_df = genotype_df.loc[sample_df.index]
        #all_geno = SimpleNamespace(**test_genfile_format.get_genotypes_df().loc[rsid])

        geno_1, geno_2, geno_3 = [sample_df.astype(float)[col] for col in sample_df]
        homo_ref_cond = (geno_1 >=high_lim) & (geno_2 < low_lim) & (geno_3 < low_lim)
        het_cond = (geno_2 >= high_lim) & (geno_1 < low_lim) & (geno_3 < low_lim)
        homo_alt_cond = (geno_3 >= high_lim) & (geno_1 < low_lim) & (geno_2 < low_lim)
        geno_df =  np.select([homo_ref_cond, het_cond, homo_alt_cond],
                 [rsid_genotype_df["homo_ref"], rsid_genotype_df["het"], rsid_genotype_df["homo_alt"]],
                 default = NA_val)
        geno_df = pd.DataFrame(geno_df, index = sample_df.index, columns = [sample_id])
        geno_df.columns.name= "sample_id"
        return geno_df


def get_possible_geno_combinations(allele_1:str, allele_2:str):
    geno_df["homo_ref"] = geno_df.loc[:,[self.ref_col]] *2
    make_het_geno_func = lambda row: ''.join(sorted([row[self.ref_col],
                                   row[self.alt_col]]))
    geno_df["het"] = geno_df[[self.ref_col, self.alt_col]].apply(make_het_geno_func, axis=1)
    geno_df["homo_alt"] = geno_df.loc[:,self.alt_col] *2