# AUTOGENERATED! DO NOT EDIT! File to edit: 01_datasets_genetic_dataset.ipynb (unless otherwise specified).

__all__ = ['GenFileFormat']

# Cell
from . import GeneticFileFormat
from typing import Any, Dict, List, Optional, Literal, Union, Protocol
from enum import Enum
import numpy as np
from kedro.io import AbstractVersionedDataSet
from pydantic import BaseModel
from pathlib import Path, PosixPath
from pydantic.dataclasses import dataclass
from dataclasses import InitVar, asdict
from copy import deepcopy
import fsspec
from kedro.io.core import (
    AbstractVersionedDataSet,
    DataSetError,
    Version,
    get_filepath_str,
    get_protocol_and_path,
)
from kedro.extras.datasets.pandas import CSVDataSet
from fastcore.meta import delegates
from functools import partial, wraps, lru_cache
from types import SimpleNamespace
from tqdm.auto import tqdm
import pandas as pd
import itertools

# Cell

class GenFileFormat(GeneticFileFormat):
    prob_n_cols: int
    initial_cols: List[str]
    rsid_col: str
    ref_col: str
    alt_col: str
    ref_alt_delim: Optional[str]
    pandas_args: Dict[str, Any]
    sample_ids: Optional[str]
    current_file_path: Optional[Union[str, Path]]

    # check that num_cols - initial cols is divisible by prob_n_cols
    # if ref col == alt col then ref_alt_delim needs to be specified, so ref,alt = ref_col.str.split(delim)

    def col_name_generator(self, include_initial_cols=True):

        if include_initial_cols:
            for col in self.initial_cols:
                yield col

        if self.sample_ids is None:
            sample_ids_gen = (f"sample{i}" for i in itertools.count(1))
        else:
            sample_ids_gen = (sample_id for sample_id in self.sample_ids)

        while True:
            cur_sample_id = next(sample_ids_gen)
            for allele_prob_col_num in range(1, self.prob_n_cols + 1):
                yield f"{cur_sample_id}_{allele_prob_col_num}"

    @property
    def gen_info_cols(self):
        return [self.rsid_col, self.ref_col, self.alt_col]

    @property
    def column_headers(self):
        #read the first non-header line
        first_line_df = next(self._load_unprocessed(chunksize=1))
        generator = self.col_name_generator()
        return [next(generator) for col in first_line_df.columns]

    @property
    def sample_cols(self):
        cols = [col for col in self.column_headers if col not in set(self.initial_cols)]
        return cols

    @property
    def _sample_list(self):
        if self.sample_ids is not None:
            return self.sample_ids
        else:
            return sorted(list(set([col.split("_")[0] for col in self.sample_cols])))

    @property
    def num_samples(self):
        return len(self.sample_cols)/self.prob_n_cols

    @property
    def load_args(self):
        load_args = deepcopy(self.pandas_args)
        col_names = self.column_headers
        load_args["names"] = col_names
        return load_args

    @delegates(pd.read_csv)
    def _load_unprocessed(self, **kwargs):
        return pd.read_csv(filepath_or_buffer = self.current_file_path, **self.pandas_args, **kwargs)


    @delegates(pd.read_csv)
    def load(self, chrom=None, **kwargs):
        self.current_file_path = self.get_resolved_file_path(chrom) # use another attribute so `load` and `_load_unprocessed` can share
        df = pd.read_csv(filepath_or_buffer = self.current_file_path, **self.load_args, **kwargs)
        #df.columns = self.column_headers
        return df


    @delegates(pd.read_csv)
    def get_rsid_df(self,chrom=None, rsid_list=None, **kwargs):
        rsid_df = self.load(chrom = chrom, usecols = [self.rsid_col])
        if rsid_list is not None:
            found_rsid_df = rsid_df.query(f"{self.rsid_col} in @rsid_list")
        else:
            found_rsid_df = rsid_df
        found_index = found_rsid_df.index
        found_rsids = set(found_rsid_df[self.rsid_col].unique())
        found_rsid_df_full = self.load(chrom= chrom, skiprows = lambda x: x not in found_index, **kwargs)
        return found_rsid_df_full

    @delegates(load)
    def get_genotypes_df(self, chrom=None, rsid_list: List = None, **kwargs):
        if rsid_list is not None:
            geno_df = self.get_rsid_df(chrom=chrom, rsid_list = rsid_list, usecols = self.gen_info_cols, **kwargs)
        else:
            geno_df = self.load(chrom = chrom, usecols = self.gen_info_cols,**kwargs)
        geno_df["homo_ref"] = geno_df.loc[:,[self.ref_col]] *2
        make_het_geno_func = lambda row: ''.join(sorted([row[self.ref_col],
                                   row[self.alt_col]]))
        geno_df["het"] = geno_df[[self.ref_col, self.alt_col]].apply(make_het_geno_func, axis=1)
        geno_df["homo_alt"] = geno_df.loc[:,self.alt_col] *2

        geno_df = geno_df.set_index(self.rsid_col)
        return geno_df


    def sample_columns_iter(self, chrom=None, rsid_list=None, **kwargs):

        df = self.get_rsid_df(chrom=chrom, rsid_list = rsid_list, **kwargs)
        df = df.set_index(self.rsid_col)

        for sample in self._sample_list:
            sample_cols = [f"{sample}_{allele_prob_col_num}" for allele_prob_col_num in range(1, self.prob_n_cols + 1)]
            sample_cols_df = df[sample_cols]
            yield SimpleNamespace(sample_id = sample,
                                  sample_df = sample_cols_df)


    #the function has to accept sample_id kwarg
    def apply_func_to_all_samples(self, func, rsid_list=None, chrom=None, **kwargs):
        result_dict = [func(sample_obj.sample_df, sample_id = sample_obj.sample_id, **kwargs) for sample_obj in tqdm(self.sample_columns_iter(chrom= chrom, rsid_list=rsid_list))]#{sample_obj.sample_id: func(sample_obj.sample_df, sample_id = sample_obj.sample_id, **kwargs) for sample_obj in tqdm(self.sample_columns_iter(rsid_list=rsid_list))}
        result_df = pd.concat(result_dict, axis=1)
        #, orient="records")
        return result_df

    def get_geno_each_sample(self, *, chrom=None, rsid_list:List[str]):
        geno_each_sample_df = self.apply_func_to_all_samples(triplicate_converter,
                                        rsid_list = rsid_list,
                                        genotype_df = self.get_genotypes_df(chrom=chrom, rsid_list = rsid_list),
                                        chrom=chrom)
        return geno_each_sample_df.T

#     @property
#     def single_line_iter(self, **runtime_kwargs):
#         return pd.read_csv(self.filepath,
#                            **self.load_args,
#                            **runtime_kwargs,
#                            chunksize=1)

#     #@delegates(pd.read_csv, but= list(self.load_args.keys()))
#     def load_full(self, **kwargs):
#         return pd.read_csv(self.filepath,
#                            **self.load_args,
#                           **kwargs)

#     #if ref_col = alt_col then ref_alt_delim need to be specified
