# AUTOGENERATED! DO NOT EDIT! File to edit: datasets_bgen_file_format.ipynb (unless otherwise specified).

__all__ = ['get_possible_geno_combinations', 'get_geno_one_snp', 'BgenFileObject', 'BgenFileFormat']

# Cell
from . import GeneticFileFormat
from typing import Any, Dict, List, Optional, Literal, Union, Protocol
from pydantic import BaseModel
import pandas as pd
from bgen_reader import open_bgen, read_bgen
import dask.dataframe as dd
from dask.delayed import Delayed
from fastcore.meta import delegates
import numpy as np

# Cell

#TODO: move this to shared genetic funcs
def get_possible_geno_combinations(geno_df, allele_1_col:str, allele_2_col:str):
    geno_df["homo_1"] = geno_df.loc[:,[allele_1_col, allele_1_col]].apply("/".join, axis=1)
    make_het_geno_func = lambda row: '/'.join(sorted([row[allele_1_col],
                                   row[allele_2_col]]))
    geno_df["het"] = geno_df[[allele_1_col, allele_2_col]].apply(make_het_geno_func, axis=1)
    geno_df["homo_2"] = geno_df.loc[:,[allele_2_col, allele_2_col]].apply("/".join, axis=1)
    return geno_df

def get_geno_one_snp(row,  high_lim=0.9, low_lim=0.3, NA_val = np.nan):
    geno_1, geno_2, geno_3 = row
    homo_ref_cond = (geno_1 >=high_lim) & (geno_2 < low_lim) & (geno_3 < low_lim)
    het_cond = (geno_2 >= high_lim) & (geno_1 < low_lim) & (geno_3 < low_lim)
    homo_alt_cond = (geno_3 >= high_lim) & (geno_1 < low_lim) & (geno_2 < low_lim)
    geno_df =  np.select([homo_ref_cond, het_cond, homo_alt_cond],
             [0., 1., 2.],
             default = NA_val)
    #geno_df = pd.DataFrame(geno_df, index = sample_df.index, columns = [sample_id])
    #geno_df.columns.name= "sample_id"
    return geno_df


# Cell

class BgenFileObject(BaseModel):
    variants: dd.DataFrame
    samples: pd.Series
    genotype: List[Delayed]
    bgen_reader_obj: open_bgen

    class Config:
        arbitrary_types_allowed = True

    def __repr__(self):
        return str(self.__class__) + f" {self.samples.shape[0]} samples"

    def get_variant_index(self,rsids=None):
        variant_index = np.argwhere(np.isin(self.bgen_reader_obj.rsids, rsids)).reshape(-1,) if rsids is not None else None
        return variant_index

    def get_sample_index(self, sample_ids=None):
        sample_index = np.argwhere(np.isin(self.samples.values, sample_ids)).reshape(-1,) if sample_ids is not None else None
        return sample_index

    def get_probs(self, sample_ids=None, rsids=None):
        variant_index = self.get_variant_index(rsids)
        sample_index = self.get_sample_index(sample_ids)
        return self.bgen_reader_obj.read((sample_index, variant_index))


    def get_geno_each_sample(self, probs, prob_to_geno_func:Literal["max", "stringent"]= "stringent", high_lim=0.9, low_lim=0.3, NA_val=np.nan):
        if prob_to_geno_func == "max":
            geno = np.nanargmax(probs, axis=2).astype(float)

        elif prob_to_geno_func == "stringent":
            geno = np.apply_along_axis(get_geno_one_snp, axis=2, arr=probs, high_lim=high_lim, low_lim=low_lim, NA_val=NA_val)

        return geno


    def get_allele_ids(self, rsids = None, variant_index = None):
        if variant_index is None:
            variant_index = self.get_variant_index(rsids)
        df = pd.DataFrame([allele_str.split(",") for allele_str in self.bgen_reader_obj.allele_ids[variant_index]], columns = ["allele_1", "allele_2"])

        if rsids is not None:
            df.index = rsids
        return df

    def get_variant_combinations(self, rsids = None, variant_index = None):
        if variant_index is None:
            variant_index = np.argwhere(np.isin(self.bgen_reader_obj.rsids, rsids)).reshape(-1,) if rsids is not None else None
        geno_df = self.get_allele_ids(rsids, variant_index)
        geno_df = get_possible_geno_combinations(geno_df, "allele_1", "allele_2")
        return geno_df

    #def get_genotypes_df(self, rsid_list: List = None, **kwargs):


class BgenFileFormat(GeneticFileFormat):
    sample_file: str

    @delegates(read_bgen)
    def load(self, chrom=None, **kwargs):
        file_path = self.get_resolved_file_path(chrom=chrom)
        print("Creating object from function `open_bgen`, please be patient...")
        open_bgen_obj = open_bgen(file_path, samples_filepath= self.sample_file, allow_complex = False)
        return BgenFileObject(**read_bgen(file_path, samples_filepath= self.sample_file, **kwargs),
                             bgen_reader_obj = open_bgen_obj)
