# AUTOGENERATED! DO NOT EDIT! File to edit: 05_datasets_CombinedGenoPheno.ipynb (unless otherwise specified).

__all__ = ['CombinedGenoPheno']

# Cell
from typing import Any, Dict, List, Optional, Literal, Union
from pydantic import BaseModel
import pandas as pd
import corradin_ovp_utils
from fastcore.basics import typed
from fastcore.dispatch import typedispatch
from . import OVPDataset

# Cell
class CombinedGenoPheno(BaseModel):
    genetic_file_df: pd.DataFrame
    sample_file_df: pd.DataFrame

    @classmethod
    def init_from_OVPDataset(cls,
                             genetic_dataset: OVPDataset.OVPDataset,
                             sample_dataset: OVPDataset.OVPDataset,
                            rsid_list: List[str],
                             chrom=None,
                            ):

        genetic_dict = cls.process_datasets(genetic_dataset, sample_dataset)
        all_samples_geno_df = [file.get_geno_each_sample(chrom=chrom, rsid_list= rsid_list) for file in genetic_dict.values()]
        return pd.concat(all_samples_geno_df)


    @classmethod
    def process_datasets(cls, genetic_dataset: OVPDataset.OVPDataset, sample_dataset: OVPDataset.OVPDataset, ):
        combine_genetic_sample_func = cls._process_file_type(genetic_dataset._file_path, sample_dataset._file_path)
        genetic_dict = combine_genetic_sample_func(genetic_dataset, sample_dataset)
        return genetic_dict

    @typedispatch
    @classmethod
    def _process_file_type(cls, genetic_file_schema:OVPDataset.SingleFilePathSchema, sample_file_schema: OVPDataset.SingleFilePathSchema):
        return lambda x, y: x

    @typedispatch
    @classmethod
    def _process_file_type(cls, genetic_file_schema:OVPDataset.MultipleFilePathSchema, sample_file_schema: OVPDataset.MultipleFilePathSchema):
        assert genetic_file_schema.__class__ == sample_file_schema.__class__
        def combine_genetic_sample_multiple(genetic_dataset, sample_file_dataset):
            genetic_dict = genetic_dataset.files.__dict__
            sample_dict = sample_file_dataset.files.__dict__
            shared_keys = set(genetic_dict.keys()) & set(sample_dict.keys())

            #make sure the two datasets only have shared keys
            assert shared_keys == genetic_dict.keys() == sample_dict.keys()
            for key in shared_keys:
                genetic_dict[key].sample_ids = sample_dict[key].load().index
            return genetic_dict

        return combine_genetic_sample_multiple

    class Config:
        arbitrary_types_allowed = True