# AUTOGENERATED! DO NOT EDIT! File to edit: catalog.ipynb (unless otherwise specified).

__all__ = ['conf_loader', 'conf_test_data_catalog', 'test_data_catalog', 'cd', 'change_cwd_dir', 'get_config',
           'get_catalog', 'reload_catalog', 'reload', 'package_outer_folder', 'conf_test_data_catalog',
           'test_data_catalog']

# Cell

from kedro.config import ConfigLoader
from kedro.io import DataCatalog
from fastcore.meta import delegates

# Cell
conf_loader = ConfigLoader("conf/base")
conf_test_data_catalog = conf_loader.get("catalog*.yaml", "catalog*/*.yaml")
test_data_catalog = DataCatalog.from_config(conf_test_data_catalog)


# Cell

from functools import wraps
from contextlib import contextmanager

@contextmanager
def cd(newdir):
    prevdir = os.getcwd()
    os.chdir(os.path.expanduser(newdir))
    try:
        yield
    finally:
        os.chdir(prevdir)

def change_cwd_dir(new_dir):
    def decorator(func):
        @wraps(func)
        def wrapped_func(*args, **kwargs):
            with cd(new_dir):
                func_result = func(*args, **kwargs)
            return func_result
        return wrapped_func
    return decorator



# Cell

from kedro.config import ConfigLoader
from kedro.io import DataCatalog
import os
from pathlib import Path

package_outer_folder = Path(__file__).parents[1]

@change_cwd_dir(new_dir = package_outer_folder)
def get_config(env="base", patterns=["catalog*.yml", "catalog*.yaml", "catalog*/*.yml", "catalog*/*.yaml"]):
    # Initialise a ConfigLoader
    conf_loader = ConfigLoader(f"conf/{env}")

    # Load the data catalog configuration from catalog.yml
    conf= conf_loader.get(*patterns)

    return conf


@change_cwd_dir(new_dir = package_outer_folder)
def get_catalog(env="base", patterns=["catalog*.yml", "catalog*.yaml", "catalog*/*.yml", "catalog*/*.yaml"]):

    conf_catalog = get_config(env=env, patterns = patterns)

    # Create the DataCatalog instance from the configuration
    catalog = DataCatalog.from_config(conf_catalog)
    catalog.load = change_cwd_dir(package_outer_folder)(catalog.load)
    catalog.env = env
    catalog.patterns = patterns
    catalog.reload = reload.__get__(catalog)
    return catalog

def reload_catalog(catalog):
    return get_catalog(catalog.env, catalog.patterns)

def reload(self):
    return reload_catalog(self)

conf_test_data_catalog = get_config()
test_data_catalog = get_catalog()
#test_parameters = get_config("base", ["parameters*.yml","parameters*.yaml", "parameters*/*.yml", "parameters*/*.yaml"])

