# mypy-boto3-codedeploy

[![PyPI - mypy-boto3-codedeploy](https://img.shields.io/pypi/v/mypy-boto3-codedeploy.svg?color=blue)](https://pypi.org/project/mypy-boto3-codedeploy)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codedeploy.svg?color=blue)](https://pypi.org/project/mypy-boto3-codedeploy)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-codedeploy](#mypy-boto3-codedeploy)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)

Type annotations for
[boto3.CodeDeploy 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/codedeploy.html#CodeDeploy) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CodeDeploy` service.

```bash
python -m pip install boto3-stubs[codedeploy]
```

Use `boto3` with `mypy_boto3_codedeploy` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_codedeploy import CodeDeployClient

# Now mypy can check if your code is valid.
client: CodeDeployClient = boto3.client("codedeploy")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeDeployClient = session.client("codedeploy")



# Waiters are also supported

import mypy_boto3_codedeploy.waiter as codedeploy_waiters

deployment_successful_waiter: codedeploy_waiters.DeploymentSuccessfulWaiter = client.get_waiter("deployment_successful")


# Annotated paginators are included as well

import mypy_boto3_codedeploy.paginator as codedeploy_paginators

list_application_revisions_paginator: codedeploy_paginators.ListApplicationRevisionsPaginator = client.get_paginator("list_application_revisions")
list_applications_paginator: codedeploy_paginators.ListApplicationsPaginator = client.get_paginator("list_applications")
list_deployment_configs_paginator: codedeploy_paginators.ListDeploymentConfigsPaginator = client.get_paginator("list_deployment_configs")
list_deployment_groups_paginator: codedeploy_paginators.ListDeploymentGroupsPaginator = client.get_paginator("list_deployment_groups")
list_deployment_instances_paginator: codedeploy_paginators.ListDeploymentInstancesPaginator = client.get_paginator("list_deployment_instances")
list_deployment_targets_paginator: codedeploy_paginators.ListDeploymentTargetsPaginator = client.get_paginator("list_deployment_targets")
list_deployments_paginator: codedeploy_paginators.ListDeploymentsPaginator = client.get_paginator("list_deployments")
list_git_hub_account_token_names_paginator: codedeploy_paginators.ListGitHubAccountTokenNamesPaginator = client.get_paginator("list_git_hub_account_token_names")
list_on_premises_instances_paginator: codedeploy_paginators.ListOnPremisesInstancesPaginator = client.get_paginator("list_on_premises_instances")
```

## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_codedeploy` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python
import boto3

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("codedeploy")

session_client = boto3.Session().client("codedeploy")
```