import { Construct } from 'constructs';
import { UserPoolIdentityProviderProps } from './base';
import { UserPoolIdentityProviderBase } from './private/user-pool-idp-base';
/**
 * Properties to initialize UserPoolAppleIdentityProvider.
 *
 * @stability stable
 */
export interface UserPoolIdentityProviderAppleProps extends UserPoolIdentityProviderProps {
    /**
     * The client id recognized by Apple APIs.
     *
     * @see https://developer.apple.com/documentation/sign_in_with_apple/clientconfigi/3230948-clientid
     * @stability stable
     */
    readonly clientId: string;
    /**
     * The teamId for Apple APIs to authenticate the client.
     *
     * @stability stable
     */
    readonly teamId: string;
    /**
     * The keyId (of the same key, which content has to be later supplied as `privateKey`) for Apple APIs to authenticate the client.
     *
     * @stability stable
     */
    readonly keyId: string;
    /**
     * The privateKey content for Apple APIs to authenticate the client.
     *
     * @stability stable
     */
    readonly privateKey: string;
    /**
     * The list of apple permissions to obtain for getting access to the apple profile.
     *
     * @default [ name ]
     * @see https://developer.apple.com/documentation/sign_in_with_apple/clientconfigi/3230955-scope
     * @stability stable
     */
    readonly scopes?: string[];
}
/**
 * Represents a identity provider that integrates with 'Apple'.
 *
 * @stability stable
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class UserPoolIdentityProviderApple extends UserPoolIdentityProviderBase {
    /**
     * The primary identifier of this identity provider.
     *
     * @stability stable
     */
    readonly providerName: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderAppleProps);
}
