# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
try:
    from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr, validator
except ImportError:
    from pydantic import BaseModel, Field, StrictBool, StrictStr, validator
from lakefs_sdk.models.login_config import LoginConfig

class SetupState(BaseModel):
    """
    SetupState
    """
    state: Optional[StrictStr] = None
    comm_prefs_missing: Optional[StrictBool] = Field(None, description="true if the comm prefs are missing.")
    login_config: Optional[LoginConfig] = None
    __properties = ["state", "comm_prefs_missing", "login_config"]

    @validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('initialized', 'not_initialized'):
            raise ValueError("must be one of enum values ('initialized', 'not_initialized')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SetupState:
        """Create an instance of SetupState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of login_config
        if self.login_config:
            _dict['login_config'] = self.login_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SetupState:
        """Create an instance of SetupState from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SetupState.parse_obj(obj)

        _obj = SetupState.parse_obj({
            "state": obj.get("state"),
            "comm_prefs_missing": obj.get("comm_prefs_missing"),
            "login_config": LoginConfig.from_dict(obj.get("login_config")) if obj.get("login_config") is not None else None
        })
        return _obj


