import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `CfnReportDefinition`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html
 */
export interface CfnReportDefinitionProps {
    /**
     * The compression format that Amazon Web Services uses for the report.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-compression
     */
    readonly compression: string;
    /**
     * The format that Amazon Web Services saves the report in.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-format
     */
    readonly format: string;
    /**
     * Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web Services detects charges related to previous months.
     *
     * These charges can include refunds, credits, or support fees.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-refreshclosedreports
     */
    readonly refreshClosedReports: boolean | cdk.IResolvable;
    /**
     * The name of the report that you want to create.
     *
     * The name must be unique, is case sensitive, and can't include spaces.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-reportname
     */
    readonly reportName: string;
    /**
     * Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-reportversioning
     */
    readonly reportVersioning: string;
    /**
     * The S3 bucket where Amazon Web Services delivers the report.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3bucket
     */
    readonly s3Bucket: string;
    /**
     * The prefix that Amazon Web Services adds to the report name when Amazon Web Services delivers the report.
     *
     * Your prefix can't include spaces.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3prefix
     */
    readonly s3Prefix: string;
    /**
     * The Region of the S3 bucket that Amazon Web Services delivers the report into.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3region
     */
    readonly s3Region: string;
    /**
     * The granularity of the line items in the report.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-timeunit
     */
    readonly timeUnit: string;
    /**
     * A list of manifests that you want Amazon Web Services to create for this report.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-additionalartifacts
     */
    readonly additionalArtifacts?: string[];
    /**
     * A list of strings that indicate additional content that Amazon Web Services includes in the report, such as individual resource IDs.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-additionalschemaelements
     */
    readonly additionalSchemaElements?: string[];
    /**
     * The Amazon Resource Name (ARN) of the billing view.
     *
     * You can get this value by using the billing view service public APIs.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-billingviewarn
     */
    readonly billingViewArn?: string;
}
/**
 * A CloudFormation `AWS::CUR::ReportDefinition`.
 *
 * The definition of AWS Cost and Usage Report. You can specify the report name, time unit, report format, compression format, S3 bucket, additional artifacts, and schema elements in the definition.
 *
 * @external
 * @cloudformationResource AWS::CUR::ReportDefinition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html
 */
export declare class CfnReportDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CUR::ReportDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnReportDefinition;
    /**
     * The compression format that Amazon Web Services uses for the report.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-compression
     */
    compression: string;
    /**
     * The format that Amazon Web Services saves the report in.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-format
     */
    format: string;
    /**
     * Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web Services detects charges related to previous months.
     *
     * These charges can include refunds, credits, or support fees.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-refreshclosedreports
     */
    refreshClosedReports: boolean | cdk.IResolvable;
    /**
     * The name of the report that you want to create.
     *
     * The name must be unique, is case sensitive, and can't include spaces.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-reportname
     */
    reportName: string;
    /**
     * Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-reportversioning
     */
    reportVersioning: string;
    /**
     * The S3 bucket where Amazon Web Services delivers the report.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3bucket
     */
    s3Bucket: string;
    /**
     * The prefix that Amazon Web Services adds to the report name when Amazon Web Services delivers the report.
     *
     * Your prefix can't include spaces.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3prefix
     */
    s3Prefix: string;
    /**
     * The Region of the S3 bucket that Amazon Web Services delivers the report into.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3region
     */
    s3Region: string;
    /**
     * The granularity of the line items in the report.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-timeunit
     */
    timeUnit: string;
    /**
     * A list of manifests that you want Amazon Web Services to create for this report.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-additionalartifacts
     */
    additionalArtifacts: string[] | undefined;
    /**
     * A list of strings that indicate additional content that Amazon Web Services includes in the report, such as individual resource IDs.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-additionalschemaelements
     */
    additionalSchemaElements: string[] | undefined;
    /**
     * The Amazon Resource Name (ARN) of the billing view.
     *
     * You can get this value by using the billing view service public APIs.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-billingviewarn
     */
    billingViewArn: string | undefined;
    /**
     * Create a new `AWS::CUR::ReportDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReportDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
