# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['simple_ddl_parser', 'simple_ddl_parser.dialects']

package_data = \
{'': ['*']}

install_requires = \
['ply>=3.11,<4.0']

entry_points = \
{'console_scripts': ['sdp = simple_ddl_parser.cli:main']}

setup_kwargs = {
    'name': 'simple-ddl-parser',
    'version': '0.11.0',
    'description': 'Simple DDL Parser to parse SQL & HQL ddl files to json/python dict with full information about columns: types, defaults, primary keys, etc.',
    'long_description': '\nSimple DDL Parser\n-----------------\n\n\n.. image:: https://img.shields.io/pypi/v/simple-ddl-parser\n   :target: https://img.shields.io/pypi/v/simple-ddl-parser\n   :alt: badge1\n \n.. image:: https://img.shields.io/pypi/l/simple-ddl-parser\n   :target: https://img.shields.io/pypi/l/simple-ddl-parser\n   :alt: badge2\n \n.. image:: https://img.shields.io/pypi/pyversions/simple-ddl-parser\n   :target: https://img.shields.io/pypi/pyversions/simple-ddl-parser\n   :alt: badge3\n \n\nBuild with ply (lex & yacc in python). A lot of samples in \'tests/\'\n\nHow does it work?\n^^^^^^^^^^^^^^^^^\n\nParser tested on different DDLs for PostgreSQL & Hive. But idea to support as much as possible DDL dialects, I already added such things as support  MySQL \'#\' comments. If you need to add something - please provide DDL example & information abotu that is it SQL dialect & DB.\n\nTypes that are used in your DB does not matter, so parser must also work successfuly to any DDL for SQL DB. Parser is NOT case sensitive, it did not expect that all queries will be in upper case or lower case. So you can write statements like this:\n\n.. code-block:: sql\n\n   Alter Table Persons ADD CONSTRAINT CHK_PersonAge CHECK (Age>=18 AND City=\'Sandnes\');\n\nIt will be parsed as is without errors.\n\nIf you have samples that cause an error - please open the issue (but don\'t forget to add ddl example), I will be glad to fix it.\n\nA lot of statements and output result you can find in tests on the github - https://github.com/xnuinside/simple-ddl-parser/tree/main/tests .\n\nHow to install\n^^^^^^^^^^^^^^\n\n.. code-block:: bash\n\n\n       pip install simple-ddl-parser\n\nHow to use\n----------\n\nExtract additional information from HQL (& other dialects)\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nIn some dialects like HQL there is a lot of additional information about table like, fore example, is it external table, STORED AS, location & etc. This propertie will be always empty in \'classic\' SQL DB like PostgreSQL or MySQL and this is the reason, why by default this information are \'hidden\'. \nAlso some fields hidden in HQL, because they are simple not exists in HIVE, for example \'deferrable_initially\'\nTo get this \'hql\' specific details about table in output please use \'output_mode\' argument in run() method.\n\nexample:\n\n.. code-block:: python\n\n\n       ddl = """\n       CREATE TABLE IF NOT EXISTS default.salesorderdetail(\n           SalesOrderID int,\n           ProductID int,\n           OrderQty int,\n           LineTotal decimal\n           )\n       PARTITIONED BY (batch_id int, batch_id2 string, batch_32 some_type)\n       LOCATION \'s3://datalake/table_name/v1\'\n       ROW FORMAT DELIMITED\n           FIELDS TERMINATED BY \',\'\n           COLLECTION ITEMS TERMINATED BY \'\\002\'\n           MAP KEYS TERMINATED BY \'\\003\'\n       STORED AS TEXTFILE\n       """\n\n       result = DDLParser(ddl).run(output_mode="hql")\n       print(result)\n\nAnd you will get output with additional keys \'stored_as\', \'location\', \'external\', etc.\n\n.. code-block:: python\n\n\n       # additional keys examples\n     {\n       ...,\n       \'location\': "\'s3://datalake/table_name/v1\'",\n       \'map_keys_terminated_by\': "\'\\\\003\'",\n       \'partitioned_by\': [{\'name\': \'batch_id\', \'size\': None, \'type\': \'int\'},\n                           {\'name\': \'batch_id2\', \'size\': None, \'type\': \'string\'},\n                           {\'name\': \'batch_32\', \'size\': None, \'type\': \'some_type\'}],\n       \'primary_key\': [],\n       \'row_format\': \'DELIMITED\',\n       \'schema\': \'default\',\n       \'stored_as\': \'TEXTFILE\',\n       ... \n     }\n\nIf you run parser with command line add flag \'-o=hql\' or \'--output-mode=hql\' to get the same result.\n\nFrom python code\n^^^^^^^^^^^^^^^^\n\n.. code-block:: python\n\n       from simple_ddl_parser import DDLParser\n\n\n       parse_results = DDLParser("""create table dev.data_sync_history(\n           data_sync_id bigint not null,\n           sync_count bigint not null,\n           sync_mark timestamp  not  null,\n           sync_start timestamp  not null,\n           sync_end timestamp  not null,\n           message varchar(2000) null,\n           primary key (data_sync_id, sync_start)\n       ); """).run()\n\n       print(parse_results)\n\nTo parse from file\n^^^^^^^^^^^^^^^^^^\n\n.. code-block:: python\n\n\n       from simple_ddl_parser import parse_from_file\n\n       result = parse_from_file(\'tests/sql/test_one_statement.sql\')\n       print(result)\n\nFrom command line\n^^^^^^^^^^^^^^^^^\n\nsimple-ddl-parser is installed to environment as command **sdp**\n\n.. code-block:: bash\n\n\n       sdp path_to_ddl_file\n\n       # for example:\n\n       sdp tests/sql/test_two_tables.sql\n\nYou will see the output in **schemas** folder in file with name **test_two_tables_schema.json**\n\nIf you want to have also output in console - use **-v** flag for verbose.\n\n.. code-block:: bash\n\n\n       sdp tests/sql/test_two_tables.sql -v\n\nIf you don\'t want to dump schema in file and just print result to the console, use **--no-dump** flag:\n\n.. code-block:: bash\n\n\n       sdp tests/sql/test_two_tables.sql --no-dump\n\nYou can provide target path where you want to dump result with argument **-t**\\ , **--targer**\\ :\n\n.. code-block:: bash\n\n\n       sdp tests/sql/test_two_tables.sql -t dump_results/\n\nMore details\n^^^^^^^^^^^^\n\n``DDLParser(ddl).run()``\n.run() method contains several arguments, that impact changing output result. As you can saw upper exists argument ``output_mode`` that allow you to set dialect and get more fields in output relative to chosen dialect, for example \'hql\'.\n\nAlso in .run() method exists argument ``group_by_type`` (by default: False). By default output of parser looks like a List with Dicts where each dict == one entitiy from ddl (table, sequence, type, etc). And to understand that is current entity you need to check Dict like: if \'table_name\' in dict - this is a table, if \'type_name\' - this is a type & etc.\n\nTo make work little bit easy you can set group_by_type=True and you will get output already sorted by types, like:\n\n.. code-block:: python\n\n\n       { \n           \'tables\': [all_pasrsed_tables], \n           \'sequences\': [all_pasrsed_sequences], \n           \'types\': [all_pasrsed_types], \n           \'domains\': [all_pasrsed_domains],\n           ...\n       }\n\nFor example:\n\n.. code-block:: python\n\n\n       ddl = """\n       CREATE TYPE "schema--notification"."ContentType" AS\n           ENUM (\'TEXT\',\'MARKDOWN\',\'HTML\');\n           CREATE TABLE "schema--notification"."notification" (\n               content_type "schema--notification"."ContentType"\n           );\n       CREATE SEQUENCE dev.incremental_ids\n           INCREMENT 10\n           START 0\n           MINVALUE 0\n           MAXVALUE 9223372036854775807\n           CACHE 1;\n       """\n\n       result = DDLParser(ddl).run(group_by_type=True)\n\n       # result will be:\n\n       {\'sequences\': [{\'cache\': 1,\n                       \'increment\': 10,\n                       \'maxvalue\': 9223372036854775807,\n                       \'minvalue\': 0,\n                       \'schema\': \'dev\',\n                       \'sequence_name\': \'incremental_ids\',\n                       \'start\': 0}],\n       \'tables\': [{\'alter\': {},\n                   \'checks\': [],\n                   \'columns\': [{\'check\': None,\n                               \'default\': None,\n                               \'name\': \'content_type\',\n                               \'nullable\': True,\n                               \'references\': None,\n                               \'size\': None,\n                               \'type\': \'"schema--notification"."ContentType"\',\n                               \'unique\': False}],\n                   \'index\': [],\n                   \'partitioned_by\': [],\n                   \'primary_key\': [],\n                   \'schema\': \'"schema--notification"\',\n                   \'table_name\': \'"notification"\'}],\n       \'types\': [{\'base_type\': \'ENUM\',\n                   \'properties\': {\'values\': ["\'TEXT\'", "\'MARKDOWN\'", "\'HTML\'"]},\n                   \'schema\': \'"schema--notification"\',\n                   \'type_name\': \'"ContentType"\'}]}\n\nALTER statements\n^^^^^^^^^^^^^^^^\n\nRight now added support only for ALTER statements with FOREIGEIN key\n\nFor example, if in your ddl after table defenitions (create table statements) you have ALTER table statements like this:\n\n.. code-block:: sql\n\n\n   ALTER TABLE "material_attachments" ADD FOREIGN KEY ("material_id", "material_title") REFERENCES "materials" ("id", "title");\n\nThis statements will be parsed and information about them putted inside \'alter\' key in table\'s dict.\nFor example, please check alter statement tests - **tests/test_alter_statements.py**\n\nMore examples & tests\n^^^^^^^^^^^^^^^^^^^^^\n\nYou can find in **tests/** folder.\n\nDump result in json\n^^^^^^^^^^^^^^^^^^^\n\nTo dump result in json use argument .run(dump=True)\n\nYou also can provide a path where you want to have a dumps with schema with argument .run(dump_path=\'folder_that_use_for_dumps/\')\n\nSupported Statements\n^^^^^^^^^^^^^^^^^^^^\n\n\n* \n  CREATE TABLE [ IF NOT EXISTS ] + columns defenition, columns attributes: column name + type + type size(for example, varchar(255)), UNIQUE, PRIMARY KEY, DEFAULT, CHECK, NULL/NOT NULL, REFERENCES, ON DELETE, ON UPDATE,  NOT DEFERRABLE, DEFERRABLE INITIALLY\n\n* \n  STATEMENTS: PRIMARY KEY, CHECK, FOREIGN KEY in table defenitions (in create table();)\n\n* \n  ALTER TABLE STATEMENTS: ADD CHECK (with CONSTRAINT), ADD FOREIGN KEY (with CONSTRAINT)\n\n* \n  PARTITIONED BY statement\n\n* \n  CREATE SEQUENCE with words: INCREMENT, START, MINVALUE, MAXVALUE, CACHE\n\n* \n  CREATE TYPE statement:  AS ENUM, AS OBJECT, INTERNALLENGTH, INPUT, OUTPUT\n\n* \n  LIKE statement (in this and only in this case to output will be added \'like\' keyword with information about table from that we did like - \'like\': {\'schema\': None, \'table_name\': \'Old_Users\'}).\n\nHQL Dialect statements\n----------------------\n\n\n* PARTITIONED BY statement\n* ROW FORMAT\n* STORED AS\n* LOCATION, FIELDS TERMINATED BY, COLLECTION ITEMS TERMINATED BY, MAP KEYS TERMINATED BY\n\nTODO in next Releases (if you don\'t see feature that you need - open the issue)\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n\n#. Add \'oracle\' output_mode: add support for STORAGE statement, ENCRYPT column parameter\n#. Add support for GENERATED ALWAYS AS statement\n#. Add support for CREATE TABLESPACE statement & TABLESPACE statement in table defenition.\n#. Add support for statement CREATE DOMAIN\n#. Add COMMENT ON statement support\n#. Add CREATE DATABASE statement support\n#. Add more support for CREATE type IS TABLE (example: CREATE OR REPLACE TYPE budget_tbl_typ IS TABLE OF NUMBER(8,2);\n#. Add support for MEMBER PROCEDURE, STATIC FUNCTION, CONSTRUCTOR FUNCTION,  in TYPE\n\nnon-feature todo\n----------------\n\n\n#. Provide API to get result as Python Object\n#. Add online demo (UI) to parse ddl\n\nHistorical context\n^^^^^^^^^^^^^^^^^^\n\nThis library is an extracted parser code from https://github.com/xnuinside/fakeme (Library for fake relation data generation, that I used in several work projects, but did not have time to make from it normal open source library)\n\nFor one of the work projects I needed to convert SQL ddl to Python ORM models in auto way and I tried to use https://github.com/andialbrecht/sqlparse but it works not well enough with ddl for my case (for example, if in ddl used lower case - nothing works, primary keys inside ddl are mapped as column name not reserved word and etc.).\nSo I remembered about Parser in Fakeme and just extracted it & improved. \n\nHow to run tests\n^^^^^^^^^^^^^^^^\n\n.. code-block:: bash\n\n\n       git clone https://github.com/xnuinside/simple-ddl-parser.git\n       cd simple-ddl-parser\n       poetry install # if you use poetry\n       # or use `pip install .`\n       pytest tests/ -vv\n\nHow to contribute\n-----------------\n\nPlease describe issue that you want to solve and open the PR, I will review it as soon as possible.\n\nAny questions? Ping me in Telegram: https://t.me/xnuinside \n\nChangelog\n---------\n\n**v0.11.0**\n\n\n#. Now table can has name \'table\'\n#. Added base support for statement CREATE TYPE:  AS ENUM, AS OBJECT, INTERNALLENGTH, INPUT, OUTPUT (not all properties & types supported yet.)\n#. Added argument \'group_by_type\' in \'run\' method that will group output by type of parsed entities like: \n   \'tables\': [all_pasrsed_tables], \'sequences\': [all_pasrsed_sequences], \'types\': [all_pasrsed_types], \'domains\': [all_pasrsed_domains]\n#. Type in column defenition also can be "schema"."YourCustomType"\n#. " now are not dissapeared if you use them in DDL.\n\n**v0.10.2**\n\n\n#. Fix regex that find \'--\' in table names (to avoid issue with -- comment lines near string defaults)\n\n**v0.10.1**\n\n\n#. Added support for CREATE TABLE ... LIKE statement\n#. Add support for DEFERRABLE INITIALLY, NOT DEFERRABLE statements\n\n**v0.9.0**\n\n\n#. Added support for REFERENCES without field name, like ``product_no integer REFERENCES products ON DELETE RESTRICT``\n#. Added support for REFERENCES ON statement\n\n**v0.8.1**\n\n\n#. Added support for HQL Structured types like ARRAY < STRUCT <street: STRING, city: STRING, country: STRING >>, \n   MAP < STRING, STRUCT < year: INT, place: STRING, details: STRING >>, \n   STRUCT < street_address: STRUCT <street_number: INT, street_name: STRING, street_type: STRING>, country: STRING, postal_code: STRING >\n\n**v0.8.0**\n\n\n#. To DDLParser\'s run method was added \'output_mode\' argument that expect valur \'hql\' or \'sql\' (by default).\n   Mode change result output. For example, in hql exists statement EXTERNAL. If you want to see in table information \n   is it EXTERNAL table or not - you need to set \'hql\' output_mode.\n#. Added suppport for hql EXTERNAL statement, STORED AS statement, LOCATION statement\n#. Added suppport for PARTITIONED BY statement (for both hql & sql)\n#. Added support for HQL ROW FORMAT statement, FIELDS TERMINATED BY statement, COLLECTION ITEMS TERMINATED BY statement, MAP KEYS TERMINATED BY statement\n\n**v0.7.4**\n\n\n#. Fix behaviour with -- in strings. Allow calid table name like \'table--name\'\n\n**v0.7.3**\n\n\n#. Added support ``/* ... */`` block comments\n#. Added support for Mysql \'#\' comments\n\n**v0.7.1**\n\n\n#. Ignore inline with \'--\' comments\n\n**v0.7.0**\n\n\n#. Redone logic of parse CREATE TABLE statements, now they parsed as one statement (not line by line as previous)\n#. Fixed several minor bugs with edge cases in default values and checks\n#. Added support for ALTER FOREIGN KEY statement for several fields in one statement\n\n**v0.6.1**\n\n\n#. Fix minor bug with schema in index statements\n\n**v0.6.0**\n\n\n#. Added support for SEQUENCE statemensts\n#. Added support for ARRAYs in types\n#. Added support for CREATE INDEX statements\n\n**v0.5.0**\n\n\n#. Added support for UNIQUE column attribute\n#. Add command line arg to pass folder with ddls (parse multiple files)\n#. Added support for CHECK Constratint\n#. Added support for FOREIGN Constratint in ALTER TABLE\n\n**v0.4.0**\n\n\n#. Added support schema for table in REFERENCES statement in column defenition\n#. Added base support fot Alter table statements (added \'alters\' key in table)\n#. Added command line arg to pass path to get the output results\n#. Fixed incorrect null fields parsing\n\n**v0.3.0**\n\n\n#. Added support for REFERENCES statement in column defenition\n#. Added command line\n',
    'author': 'Iuliia Volkova',
    'author_email': 'xnuinside@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/xnuinside/simple-ddl-parser',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
