import setuptools

packages = \
['convo',
 'convo.cli',
 'convo.cli.arguments',
 'convo.cli.initial_project',
 'convo.core',
 'convo.core.actions',
 'convo.core.brokers',
 'convo.core.channels',
 'convo.core.events',
 'convo.core.nlg',
 'convo.core.policies',
 'convo.core.training',
 'convo.importers',
 'convo.nlu',
 'convo.nlu.classifiers',
 'convo.nlu.emulators',
 'convo.nlu.extractors',
 'convo.nlu.featurizers',
 'convo.nlu.featurizers.dense_featurizer',
 'convo.nlu.featurizers.sparse_featurizer',
 'convo.nlu.schemas',
 'convo.nlu.selectors',
 'convo.nlu.tokenizers',
 'convo.nlu.training_data',
 'convo.nlu.training_data.formats',
 'convo.nlu.utils',
 'convo.nlu.utils.hugging_face',
 'convo.utils',
 'convo.utils.tensorflow']

package_data = \
{'': ['*'],
 'convo.cli.initial_project': ['data/*', 'tests/*'],
 'convo.core': ['schemas/*']}

install_requires = \
['PyJWT>=1.7,<1.8',
 'SQLAlchemy>=1.3.3,<1.4.0',
 'absl-py>=0.9,<0.10',
 'aiohttp>=3.6,<3.7',
 'apscheduler>=3.6,<3.7',
 'async_generator>=1.10,<1.11',
 'attrs>=19.3,<19.4',
 'boto3>=1.12,<2.0',
 'cloudpickle>=1.2,<1.4',
 'colorclass>=2.2,<2.3',
 'coloredlogs>=10.0,<11.0',
 'colorhash>=1.0.2,<1.1.0',
 'fbmessenger>=6.0.0,<6.1.0',
 'gevent>=1.4,<1.6',
 'jsonpickle>=1.3,<1.5',
 'jsonschema>=3.2,<3.3',
 'kafka-python>=1.4,<2.0',
 'matplotlib>=3.1,<3.3',
 'mattermostwrapper>=2.2,<2.3',
 'multidict>=4.6,<5.0',
 'networkx>=2.4.0,<2.5.0',
 'numpy>=1.16,<2.0',
 'oauth2client==4.1.3',
 'packaging>=20.0,<21.0',
 'pika>=1.1.0,<1.2.0',
 'prompt-toolkit>=2.0,<3.0',
 'psycopg2-binary>=2.8.2,<2.9.0',
 'pydot>=1.4,<1.5',
 'pykwalify>=1.7.0,<1.8.0',
 'pymongo[tls,srv]>=3.8.0,<3.9.0',
 'python-dateutil>=2.8,<2.9',
 'python-engineio>=3.11,<3.13',
 'python-socketio>=4.4,<4.6',
 'python-telegram-bot>=11.1,<13.0',
 'pytz>=2019.1,<2020.0',
 'questionary>=1.5.1,<1.6.0',

 'redis>=3.4,<4.0',
 'regex>=2020.6,<2020.7',
 'requests>=2.23,<3.0',
 'rocketchat_API>=0.6.31,<1.4.0',
 'ruamel.yaml>=0.16,<0.17',
 'sanic-cors>=0.10.0b1,<0.11.0',
 'sanic-jwt>=1.3.2,<1.5.0',
 'sanic>=19.12.2,<20.0.0',
 'scikit-learn>=0.22,<0.23',
 'scipy>=1.4.1,<2.0.0',
 'setuptools>=41.0.0',
 'sklearn-crfsuite>=0.3,<0.4',
 'slackclient>=2.0.0,<3.0.0',
 'tensorflow-addons>=0.7.1,<0.8.0',
 'tensorflow-estimator==2.1.0',
 'tensorflow-probability>=0.7,<0.10',
 'tensorflow>=2.1,<2.2',
 'tensorflow_hub>=0.7,<0.9',
 'terminaltables>=3.1.0,<3.2.0',
 'tqdm>=4.31,<4.46',
 'twilio>=6.26,<6.27',
 'ujson>=1.35,<3.0',
 'webexteamssdk>=1.1.1,<1.4.0']

extras_require = \
{'convert': ['tensorflow_text==2.1.0rc0'],
 'full': ['spacy>=2.1,<2.2',
          'tensorflow_text==2.1.0rc0',
          'transformers>=2.4,<2.5',
          'jieba==0.39'],
 'spacy': ['spacy>=2.1,<2.2'],
 'transformers': ['transformers>=2.4,<2.5']}

entry_points = \
{'console_scripts': ['convo = convo.__main__:main']}


setuptools.setup(name='convo7',
      version='0.1',
      description='Convo: the AI powered chatbot API',
      author='OodlesTechnologies',
      author_email='vaibhav.garg.334@gmail.com.com',
      license='MIT',
      entry_points= entry_points,
      packages=setuptools.find_packages(),
      install_requires= install_requires,
      package_data=package_data,
      extras_require= extras_require,
      python_requires= '>=3.6,<3.8',
      zip_safe=False)
