import numpy as np

from algotradepy.indicators.macd import MACD


def test_macd():
    macd = MACD(
        short_ema_n_periods=12, long_ema_n_periods=26, signal_ema_n_periods=9,
    )

    feed = [
        459.99,
        448.85,
        446.06,
        450.81,
        442.8,
        448.97,
        444.57,
        441.4,
        430.47,
        420.05,
        431.14,
        425.66,
        430.58,
        431.72,
        437.87,
        428.43,
        428.35,
        432.5,
        443.66,
        455.72,
        454.49,
        452.08,
        452.73,
        461.91,
        463.58,
        461.14,
        452.08,
        442.66,
        428.91,
        429.79,
        431.99,
        427.72,
        423.2,
        426.21,
        426.98,
    ]
    macd_line_target = [
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        8.275269503908,
        7.703378381457,
        6.416074756957,
        4.237519783266,
        2.552583324867,
        1.378885719855,
        0.1029814912,
        -1.258401952802,
        -2.070558190094,
        -2.621842328256,
    ]
    signal_line_target = [
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        3.03752586873489,
        1.90565222933671,
    ]
    macd_hist_target = [
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        np.nan,
        -5.10808405882889,
        -4.52749455759271,
    ]

    for i in range(len(feed)):
        macd.update(value=feed[i])
        assert (
            np.isnan(macd.macd_line) and np.isnan(macd_line_target[i])
        ) or np.isclose(macd.macd_line, macd_line_target[i], 0.005)
        assert (
            np.isnan(macd.signal_line) and np.isnan(signal_line_target[i])
        ) or np.isclose(macd.signal_line, signal_line_target[i], 0.005)
        assert (
            np.isnan(macd.macd_hist) and np.isnan(macd_hist_target[i])
        ) or np.isclose(macd.macd_hist, macd_hist_target[i], 0.005)
