#
# (c) 2022, Yegor Yakubovich
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#


from adecty_design.elements.config import Config
from adecty_design.elements.header import Header
from adecty_design.elements.footer import Footer
from adecty_design.elements.page import Page
from adecty_design.markups.markups import MarkupsHtml


class AdectyDesign:
    config: Config
    header: Header
    footer: Footer

    def __init__(self, config: Config, header: Header, footer: Footer):
        self.config = config
        self.header = header
        self.footer = footer

    def get_page_html(self, page: Page):
        page_html = page.html_get(config=self.config)

        config_html = self.config.html_get()

        base_html_format = {
            'title': page.title,
            'config': config_html,
            'header': self.header.html_get(),
            'page': page_html,
            'footer': self.footer.html_get(),
        }
        base_html = MarkupsHtml.base.format(**base_html_format)
        return base_html
