import requests
import json
from ..config import config


class Api(object):
    def __init__(self, Auth=None):

        self.auth = Auth

        self.api_endpoint_url = config["aws_appsync_graphqlEndpoint"]
        self.headers = None

    def attach_auth(self, auth):
        self.auth = auth

        self.headers = {
            'Authorization': str(self.auth.access_token)
        }

    def execute_gql(self, query, params):

        if not self.headers:
            raise UserWarning(
                "No auth object attached.")

        if self.auth.check_token():
            self.attach_auth(self.auth)

        payload_obj = {"query": query, "variables": params}
        payload = json.dumps(payload_obj)

        try:
            response = requests.request(
                "POST", self.api_endpoint_url, data=payload, headers=self.headers)

            return response.json()

        except requests.exceptions.Timeout:
            raise TimeoutError(
                "Request timed out")
        except requests.exceptions.TooManyRedirects:
            raise TimeoutError(
                "Too many Redirects")
        except requests.exceptions.RequestException as e:
            raise UserWarning(
                "Request raised error {}".format(e))
