# Generated by Django 2.1.3 on 2018-11-29 21:57

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('quartet_capture', '0005_auto_20181129_1557'),
        ('quartet_trail', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalFilter',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='The name of the filter.', max_length=100, verbose_name='Name')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical filter',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalRuleFilter',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('search_value', models.CharField(help_text='This is either a generic search term or a regular expression used to determine if a Rule should be executed.', max_length=2000, verbose_name='Search Value')),
                ('search_type', models.CharField(choices=[('regex', 'Regular Expression'), ('search', 'Text Search')], default='regex', help_text='Regular Expression (regex) or Text Search (text). A regular expression that matches something in the inbound data or a plain text search value containing a string that can be matched within the inbound data.', max_length=10, verbose_name='Search Type')),
                ('reverse', models.BooleanField(default=False, help_text="Set this to true if you'd like the search logic to act in 'reverse' in that any messages matching the defined value will not trigger the rule and all others will.", verbose_name='Reverse')),
                ('order', models.IntegerField(default=1, help_text='The order in which this filter should be applied.', verbose_name='Order')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('filter', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_capture.Filter')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('rule', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_capture.Rule')),
            ],
            options={
                'verbose_name': 'historical rule filter',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
