#!/usr/bin/env python
"""
Provide version number for ncvue.

This module was written by Matthias Cuntz while at Institut National de
Recherche pour l'Agriculture, l'Alimentation et l'Environnement (INRAE), Nancy,
France.

Copyright (c) 2020-2021 Matthias Cuntz - mc (at) macu (dot) de
Released under the MIT License; see LICENSE file for details.

* Written Nov 2020 by Matthias Cuntz (mc (at) macu (dot) de)
* v1.0, initial PyPI commit, Nov 2020, Matthias Cuntz
* v1.1, modularised, having utilities and panels in individual files,
  Dec 2020, Matthias Cuntz
* v1.2, Make lists of spinbox labels and values, outsource common methods,
  Dec 2020, Matthias Cuntz
* v1.3, fix colorbar and gridlines in contour, invert x in scatter,
  Dec 2020, Matthias Cuntz
* v1.4, Read only slice from disk, respect unlimited dimension,
  visual colorbar chooser, Dec 2020, Matthias Cuntz
* v2.0, Added map panel, Jan 2021, Matthias Cuntz
* v3.0, First version to be tested elsewhere, documentation on Github Pages,
  allow spaces in variable names, bug fixes, Jan 2021, Matthias Cuntz
* v3.1, Include png files in ncvue/images in PyPI wheel,
  Jan 2021, Matthias Cuntz
* v3.2, Open netcdf files from within ncvue, Jan 2021, Matthias Cuntz
* v3.3, Standalone apps for macOS and Windows, Feb 2021, Matthias Cuntz
* v3.3.1, Better installation instructions, Feb 2021, Matthias Cuntz
* v3.4, Print values, draw grid lines in contour, May 2021, Matthias Cuntz
* v3.5, Uses different themes on different OS, Jun 2021, Matthias Cuntz

.. moduleauthor:: Matthias Cuntz
"""

__author__  = "Matthias Cuntz"
__version__ = "3.5"
