# generated by datamodel-codegen:
#   filename:  schemas.json
#   timestamp: 2022-08-01T18:53:04+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, List, Optional

from pydantic import BaseModel, Field


class LocationPreference(BaseModel):
    zone: Optional[str] = Field(
        None,
        description="The preferred Compute Engine zone (for example: us-central1-a, us-central1-b, etc.). WARNING: Changing this might restart the instance.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#locationPreference`.")
    follow_gae_application: Optional[str] = Field(
        None,
        alias="followGaeApplication",
        description="The App Engine application to follow, it must be in the same region as the Cloud SQL instance. WARNING: Changing this might restart the instance.",
    )
    secondary_zone: Optional[str] = Field(
        None,
        alias="secondaryZone",
        description="The preferred Compute Engine zone for the secondary/failover (for example: us-central1-a, us-central1-b, etc.).",
    )


class DiskEncryptionConfiguration(BaseModel):
    kms_key_name: Optional[str] = Field(
        None,
        alias="kmsKeyName",
        description="Resource name of KMS key for disk encryption",
    )
    kind: Optional[str] = Field(
        None, description="This is always `sql#diskEncryptionConfiguration`."
    )


class RetentionUnit(Enum):
    retention_unit_unspecified = "RETENTION_UNIT_UNSPECIFIED"
    count = "COUNT"


class BackupRetentionSettings(BaseModel):
    retained_backups: Optional[int] = Field(
        None,
        alias="retainedBackups",
        description="Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit is 'COUNT', we will retain this many backups.",
    )
    retention_unit: Optional[RetentionUnit] = Field(
        None,
        alias="retentionUnit",
        description="The unit that 'retained_backups' represents.",
    )


class InsightsConfig(BaseModel):
    record_application_tags: Optional[bool] = Field(
        None,
        alias="recordApplicationTags",
        description="Whether Query Insights will record application tags from query when enabled.",
    )
    query_string_length: Optional[int] = Field(
        None,
        alias="queryStringLength",
        description="Maximum query length stored in bytes. Default value: 1024 bytes. Range: 256-4500 bytes. Query length more than this field value will be truncated to this value. When unset, query length will be the default value. Changing query length will restart the database.",
    )
    query_plans_per_minute: Optional[int] = Field(
        None,
        alias="queryPlansPerMinute",
        description="Number of query execution plans captured by Insights per minute for all queries combined. Default is 5.",
    )
    query_insights_enabled: Optional[bool] = Field(
        None,
        alias="queryInsightsEnabled",
        description="Whether Query Insights feature is enabled.",
    )
    record_client_address: Optional[bool] = Field(
        None,
        alias="recordClientAddress",
        description="Whether Query Insights will record client address when enabled.",
    )


class RestoreBackupContext(BaseModel):
    project: Optional[str] = Field(None, description="The full project ID of the source instance.")
    kind: Optional[str] = Field(None, description="This is always `sql#restoreBackupContext`.")
    backup_run_id: Optional[str] = Field(
        None,
        alias="backupRunId",
        description="The ID of the backup run to restore from.",
    )
    instance_id: Optional[str] = Field(
        None,
        alias="instanceId",
        description="The ID of the instance that the backup was taken from.",
    )


class SqlScheduledMaintenance(BaseModel):
    can_defer: Optional[bool] = Field(None, alias="canDefer")
    schedule_deadline_time: Optional[str] = Field(
        None,
        alias="scheduleDeadlineTime",
        description="Maintenance cannot be rescheduled to start beyond this deadline.",
    )
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description="The start time of any upcoming scheduled maintenance for this instance.",
    )
    can_reschedule: Optional[bool] = Field(
        None,
        alias="canReschedule",
        description="If the scheduled maintenance can be rescheduled.",
    )


class FailoverContext(BaseModel):
    kind: Optional[str] = Field(None, description="This is always `sql#failoverContext`.")
    settings_version: Optional[str] = Field(
        None,
        alias="settingsVersion",
        description="The current settings version of this instance. Request will be rejected if this version doesn't match the current settings version.",
    )


class RotateServerCaContext(BaseModel):
    next_version: Optional[str] = Field(
        None,
        alias="nextVersion",
        description="The fingerprint of the next version to be rotated to. If left unspecified, will be rotated to the most recently added server CA version.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#rotateServerCaContext`.")


class TruncateLogContext(BaseModel):
    kind: Optional[str] = Field(None, description="This is always `sql#truncateLogContext`.")
    log_type: Optional[str] = Field(
        None,
        alias="logType",
        description="The type of log to truncate. Valid values are `MYSQL_GENERAL_TABLE` and `MYSQL_SLOW_TABLE`.",
    )


class SslCert(BaseModel):
    sha1_fingerprint: Optional[str] = Field(
        None, alias="sha1Fingerprint", description="Sha1 Fingerprint."
    )
    cert_serial_number: Optional[str] = Field(
        None,
        alias="certSerialNumber",
        description="Serial number, as extracted from the certificate.",
    )
    cert: Optional[str] = Field(None, description="PEM representation.")
    instance: Optional[str] = Field(None, description="Name of the database instance.")
    common_name: Optional[str] = Field(
        None,
        alias="commonName",
        description="User supplied name. Constrained to [a-zA-Z.-_ ]+.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#sslCert`.")
    self_link: Optional[str] = Field(
        None, alias="selfLink", description="The URI of this resource."
    )
    create_time: Optional[str] = Field(
        None,
        alias="createTime",
        description="The time when the certificate was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`",
    )
    expiration_time: Optional[str] = Field(
        None,
        alias="expirationTime",
        description="The time when the certificate expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )


class DemoteMasterMySqlReplicaConfiguration(BaseModel):
    ca_certificate: Optional[str] = Field(
        None,
        alias="caCertificate",
        description="PEM representation of the trusted CA's x509 certificate.",
    )
    client_key: Optional[str] = Field(
        None,
        alias="clientKey",
        description="PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate. The format of the replica's private key can be either PKCS #1 or PKCS #8.",
    )
    client_certificate: Optional[str] = Field(
        None,
        alias="clientCertificate",
        description="PEM representation of the replica's x509 certificate.",
    )
    password: Optional[str] = Field(
        None, description="The password for the replication connection."
    )
    username: Optional[str] = Field(
        None, description="The username for the replication connection."
    )
    kind: Optional[str] = Field(
        None, description="This is always `sql#demoteMasterMysqlReplicaConfiguration`."
    )


class GenerateEphemeralCertResponse(BaseModel):
    ephemeral_cert: Optional[SslCert] = Field(
        None, alias="ephemeralCert", description="Generated cert"
    )


class Status(Enum):
    sql_operation_status_unspecified = "SQL_OPERATION_STATUS_UNSPECIFIED"
    pending = "PENDING"
    running = "RUNNING"
    done = "DONE"


class OperationType(Enum):
    sql_operation_type_unspecified = "SQL_OPERATION_TYPE_UNSPECIFIED"
    import_ = "IMPORT"
    export = "EXPORT"
    create = "CREATE"
    update = "UPDATE"
    delete = "DELETE"
    restart = "RESTART"
    backup = "BACKUP"
    snapshot = "SNAPSHOT"
    backup_volume = "BACKUP_VOLUME"
    delete_volume = "DELETE_VOLUME"
    restore_volume = "RESTORE_VOLUME"
    inject_user = "INJECT_USER"
    clone = "CLONE"
    stop_replica = "STOP_REPLICA"
    start_replica = "START_REPLICA"
    promote_replica = "PROMOTE_REPLICA"
    create_replica = "CREATE_REPLICA"
    create_user = "CREATE_USER"
    delete_user = "DELETE_USER"
    update_user = "UPDATE_USER"
    create_database = "CREATE_DATABASE"
    delete_database = "DELETE_DATABASE"
    update_database = "UPDATE_DATABASE"
    failover = "FAILOVER"
    delete_backup = "DELETE_BACKUP"
    recreate_replica = "RECREATE_REPLICA"
    truncate_log = "TRUNCATE_LOG"
    demote_master = "DEMOTE_MASTER"
    maintenance = "MAINTENANCE"
    enable_private_ip = "ENABLE_PRIVATE_IP"
    defer_maintenance = "DEFER_MAINTENANCE"
    create_clone = "CREATE_CLONE"
    reschedule_maintenance = "RESCHEDULE_MAINTENANCE"
    start_external_sync = "START_EXTERNAL_SYNC"
    log_cleanup = "LOG_CLEANUP"
    auto_restart = "AUTO_RESTART"


class BackupContext(BaseModel):
    kind: Optional[str] = Field(None, description="This is always `sql#backupContext`.")
    backup_id: Optional[str] = Field(
        None, alias="backupId", description="The identifier of the backup."
    )


class OperationError(BaseModel):
    message: Optional[str] = Field(
        None, description="Additional information about the error encountered."
    )
    code: Optional[str] = Field(None, description="Identifies the specific error that occurred.")
    kind: Optional[str] = Field(None, description="This is always `sql#operationError`.")


class EncryptionOptions(BaseModel):
    pvk_path: Optional[str] = Field(
        None,
        alias="pvkPath",
        description="Path to the Certificate Private Key (.pvk) in Cloud Storage, in the form `gs://bucketName/fileName`. The instance must have write permissions to the bucket and read access to the file.",
    )
    cert_path: Optional[str] = Field(
        None,
        alias="certPath",
        description="Path to the Certificate (.cer) in Cloud Storage, in the form `gs://bucketName/fileName`. The instance must have write permissions to the bucket and read access to the file.",
    )
    pvk_password: Optional[str] = Field(
        None, alias="pvkPassword", description="Password that encrypts the private key"
    )


class BakImportOptions(BaseModel):
    encryption_options: Optional[EncryptionOptions] = Field(None, alias="encryptionOptions")


class CsvImportOptions(BaseModel):
    lines_terminated_by: Optional[str] = Field(
        None,
        alias="linesTerminatedBy",
        description="This is used to separate lines. If a line does not contain all fields, the rest of the columns are set to their default values.",
    )
    fields_terminated_by: Optional[str] = Field(
        None,
        alias="fieldsTerminatedBy",
        description="Specifies the character that separates columns within each row (line) of the file.",
    )
    quote_character: Optional[str] = Field(
        None,
        alias="quoteCharacter",
        description="Specifies the quoting character to be used when a data value is quoted.",
    )
    columns: Optional[List[str]] = Field(
        None,
        description="The columns to which CSV data is imported. If not specified, all columns of the database table are loaded with CSV data.",
    )
    table: Optional[str] = Field(None, description="The table to which CSV data is imported.")
    escape_character: Optional[str] = Field(
        None,
        alias="escapeCharacter",
        description="Specifies the character that should appear before a data character that needs to be escaped.",
    )


class FileType(Enum):
    sql_file_type_unspecified = "SQL_FILE_TYPE_UNSPECIFIED"
    sql = "SQL"
    csv = "CSV"
    bak = "BAK"


class ImportContext(BaseModel):
    database: Optional[str] = Field(
        None,
        description="The target database for the import. If `fileType` is `SQL`, this field is required only if the import file does not specify a database, and is overridden by any database specification in the import file. If `fileType` is `CSV`, one database must be specified.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#importContext`.")
    uri: Optional[str] = Field(
        None,
        description="Path to the import file in Cloud Storage, in the form `gs://bucketName/fileName`. Compressed gzip files (.gz) are supported when `fileType` is `SQL`. The instance must have write permissions to the bucket and read access to the file.",
    )
    bak_import_options: Optional[BakImportOptions] = Field(
        None,
        alias="bakImportOptions",
        description="Import parameters specific to SQL Server .BAK files",
    )
    csv_import_options: Optional[CsvImportOptions] = Field(
        None, alias="csvImportOptions", description="Options for importing data as CSV."
    )
    file_type: Optional[FileType] = Field(
        None,
        alias="fileType",
        description="The file type for the specified uri.\\`SQL`: The file contains SQL statements. \\`CSV`: The file contains CSV data.",
    )
    import_user: Optional[str] = Field(
        None,
        alias="importUser",
        description="The PostgreSQL user for this import operation. PostgreSQL instances only.",
    )


class CsvExportOptions(BaseModel):
    lines_terminated_by: Optional[str] = Field(
        None,
        alias="linesTerminatedBy",
        description="This is used to separate lines. If a line does not contain all fields, the rest of the columns are set to their default values.",
    )
    quote_character: Optional[str] = Field(
        None,
        alias="quoteCharacter",
        description="Specifies the quoting character to be used when a data value is quoted.",
    )
    select_query: Optional[str] = Field(
        None,
        alias="selectQuery",
        description="The select query used to extract the data.",
    )
    fields_terminated_by: Optional[str] = Field(
        None,
        alias="fieldsTerminatedBy",
        description="Specifies the character that separates columns within each row (line) of the file.",
    )
    escape_character: Optional[str] = Field(
        None,
        alias="escapeCharacter",
        description="Specifies the character that should appear before a data character that needs to be escaped.",
    )


class MysqlExportOptions(BaseModel):
    master_data: Optional[int] = Field(
        None,
        alias="masterData",
        description="Option to include SQL statement required to set up replication. If set to `1`, the dump file includes a CHANGE MASTER TO statement with the binary log coordinates, and --set-gtid-purged is set to ON. If set to `2`, the CHANGE MASTER TO statement is written as a SQL comment and has no effect. If set to any value other than `1`, --set-gtid-purged is set to OFF.",
    )


class SqlExportOptions(BaseModel):
    tables: Optional[List[str]] = Field(
        None,
        description="Tables to export, or that were exported, from the specified database. If you specify tables, specify one and only one database. For PostgreSQL instances, you can specify only one table.",
    )
    mysql_export_options: Optional[MysqlExportOptions] = Field(
        None,
        alias="mysqlExportOptions",
        description="Options for exporting from MySQL.",
    )
    schema_only: Optional[bool] = Field(
        None, alias="schemaOnly", description="Export only schemas."
    )


class ExportContext(BaseModel):
    databases: Optional[List[str]] = Field(
        None,
        description="Databases to be exported. `MySQL instances:` If `fileType` is `SQL` and no database is specified, all databases are exported, except for the `mysql` system database. If `fileType` is `CSV`, you can specify one database, either by using this property or by using the `csvExportOptions.selectQuery` property, which takes precedence over this property. `PostgreSQL instances:` You must specify one database to be exported. If `fileType` is `CSV`, this database must match the one specified in the `csvExportOptions.selectQuery` property. `SQL Server instances:` You must specify one database to be exported, and the `fileType` must be `BAK`.",
    )
    uri: Optional[str] = Field(
        None,
        description="The path to the file in Google Cloud Storage where the export will be stored. The URI is in the form `gs://bucketName/fileName`. If the file already exists, the request succeeds, but the operation fails. If `fileType` is `SQL` and the filename ends with .gz, the contents are compressed.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#exportContext`.")
    offload: Optional[bool] = Field(None, description="Option for export offload.")
    file_type: Optional[FileType] = Field(
        None, alias="fileType", description="The file type for the specified uri."
    )
    csv_export_options: Optional[CsvExportOptions] = Field(
        None,
        alias="csvExportOptions",
        description="Options for exporting data as CSV. `MySQL` and `PostgreSQL` instances only.",
    )
    sql_export_options: Optional[SqlExportOptions] = Field(
        None,
        alias="sqlExportOptions",
        description="Options for exporting data as SQL statements.",
    )


class AclEntry(BaseModel):
    value: Optional[str] = Field(
        None, description="The allowlisted value for the access control list."
    )
    expiration_time: Optional[str] = Field(
        None,
        alias="expirationTime",
        description="The time when this access control entry expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )
    name: Optional[str] = Field(None, description="Optional. A label to identify this entry.")
    kind: Optional[str] = Field(None, description="This is always `sql#aclEntry`.")


class SyncMode(Enum):
    external_sync_mode_unspecified = "EXTERNAL_SYNC_MODE_UNSPECIFIED"
    online = "ONLINE"
    offline = "OFFLINE"


class SyncFlags(BaseModel):
    name: Optional[str] = Field(None, description="The name of the flag.")
    value: Optional[str] = Field(
        None,
        description="The value of the flag. This field must be omitted if the flag doesn't take a value.",
    )


class PasswordStatus(BaseModel):
    locked: Optional[bool] = Field(
        None, description="If true, user does not have login privileges."
    )
    password_expiration_time: Optional[str] = Field(
        None,
        alias="passwordExpirationTime",
        description="The expiration time of the current password.",
    )


class Type(Enum):
    sql_external_sync_setting_error_type_unspecified = (
        "SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED"
    )
    connection_failure = "CONNECTION_FAILURE"
    binlog_not_enabled = "BINLOG_NOT_ENABLED"
    incompatible_database_version = "INCOMPATIBLE_DATABASE_VERSION"
    replica_already_setup = "REPLICA_ALREADY_SETUP"
    insufficient_privilege = "INSUFFICIENT_PRIVILEGE"
    unsupported_migration_type = "UNSUPPORTED_MIGRATION_TYPE"
    no_pglogical_installed = "NO_PGLOGICAL_INSTALLED"
    pglogical_node_already_exists = "PGLOGICAL_NODE_ALREADY_EXISTS"
    invalid_wal_level = "INVALID_WAL_LEVEL"
    invalid_shared_preload_library = "INVALID_SHARED_PRELOAD_LIBRARY"
    insufficient_max_replication_slots = "INSUFFICIENT_MAX_REPLICATION_SLOTS"
    insufficient_max_wal_senders = "INSUFFICIENT_MAX_WAL_SENDERS"
    insufficient_max_worker_processes = "INSUFFICIENT_MAX_WORKER_PROCESSES"
    unsupported_extensions = "UNSUPPORTED_EXTENSIONS"
    invalid_rds_logical_replication = "INVALID_RDS_LOGICAL_REPLICATION"
    invalid_logging_setup = "INVALID_LOGGING_SETUP"
    invalid_db_param = "INVALID_DB_PARAM"
    unsupported_gtid_mode = "UNSUPPORTED_GTID_MODE"
    sqlserver_agent_not_running = "SQLSERVER_AGENT_NOT_RUNNING"
    unsupported_table_definition = "UNSUPPORTED_TABLE_DEFINITION"
    unsupported_definer = "UNSUPPORTED_DEFINER"
    sqlserver_servername_mismatch = "SQLSERVER_SERVERNAME_MISMATCH"
    primary_already_setup = "PRIMARY_ALREADY_SETUP"
    unsupported_binlog_format = "UNSUPPORTED_BINLOG_FORMAT"
    binlog_retention_setting = "BINLOG_RETENTION_SETTING"
    unsupported_storage_engine = "UNSUPPORTED_STORAGE_ENGINE"
    limited_support_tables = "LIMITED_SUPPORT_TABLES"


class SqlExternalSyncSettingError(BaseModel):
    kind: Optional[str] = Field(
        None,
        description="Can be `sql#externalSyncSettingError` or `sql#externalSyncSettingWarning`.",
    )
    detail: Optional[str] = Field(
        None, description="Additional information about the error encountered."
    )
    type: Optional[Type] = Field(None, description="Identifies the specific error that occurred.")


class DenyMaintenancePeriod(BaseModel):
    start_date: Optional[str] = Field(
        None,
        alias="startDate",
        description='"deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01',
    )
    time: Optional[str] = Field(
        None,
        description='Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00',
    )
    end_date: Optional[str] = Field(
        None,
        alias="endDate",
        description='"deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01',
    )


class Type1(Enum):
    sql_ip_address_type_unspecified = "SQL_IP_ADDRESS_TYPE_UNSPECIFIED"
    primary = "PRIMARY"
    outgoing = "OUTGOING"
    private = "PRIVATE"
    migrated_1_st_gen = "MIGRATED_1ST_GEN"


class IpMapping(BaseModel):
    time_to_retire: Optional[str] = Field(
        None,
        alias="timeToRetire",
        description="The due time for this IP to be retired in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`. This field is only available when the IP is scheduled to be retired.",
    )
    ip_address: Optional[str] = Field(
        None, alias="ipAddress", description="The IP address assigned."
    )
    type: Optional[Type1] = Field(
        None,
        description="The type of this IP address. A `PRIMARY` address is a public address that can accept incoming connections. A `PRIVATE` address is a private address that can accept incoming connections. An `OUTGOING` address is the source address of connections originating from the instance, if supported.",
    )


class InstancesImportRequest(BaseModel):
    import_context: Optional[ImportContext] = Field(
        None,
        alias="importContext",
        description="Contains details about the import operation.",
    )


class SqlServerDatabaseDetails(BaseModel):
    recovery_model: Optional[str] = Field(
        None,
        alias="recoveryModel",
        description="The recovery model of a SQL Server database",
    )
    compatibility_level: Optional[int] = Field(
        None,
        alias="compatibilityLevel",
        description="The version of SQL Server with which the database is to be made compatible",
    )


class SqlServerUserDetails(BaseModel):
    server_roles: Optional[List[str]] = Field(
        None, alias="serverRoles", description="The server roles for this user"
    )
    disabled: Optional[bool] = Field(None, description="If the user has been disabled")


class BackupKind(Enum):
    sql_backup_kind_unspecified = "SQL_BACKUP_KIND_UNSPECIFIED"
    snapshot = "SNAPSHOT"
    physical = "PHYSICAL"


class Type2(Enum):
    sql_backup_run_type_unspecified = "SQL_BACKUP_RUN_TYPE_UNSPECIFIED"
    automated = "AUTOMATED"
    on_demand = "ON_DEMAND"


class Status1(Enum):
    sql_backup_run_status_unspecified = "SQL_BACKUP_RUN_STATUS_UNSPECIFIED"
    enqueued = "ENQUEUED"
    overdue = "OVERDUE"
    running = "RUNNING"
    failed = "FAILED"
    successful = "SUCCESSFUL"
    skipped = "SKIPPED"
    deletion_pending = "DELETION_PENDING"
    deletion_failed = "DELETION_FAILED"
    deleted = "DELETED"


class DiskEncryptionStatus(BaseModel):
    kms_key_version_name: Optional[str] = Field(
        None,
        alias="kmsKeyVersionName",
        description="KMS key version used to encrypt the Cloud SQL instance resource",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#diskEncryptionStatus`.")


class DatabaseFlags(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name of the flag. These flags are passed at instance startup, so include both server options and system variables. Flags are specified with underscores, not hyphens. For more information, see [Configuring Database Flags](https://cloud.google.com/sql/docs/mysql/flags) in the Cloud SQL documentation.",
    )
    value: Optional[str] = Field(
        None,
        description="The value of the flag. Boolean flags are set to `on` for true and `off` for false. This field must be omitted if the flag doesn't take a value.",
    )


class InstancesFailoverRequest(BaseModel):
    failover_context: Optional[FailoverContext] = Field(
        None, alias="failoverContext", description="Failover Context."
    )


class AppliesToEnum(Enum):
    sql_database_version_unspecified = "SQL_DATABASE_VERSION_UNSPECIFIED"
    mysql_5_1 = "MYSQL_5_1"
    mysql_5_5 = "MYSQL_5_5"
    mysql_5_6 = "MYSQL_5_6"
    mysql_5_7 = "MYSQL_5_7"
    postgres_9_6 = "POSTGRES_9_6"
    postgres_11 = "POSTGRES_11"
    sqlserver_2017_standard = "SQLSERVER_2017_STANDARD"
    sqlserver_2017_enterprise = "SQLSERVER_2017_ENTERPRISE"
    sqlserver_2017_express = "SQLSERVER_2017_EXPRESS"
    sqlserver_2017_web = "SQLSERVER_2017_WEB"
    postgres_10 = "POSTGRES_10"
    postgres_12 = "POSTGRES_12"
    mysql_8_0 = "MYSQL_8_0"
    mysql_8_0_18 = "MYSQL_8_0_18"
    mysql_8_0_26 = "MYSQL_8_0_26"
    mysql_8_0_27 = "MYSQL_8_0_27"
    mysql_8_0_28 = "MYSQL_8_0_28"
    mysql_8_0_29 = "MYSQL_8_0_29"
    postgres_13 = "POSTGRES_13"
    postgres_14 = "POSTGRES_14"
    sqlserver_2019_standard = "SQLSERVER_2019_STANDARD"
    sqlserver_2019_enterprise = "SQLSERVER_2019_ENTERPRISE"
    sqlserver_2019_express = "SQLSERVER_2019_EXPRESS"
    sqlserver_2019_web = "SQLSERVER_2019_WEB"


class Type3(Enum):
    sql_flag_type_unspecified = "SQL_FLAG_TYPE_UNSPECIFIED"
    boolean = "BOOLEAN"
    string = "STRING"
    integer = "INTEGER"
    none = "NONE"
    mysql_timezone_offset = "MYSQL_TIMEZONE_OFFSET"
    float = "FLOAT"
    repeated_string = "REPEATED_STRING"


class Flag(BaseModel):
    allowed_int_values: Optional[List[str]] = Field(
        None,
        alias="allowedIntValues",
        description="Use this field if only certain integers are accepted. Can be combined with min_value and max_value to add additional values.",
    )
    min_value: Optional[str] = Field(
        None,
        alias="minValue",
        description="For `INTEGER` flags, the minimum allowed value.",
    )
    allowed_string_values: Optional[List[str]] = Field(
        None,
        alias="allowedStringValues",
        description="For `STRING` flags, a list of strings that the value can be set to.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#flag`.")
    requires_restart: Optional[bool] = Field(
        None,
        alias="requiresRestart",
        description="Indicates whether changing this flag will trigger a database restart. Only applicable to Second Generation instances.",
    )
    max_value: Optional[str] = Field(
        None,
        alias="maxValue",
        description="For `INTEGER` flags, the maximum allowed value.",
    )
    applies_to: Optional[List[AppliesToEnum]] = Field(
        None,
        alias="appliesTo",
        description="The database version this flag applies to. Can be MySQL instances: `MYSQL_8_0`, `MYSQL_8_0_18`, `MYSQL_8_0_26`, `MYSQL_5_7`, or `MYSQL_5_6`. PostgreSQL instances: `POSTGRES_9_6`, `POSTGRES_10`, `POSTGRES_11` or `POSTGRES_12`. SQL Server instances: `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`, `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`, or `SQLSERVER_2019_WEB`. See [the complete list](/sql/docs/mysql/admin-api/rest/v1/SqlDatabaseVersion).",
    )
    name: Optional[str] = Field(
        None,
        description="This is the name of the flag. Flag names always use underscores, not hyphens, for example: `max_allowed_packet`",
    )
    type: Optional[Type3] = Field(
        None,
        description="The type of the flag. Flags are typed to being `BOOLEAN`, `STRING`, `INTEGER` or `NONE`. `NONE` is used for flags that do not take a value, such as `skip_grant_tables`.",
    )
    in_beta: Optional[bool] = Field(
        None,
        alias="inBeta",
        description="Whether or not the flag is considered in beta.",
    )


class MySqlReplicaConfiguration(BaseModel):
    client_key: Optional[str] = Field(
        None,
        alias="clientKey",
        description="PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate.",
    )
    connect_retry_interval: Optional[int] = Field(
        None,
        alias="connectRetryInterval",
        description="Seconds to wait between connect retries. MySQL's default is 60 seconds.",
    )
    verify_server_certificate: Optional[bool] = Field(
        None,
        alias="verifyServerCertificate",
        description="Whether or not to check the primary instance's Common Name value in the certificate that it sends during the SSL handshake.",
    )
    ca_certificate: Optional[str] = Field(
        None,
        alias="caCertificate",
        description="PEM representation of the trusted CA's x509 certificate.",
    )
    ssl_cipher: Optional[str] = Field(
        None,
        alias="sslCipher",
        description="A list of permissible ciphers to use for SSL encryption.",
    )
    dump_file_path: Optional[str] = Field(
        None,
        alias="dumpFilePath",
        description="Path to a SQL dump file in Google Cloud Storage from which the replica instance is to be created. The URI is in the form gs://bucketName/fileName. Compressed gzip files (.gz) are also supported. Dumps have the binlog co-ordinates from which replication begins. This can be accomplished by setting --master-data to 1 when using mysqldump.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#mysqlReplicaConfiguration`.")
    client_certificate: Optional[str] = Field(
        None,
        alias="clientCertificate",
        description="PEM representation of the replica's x509 certificate.",
    )
    password: Optional[str] = Field(
        None, description="The password for the replication connection."
    )
    master_heartbeat_period: Optional[str] = Field(
        None,
        alias="masterHeartbeatPeriod",
        description="Interval in milliseconds between replication heartbeats.",
    )
    username: Optional[str] = Field(
        None, description="The username for the replication connection."
    )


class Complexity(Enum):
    complexity_unspecified = "COMPLEXITY_UNSPECIFIED"
    complexity_default = "COMPLEXITY_DEFAULT"


class PasswordValidationPolicy(BaseModel):
    min_length: Optional[int] = Field(
        None, alias="minLength", description="Minimum number of characters allowed."
    )
    reuse_interval: Optional[int] = Field(
        None,
        alias="reuseInterval",
        description="Number of previous passwords that cannot be reused.",
    )
    disallow_username_substring: Optional[bool] = Field(
        None,
        alias="disallowUsernameSubstring",
        description="Disallow username as a part of the password.",
    )
    complexity: Optional[Complexity] = Field(None, description="The complexity of the password.")
    enable_password_policy: Optional[bool] = Field(
        None,
        alias="enablePasswordPolicy",
        description="Whether the password policy is enabled or not.",
    )
    password_change_interval: Optional[str] = Field(
        None,
        alias="passwordChangeInterval",
        description="Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.",
    )


class BackendType(Enum):
    sql_backend_type_unspecified = "SQL_BACKEND_TYPE_UNSPECIFIED"
    first_gen = "FIRST_GEN"
    second_gen = "SECOND_GEN"
    external = "EXTERNAL"


class InstanceType(Enum):
    sql_instance_type_unspecified = "SQL_INSTANCE_TYPE_UNSPECIFIED"
    cloud_sql_instance = "CLOUD_SQL_INSTANCE"
    on_premises_instance = "ON_PREMISES_INSTANCE"
    read_replica_instance = "READ_REPLICA_INSTANCE"


class SuspensionReasonEnum(Enum):
    sql_suspension_reason_unspecified = "SQL_SUSPENSION_REASON_UNSPECIFIED"
    billing_issue = "BILLING_ISSUE"
    legal_issue = "LEGAL_ISSUE"
    operational_issue = "OPERATIONAL_ISSUE"
    kms_key_issue = "KMS_KEY_ISSUE"


class State(Enum):
    sql_instance_state_unspecified = "SQL_INSTANCE_STATE_UNSPECIFIED"
    runnable = "RUNNABLE"
    suspended = "SUSPENDED"
    pending_delete = "PENDING_DELETE"
    pending_create = "PENDING_CREATE"
    maintenance = "MAINTENANCE"
    failed = "FAILED"
    online_maintenance = "ONLINE_MAINTENANCE"


class FailoverReplica(BaseModel):
    available: Optional[bool] = Field(
        None,
        description="The availability status of the failover replica. A false status indicates that the failover replica is out of sync. The primary instance can only failover to the failover replica when the status is true.",
    )
    name: Optional[str] = Field(
        None,
        description="The name of the failover replica. If specified at instance creation, a failover replica is created for the instance. The name doesn't include the project ID.",
    )


class SqlOutOfDiskState(Enum):
    sql_out_of_disk_state_unspecified = "SQL_OUT_OF_DISK_STATE_UNSPECIFIED"
    normal = "NORMAL"
    soft_shutdown = "SOFT_SHUTDOWN"


class SqlOutOfDiskReport(BaseModel):
    sql_min_recommended_increase_size_gb: Optional[int] = Field(
        None,
        alias="sqlMinRecommendedIncreaseSizeGb",
        description="The minimum recommended increase size in GigaBytes This field is consumed by the frontend * Writers: * the proactive database wellness job for OOD. * Readers:",
    )
    sql_out_of_disk_state: Optional[SqlOutOfDiskState] = Field(
        None,
        alias="sqlOutOfDiskState",
        description="This field represents the state generated by the proactive database wellness job for OutOfDisk issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive database wellness job",
    )


class InstanceReference(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name of the Cloud SQL instance being referenced. This does not include the project ID.",
    )
    region: Optional[str] = Field(
        None, description="The region of the Cloud SQL instance being referenced."
    )
    project: Optional[str] = Field(
        None,
        description="The project ID of the Cloud SQL instance being referenced. The default is the same project ID as the instance references it.",
    )


class ReplicaConfiguration(BaseModel):
    mysql_replica_configuration: Optional[MySqlReplicaConfiguration] = Field(
        None,
        alias="mysqlReplicaConfiguration",
        description="MySQL specific configuration when replicating from a MySQL on-premises primary instance. Replication configuration information such as the username, password, certificates, and keys are not stored in the instance metadata. The configuration information is used only to set up the replication connection and is stored by MySQL in a file named `master.info` in the data directory.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#replicaConfiguration`.")
    failover_target: Optional[bool] = Field(
        None,
        alias="failoverTarget",
        description="Specifies if the replica is the failover target. If the field is set to `true`, the replica will be designated as a failover replica. In case the primary instance fails, the replica instance will be promoted as the new primary instance. Only one replica can be specified as failover target, and the replica has to be in different zone with the primary instance.",
    )


class AvailabilityType(Enum):
    sql_availability_type_unspecified = "SQL_AVAILABILITY_TYPE_UNSPECIFIED"
    zonal = "ZONAL"
    regional = "REGIONAL"


class DataDiskType(Enum):
    sql_data_disk_type_unspecified = "SQL_DATA_DISK_TYPE_UNSPECIFIED"
    pd_ssd = "PD_SSD"
    pd_hdd = "PD_HDD"
    obsolete_local_ssd = "OBSOLETE_LOCAL_SSD"


class ActivationPolicy(Enum):
    sql_activation_policy_unspecified = "SQL_ACTIVATION_POLICY_UNSPECIFIED"
    always = "ALWAYS"
    never = "NEVER"
    on_demand = "ON_DEMAND"


class ReplicationType(Enum):
    sql_replication_type_unspecified = "SQL_REPLICATION_TYPE_UNSPECIFIED"
    synchronous = "SYNCHRONOUS"
    asynchronous = "ASYNCHRONOUS"


class PricingPlan(Enum):
    sql_pricing_plan_unspecified = "SQL_PRICING_PLAN_UNSPECIFIED"
    package = "PACKAGE"
    per_use = "PER_USE"


class SqlServerAuditConfig(BaseModel):
    retention_interval: Optional[str] = Field(
        None,
        alias="retentionInterval",
        description="How long to keep generated audit files.",
    )
    kind: Optional[str] = Field(None, description="This is always sql#sqlServerAuditConfig")
    bucket: Optional[str] = Field(
        None, description="The name of the destination bucket (e.g., gs://mybucket)."
    )
    upload_interval: Optional[str] = Field(
        None,
        alias="uploadInterval",
        description="How often to upload generated audit files.",
    )


class SqlActiveDirectoryConfig(BaseModel):
    kind: Optional[str] = Field(None, description="This is always sql#activeDirectoryConfig.")
    domain: Optional[str] = Field(None, description="The name of the domain (e.g., mydomain.com).")


class UpdateTrack(Enum):
    sql_update_track_unspecified = "SQL_UPDATE_TRACK_UNSPECIFIED"
    canary = "canary"
    stable = "stable"


class MaintenanceWindow(BaseModel):
    day: Optional[int] = Field(None, description="day of week (1-7), starting on Monday.")
    kind: Optional[str] = Field(None, description="This is always `sql#maintenanceWindow`.")
    hour: Optional[int] = Field(None, description="hour of day - 0 to 23.")
    update_track: Optional[UpdateTrack] = Field(
        None,
        alias="updateTrack",
        description="Maintenance timing setting: `canary` (Earlier) or `stable` (Later). [Learn more](https://cloud.google.com/sql/docs/mysql/instance-settings#maintenance-timing-2ndgen).",
    )


class Code(Enum):
    sql_api_warning_code_unspecified = "SQL_API_WARNING_CODE_UNSPECIFIED"
    region_unreachable = "REGION_UNREACHABLE"
    max_results_exceeds_limit = "MAX_RESULTS_EXCEEDS_LIMIT"


class ApiWarning(BaseModel):
    code: Optional[Code] = Field(None, description="Code to uniquely identify the warning type.")
    region: Optional[str] = Field(
        None, description="The region name for REGION_UNREACHABLE warning."
    )
    message: Optional[str] = Field(None, description="The warning message.")


class SslCertsCreateEphemeralRequest(BaseModel):
    access_token: Optional[str] = Field(
        None, description="Access token to include in the signed certificate."
    )
    public_key: Optional[str] = Field(
        None, description="PEM encoded public key to include in the signed certificate."
    )


class InstancesRestoreBackupRequest(BaseModel):
    restore_backup_context: Optional[RestoreBackupContext] = Field(
        None,
        alias="restoreBackupContext",
        description="Parameters required to perform the restore backup operation.",
    )


class InstancesExportRequest(BaseModel):
    export_context: Optional[ExportContext] = Field(
        None,
        alias="exportContext",
        description="Contains details about the export operation.",
    )


class Tier(BaseModel):
    tier: Optional[str] = Field(
        None,
        description="An identifier for the machine type, for example, `db-custom-1-3840`. For related information, see [Pricing](/sql/pricing).",
    )
    disk_quota: Optional[str] = Field(
        None,
        alias="DiskQuota",
        description="The maximum disk size of this tier in bytes.",
    )
    ram: Optional[str] = Field(
        None, alias="RAM", description="The maximum RAM usage of this tier in bytes."
    )
    region: Optional[List[str]] = Field(None, description="The applicable regions for this tier.")
    kind: Optional[str] = Field(None, description="This is always `sql#tier`.")


class InstancesRotateServerCaRequest(BaseModel):
    rotate_server_ca_context: Optional[RotateServerCaContext] = Field(
        None,
        alias="rotateServerCaContext",
        description="Contains details about the rotate server CA operation.",
    )


class FlagsListResponse(BaseModel):
    items: Optional[List[Flag]] = Field(None, description="List of flags.")
    kind: Optional[str] = Field(None, description="This is always `sql#flagsList`.")


class SslCertsInsertRequest(BaseModel):
    common_name: Optional[str] = Field(
        None,
        alias="commonName",
        description="User supplied name. Must be a distinct name from the other certificates for this instance.",
    )


class DualPasswordType(Enum):
    dual_password_type_unspecified = "DUAL_PASSWORD_TYPE_UNSPECIFIED"
    no_modify_dual_password = "NO_MODIFY_DUAL_PASSWORD"
    no_dual_password = "NO_DUAL_PASSWORD"
    dual_password = "DUAL_PASSWORD"


class Type4(Enum):
    built_in = "BUILT_IN"
    cloud_iam_user = "CLOUD_IAM_USER"
    cloud_iam_service_account = "CLOUD_IAM_SERVICE_ACCOUNT"


class UserPasswordValidationPolicy(BaseModel):
    password_expiration_duration: Optional[str] = Field(
        None,
        alias="passwordExpirationDuration",
        description="Expiration duration after password is updated.",
    )
    allowed_failed_attempts: Optional[int] = Field(
        None,
        alias="allowedFailedAttempts",
        description="Number of failed login attempts allowed before user get locked.",
    )
    enable_password_verification: Optional[bool] = Field(
        None,
        alias="enablePasswordVerification",
        description="If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.",
    )
    status: Optional[PasswordStatus] = Field(
        None, description="Output only. Read-only password status."
    )
    enable_failed_attempts_check: Optional[bool] = Field(
        None,
        alias="enableFailedAttemptsCheck",
        description="If true, failed login attempts check will be enabled.",
    )


class RescheduleType(Enum):
    reschedule_type_unspecified = "RESCHEDULE_TYPE_UNSPECIFIED"
    immediate = "IMMEDIATE"
    next_available_window = "NEXT_AVAILABLE_WINDOW"
    specific_time = "SPECIFIC_TIME"


class Reschedule(BaseModel):
    reschedule_type: Optional[RescheduleType] = Field(
        None,
        alias="rescheduleType",
        description="Required. The type of the reschedule.",
    )
    schedule_time: Optional[str] = Field(
        None,
        alias="scheduleTime",
        description="Optional. Timestamp when the maintenance shall be rescheduled to if reschedule_type=SPECIFIC_TIME, in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )


class SqlInstancesRescheduleMaintenanceRequestBody(BaseModel):
    reschedule: Optional[Reschedule] = Field(
        None, description="Required. The type of the reschedule the user wants."
    )


class SslCertsListResponse(BaseModel):
    kind: Optional[str] = Field(None, description="This is always `sql#sslCertsList`.")
    items: Optional[List[SslCert]] = Field(
        None, description="List of client certificates for the instance."
    )


class BinLogCoordinates(BaseModel):
    bin_log_file_name: Optional[str] = Field(
        None,
        alias="binLogFileName",
        description="Name of the binary log file for a Cloud SQL instance.",
    )
    bin_log_position: Optional[str] = Field(
        None,
        alias="binLogPosition",
        description="Position (offset) within the binary log file.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#binLogCoordinates`.")


class GenerateEphemeralCertRequest(BaseModel):
    valid_duration: Optional[str] = Field(
        None,
        alias="validDuration",
        description="Optional. If set, it will contain the cert valid duration.",
    )
    public_key: Optional[str] = Field(
        None, description="PEM encoded public key to include in the signed certificate."
    )
    read_time: Optional[str] = Field(
        None,
        alias="readTime",
        description="Optional. Optional snapshot read timestamp to trade freshness for performance.",
    )
    access_token: Optional[str] = Field(
        None, description="Optional. Access token to include in the signed certificate."
    )


class SslCertDetail(BaseModel):
    cert_private_key: Optional[str] = Field(
        None,
        alias="certPrivateKey",
        description="The private key for the client cert, in pem format. Keep private in order to protect your security.",
    )
    cert_info: Optional[SslCert] = Field(
        None, alias="certInfo", description="The public information about the cert."
    )


class CloneContext(BaseModel):
    pitr_timestamp_ms: Optional[str] = Field(
        None, alias="pitrTimestampMs", description="Reserved for future use."
    )
    allocated_ip_range: Optional[str] = Field(
        None,
        alias="allocatedIpRange",
        description='The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. Reserved for future use.',
    )
    point_in_time: Optional[str] = Field(
        None,
        alias="pointInTime",
        description="Timestamp, if specified, identifies the time to which the source instance is cloned.",
    )
    destination_instance_name: Optional[str] = Field(
        None,
        alias="destinationInstanceName",
        description="Name of the Cloud SQL instance to be created as a clone.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#cloneContext`.")
    bin_log_coordinates: Optional[BinLogCoordinates] = Field(
        None,
        alias="binLogCoordinates",
        description="Binary log coordinates, if specified, identify the position up to which the source instance is cloned. If not specified, the source instance is cloned up to the most recent binary log coordinates.",
    )


class ConnectSettings(BaseModel):
    ip_addresses: Optional[List[IpMapping]] = Field(
        None,
        alias="ipAddresses",
        description="The assigned IP addresses for the instance.",
    )
    server_ca_cert: Optional[SslCert] = Field(
        None, alias="serverCaCert", description="SSL configuration."
    )
    database_version: Optional[AppliesToEnum] = Field(
        None,
        alias="databaseVersion",
        description="The database engine type and version. The `databaseVersion` field cannot be changed after instance creation. MySQL instances: `MYSQL_8_0`, `MYSQL_5_7` (default), or `MYSQL_5_6`. PostgreSQL instances: `POSTGRES_9_6`, `POSTGRES_10`, `POSTGRES_11`, `POSTGRES_12` (default), `POSTGRES_13`, or `POSTGRES_14`. SQL Server instances: `SQLSERVER_2017_STANDARD` (default), `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`, `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`, or `SQLSERVER_2019_WEB`.",
    )
    backend_type: Optional[BackendType] = Field(
        None,
        alias="backendType",
        description="`SECOND_GEN`: Cloud SQL database instance. `EXTERNAL`: A database server that is not managed by Google. This property is read-only; use the `tier` property in the `settings` object to determine the database type.",
    )
    region: Optional[str] = Field(
        None,
        description="The cloud region for the instance. For example, `us-central1`, `europe-west1`. The region cannot be changed after instance creation.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#connectSettings`.")


class BackupConfiguration(BaseModel):
    point_in_time_recovery_enabled: Optional[bool] = Field(
        None,
        alias="pointInTimeRecoveryEnabled",
        description="(Postgres only) Whether point in time recovery is enabled.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#backupConfiguration`.")
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description="Start time for the daily backup configuration in UTC timezone in the 24 hour format - `HH:MM`.",
    )
    replication_log_archiving_enabled: Optional[bool] = Field(
        None,
        alias="replicationLogArchivingEnabled",
        description="Reserved for future use.",
    )
    binary_log_enabled: Optional[bool] = Field(
        None,
        alias="binaryLogEnabled",
        description="(MySQL only) Whether binary log is enabled. If backup configuration is disabled, binarylog must be disabled as well.",
    )
    backup_retention_settings: Optional[BackupRetentionSettings] = Field(
        None, alias="backupRetentionSettings", description="Backup retention settings."
    )
    location: Optional[str] = Field(None, description="Location of the backup")
    transaction_log_retention_days: Optional[int] = Field(
        None,
        alias="transactionLogRetentionDays",
        description="The number of days of transaction logs we retain for point in time restore, from 1-7.",
    )
    enabled: Optional[bool] = Field(None, description="Whether this configuration is enabled.")


class InstancesTruncateLogRequest(BaseModel):
    truncate_log_context: Optional[TruncateLogContext] = Field(
        None,
        alias="truncateLogContext",
        description="Contains details about the truncate log operation.",
    )


class InstancesListServerCasResponse(BaseModel):
    kind: Optional[str] = Field(None, description="This is always `sql#instancesListServerCas`.")
    active_version: Optional[str] = Field(None, alias="activeVersion")
    certs: Optional[List[SslCert]] = Field(
        None, description="List of server CA certificates for the instance."
    )


class DemoteMasterConfiguration(BaseModel):
    mysql_replica_configuration: Optional[DemoteMasterMySqlReplicaConfiguration] = Field(
        None,
        alias="mysqlReplicaConfiguration",
        description="MySQL specific configuration when replicating from a MySQL on-premises primary instance. Replication configuration information such as the username, password, certificates, and keys are not stored in the instance metadata. The configuration information is used only to set up the replication connection and is stored by MySQL in a file named `master.info` in the data directory.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#demoteMasterConfiguration`.")


class OperationErrors(BaseModel):
    kind: Optional[str] = Field(None, description="This is always `sql#operationErrors`.")
    errors: Optional[List[OperationError]] = Field(
        None,
        description="The list of errors encountered while processing this operation.",
    )


class IpConfiguration(BaseModel):
    authorized_networks: Optional[List[AclEntry]] = Field(
        None,
        alias="authorizedNetworks",
        description="The list of external networks that are allowed to connect to the instance using the IP. In 'CIDR' notation, also known as 'slash' notation (for example: `157.197.200.0/24`).",
    )
    allocated_ip_range: Optional[str] = Field(
        None,
        alias="allocatedIpRange",
        description='The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?.`',
    )
    require_ssl: Optional[bool] = Field(
        None,
        alias="requireSsl",
        description="Whether SSL connections over IP are enforced or not.",
    )
    ipv4_enabled: Optional[bool] = Field(
        None,
        alias="ipv4Enabled",
        description="Whether the instance is assigned a public IP address or not.",
    )
    private_network: Optional[str] = Field(
        None,
        alias="privateNetwork",
        description="The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, `/projects/myProject/global/networks/default`. This setting can be updated, but it cannot be removed after it is set.",
    )


class MySqlSyncConfig(BaseModel):
    initial_sync_flags: Optional[List[SyncFlags]] = Field(
        None, alias="initialSyncFlags", description="Flags to use for the initial dump."
    )


class SqlInstancesVerifyExternalSyncSettingsResponse(BaseModel):
    errors: Optional[List[SqlExternalSyncSettingError]] = Field(
        None, description="List of migration violations."
    )
    kind: Optional[str] = Field(None, description="This is always `sql#migrationSettingErrorList`.")
    warnings: Optional[List[SqlExternalSyncSettingError]] = Field(
        None, description="List of migration warnings."
    )


class Database(BaseModel):
    self_link: Optional[str] = Field(
        None, alias="selfLink", description="The URI of this resource."
    )
    name: Optional[str] = Field(
        None,
        description="The name of the database in the Cloud SQL instance. This does not include the project ID or instance name.",
    )
    sqlserver_database_details: Optional[SqlServerDatabaseDetails] = Field(
        None, alias="sqlserverDatabaseDetails"
    )
    kind: Optional[str] = Field(None, description="This is always `sql#database`.")
    project: Optional[str] = Field(
        None,
        description="The project ID of the project containing the Cloud SQL database. The Google apps domain is prefixed if applicable.",
    )
    charset: Optional[str] = Field(None, description="The Cloud SQL charset value.")
    collation: Optional[str] = Field(None, description="The Cloud SQL collation value.")
    etag: Optional[str] = Field(
        None,
        description="This field is deprecated and will be removed from a future version of the API.",
    )
    instance: Optional[str] = Field(
        None,
        description="The name of the Cloud SQL instance. This does not include the project ID.",
    )


class BackupRun(BaseModel):
    self_link: Optional[str] = Field(
        None, alias="selfLink", description="The URI of this resource."
    )
    backup_kind: Optional[BackupKind] = Field(
        None,
        alias="backupKind",
        description="Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.",
    )
    id: Optional[str] = Field(
        None,
        description="The identifier for this backup run. Unique only for a specific Cloud SQL instance.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#backupRun`.")
    location: Optional[str] = Field(None, description="Location of the backups.")
    disk_encryption_status: Optional[DiskEncryptionStatus] = Field(
        None,
        alias="diskEncryptionStatus",
        description="Encryption status specific to a backup.",
    )
    type: Optional[Type2] = Field(
        None,
        description='The type of this run; can be either "AUTOMATED" or "ON_DEMAND" or "FINAL". This field defaults to "ON_DEMAND" and is ignored, when specified for insert requests.',
    )
    window_start_time: Optional[str] = Field(
        None,
        alias="windowStartTime",
        description="The start time of the backup window during which this the backup was attempted in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description="The time the backup operation actually started in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )
    enqueued_time: Optional[str] = Field(
        None,
        alias="enqueuedTime",
        description="The time the run was enqueued in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )
    error: Optional[OperationError] = Field(
        None,
        description="Information about why the backup operation failed. This is only present if the run has the FAILED status.",
    )
    status: Optional[Status1] = Field(None, description="The status of this run.")
    instance: Optional[str] = Field(None, description="Name of the database instance.")
    end_time: Optional[str] = Field(
        None,
        alias="endTime",
        description="The time the backup operation completed in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )
    description: Optional[str] = Field(
        None,
        description="The description of this run, only applicable to on-demand backups.",
    )
    disk_encryption_configuration: Optional[DiskEncryptionConfiguration] = Field(
        None,
        alias="diskEncryptionConfiguration",
        description="Encryption configuration specific to a backup.",
    )


class OnPremisesConfiguration(BaseModel):
    client_key: Optional[str] = Field(
        None,
        alias="clientKey",
        description="PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate.",
    )
    password: Optional[str] = Field(
        None, description="The password for connecting to on-premises instance."
    )
    ca_certificate: Optional[str] = Field(
        None,
        alias="caCertificate",
        description="PEM representation of the trusted CA's x509 certificate.",
    )
    host_port: Optional[str] = Field(
        None,
        alias="hostPort",
        description="The host and port of the on-premises instance in host:port format",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#onPremisesConfiguration`.")
    source_instance: Optional[InstanceReference] = Field(
        None,
        alias="sourceInstance",
        description="The reference to Cloud SQL instance if the source is Cloud SQL.",
    )
    client_certificate: Optional[str] = Field(
        None,
        alias="clientCertificate",
        description="PEM representation of the replica's x509 certificate.",
    )
    username: Optional[str] = Field(
        None, description="The username for connecting to on-premises instance."
    )
    dump_file_path: Optional[str] = Field(
        None,
        alias="dumpFilePath",
        description="The dump file to create the Cloud SQL replica.",
    )


class Settings(BaseModel):
    settings_version: Optional[str] = Field(
        None,
        alias="settingsVersion",
        description="The version of instance settings. This is a required field for update method to make sure concurrent updates are handled properly. During update, use the most recent settingsVersion value for this instance and do not try to update this value.",
    )
    storage_auto_resize_limit: Optional[str] = Field(
        None,
        alias="storageAutoResizeLimit",
        description="The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.",
    )
    database_flags: Optional[List[DatabaseFlags]] = Field(
        None,
        alias="databaseFlags",
        description="The database flags passed to the instance at startup.",
    )
    sql_server_audit_config: Optional[SqlServerAuditConfig] = Field(
        None,
        alias="sqlServerAuditConfig",
        description="SQL Server specific audit configuration.",
    )
    crash_safe_replication_enabled: Optional[bool] = Field(
        None,
        alias="crashSafeReplicationEnabled",
        description="Configuration specific to read replica instances. Indicates whether database flags for crash-safe replication are enabled. This property was only applicable to First Generation instances.",
    )
    availability_type: Optional[AvailabilityType] = Field(
        None,
        alias="availabilityType",
        description="Availability type. Potential values: * `ZONAL`: The instance serves data from only one zone. Outages in that zone affect data accessibility. * `REGIONAL`: The instance can serve data from more than one zone in a region (it is highly available)./ For more information, see [Overview of the High Availability Configuration](https://cloud.google.com/sql/docs/mysql/high-availability).",
    )
    location_preference: Optional[LocationPreference] = Field(
        None,
        alias="locationPreference",
        description="The location preference settings. This allows the instance to be located as near as possible to either an App Engine app or Compute Engine zone for better performance. App Engine co-location was only applicable to First Generation instances.",
    )
    deletion_protection_enabled: Optional[bool] = Field(
        None,
        alias="deletionProtectionEnabled",
        description="Configuration to protect against accidental instance deletion.",
    )
    authorized_gae_applications: Optional[List[str]] = Field(
        None,
        alias="authorizedGaeApplications",
        description="The App Engine app IDs that can access this instance. (Deprecated) Applied to First Generation instances only.",
    )
    data_disk_type: Optional[DataDiskType] = Field(
        None,
        alias="dataDiskType",
        description="The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not used for First Generation instances.",
    )
    tier: Optional[str] = Field(
        None,
        description="The tier (or machine type) for this instance, for example `db-custom-1-3840`. WARNING: Changing this restarts the instance.",
    )
    activation_policy: Optional[ActivationPolicy] = Field(
        None,
        alias="activationPolicy",
        description="The activation policy specifies when the instance is activated; it is applicable only when the instance state is RUNNABLE. Valid values: * `ALWAYS`: The instance is on, and remains so even in the absence of connection requests. * `NEVER`: The instance is off; it is not activated, even if a connection request arrives.",
    )
    active_directory_config: Optional[SqlActiveDirectoryConfig] = Field(
        None,
        alias="activeDirectoryConfig",
        description="Active Directory configuration, relevant only for Cloud SQL for SQL Server.",
    )
    collation: Optional[str] = Field(None, description="The name of server Instance collation.")
    storage_auto_resize: Optional[bool] = Field(
        None,
        alias="storageAutoResize",
        description="Configuration to increase storage size automatically. The default value is true.",
    )
    password_validation_policy: Optional[PasswordValidationPolicy] = Field(
        None,
        alias="passwordValidationPolicy",
        description="The local user password validation policy of the instance.",
    )
    database_replication_enabled: Optional[bool] = Field(
        None,
        alias="databaseReplicationEnabled",
        description="Configuration specific to read replica instances. Indicates whether replication is enabled or not. WARNING: Changing this restarts the instance.",
    )
    data_disk_size_gb: Optional[str] = Field(
        None,
        alias="dataDiskSizeGb",
        description="The size of data disk, in GB. The data disk size minimum is 10GB.",
    )
    backup_configuration: Optional[BackupConfiguration] = Field(
        None,
        alias="backupConfiguration",
        description="The daily backup configuration for the instance.",
    )
    maintenance_window: Optional[MaintenanceWindow] = Field(
        None,
        alias="maintenanceWindow",
        description="The maintenance window for this instance. This specifies when the instance can be restarted for maintenance purposes.",
    )
    user_labels: Optional[Dict[str, str]] = Field(
        None,
        alias="userLabels",
        description="User-provided labels, represented as a dictionary where each label is a single key value pair.",
    )
    replication_type: Optional[ReplicationType] = Field(
        None,
        alias="replicationType",
        description="The type of replication this instance uses. This can be either `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was only applicable to First Generation instances.",
    )
    insights_config: Optional[InsightsConfig] = Field(
        None,
        alias="insightsConfig",
        description="Insights configuration, for now relevant only for Postgres.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#settings`.")
    ip_configuration: Optional[IpConfiguration] = Field(
        None,
        alias="ipConfiguration",
        description="The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled for Second Generation instances.",
    )
    deny_maintenance_periods: Optional[List[DenyMaintenancePeriod]] = Field(
        None, alias="denyMaintenancePeriods", description="Deny maintenance periods"
    )
    pricing_plan: Optional[PricingPlan] = Field(
        None,
        alias="pricingPlan",
        description="The pricing plan for this instance. This can be either `PER_USE` or `PACKAGE`. Only `PER_USE` is supported for Second Generation instances.",
    )


class SqlInstancesStartExternalSyncRequest(BaseModel):
    sync_mode: Optional[SyncMode] = Field(None, alias="syncMode", description="External sync mode.")
    mysql_sync_config: Optional[MySqlSyncConfig] = Field(
        None,
        alias="mysqlSyncConfig",
        description="MySQL-specific settings for start external sync.",
    )
    skip_verification: Optional[bool] = Field(
        None,
        alias="skipVerification",
        description="Whether to skip the verification step (VESS).",
    )


class TiersListResponse(BaseModel):
    items: Optional[List[Tier]] = Field(None, description="List of tiers.")
    kind: Optional[str] = Field(None, description="This is always `sql#tiersList`.")


class User(BaseModel):
    password: Optional[str] = Field(None, description="The password for the user.")
    etag: Optional[str] = Field(
        None,
        description="This field is deprecated and will be removed from a future version of the API.",
    )
    instance: Optional[str] = Field(
        None,
        description="The name of the Cloud SQL instance. This does not include the project ID. Can be omitted for `update` because it is already specified on the URL.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#user`.")
    dual_password_type: Optional[DualPasswordType] = Field(
        None, alias="dualPasswordType", description="Dual password status for the user."
    )
    sqlserver_user_details: Optional[SqlServerUserDetails] = Field(
        None, alias="sqlserverUserDetails"
    )
    password_policy: Optional[UserPasswordValidationPolicy] = Field(
        None,
        alias="passwordPolicy",
        description="User level password validation policy.",
    )
    name: Optional[str] = Field(
        None,
        description="The name of the user in the Cloud SQL instance. Can be omitted for `update` because it is already specified in the URL.",
    )
    type: Optional[Type4] = Field(
        None,
        description="The user type. It determines the method to authenticate the user during login. The default is the database's built-in user type.",
    )
    host: Optional[str] = Field(
        None,
        description="Optional. The host from which the user can connect. For `insert` operations, host defaults to an empty string. For `update` operations, host is specified as part of the request URL. The host name cannot be updated after insertion. For a MySQL instance, it's required; for a PostgreSQL or SQL Server instance, it's optional.",
    )
    project: Optional[str] = Field(
        None,
        description="The project ID of the project containing the Cloud SQL database. The Google apps domain is prefixed if applicable. Can be omitted for `update` because it is already specified on the URL.",
    )


class InstancesCloneRequest(BaseModel):
    clone_context: Optional[CloneContext] = Field(
        None,
        alias="cloneContext",
        description="Contains details about the clone operation.",
    )


class DemoteMasterContext(BaseModel):
    master_instance_name: Optional[str] = Field(
        None,
        alias="masterInstanceName",
        description="The name of the instance which will act as on-premises primary instance in the replication setup.",
    )
    verify_gtid_consistency: Optional[bool] = Field(
        None,
        alias="verifyGtidConsistency",
        description="Verify the GTID consistency for demote operation. Default value: `True`. Setting this flag to `false` enables you to bypass the GTID consistency check between on-premises primary instance and Cloud SQL instance during the demotion operation but also exposes you to the risk of future replication failures. Change the value only if you know the reason for the GTID divergence and are confident that doing so will not cause any replication issues.",
    )
    skip_replication_setup: Optional[bool] = Field(
        None,
        alias="skipReplicationSetup",
        description="Flag to skip replication setup on the instance.",
    )
    replica_configuration: Optional[DemoteMasterConfiguration] = Field(
        None,
        alias="replicaConfiguration",
        description="Configuration specific to read-replicas replicating from the on-premises primary instance.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#demoteMasterContext`.")


class Operation(BaseModel):
    target_link: Optional[str] = Field(None, alias="targetLink")
    user: Optional[str] = Field(
        None, description="The email address of the user who initiated this operation."
    )
    target_id: Optional[str] = Field(
        None,
        alias="targetId",
        description="Name of the database instance related to this operation.",
    )
    name: Optional[str] = Field(
        None,
        description="An identifier that uniquely identifies the operation. You can use this identifier to retrieve the Operations resource that has information about the operation.",
    )
    backup_context: Optional[BackupContext] = Field(
        None,
        alias="backupContext",
        description="The context for backup operation, if applicable.",
    )
    start_time: Optional[str] = Field(
        None,
        alias="startTime",
        description="The time this operation actually started in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )
    error: Optional[OperationErrors] = Field(
        None,
        description="If errors occurred during processing of this operation, this field will be populated.",
    )
    end_time: Optional[str] = Field(
        None,
        alias="endTime",
        description="The time this operation finished in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )
    import_context: Optional[ImportContext] = Field(
        None,
        alias="importContext",
        description="The context for import operation, if applicable.",
    )
    status: Optional[Status] = Field(None, description="The status of an operation.")
    insert_time: Optional[str] = Field(
        None,
        alias="insertTime",
        description="The time this operation was enqueued in UTC timezone in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )
    operation_type: Optional[OperationType] = Field(
        None,
        alias="operationType",
        description="The type of the operation. Valid values are: * `CREATE` * `DELETE` * `UPDATE` * `RESTART` * `IMPORT` * `EXPORT` * `BACKUP_VOLUME` * `RESTORE_VOLUME` * `CREATE_USER` * `DELETE_USER` * `CREATE_DATABASE` * `DELETE_DATABASE`",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#operation`.")
    self_link: Optional[str] = Field(
        None, alias="selfLink", description="The URI of this resource."
    )
    export_context: Optional[ExportContext] = Field(
        None,
        alias="exportContext",
        description="The context for export operation, if applicable.",
    )
    target_project: Optional[str] = Field(
        None,
        alias="targetProject",
        description="The project ID of the target instance related to this operation.",
    )


class SqlInstancesVerifyExternalSyncSettingsRequest(BaseModel):
    verify_replication_only: Optional[bool] = Field(
        None,
        alias="verifyReplicationOnly",
        description="Optional. Flag to verify settings required by replication setup only",
    )
    verify_connection_only: Optional[bool] = Field(
        None,
        alias="verifyConnectionOnly",
        description="Flag to enable verifying connection only",
    )
    sync_mode: Optional[SyncMode] = Field(None, alias="syncMode", description="External sync mode")
    mysql_sync_config: Optional[MySqlSyncConfig] = Field(
        None,
        alias="mysqlSyncConfig",
        description="Optional. MySQL-specific settings for start external sync.",
    )


class InstancesDemoteMasterRequest(BaseModel):
    demote_master_context: Optional[DemoteMasterContext] = Field(
        None,
        alias="demoteMasterContext",
        description="Contains details about the demoteMaster operation.",
    )


class DatabasesListResponse(BaseModel):
    items: Optional[List[Database]] = Field(
        None, description="List of database resources in the instance."
    )
    kind: Optional[str] = Field(None, description="This is always `sql#databasesList`.")


class BackupRunsListResponse(BaseModel):
    kind: Optional[str] = Field(None, description="This is always `sql#backupRunsList`.")
    items: Optional[List[BackupRun]] = Field(
        None,
        description="A list of backup runs in reverse chronological order of the enqueued time.",
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="The continuation token, used to page through large result sets. Provide this value in a subsequent request to return the next page of results.",
    )


class DatabaseInstance(BaseModel):
    out_of_disk_report: Optional[SqlOutOfDiskReport] = Field(
        None,
        alias="outOfDiskReport",
        description="This field represents the report generated by the proactive database wellness job for OutOfDisk issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive database wellness job",
    )
    backend_type: Optional[BackendType] = Field(
        None,
        alias="backendType",
        description="The backend type. `SECOND_GEN`: Cloud SQL database instance. `EXTERNAL`: A database server that is not managed by Google. This property is read-only; use the `tier` property in the `settings` object to determine the database type.",
    )
    self_link: Optional[str] = Field(
        None, alias="selfLink", description="The URI of this resource."
    )
    server_ca_cert: Optional[SslCert] = Field(
        None, alias="serverCaCert", description="SSL configuration."
    )
    replica_names: Optional[List[str]] = Field(
        None, alias="replicaNames", description="The replicas of the instance."
    )
    database_installed_version: Optional[str] = Field(
        None,
        alias="databaseInstalledVersion",
        description="Output only. Stores the current database version running on the instance including minor version such as `MYSQL_8_0_18`.",
    )
    current_disk_size: Optional[str] = Field(
        None,
        alias="currentDiskSize",
        description='The current disk usage of the instance in bytes. This property has been deprecated. Use the "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud Monitoring API instead. Please see [this announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ) for details.',
    )
    master_instance_name: Optional[str] = Field(
        None,
        alias="masterInstanceName",
        description="The name of the instance which will act as primary in the replication setup.",
    )
    scheduled_maintenance: Optional[SqlScheduledMaintenance] = Field(
        None,
        alias="scheduledMaintenance",
        description="The start time of any upcoming scheduled maintenance for this instance.",
    )
    maintenance_version: Optional[str] = Field(
        None,
        alias="maintenanceVersion",
        description="The current software version on the instance.",
    )
    satisfies_pzs: Optional[bool] = Field(
        None,
        alias="satisfiesPzs",
        description="The status indicating if instance satisfiesPzs. Reserved for future use.",
    )
    available_maintenance_versions: Optional[List[str]] = Field(
        None,
        alias="availableMaintenanceVersions",
        description="List all maintenance versions applicable on the instance",
    )
    disk_encryption_configuration: Optional[DiskEncryptionConfiguration] = Field(
        None,
        alias="diskEncryptionConfiguration",
        description="Disk encryption configuration specific to an instance.",
    )
    region: Optional[str] = Field(
        None,
        description="The geographical region. Can be: * `us-central` (`FIRST_GEN` instances only) * `us-central1` (`SECOND_GEN` instances only) * `asia-east1` or `europe-west1`. Defaults to `us-central` or `us-central1` depending on the instance type. The region cannot be changed after instance creation.",
    )
    disk_encryption_status: Optional[DiskEncryptionStatus] = Field(
        None,
        alias="diskEncryptionStatus",
        description="Disk encryption status specific to an instance.",
    )
    on_premises_configuration: Optional[OnPremisesConfiguration] = Field(
        None,
        alias="onPremisesConfiguration",
        description="Configuration specific to on-premises instances.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#instance`.")
    service_account_email_address: Optional[str] = Field(
        None,
        alias="serviceAccountEmailAddress",
        description="The service account email address assigned to the instance.\\This property is read-only.",
    )
    connection_name: Optional[str] = Field(
        None,
        alias="connectionName",
        description="Connection name of the Cloud SQL instance used in connection strings.",
    )
    etag: Optional[str] = Field(
        None,
        description="This field is deprecated and will be removed from a future version of the API. Use the `settings.settingsVersion` field instead.",
    )
    name: Optional[str] = Field(
        None,
        description="Name of the Cloud SQL instance. This does not include the project ID.",
    )
    instance_type: Optional[InstanceType] = Field(
        None, alias="instanceType", description="The instance type."
    )
    ipv6_address: Optional[str] = Field(
        None,
        alias="ipv6Address",
        description="The IPv6 address assigned to the instance. (Deprecated) This property was applicable only to First Generation instances.",
    )
    create_time: Optional[str] = Field(
        None,
        alias="createTime",
        description="Output only. The time when the instance was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.",
    )
    secondary_gce_zone: Optional[str] = Field(
        None,
        alias="secondaryGceZone",
        description="The Compute Engine zone that the failover instance is currently serving from for a regional instance. This value could be different from the zone that was specified when the instance was created if the instance has failed over to its secondary/failover zone.",
    )
    gce_zone: Optional[str] = Field(
        None,
        alias="gceZone",
        description="The Compute Engine zone that the instance is currently serving from. This value could be different from the zone that was specified when the instance was created if the instance has failed over to its secondary zone. WARNING: Changing this might restart the instance.",
    )
    replica_configuration: Optional[ReplicaConfiguration] = Field(
        None,
        alias="replicaConfiguration",
        description="Configuration specific to failover replicas and read replicas.",
    )
    suspension_reason: Optional[List[SuspensionReasonEnum]] = Field(
        None,
        alias="suspensionReason",
        description="If the instance state is SUSPENDED, the reason for the suspension.",
    )
    state: Optional[State] = Field(
        None, description="The current serving state of the Cloud SQL instance."
    )
    settings: Optional[Settings] = Field(None, description="The user settings.")
    failover_replica: Optional[FailoverReplica] = Field(
        None,
        alias="failoverReplica",
        description="The name and status of the failover replica.",
    )
    max_disk_size: Optional[str] = Field(
        None,
        alias="maxDiskSize",
        description="The maximum disk size of the instance in bytes.",
    )
    root_password: Optional[str] = Field(
        None,
        alias="rootPassword",
        description="Initial root password. Use only on creation. You must set root passwords before you can connect to PostgreSQL instances.",
    )
    ip_addresses: Optional[List[IpMapping]] = Field(
        None,
        alias="ipAddresses",
        description="The assigned IP addresses for the instance.",
    )
    project: Optional[str] = Field(
        None,
        description="The project ID of the project containing the Cloud SQL instance. The Google apps domain is prefixed if applicable.",
    )
    database_version: Optional[AppliesToEnum] = Field(
        None,
        alias="databaseVersion",
        description="The database engine type and version. The `databaseVersion` field cannot be changed after instance creation.",
    )


class OperationsListResponse(BaseModel):
    items: Optional[List[Operation]] = Field(None, description="List of operation resources.")
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="The continuation token, used to page through large result sets. Provide this value in a subsequent request to return the next page of results.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#operationsList`.")


class UsersListResponse(BaseModel):
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="An identifier that uniquely identifies the operation. You can use this identifier to retrieve the Operations resource that has information about the operation.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#usersList`.")
    items: Optional[List[User]] = Field(None, description="List of user resources in the instance.")


class SslCertsInsertResponse(BaseModel):
    client_cert: Optional[SslCertDetail] = Field(
        None,
        alias="clientCert",
        description="The new client certificate and private key.",
    )
    server_ca_cert: Optional[SslCert] = Field(
        None,
        alias="serverCaCert",
        description="The server Certificate Authority's certificate. If this is missing you can force a new one to be generated by calling resetSslConfig method on instances resource.",
    )
    kind: Optional[str] = Field(None, description="This is always `sql#sslCertsInsert`.")
    operation: Optional[Operation] = Field(
        None, description="The operation to track the ssl certs insert request."
    )


class InstancesListResponse(BaseModel):
    items: Optional[List[DatabaseInstance]] = Field(
        None, description="List of database instance resources."
    )
    next_page_token: Optional[str] = Field(
        None,
        alias="nextPageToken",
        description="The continuation token, used to page through large result sets. Provide this value in a subsequent request to return the next page of results.",
    )
    warnings: Optional[List[ApiWarning]] = Field(
        None, description="List of warnings that occurred while handling the request."
    )
    kind: Optional[str] = Field(None, description="This is always `sql#instancesList`.")


class Model(BaseModel):
    location_preference: Optional[LocationPreference] = Field(None, alias="LocationPreference")
    disk_encryption_configuration: Optional[DiskEncryptionConfiguration] = Field(
        None, alias="DiskEncryptionConfiguration"
    )
    backup_configuration: Optional[BackupConfiguration] = Field(None, alias="BackupConfiguration")
    insights_config: Optional[InsightsConfig] = Field(None, alias="InsightsConfig")
    restore_backup_context: Optional[RestoreBackupContext] = Field(
        None, alias="RestoreBackupContext"
    )
    sql_scheduled_maintenance: Optional[SqlScheduledMaintenance] = Field(
        None, alias="SqlScheduledMaintenance"
    )
    failover_context: Optional[FailoverContext] = Field(None, alias="FailoverContext")
    rotate_server_ca_context: Optional[RotateServerCaContext] = Field(
        None, alias="RotateServerCaContext"
    )
    instances_truncate_log_request: Optional[InstancesTruncateLogRequest] = Field(
        None, alias="InstancesTruncateLogRequest"
    )
    instances_list_server_cas_response: Optional[InstancesListServerCasResponse] = Field(
        None, alias="InstancesListServerCasResponse"
    )
    demote_master_context: Optional[DemoteMasterContext] = Field(None, alias="DemoteMasterContext")
    backup_retention_settings: Optional[BackupRetentionSettings] = Field(
        None, alias="BackupRetentionSettings"
    )
    generate_ephemeral_cert_response: Optional[GenerateEphemeralCertResponse] = Field(
        None, alias="GenerateEphemeralCertResponse"
    )
    operation: Optional[Operation] = Field(None, alias="Operation")
    ip_configuration: Optional[IpConfiguration] = Field(None, alias="IpConfiguration")
    sql_instances_verify_external_sync_settings_request: Optional[
        SqlInstancesVerifyExternalSyncSettingsRequest
    ] = Field(None, alias="SqlInstancesVerifyExternalSyncSettingsRequest")
    password_status: Optional[PasswordStatus] = Field(None, alias="PasswordStatus")
    sql_instances_verify_external_sync_settings_response: Optional[
        SqlInstancesVerifyExternalSyncSettingsResponse
    ] = Field(None, alias="SqlInstancesVerifyExternalSyncSettingsResponse")
    instances_demote_master_request: Optional[InstancesDemoteMasterRequest] = Field(
        None, alias="InstancesDemoteMasterRequest"
    )
    backup_context: Optional[BackupContext] = Field(None, alias="BackupContext")
    deny_maintenance_period: Optional[DenyMaintenancePeriod] = Field(
        None, alias="DenyMaintenancePeriod"
    )
    ip_mapping: Optional[IpMapping] = Field(None, alias="IpMapping")
    instances_import_request: Optional[InstancesImportRequest] = Field(
        None, alias="InstancesImportRequest"
    )
    databases_list_response: Optional[DatabasesListResponse] = Field(
        None, alias="DatabasesListResponse"
    )
    demote_master_my_sql_replica_configuration: Optional[
        DemoteMasterMySqlReplicaConfiguration
    ] = Field(None, alias="DemoteMasterMySqlReplicaConfiguration")
    sql_server_user_details: Optional[SqlServerUserDetails] = Field(
        None, alias="SqlServerUserDetails"
    )
    backup_runs_list_response: Optional[BackupRunsListResponse] = Field(
        None, alias="BackupRunsListResponse"
    )
    database_flags: Optional[DatabaseFlags] = Field(None, alias="DatabaseFlags")
    disk_encryption_status: Optional[DiskEncryptionStatus] = Field(
        None, alias="DiskEncryptionStatus"
    )
    instances_failover_request: Optional[InstancesFailoverRequest] = Field(
        None, alias="InstancesFailoverRequest"
    )
    flag: Optional[Flag] = Field(None, alias="Flag")
    my_sql_replica_configuration: Optional[MySqlReplicaConfiguration] = Field(
        None, alias="MySqlReplicaConfiguration"
    )
    password_validation_policy: Optional[PasswordValidationPolicy] = Field(
        None, alias="PasswordValidationPolicy"
    )
    instances_list_response: Optional[InstancesListResponse] = Field(
        None, alias="InstancesListResponse"
    )
    sql_instances_start_external_sync_request: Optional[
        SqlInstancesStartExternalSyncRequest
    ] = Field(None, alias="SqlInstancesStartExternalSyncRequest")
    replica_configuration: Optional[ReplicaConfiguration] = Field(
        None, alias="ReplicaConfiguration"
    )
    sql_server_audit_config: Optional[SqlServerAuditConfig] = Field(
        None, alias="SqlServerAuditConfig"
    )
    operations_list_response: Optional[OperationsListResponse] = Field(
        None, alias="OperationsListResponse"
    )
    ssl_certs_create_ephemeral_request: Optional[SslCertsCreateEphemeralRequest] = Field(
        None, alias="SslCertsCreateEphemeralRequest"
    )
    on_premises_configuration: Optional[OnPremisesConfiguration] = Field(
        None, alias="OnPremisesConfiguration"
    )
    truncate_log_context: Optional[TruncateLogContext] = Field(None, alias="TruncateLogContext")
    demote_master_configuration: Optional[DemoteMasterConfiguration] = Field(
        None, alias="DemoteMasterConfiguration"
    )
    my_sql_sync_config: Optional[MySqlSyncConfig] = Field(None, alias="MySqlSyncConfig")
    instances_restore_backup_request: Optional[InstancesRestoreBackupRequest] = Field(
        None, alias="InstancesRestoreBackupRequest"
    )
    instances_export_request: Optional[InstancesExportRequest] = Field(
        None, alias="InstancesExportRequest"
    )
    backup_run: Optional[BackupRun] = Field(None, alias="BackupRun")
    sql_out_of_disk_report: Optional[SqlOutOfDiskReport] = Field(None, alias="SqlOutOfDiskReport")
    sql_external_sync_setting_error: Optional[SqlExternalSyncSettingError] = Field(
        None, alias="SqlExternalSyncSettingError"
    )
    settings: Optional[Settings] = Field(None, alias="Settings")
    sql_server_database_details: Optional[SqlServerDatabaseDetails] = Field(
        None, alias="SqlServerDatabaseDetails"
    )
    tiers_list_response: Optional[TiersListResponse] = Field(None, alias="TiersListResponse")
    acl_entry: Optional[AclEntry] = Field(None, alias="AclEntry")
    instances_rotate_server_ca_request: Optional[InstancesRotateServerCaRequest] = Field(
        None, alias="InstancesRotateServerCaRequest"
    )
    flags_list_response: Optional[FlagsListResponse] = Field(None, alias="FlagsListResponse")
    ssl_certs_insert_request: Optional[SslCertsInsertRequest] = Field(
        None, alias="SslCertsInsertRequest"
    )
    users_list_response: Optional[UsersListResponse] = Field(None, alias="UsersListResponse")
    sync_flags: Optional[SyncFlags] = Field(None, alias="SyncFlags")
    reschedule: Optional[Reschedule] = Field(None, alias="Reschedule")
    sql_instances_reschedule_maintenance_request_body: Optional[
        SqlInstancesRescheduleMaintenanceRequestBody
    ] = Field(None, alias="SqlInstancesRescheduleMaintenanceRequestBody")
    operation_errors: Optional[OperationErrors] = Field(None, alias="OperationErrors")
    maintenance_window: Optional[MaintenanceWindow] = Field(None, alias="MaintenanceWindow")
    ssl_certs_list_response: Optional[SslCertsListResponse] = Field(
        None, alias="SslCertsListResponse"
    )
    export_context: Optional[ExportContext] = Field(None, alias="ExportContext")
    import_context: Optional[ImportContext] = Field(None, alias="ImportContext")
    database: Optional[Database] = Field(None, alias="Database")
    user_password_validation_policy: Optional[UserPasswordValidationPolicy] = Field(
        None, alias="UserPasswordValidationPolicy"
    )
    instance_reference: Optional[InstanceReference] = Field(None, alias="InstanceReference")
    operation_error: Optional[OperationError] = Field(None, alias="OperationError")
    bin_log_coordinates: Optional[BinLogCoordinates] = Field(None, alias="BinLogCoordinates")
    generate_ephemeral_cert_request: Optional[GenerateEphemeralCertRequest] = Field(
        None, alias="GenerateEphemeralCertRequest"
    )
    ssl_certs_insert_response: Optional[SslCertsInsertResponse] = Field(
        None, alias="SslCertsInsertResponse"
    )
    database_instance: Optional[DatabaseInstance] = Field(None, alias="DatabaseInstance")
    tier: Optional[Tier] = Field(None, alias="Tier")
    user: Optional[User] = Field(None, alias="User")
    instances_clone_request: Optional[InstancesCloneRequest] = Field(
        None, alias="InstancesCloneRequest"
    )
    sql_active_directory_config: Optional[SqlActiveDirectoryConfig] = Field(
        None, alias="SqlActiveDirectoryConfig"
    )
    clone_context: Optional[CloneContext] = Field(None, alias="CloneContext")
    ssl_cert: Optional[SslCert] = Field(None, alias="SslCert")
    connect_settings: Optional[ConnectSettings] = Field(None, alias="ConnectSettings")
    api_warning: Optional[ApiWarning] = Field(None, alias="ApiWarning")
    ssl_cert_detail: Optional[SslCertDetail] = Field(None, alias="SslCertDetail")
