# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetVpcEndpointResult',
    'AwaitableGetVpcEndpointResult',
    'get_vpc_endpoint',
    'get_vpc_endpoint_output',
]

@pulumi.output_type
class GetVpcEndpointResult:
    def __init__(__self__, id=None, security_group_ids=None, subnet_ids=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The identifier of the VPC Endpoint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        The ID of one or more security groups to associate with the endpoint network interface
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[str]]:
        """
        The ID of one or more subnets in which to create an endpoint network interface
        """
        return pulumi.get(self, "subnet_ids")


class AwaitableGetVpcEndpointResult(GetVpcEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcEndpointResult(
            id=self.id,
            security_group_ids=self.security_group_ids,
            subnet_ids=self.subnet_ids)


def get_vpc_endpoint(id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcEndpointResult:
    """
    Amazon OpenSearchServerless vpc endpoint resource


    :param str id: The identifier of the VPC Endpoint
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:opensearchserverless:getVpcEndpoint', __args__, opts=opts, typ=GetVpcEndpointResult).value

    return AwaitableGetVpcEndpointResult(
        id=__ret__.id,
        security_group_ids=__ret__.security_group_ids,
        subnet_ids=__ret__.subnet_ids)


@_utilities.lift_output_func(get_vpc_endpoint)
def get_vpc_endpoint_output(id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVpcEndpointResult]:
    """
    Amazon OpenSearchServerless vpc endpoint resource


    :param str id: The identifier of the VPC Endpoint
    """
    ...
