# Copyright 2020 JD.com, Inc. Galileo Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================

import torch
from torch.utils.data import Dataset
from galileo.platform.export import export


@export('galileo.pytorch')
class TensorDataset(Dataset):
    r'''
    tensor dataset

    args:
        tensor: tensor or np.ndarray or list
    '''
    def __init__(self, tensor, **kwargs):
        super().__init__()
        self.data = tensor if torch.is_tensor(tensor) else torch.tensor(tensor)

    def __len__(self):
        return len(self.data)

    def __getitem__(self, idx):
        assert idx >= 0 and idx < len(self.data)
        return self.data[idx]
