"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Whitelist = exports.WhitelistProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const memcache_generated_1 = require("./memcache.generated");
Object.defineProperty(exports, "WhitelistProperty", { enumerable: true, get: function () { return memcache_generated_1.RosWhitelist; } });
/**
 * A ROS resource type:  `ALIYUN::Memcache::Whitelist`
 */
class Whitelist extends ros.Resource {
    /**
     * Create a new `ALIYUN::Memcache::Whitelist`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosWhitelist = new memcache_generated_1.RosWhitelist(this, id, {
            securityIpGroupAttribute: props.securityIpGroupAttribute,
            securityIps: props.securityIps,
            instanceId: props.instanceId,
            securityIpGroupName: props.securityIpGroupName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWhitelist;
        this.attrSecurityIpGroupAttribute = rosWhitelist.attrSecurityIpGroupAttribute;
        this.attrSecurityIpGroupName = rosWhitelist.attrSecurityIpGroupName;
        this.attrSecurityIps = rosWhitelist.attrSecurityIps;
    }
}
exports.Whitelist = Whitelist;
//# sourceMappingURL=data:application/json;base64,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