

[![GitHub license](https://img.shields.io/github/license/Naereen/StrapDown.js.svg)](https://github.com/Naereen/StrapDown.js/blob/master/LICENSE)
[![Generic badge](https://img.shields.io/badge/Status-stable-blue.svg)](https://shields.io/)
[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://GitHub.com/Naereen/StrapDown.js/graphs/commit-activity)
[![Generic badge](https://img.shields.io/badge/Pypi-1.0.0-blue.svg)](https://shields.io/)
[![Generic badge](https://img.shields.io/badge/Python-3.8-blue.svg)](https://shields.io/)


# Introduction

**`PyPipet`** is an open source project, aiming to integrate data flows of Ecommerce. It provides platform-independent data flows to support Ecommerce functionality. It simplifies data pipelines of data management in ecommerce, for example, adding catalog, updating product, managing inventory and orders, etc. It is specially customized for small business who are selling on wordpress (for example, with woocommerce), shopify, ebay, etc. (more frontshop connected will be added). It extremely handy if the business is selling on multiple platforms (e.g., for dropshipping). It makes it extreamly easy to move your frontshop from one platform to anothor.

* For source code,  visit  [github repository](https://github.com/pypipet/pypipet).
* For documentation, vist [docs](https://pypipet.com)

## Latest `pip` [version: 1.1.0](https://pypi.org/project/pypipet/)

### [Change Logs](https://pypi.org/project/changelogs)

[reporting bugs here](https://github.com/pypipet/pypipet/issues)

## [Dependencies](https://pypipet.com/dependencies)

# Installation

use `pip`

    pip install -r requirements.txt

    pip install --upgrade pypipet  


for using Google Content API to connect Google Merchant, please install
[`google_auth_httplib2`](https://pypi.org/project/google-auth-httplib2/)
and [`googleapiclient`](https://github.com/googleapis/google-api-python-client)

## Tested with

- Shopify
- Woocommerce with Wordpress.com
- Postgresql
- AWS RDS


## Key features

- cli supported
- catalog import/export
- product management for publishing
- order management
- fulfillment management
- inventory management with multiple suppliers

# [Quick start guide](https://pypipet.com/quick_start/create_project/)


# [Use cases](https://pypipet.com/usecases/usecases)






