/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.index;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.index.IndexSystemID$;
import com.databricks.labs.mosaic.core.types.package$;
import com.databricks.labs.mosaic.expressions.index.Polyfill$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(geometry, resolution) - Returns the 1 set representation of geometry at resolution.", examples="\n    Examples:\n      > SELECT _FUNC_(a, b);\n       [622236721348804607, 622236721274716159, ...]\n  ", since="1.0")
@ScalaSignature(bytes="\u0006\u0001\tMd\u0001B\u0015+\u0001^B\u0001b\u001c\u0001\u0003\u0016\u0004%\t\u0001\u001d\u0005\ti\u0002\u0011\t\u0012)A\u0005c\"AQ\u000f\u0001BK\u0002\u0013\u0005\u0001\u000f\u0003\u0005w\u0001\tE\t\u0015!\u0003r\u0011!9\bA!f\u0001\n\u0003A\b\"CA\u0002\u0001\tE\t\u0015!\u0003z\u0011%\t)\u0001\u0001BK\u0002\u0013\u0005\u0001\u0010C\u0005\u0002\b\u0001\u0011\t\u0012)A\u0005s\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001\"CA\r\u0001\t\u0007I\u0011AA\u000e\u0011!\tY\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\u0018\u0011!\t\t\u0005\u0001Q\u0001\n\u0005E\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\t9\u0007\u0001C!\u0003SBa!a\u001b\u0001\t\u0003B\bbBA7\u0001\u0011\u0005\u0013q\u000e\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u0019\t\u0019\n\u0001C!a\"1\u0011Q\u0013\u0001\u0005BADq!a&\u0001\t#\nI\nC\u0005\u0002$\u0002\t\t\u0011\"\u0001\u0002&\"I\u0011q\u0016\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003\u000f\u0004\u0011\u0013!C\u0001\u0003cC\u0011\"!3\u0001#\u0003%\t!a3\t\u0013\u0005=\u0007!%A\u0005\u0002\u0005-\u0007\"CAi\u0001\u0005\u0005I\u0011IAj\u0011%\t\u0019\u000fAA\u0001\n\u0003\t)\u000fC\u0005\u0002n\u0002\t\t\u0011\"\u0001\u0002p\"I\u0011Q\u001f\u0001\u0002\u0002\u0013\u0005\u0013q\u001f\u0005\n\u0005\u000b\u0001\u0011\u0011!C\u0001\u0005\u000fA\u0011B!\u0005\u0001\u0003\u0003%\tEa\u0005\b\u000f\tE\"\u0006#\u0001\u00034\u00191\u0011F\u000bE\u0001\u0005kAq!!\u0003$\t\u0003\u00119\u0004C\u0004\u0003:\r\"\tAa\u000f\t\u0013\t53%!A\u0005\u0002\n=\u0003\"\u0003B-G\u0005\u0005I\u0011\u0011B.\u0011%\u0011IgIA\u0001\n\u0013\u0011YG\u0001\u0005Q_2Lh-\u001b7m\u0015\tYC&A\u0003j]\u0012,\u0007P\u0003\u0002.]\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\ty\u0003'\u0001\u0004n_N\f\u0017n\u0019\u0006\u0003cI\nA\u0001\\1cg*\u00111\u0007N\u0001\u000bI\u0006$\u0018M\u0019:jG.\u001c(\"A\u001b\u0002\u0007\r|Wn\u0001\u0001\u0014\u000f\u0001AtI\u00131gYB\u0011\u0011(R\u0007\u0002u)\u0011Qf\u000f\u0006\u0003yu\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003}}\n1a]9m\u0015\t\u0001\u0015)A\u0003ta\u0006\u00148N\u0003\u0002C\u0007\u00061\u0011\r]1dQ\u0016T\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$;\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002:\u0011&\u0011\u0011J\u000f\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA&^\u001d\ta5L\u0004\u0002N5:\u0011a*\u0017\b\u0003\u001fbs!\u0001U,\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+7\u0003\u0019a$o\\8u}%\tA)\u0003\u0002C\u0007&\u0011\u0001)Q\u0005\u0003}}J!\u0001P\u001f\n\u00055Z\u0014B\u0001/;\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011AL\u000f\t\u0003C\u0012l\u0011A\u0019\u0006\u0003Gj\nqaY8eK\u001e,g.\u0003\u0002fE\ny1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u0002hU6\t\u0001NC\u0001j\u0003\u0015\u00198-\u00197b\u0013\tY\u0007NA\u0004Qe>$Wo\u0019;\u0011\u0005\u001dl\u0017B\u00018i\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u00119Wm\\7\u0016\u0003E\u0004\"!\u000f:\n\u0005MT$AC#yaJ,7o]5p]\u0006)q-Z8nA\u0005Q!/Z:pYV$\u0018n\u001c8\u0002\u0017I,7o\u001c7vi&|g\u000eI\u0001\u0010S:$W\r_*zgR,WNT1nKV\t\u0011\u0010\u0005\u0002{}:\u00111\u0010 \t\u0003%\"L!! 5\u0002\rA\u0013X\rZ3g\u0013\ry\u0018\u0011\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005uD\u0017\u0001E5oI\u0016D8+_:uK6t\u0015-\\3!\u0003=9Wm\\7fiJL\u0018\tU%OC6,\u0017\u0001E4f_6,GO]=B!&s\u0015-\\3!\u0003\u0019a\u0014N\\5u}QQ\u0011QBA\t\u0003'\t)\"a\u0006\u0011\u0007\u0005=\u0001!D\u0001+\u0011\u0015y\u0017\u00021\u0001r\u0011\u0015)\u0018\u00021\u0001r\u0011\u00159\u0018\u00021\u0001z\u0011\u0019\t)!\u0003a\u0001s\u0006Y\u0011N\u001c3fqNK8\u000f^3n+\t\ti\u0002\u0005\u0003\u0002 \u0005\u001dRBAA\u0011\u0015\rY\u00131\u0005\u0006\u0004\u0003Kq\u0013\u0001B2pe\u0016LA!!\u000b\u0002\"\tY\u0011J\u001c3fqNK8\u000f^3n\u00031Ig\u000eZ3y'f\u001cH/Z7!\u0003-9Wm\\7fiJL\u0018\tU%\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0004CBL'\u0002BA\u001e\u0003G\t\u0001bZ3p[\u0016$(/_\u0005\u0005\u0003\u007f\t)DA\u0006HK>lW\r\u001e:z\u0003BK\u0015\u0001D4f_6,GO]=B!&\u0003\u0013AC5oaV$H+\u001f9fgV\u0011\u0011q\t\t\u0007\u0003\u0013\n\t&a\u0016\u000f\t\u0005-\u0013q\n\b\u0004%\u00065\u0013\"A5\n\u0005qC\u0017\u0002BA*\u0003+\u00121aU3r\u0015\ta\u0006\u000e\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\ti&P\u0001\u0006if\u0004Xm]\u0005\u0005\u0003C\nYF\u0001\u0005ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,WCAA,\u0003!!xn\u0015;sS:<G#A=\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002r\u0005]\u00141\u0010\t\u0004O\u0006M\u0014bAA;Q\n\u0019\u0011I\\=\t\u000f\u0005e$\u00031\u0001\u0002r\u00051\u0011N\u001c9viFBq!! \u0013\u0001\u0004\t\t(\u0001\u0004j]B,HOM\u0001\t[\u0006\\WmQ8qsR\u0019\u0011/a!\t\u000f\u0005\u00155\u00031\u0001\u0002\b\u00069a.Z<Be\u001e\u001c\b#B4\u0002\n\u00065\u0015bAAFQ\n)\u0011I\u001d:bsB\u0019q-a$\n\u0007\u0005E\u0005N\u0001\u0004B]f\u0014VMZ\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR1\u0011QBAN\u0003?Ca!!(\u0017\u0001\u0004\t\u0018a\u00028fo2+g\r\u001e\u0005\u0007\u0003C3\u0002\u0019A9\u0002\u00119,wOU5hQR\fAaY8qsRQ\u0011QBAT\u0003S\u000bY+!,\t\u000f=<\u0002\u0013!a\u0001c\"9Qo\u0006I\u0001\u0002\u0004\t\bbB<\u0018!\u0003\u0005\r!\u001f\u0005\t\u0003\u000b9\u0002\u0013!a\u0001s\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAZU\r\t\u0018QW\u0016\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u00195\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0006m&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001bT3!_A[\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAk!\u0011\t9.!9\u000e\u0005\u0005e'\u0002BAn\u0003;\fA\u0001\\1oO*\u0011\u0011q\\\u0001\u0005U\u00064\u0018-C\u0002\u0000\u00033\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a:\u0011\u0007\u001d\fI/C\u0002\u0002l\"\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u001d\u0002r\"I\u00111\u001f\u0010\u0002\u0002\u0003\u0007\u0011q]\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\bCBA~\u0005\u0003\t\t(\u0004\u0002\u0002~*\u0019\u0011q 5\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0004\u0005u(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u0003\u0003\u0010A\u0019qMa\u0003\n\u0007\t5\u0001NA\u0004C_>dW-\u00198\t\u0013\u0005M\b%!AA\u0002\u0005E\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0003\n\tU\u0001\"CAzC\u0005\u0005\t\u0019AA9Q=\u0001!\u0011\u0004B\u0010\u0005C\u0011)Ca\n\u0003,\t5\u0002cA\u001d\u0003\u001c%\u0019!Q\u0004\u001e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1E\u0001[?\u001a+fjQ0)O\u0016|W.\u001a;ss2\u0002#/Z:pYV$\u0018n\u001c8*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAE\u00023/\u001a;!e\u0016\u0004(/Z:f]R\fG/[8oA=4\u0007eZ3p[\u0016$(/\u001f\u0011bi\u0002\u0012Xm]8mkRLwN\u001c\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!\u000b\u0002G*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013\r\f\u0011cSmR\u0001\u0005\t\u0011!A\u0001\u00023L\u000e\u001a3eM2tGM\u00194iaB\u0004\u0007\u000e\u001c1o1\u0002cG\r\u001a3gY:$'\r\u001a8i]\nd'M\u001b:Y\u0001rcFL/\u000bA\u0001\nQa]5oG\u0016\f#Aa\f\u0002\u0007Er\u0003'\u0001\u0005Q_2Lh-\u001b7m!\r\tyaI\n\u0005G\u00055E\u000e\u0006\u0002\u00034\u00051\"/Z4jgR\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0013:4w\u000e\u0006\u0003\u0003>\t\r\u0003cA\u001d\u0003@%\u0019!\u0011\t\u001e\u0003\u001d\u0015C\bO]3tg&|g.\u00138g_\"9!QI\u0013A\u0002\t\u001d\u0013A\u00013c!\u00119'\u0011J=\n\u0007\t-\u0003N\u0001\u0004PaRLwN\\\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0003\u001b\u0011\tFa\u0015\u0003V\t]\u0003\"B8'\u0001\u0004\t\b\"B;'\u0001\u0004\t\b\"B<'\u0001\u0004I\bBBA\u0003M\u0001\u0007\u00110A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu#Q\r\t\u0006O\n%#q\f\t\bO\n\u0005\u0014/]=z\u0013\r\u0011\u0019\u0007\u001b\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\t\u001dt%!AA\u0002\u00055\u0011a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011i\u0007\u0005\u0003\u0002X\n=\u0014\u0002\u0002B9\u00033\u0014aa\u00142kK\u000e$\b")
public class Polyfill
extends BinaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
CodegenFallback,
scala.Serializable {
    private final Expression geom;
    private final Expression resolution;
    private final String indexSystemName;
    private final String geometryAPIName;
    private final IndexSystem indexSystem;
    private final GeometryAPI geometryAPI;

    public static Option<Tuple4<Expression, Expression, String, String>> unapply(Polyfill polyfill) {
        return Polyfill$.MODULE$.unapply(polyfill);
    }

    public static ExpressionInfo registryExpressionInfo(Option<String> option) {
        return Polyfill$.MODULE$.registryExpressionInfo(option);
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$((CodegenFallback)this, (CodegenContext)ctx, (ExprCode)ev);
    }

    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$((ExpectsInputTypes)this);
    }

    public Expression geom() {
        return this.geom;
    }

    public Expression resolution() {
        return this.resolution;
    }

    public String indexSystemName() {
        return this.indexSystemName;
    }

    public String geometryAPIName() {
        return this.geometryAPIName;
    }

    public IndexSystem indexSystem() {
        return this.indexSystem;
    }

    public GeometryAPI geometryAPI() {
        return this.geometryAPI;
    }

    public Seq<DataType> inputTypes() {
        if (!((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{BinaryType$.MODULE$, StringType$.MODULE$, package$.MODULE$.HexType(), package$.MODULE$.InternalGeometryType()}))).contains((Object)this.geom().dataType()) || !((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{IntegerType$.MODULE$, StringType$.MODULE$}))).contains((Object)this.resolution().dataType())) {
            throw new Error(new StringBuilder(29).append("Not supported data type: (").append(this.geom().dataType()).append(", ").append(this.resolution().dataType()).append(".").toString());
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{this.geom().dataType(), this.resolution().dataType()}));
    }

    public DataType dataType() {
        return ArrayType$.MODULE$.apply(this.indexSystem().getCellIdDataType());
    }

    public String toString() {
        return new StringBuilder(17).append("grid_polyfill(").append(this.geom()).append(", ").append(this.resolution()).append(")").toString();
    }

    public String prettyName() {
        return "grid_polyfill";
    }

    public Object nullSafeEval(Object input1, Object input2) {
        int resolutionVal = this.indexSystem().getResolution(input2);
        MosaicGeometry geometry = this.geometryAPI().geometry(input1, this.geom().dataType());
        Seq<Object> indices = this.indexSystem().polyfill(geometry, resolutionVal, (Option<GeometryAPI>)new Some((Object)this.geometryAPI()));
        Seq formatted = (Seq)indices.map((Function1 & Serializable & scala.Serializable)cellId -> this.indexSystem().formatCellId(cellId), Seq$.MODULE$.canBuildFrom());
        ArrayData serialized = ArrayData$.MODULE$.toArrayData(formatted.toArray(ClassTag$.MODULE$.Any()));
        return serialized;
    }

    /*
     * WARNING - void declaration
     */
    public Expression makeCopy(Object[] newArgs) {
        void var3_3;
        Expression[] asArray = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(newArgs)).take(3))).map((Function1 & Serializable & scala.Serializable)x$1 -> (Expression)x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
        Polyfill res = new Polyfill(asArray[0], asArray[1], this.indexSystemName(), this.geometryAPIName());
        res.copyTagsFrom((TreeNode)this);
        return var3_3;
    }

    public Expression left() {
        return this.geom();
    }

    public Expression right() {
        return this.resolution();
    }

    public Polyfill withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    public Polyfill copy(Expression geom, Expression resolution, String indexSystemName, String geometryAPIName) {
        return new Polyfill(geom, resolution, indexSystemName, geometryAPIName);
    }

    public Expression copy$default$1() {
        return this.geom();
    }

    public Expression copy$default$2() {
        return this.resolution();
    }

    public String copy$default$3() {
        return this.indexSystemName();
    }

    public String copy$default$4() {
        return this.geometryAPIName();
    }

    public String productPrefix() {
        return "Polyfill";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.geom();
                break;
            }
            case 1: {
                object = this.resolution();
                break;
            }
            case 2: {
                object = this.indexSystemName();
                break;
            }
            case 3: {
                object = this.geometryAPIName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Polyfill;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Polyfill)) return false;
        boolean bl = true;
        if (!bl) return false;
        Polyfill polyfill = (Polyfill)((Object)x$1);
        Expression expression = this.geom();
        Expression expression2 = polyfill.geom();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.resolution();
        Expression expression4 = polyfill.resolution();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        String string = this.indexSystemName();
        String string2 = polyfill.indexSystemName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.geometryAPIName();
        String string4 = polyfill.geometryAPIName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (!polyfill.canEqual((Object)this)) return false;
        return true;
    }

    public Polyfill(Expression geom, Expression resolution, String indexSystemName, String geometryAPIName) {
        this.geom = geom;
        this.resolution = resolution;
        this.indexSystemName = indexSystemName;
        this.geometryAPIName = geometryAPIName;
        ExpectsInputTypes.$init$((ExpectsInputTypes)this);
        CodegenFallback.$init$((CodegenFallback)this);
        this.indexSystem = IndexSystemID$.MODULE$.getIndexSystem(IndexSystemID$.MODULE$.apply(indexSystemName));
        this.geometryAPI = GeometryAPI$.MODULE$.apply(geometryAPIName);
    }
}

