/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.index;

import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.index.IndexSystemID$;
import com.databricks.labs.mosaic.expressions.index.CellKRing$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(cellId, k) - Returns k ring for a given cell.", examples="\n    Examples:\n      > SELECT _FUNC_(a, b);\n       [622236721348804607, 622236721274716159, ...]\n  ", since="1.0")
@ScalaSignature(bytes="\u0006\u0001\tMd\u0001B\u0015+\u0001^B\u0001b\u001c\u0001\u0003\u0016\u0004%\t\u0001\u001d\u0005\ti\u0002\u0011\t\u0012)A\u0005c\"AQ\u000f\u0001BK\u0002\u0013\u0005\u0001\u000f\u0003\u0005w\u0001\tE\t\u0015!\u0003r\u0011!9\bA!f\u0001\n\u0003A\b\"CA\u0002\u0001\tE\t\u0015!\u0003z\u0011%\t)\u0001\u0001BK\u0002\u0013\u0005\u0001\u0010C\u0005\u0002\b\u0001\u0011\t\u0012)A\u0005s\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001\"CA\r\u0001\t\u0007I\u0011AA\u000e\u0011!\tY\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\u0018\u0011!\t\t\u0005\u0001Q\u0001\n\u0005E\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\u0007\u0003G\u0002A\u0011\t9\t\r\u0005\u0015\u0004\u0001\"\u0011q\u0011\u001d\t9\u0007\u0001C!\u0003SBq!a\u001b\u0001\t\u0003\ni\u0007\u0003\u0004\u0002p\u0001!\t\u0005\u001f\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!a&\u0001\t#\nI\nC\u0005\u0002$\u0002\t\t\u0011\"\u0001\u0002&\"I\u0011q\u0016\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003\u000f\u0004\u0011\u0013!C\u0001\u0003cC\u0011\"!3\u0001#\u0003%\t!a3\t\u0013\u0005=\u0007!%A\u0005\u0002\u0005-\u0007\"CAi\u0001\u0005\u0005I\u0011IAj\u0011%\t\u0019\u000fAA\u0001\n\u0003\t)\u000fC\u0005\u0002n\u0002\t\t\u0011\"\u0001\u0002p\"I\u0011Q\u001f\u0001\u0002\u0002\u0013\u0005\u0013q\u001f\u0005\n\u0005\u000b\u0001\u0011\u0011!C\u0001\u0005\u000fA\u0011B!\u0005\u0001\u0003\u0003%\tEa\u0005\b\u000f\tE\"\u0006#\u0001\u00034\u00191\u0011F\u000bE\u0001\u0005kAq!!\u0003$\t\u0003\u00119\u0004C\u0004\u0003:\r\"\tAa\u000f\t\u0013\t53%!A\u0005\u0002\n=\u0003\"\u0003B-G\u0005\u0005I\u0011\u0011B.\u0011%\u0011IgIA\u0001\n\u0013\u0011YGA\u0005DK2d7JU5oO*\u00111\u0006L\u0001\u0006S:$W\r\u001f\u0006\u0003[9\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0006M\u0001\u0007[>\u001c\u0018-[2\u000b\u0005E\u0012\u0014\u0001\u00027bENT!a\r\u001b\u0002\u0015\u0011\fG/\u00192sS\u000e\\7OC\u00016\u0003\r\u0019w.\\\u0002\u0001'\u001d\u0001\u0001h\u0012&aM2\u0004\"!O#\u000e\u0003iR!!L\u001e\u000b\u0005qj\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005yz\u0014aA:rY*\u0011\u0001)Q\u0001\u0006gB\f'o\u001b\u0006\u0003\u0005\u000e\u000ba!\u00199bG\",'\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002Gu\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003s!K!!\u0013\u001e\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002L;:\u0011Aj\u0017\b\u0003\u001bjs!AT-\u000f\u0005=CfB\u0001)X\u001d\t\tfK\u0004\u0002S+6\t1K\u0003\u0002Um\u00051AH]8pizJ\u0011\u0001R\u0005\u0003\u0005\u000eK!\u0001Q!\n\u0005yz\u0014B\u0001\u001f>\u0013\ti3(\u0003\u0002]u\u00059\u0001/Y2lC\u001e,\u0017B\u00010`\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!\u0001\u0018\u001e\u0011\u0005\u0005$W\"\u00012\u000b\u0005\rT\u0014aB2pI\u0016<WM\\\u0005\u0003K\n\u0014qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003O*l\u0011\u0001\u001b\u0006\u0002S\u0006)1oY1mC&\u00111\u000e\u001b\u0002\b!J|G-^2u!\t9W.\u0003\u0002oQ\na1+\u001a:jC2L'0\u00192mK\u000611-\u001a7m\u0013\u0012,\u0012!\u001d\t\u0003sIL!a\u001d\u001e\u0003\u0015\u0015C\bO]3tg&|g.A\u0004dK2d\u0017\n\u001a\u0011\u0002\u0003-\f!a\u001b\u0011\u0002\u001f%tG-\u001a=TsN$X-\u001c(b[\u0016,\u0012!\u001f\t\u0003uzt!a\u001f?\u0011\u0005IC\u0017BA?i\u0003\u0019\u0001&/\u001a3fM&\u0019q0!\u0001\u0003\rM#(/\u001b8h\u0015\ti\b.\u0001\tj]\u0012,\u0007pU=ti\u0016lg*Y7fA\u0005yq-Z8nKR\u0014\u00180\u0011)J\u001d\u0006lW-\u0001\thK>lW\r\u001e:z\u0003BKe*Y7fA\u00051A(\u001b8jiz\"\"\"!\u0004\u0002\u0012\u0005M\u0011QCA\f!\r\ty\u0001A\u0007\u0002U!)q.\u0003a\u0001c\")Q/\u0003a\u0001c\")q/\u0003a\u0001s\"1\u0011QA\u0005A\u0002e\f1\"\u001b8eKb\u001c\u0016p\u001d;f[V\u0011\u0011Q\u0004\t\u0005\u0003?\t9#\u0004\u0002\u0002\")\u00191&a\t\u000b\u0007\u0005\u0015b&\u0001\u0003d_J,\u0017\u0002BA\u0015\u0003C\u00111\"\u00138eKb\u001c\u0016p\u001d;f[\u0006a\u0011N\u001c3fqNK8\u000f^3nA\u0005Yq-Z8nKR\u0014\u00180\u0011)J+\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002<\u0005\r\u0012\u0001C4f_6,GO]=\n\t\u0005}\u0012Q\u0007\u0002\f\u000f\u0016|W.\u001a;ss\u0006\u0003\u0016*\u0001\u0007hK>lW\r\u001e:z\u0003BK\u0005%\u0001\u0006j]B,H\u000fV=qKN,\"!a\u0012\u0011\r\u0005%\u0013\u0011KA,\u001d\u0011\tY%a\u0014\u000f\u0007I\u000bi%C\u0001j\u0013\ta\u0006.\u0003\u0003\u0002T\u0005U#aA*fc*\u0011A\f\u001b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL\u001f\u0002\u000bQL\b/Z:\n\t\u0005\u0005\u00141\f\u0002\t\t\u0006$\u0018\rV=qK\u0006)!/[4ii\u0006!A.\u001a4u\u0003!!\u0017\r^1UsB,WCAA,\u0003!!xn\u0015;sS:<G#A=\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002v\u0005m\u0014q\u0010\t\u0004O\u0006]\u0014bAA=Q\n\u0019\u0011I\\=\t\u000f\u0005uD\u00031\u0001\u0002v\u00051\u0011N\u001c9viFBq!!!\u0015\u0001\u0004\t)(\u0001\u0004j]B,HOM\u0001\t[\u0006\\WmQ8qsR\u0019\u0011/a\"\t\u000f\u0005%U\u00031\u0001\u0002\f\u00069a.Z<Be\u001e\u001c\b#B4\u0002\u000e\u0006E\u0015bAAHQ\n)\u0011I\u001d:bsB\u0019q-a%\n\u0007\u0005U\u0005N\u0001\u0004B]f\u0014VMZ\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$R!]AN\u0003?Ca!!(\u0017\u0001\u0004\t\u0018a\u00028fo2+g\r\u001e\u0005\u0007\u0003C3\u0002\u0019A9\u0002\u00119,wOU5hQR\fAaY8qsRQ\u0011QBAT\u0003S\u000bY+!,\t\u000f=<\u0002\u0013!a\u0001c\"9Qo\u0006I\u0001\u0002\u0004\t\bbB<\u0018!\u0003\u0005\r!\u001f\u0005\t\u0003\u000b9\u0002\u0013!a\u0001s\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAZU\r\t\u0018QW\u0016\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u00195\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0006m&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001bT3!_A[\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAk!\u0011\t9.!9\u000e\u0005\u0005e'\u0002BAn\u0003;\fA\u0001\\1oO*\u0011\u0011q\\\u0001\u0005U\u00064\u0018-C\u0002\u0000\u00033\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a:\u0011\u0007\u001d\fI/C\u0002\u0002l\"\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u001e\u0002r\"I\u00111\u001f\u0010\u0002\u0002\u0003\u0007\u0011q]\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\bCBA~\u0005\u0003\t)(\u0004\u0002\u0002~*\u0019\u0011q 5\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0004\u0005u(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u0003\u0003\u0010A\u0019qMa\u0003\n\u0007\t5\u0001NA\u0004C_>dW-\u00198\t\u0013\u0005M\b%!AA\u0002\u0005U\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0003\n\tU\u0001\"CAzC\u0005\u0005\t\u0019AA;Q=\u0001!\u0011\u0004B\u0010\u0005C\u0011)Ca\n\u0003,\t5\u0002cA\u001d\u0003\u001c%\u0019!Q\u0004\u001e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1E\u00015?\u001a+fjQ0)G\u0016dG.\u00133-A-L\u0003%\f\u0011SKR,(O\\:!W\u0002\u0012\u0018N\\4!M>\u0014\b%\u0019\u0011hSZ,g\u000eI2fY2t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t%\u0012a\u0019\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)C2\u0002#-K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7Z\u0012$GM\u001a7oI\n4\u0007\u000e\u001d9aQ2\u0004g\u000e\u0017!mI\u0012$g\r\u001c8eE\u0012t\u0007N\u001c2mE*\u0014\b\f\u0011/]9j&\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t=\u0012aA\u0019/a\u0005I1)\u001a7m\u0017JKgn\u001a\t\u0004\u0003\u001f\u00193\u0003B\u0012\u0002\u00122$\"Aa\r\u0002-I,w-[:uef,\u0005\u0010\u001d:fgNLwN\\%oM>$BA!\u0010\u0003DA\u0019\u0011Ha\u0010\n\u0007\t\u0005#H\u0001\bFqB\u0014Xm]:j_:LeNZ8\t\u000f\t\u0015S\u00051\u0001\u0003H\u0005\u0011AM\u0019\t\u0005O\n%\u00130C\u0002\u0003L!\u0014aa\u00149uS>t\u0017!B1qa2LHCCA\u0007\u0005#\u0012\u0019F!\u0016\u0003X!)qN\na\u0001c\")QO\na\u0001c\")qO\na\u0001s\"1\u0011Q\u0001\u0014A\u0002e\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003^\t\u0015\u0004#B4\u0003J\t}\u0003cB4\u0003bE\f\u00180_\u0005\u0004\u0005GB'A\u0002+va2,G\u0007C\u0005\u0003h\u001d\n\t\u00111\u0001\u0002\u000e\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005[\u0002B!a6\u0003p%!!\u0011OAm\u0005\u0019y%M[3di\u0002")
public class CellKRing
extends BinaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
CodegenFallback,
scala.Serializable {
    private final Expression cellId;
    private final Expression k;
    private final String indexSystemName;
    private final String geometryAPIName;
    private final IndexSystem indexSystem;
    private final GeometryAPI geometryAPI;

    public static Option<Tuple4<Expression, Expression, String, String>> unapply(CellKRing cellKRing) {
        return CellKRing$.MODULE$.unapply(cellKRing);
    }

    public static ExpressionInfo registryExpressionInfo(Option<String> option) {
        return CellKRing$.MODULE$.registryExpressionInfo(option);
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$((CodegenFallback)this, (CodegenContext)ctx, (ExprCode)ev);
    }

    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$((ExpectsInputTypes)this);
    }

    public Expression cellId() {
        return this.cellId;
    }

    public Expression k() {
        return this.k;
    }

    public String indexSystemName() {
        return this.indexSystemName;
    }

    public String geometryAPIName() {
        return this.geometryAPIName;
    }

    public IndexSystem indexSystem() {
        return this.indexSystem;
    }

    public GeometryAPI geometryAPI() {
        return this.geometryAPI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<DataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && IntegerType$.MODULE$.equals(dataType2)) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegralType[]{LongType$.MODULE$, IntegerType$.MODULE$}));
            }
        }
        if (tuple2 == null) throw new Error(new StringBuilder(30).append("Not supported data type: (").append(this.left().dataType()).append(", ").append(this.right().dataType()).append(").").toString());
        DataType dataType = (DataType)tuple2._1();
        DataType dataType3 = (DataType)tuple2._2();
        if (!StringType$.MODULE$.equals(dataType)) throw new Error(new StringBuilder(30).append("Not supported data type: (").append(this.left().dataType()).append(", ").append(this.right().dataType()).append(").").toString());
        if (!IntegerType$.MODULE$.equals(dataType3)) throw new Error(new StringBuilder(30).append("Not supported data type: (").append(this.left().dataType()).append(", ").append(this.right().dataType()).append(").").toString());
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    public Expression right() {
        return this.k();
    }

    public Expression left() {
        return this.cellId();
    }

    public DataType dataType() {
        return ArrayType$.MODULE$.apply(this.indexSystem().getCellIdDataType());
    }

    public String toString() {
        return new StringBuilder(18).append("grid_cellkring(").append(this.cellId()).append(", ").append(this.k()).append(")").toString();
    }

    public String prettyName() {
        return "grid_cellkring";
    }

    public Object nullSafeEval(Object input1, Object input2) {
        long cellId2 = BoxesRunTime.unboxToLong((Object)this.indexSystem().formatCellId(input1, (DataType)LongType$.MODULE$));
        Seq<Object> indices = this.indexSystem().kRing(cellId2, BoxesRunTime.unboxToInt((Object)input2));
        ArrayData serialized = ArrayData$.MODULE$.toArrayData(indices.map((Function1 & Serializable & scala.Serializable)cellId -> this.indexSystem().serializeCellId(cellId), Seq$.MODULE$.canBuildFrom()));
        return serialized;
    }

    /*
     * WARNING - void declaration
     */
    public Expression makeCopy(Object[] newArgs) {
        void var3_3;
        Expression[] asArray = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(newArgs)).take(2))).map((Function1 & Serializable & scala.Serializable)x$1 -> (Expression)x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
        CellKRing res = new CellKRing(asArray[0], asArray[1], this.indexSystemName(), this.geometryAPIName());
        res.copyTagsFrom((TreeNode)this);
        return var3_3;
    }

    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    public CellKRing copy(Expression cellId, Expression k, String indexSystemName, String geometryAPIName) {
        return new CellKRing(cellId, k, indexSystemName, geometryAPIName);
    }

    public Expression copy$default$1() {
        return this.cellId();
    }

    public Expression copy$default$2() {
        return this.k();
    }

    public String copy$default$3() {
        return this.indexSystemName();
    }

    public String copy$default$4() {
        return this.geometryAPIName();
    }

    public String productPrefix() {
        return "CellKRing";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.cellId();
                break;
            }
            case 1: {
                object = this.k();
                break;
            }
            case 2: {
                object = this.indexSystemName();
                break;
            }
            case 3: {
                object = this.geometryAPIName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CellKRing;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CellKRing)) return false;
        boolean bl = true;
        if (!bl) return false;
        CellKRing cellKRing = (CellKRing)((Object)x$1);
        Expression expression = this.cellId();
        Expression expression2 = cellKRing.cellId();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.k();
        Expression expression4 = cellKRing.k();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        String string = this.indexSystemName();
        String string2 = cellKRing.indexSystemName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.geometryAPIName();
        String string4 = cellKRing.geometryAPIName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (!cellKRing.canEqual((Object)this)) return false;
        return true;
    }

    public CellKRing(Expression cellId, Expression k, String indexSystemName, String geometryAPIName) {
        this.cellId = cellId;
        this.k = k;
        this.indexSystemName = indexSystemName;
        this.geometryAPIName = geometryAPIName;
        ExpectsInputTypes.$init$((ExpectsInputTypes)this);
        CodegenFallback.$init$((CodegenFallback)this);
        this.indexSystem = IndexSystemID$.MODULE$.getIndexSystem(IndexSystemID$.MODULE$.apply(indexSystemName));
        this.geometryAPI = GeometryAPI$.MODULE$.apply(geometryAPIName);
    }
}

