/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.linestring;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryJTS$;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineStringJTS;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointJTS;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class MosaicLineStringJTS$
implements GeometryReader,
scala.Serializable {
    public static MosaicLineStringJTS$ MODULE$;
    private final int defaultSpatialReferenceId;

    static {
        new MosaicLineStringJTS$();
    }

    @Override
    public int defaultSpatialReferenceId() {
        return this.defaultSpatialReferenceId;
    }

    @Override
    public void com$databricks$labs$mosaic$core$geometry$GeometryReader$_setter_$defaultSpatialReferenceId_$eq(int x$1) {
        this.defaultSpatialReferenceId = x$1;
    }

    public Seq<MosaicPoint> getPoints(LineString lineString) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), lineString.getNumPoints()).map((Function1 & Serializable & scala.Serializable)i -> MosaicLineStringJTS$.$anonfun$getPoints$1(lineString, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Override
    public MosaicGeometry fromInternal(InternalRow row) {
        InternalGeometry internalGeom = InternalGeometry$.MODULE$.apply(row);
        GeometryFactory gf = new GeometryFactory();
        LineString lineString = gf.createLineString((Coordinate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])internalGeom.boundaries())).head())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toCoordinate(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))));
        lineString.setSRID(internalGeom.srid());
        return this.apply((Geometry)lineString);
    }

    @Override
    public <T extends MosaicGeometry> MosaicLineStringJTS fromSeq(Seq<T> geomSeq, Enumeration.Value geomType) {
        GeometryFactory gf = new GeometryFactory();
        if (geomSeq.isEmpty()) {
            return this.apply((Geometry)gf.createLineString());
        }
        int spatialReference = ((MosaicGeometry)geomSeq.head()).getSpatialReference();
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(((MosaicGeometry)geomSeq.head()).getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            if (value != null) {
                Enumeration.Value value4;
                Enumeration.Value value5 = value4 = value;
                Enumeration.Value value6 = GeometryTypeEnum$.MODULE$.LINESTRING();
                if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                    throw new Error(new StringBuilder(65).append("Joining a sequence of ").append(value4.toString()).append(" to create a ").append(geomType.toString()).append(" geometry is not yet supported").toString());
                }
            }
            if (value != null) {
                Enumeration.Value value7 = value;
                throw new UnsupportedOperationException(new StringBuilder(57).append("MosaicGeometry.fromSeq() cannot create ").append(geomType.toString()).append(" from ").append(value7.toString()).append(" geometries.").toString());
            }
            throw new MatchError((Object)value);
        }
        Seq extractedPoints = (Seq)geomSeq.map((Function1 & Serializable & scala.Serializable)x$4 -> (MosaicPointJTS)x$4, Seq$.MODULE$.canBuildFrom());
        LineString lineString = gf.createLineString((Coordinate[])((TraversableOnce)extractedPoints.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.coord(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Coordinate.class)));
        LineString newGeom = lineString;
        newGeom.setSRID(spatialReference);
        return this.apply((Geometry)newGeom);
    }

    public <T extends MosaicGeometry> Enumeration.Value fromSeq$default$2() {
        return GeometryTypeEnum$.MODULE$.LINESTRING();
    }

    public MosaicLineStringJTS apply(Geometry geometry) {
        MosaicLineStringJTS mosaicLineStringJTS;
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(geometry.getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.LINESTRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            mosaicLineStringJTS = new MosaicLineStringJTS((LineString)geometry);
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.LINEARRING();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                LineString newGeom = new GeometryFactory().createLineString(((LinearRing)geometry).getCoordinates());
                newGeom.setSRID(geometry.getSRID());
                mosaicLineStringJTS = new MosaicLineStringJTS(newGeom);
            } else {
                throw new MatchError((Object)value);
            }
        }
        return mosaicLineStringJTS;
    }

    @Override
    public MosaicGeometry fromWKB(byte[] wkb) {
        return MosaicGeometryJTS$.MODULE$.fromWKB(wkb);
    }

    @Override
    public MosaicGeometry fromWKT(String wkt) {
        return MosaicGeometryJTS$.MODULE$.fromWKT(wkt);
    }

    @Override
    public MosaicGeometry fromJSON(String geoJson) {
        return MosaicGeometryJTS$.MODULE$.fromJSON(geoJson);
    }

    @Override
    public MosaicGeometry fromHEX(String hex) {
        return MosaicGeometryJTS$.MODULE$.fromHEX(hex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ MosaicPointJTS $anonfun$getPoints$1(LineString lineString$1, int i) {
        Point point = lineString$1.getPointN(i);
        point.setSRID(lineString$1.getSRID());
        return new MosaicPointJTS(point);
    }

    private MosaicLineStringJTS$() {
        MODULE$ = this;
        GeometryReader.$init$(this);
    }
}

