/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.BucketSort;
import com.esri.core.geometry.ClassicSort;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SizeOf;
import com.esri.core.geometry.StridedIndexTypeCollection;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;

class QuadTreeImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Envelope2D m_extent;
    private Envelope2D m_data_extent;
    private StridedIndexTypeCollection m_quad_tree_nodes;
    private StridedIndexTypeCollection m_element_nodes;
    private transient ArrayList<Data> m_data;
    private AttributeStreamOfInt32 m_free_data;
    private int m_root;
    private int m_height;
    private boolean m_b_store_duplicates;
    private static final int m_quadrant_mask = 3;
    private static final int m_height_bit_shift = 2;
    private static final int m_flushing_count = 5;

    QuadTreeImpl(Envelope2D extent, int height) {
        this.m_quad_tree_nodes = new StridedIndexTypeCollection(10);
        this.m_element_nodes = new StridedIndexTypeCollection(4);
        this.m_data = new ArrayList(0);
        this.m_free_data = new AttributeStreamOfInt32(0);
        this.m_b_store_duplicates = false;
        this.m_extent = new Envelope2D();
        this.m_data_extent = new Envelope2D();
        this.reset_(extent, height);
    }

    QuadTreeImpl(Envelope2D extent, int height, boolean b_store_duplicates) {
        this.m_quad_tree_nodes = b_store_duplicates ? new StridedIndexTypeCollection(11) : new StridedIndexTypeCollection(10);
        this.m_element_nodes = new StridedIndexTypeCollection(4);
        this.m_data = new ArrayList(0);
        this.m_free_data = new AttributeStreamOfInt32(0);
        this.m_b_store_duplicates = b_store_duplicates;
        this.m_extent = new Envelope2D();
        this.m_data_extent = new Envelope2D();
        this.reset_(extent, height);
    }

    void reset(Envelope2D extent, int height) {
        this.m_quad_tree_nodes.deleteAll(false);
        this.m_element_nodes.deleteAll(false);
        this.m_data.clear();
        this.m_free_data.clear(false);
        this.reset_(extent, height);
    }

    int insert(int element, Envelope2D bounding_box) {
        if (this.m_root == -1) {
            this.create_root_();
        }
        if (this.m_b_store_duplicates) {
            int success = this.insert_duplicates_(element, bounding_box, 0, this.m_extent, this.m_root, false, -1);
            if (success != -1) {
                if (this.m_data_extent.isEmpty()) {
                    this.m_data_extent.setCoords(bounding_box);
                } else {
                    this.m_data_extent.merge(bounding_box);
                }
            }
            return success;
        }
        int element_handle = this.insert_(element, bounding_box, 0, this.m_extent, this.m_root, false, -1);
        if (element_handle != -1) {
            if (this.m_data_extent.isEmpty()) {
                this.m_data_extent.setCoords(bounding_box);
            } else {
                this.m_data_extent.merge(bounding_box);
            }
        }
        return element_handle;
    }

    int insert(int element, Envelope2D bounding_box, int hint_index) {
        Envelope2D quad_extent;
        if (this.m_root == -1) {
            this.create_root_();
        }
        if (this.m_b_store_duplicates) {
            int success = this.insert_duplicates_(element, bounding_box, 0, this.m_extent, this.m_root, false, -1);
            if (success != -1) {
                if (this.m_data_extent.isEmpty()) {
                    this.m_data_extent.setCoords(bounding_box);
                } else {
                    this.m_data_extent.merge(bounding_box);
                }
            }
            return success;
        }
        int quad_handle = hint_index == -1 ? this.m_root : this.get_quad_(hint_index);
        int quad_height = this.getHeight(quad_handle);
        int element_handle = this.insert_(element, bounding_box, quad_height, quad_extent = this.getExtent(quad_handle), quad_handle, false, -1);
        if (element_handle != -1) {
            if (this.m_data_extent.isEmpty()) {
                this.m_data_extent.setCoords(bounding_box);
            } else {
                this.m_data_extent.merge(bounding_box);
            }
        }
        return element_handle;
    }

    void removeElement(int element_handle) {
        if (this.m_b_store_duplicates) {
            throw new GeometryException("invalid call");
        }
        int quad_handle = this.get_quad_(element_handle);
        this.disconnect_element_handle_(element_handle);
        this.free_element_and_box_node_(element_handle);
        int q = quad_handle;
        while (q != -1) {
            this.set_sub_tree_element_count_(q, this.get_sub_tree_element_count_(q) - 1);
            int parent = this.get_parent_(q);
            if (this.get_sub_tree_element_count_(q) == 0) {
                assert (this.get_local_element_count_(q) == 0);
                if (q != this.m_root) {
                    int quadrant = this.get_quadrant_(q);
                    this.m_quad_tree_nodes.deleteElement(q);
                    this.set_child_(parent, quadrant, -1);
                }
            }
            q = parent;
        }
    }

    int getElement(int element_handle) {
        return this.get_element_value_(this.get_data_(element_handle));
    }

    int getElementAtIndex(int i) {
        return this.m_data.get((int)i).element;
    }

    Envelope2D getElementExtent(int element_handle) {
        int data_handle = this.get_data_(element_handle);
        return this.get_bounding_box_value_(data_handle);
    }

    Envelope2D getElementExtentAtIndex(int i) {
        return this.m_data.get((int)i).box;
    }

    Envelope2D getDataExtent() {
        return this.m_data_extent;
    }

    Envelope2D getQuadTreeExtent() {
        return this.m_extent;
    }

    int getHeight(int quad_handle) {
        return this.get_height_(quad_handle);
    }

    int getMaxHeight() {
        return this.m_height;
    }

    Envelope2D getExtent(int quad_handle) {
        Envelope2D quad_extent = new Envelope2D();
        quad_extent.setCoords(this.m_extent);
        if (quad_handle == this.m_root) {
            return quad_extent;
        }
        AttributeStreamOfInt32 quadrants = new AttributeStreamOfInt32(0);
        int q = quad_handle;
        do {
            quadrants.add(this.get_quadrant_(q));
        } while ((q = this.get_parent_(q)) != this.m_root);
        int sz = quadrants.size();
        assert (sz == this.getHeight(quad_handle));
        int i = 0;
        while (i < sz) {
            int child = quadrants.getLast();
            quadrants.removeLast();
            if (child == 0) {
                quad_extent.xmin = 0.5 * (quad_extent.xmin + quad_extent.xmax);
                quad_extent.ymin = 0.5 * (quad_extent.ymin + quad_extent.ymax);
            } else if (child == 1) {
                quad_extent.xmax = 0.5 * (quad_extent.xmin + quad_extent.xmax);
                quad_extent.ymin = 0.5 * (quad_extent.ymin + quad_extent.ymax);
            } else if (child == 2) {
                quad_extent.xmax = 0.5 * (quad_extent.xmin + quad_extent.xmax);
                quad_extent.ymax = 0.5 * (quad_extent.ymin + quad_extent.ymax);
            } else {
                quad_extent.xmin = 0.5 * (quad_extent.xmin + quad_extent.xmax);
                quad_extent.ymax = 0.5 * (quad_extent.ymin + quad_extent.ymax);
            }
            ++i;
        }
        return quad_extent;
    }

    int getQuad(int element_handle) {
        return this.get_quad_(element_handle);
    }

    int getElementCount() {
        if (this.m_root == -1) {
            return 0;
        }
        assert (this.get_sub_tree_element_count_(this.m_root) == this.m_data.size());
        return this.get_sub_tree_element_count_(this.m_root);
    }

    int getSubTreeElementCount(int quad_handle) {
        return this.get_sub_tree_element_count_(quad_handle);
    }

    int getContainedSubTreeElementCount(int quad_handle) {
        if (!this.m_b_store_duplicates) {
            return this.get_sub_tree_element_count_(quad_handle);
        }
        return this.get_contained_sub_tree_element_count_(quad_handle);
    }

    int getIntersectionCount(Envelope2D query, double tolerance, int max_count) {
        if (this.m_root == -1) {
            return 0;
        }
        Envelope2D query_inflated = new Envelope2D();
        query_inflated.setCoords(query);
        query_inflated.inflate(tolerance, tolerance);
        AttributeStreamOfInt32 quads_stack = new AttributeStreamOfInt32(0);
        ArrayList<Envelope2D> extents_stack = new ArrayList<Envelope2D>(0);
        quads_stack.add(this.m_root);
        extents_stack.add(new Envelope2D(this.m_extent.xmin, this.m_extent.ymin, this.m_extent.xmax, this.m_extent.ymax));
        Envelope2D[] child_extents = new Envelope2D[]{new Envelope2D(), new Envelope2D(), new Envelope2D(), new Envelope2D()};
        Envelope2D current_extent = new Envelope2D();
        int intersection_count = 0;
        while (quads_stack.size() > 0) {
            boolean b_subdivide = false;
            int current_quad_handle = quads_stack.getLast();
            current_extent.setCoords((Envelope2D)extents_stack.get(extents_stack.size() - 1));
            quads_stack.removeLast();
            extents_stack.remove(extents_stack.size() - 1);
            if (query_inflated.contains(current_extent)) {
                if (max_count > 0 && (intersection_count += this.getSubTreeElementCount(current_quad_handle)) >= max_count) {
                    return max_count;
                }
            } else if (query_inflated.isIntersecting(current_extent)) {
                int element_handle = this.get_first_element_(current_quad_handle);
                while (element_handle != -1) {
                    int data_handle = this.get_data_(element_handle);
                    Envelope2D env = this.get_bounding_box_value_(data_handle);
                    if (env.isIntersecting(query_inflated) && max_count > 0 && ++intersection_count >= max_count) {
                        return max_count;
                    }
                    element_handle = this.get_next_element_(element_handle);
                }
                boolean bl = b_subdivide = this.getHeight(current_quad_handle) + 1 <= this.m_height;
            }
            if (!b_subdivide) continue;
            QuadTreeImpl.set_child_extents_(current_extent, child_extents);
            int i = 0;
            while (i < 4) {
                boolean b_is_intersecting;
                int child_handle = this.get_child_(current_quad_handle, i);
                if (child_handle != -1 && this.getSubTreeElementCount(child_handle) > 0 && (b_is_intersecting = query_inflated.isIntersecting(child_extents[i]))) {
                    quads_stack.add(child_handle);
                    extents_stack.add(new Envelope2D(child_extents[i].xmin, child_extents[i].ymin, child_extents[i].xmax, child_extents[i].ymax));
                }
                ++i;
            }
        }
        return intersection_count;
    }

    boolean hasData(Envelope2D query, double tolerance) {
        int count = this.getIntersectionCount(query, tolerance, 1);
        return count >= 1;
    }

    QuadTreeIteratorImpl getIterator(Geometry query, double tolerance) {
        return new QuadTreeIteratorImpl(this, query, tolerance);
    }

    QuadTreeIteratorImpl getIterator(Envelope2D query, double tolerance) {
        return new QuadTreeIteratorImpl(this, query, tolerance);
    }

    QuadTreeIteratorImpl getIterator() {
        return new QuadTreeIteratorImpl(this);
    }

    QuadTreeSortedIteratorImpl getSortedIterator(Geometry query, double tolerance) {
        return new QuadTreeSortedIteratorImpl(this.getIterator(query, tolerance));
    }

    QuadTreeSortedIteratorImpl getSortedIterator(Envelope2D query, double tolerance) {
        return new QuadTreeSortedIteratorImpl(this.getIterator(query, tolerance));
    }

    QuadTreeSortedIteratorImpl getSortedIterator() {
        return new QuadTreeSortedIteratorImpl(this.getIterator());
    }

    public long estimateMemorySize() {
        long size = (long)(48 + (this.m_extent != null ? this.m_extent.estimateMemorySize() : 0) + (this.m_data_extent != null ? this.m_data_extent.estimateMemorySize() : 0)) + (this.m_quad_tree_nodes != null ? this.m_quad_tree_nodes.estimateMemorySize() : 0L) + (this.m_element_nodes != null ? this.m_element_nodes.estimateMemorySize() : 0L) + (this.m_free_data != null ? this.m_free_data.estimateMemorySize() : 0L);
        if (this.m_data != null) {
            size += SizeOf.sizeOfObjectArray(this.m_data.size()) + (long)(this.m_data.size() * 24);
        }
        return size;
    }

    private void reset_(Envelope2D extent, int height) {
        if (height < 0 || height > 127) {
            throw new IllegalArgumentException("invalid height");
        }
        this.m_height = height;
        this.m_extent.setCoords(extent);
        this.m_root = this.m_quad_tree_nodes.newElement();
        this.m_data_extent.setEmpty();
        this.m_root = -1;
    }

    private int insert_(int element, Envelope2D bounding_box, int height, Envelope2D quad_extent, int quad_handle, boolean b_flushing, int flushed_element_handle) {
        if (!quad_extent.contains(bounding_box)) {
            assert (!b_flushing);
            if (height == 0) {
                return -1;
            }
            return this.insert_(element, bounding_box, 0, this.m_extent, this.m_root, b_flushing, flushed_element_handle);
        }
        if (!b_flushing) {
            int q = quad_handle;
            while (q != -1) {
                this.set_sub_tree_element_count_(q, this.get_sub_tree_element_count_(q) + 1);
                q = this.get_parent_(q);
            }
        }
        Envelope2D current_extent = new Envelope2D();
        current_extent.setCoords(quad_extent);
        int current_quad_handle = quad_handle;
        Envelope2D[] child_extents = new Envelope2D[]{new Envelope2D(), new Envelope2D(), new Envelope2D(), new Envelope2D()};
        int current_height = height;
        while (current_height < this.m_height && this.can_push_down_(current_quad_handle)) {
            QuadTreeImpl.set_child_extents_(current_extent, child_extents);
            boolean b_contains = false;
            int i = 0;
            while (i < 4) {
                if (child_extents[i].contains(bounding_box)) {
                    b_contains = true;
                    int child_handle = this.get_child_(current_quad_handle, i);
                    if (child_handle == -1) {
                        child_handle = this.create_child_(current_quad_handle, i);
                    }
                    this.set_sub_tree_element_count_(child_handle, this.get_sub_tree_element_count_(child_handle) + 1);
                    current_quad_handle = child_handle;
                    current_extent.setCoords(child_extents[i]);
                    break;
                }
                ++i;
            }
            if (!b_contains) break;
            ++current_height;
        }
        return this.insert_at_quad_(element, bounding_box, current_height, current_extent, current_quad_handle, b_flushing, quad_handle, flushed_element_handle, -1);
    }

    private int insert_duplicates_(int element, Envelope2D bounding_box, int height, Envelope2D quad_extent, int quad_handle, boolean b_flushing, int flushed_element_handle) {
        assert (b_flushing || this.m_root == quad_handle);
        if (!b_flushing) {
            if (!quad_extent.contains(bounding_box)) {
                return -1;
            }
            this.set_sub_tree_element_count_(quad_handle, this.get_sub_tree_element_count_(quad_handle) + 1);
            this.set_contained_sub_tree_element_count_(quad_handle, this.get_contained_sub_tree_element_count_(quad_handle) + 1);
        }
        double bounding_box_max_dim = Math.max(bounding_box.getWidth(), bounding_box.getHeight());
        int element_handle = -1;
        AttributeStreamOfInt32 quads_stack = new AttributeStreamOfInt32(0);
        ArrayList<Envelope2D> extents_stack = new ArrayList<Envelope2D>(0);
        AttributeStreamOfInt32 heights_stack = new AttributeStreamOfInt32(0);
        quads_stack.add(quad_handle);
        extents_stack.add(new Envelope2D(quad_extent.xmin, quad_extent.ymin, quad_extent.xmax, quad_extent.ymax));
        heights_stack.add(height);
        Envelope2D[] child_extents = new Envelope2D[]{new Envelope2D(), new Envelope2D(), new Envelope2D(), new Envelope2D()};
        Envelope2D current_extent = new Envelope2D();
        while (quads_stack.size() > 0) {
            double current_extent_max_dim;
            boolean b_subdivide = false;
            int current_quad_handle = quads_stack.getLast();
            current_extent.setCoords((Envelope2D)extents_stack.get(extents_stack.size() - 1));
            int current_height = heights_stack.getLast();
            quads_stack.removeLast();
            extents_stack.remove(extents_stack.size() - 1);
            heights_stack.removeLast();
            if (current_height + 1 < this.m_height && this.can_push_down_(current_quad_handle) && bounding_box_max_dim <= (current_extent_max_dim = Math.max(current_extent.getWidth(), current_extent.getHeight())) / 2.0) {
                b_subdivide = true;
            }
            if (b_subdivide) {
                QuadTreeImpl.set_child_extents_(current_extent, child_extents);
                boolean b_contains = false;
                int i = 0;
                while (i < 4) {
                    b_contains = child_extents[i].contains(bounding_box);
                    if (b_contains) {
                        int child_handle = this.get_child_(current_quad_handle, i);
                        if (child_handle == -1) {
                            child_handle = this.create_child_(current_quad_handle, i);
                        }
                        quads_stack.add(child_handle);
                        extents_stack.add(new Envelope2D(child_extents[i].xmin, child_extents[i].ymin, child_extents[i].xmax, child_extents[i].ymax));
                        heights_stack.add(current_height + 1);
                        this.set_sub_tree_element_count_(child_handle, this.get_sub_tree_element_count_(child_handle) + 1);
                        this.set_contained_sub_tree_element_count_(child_handle, this.get_contained_sub_tree_element_count_(child_handle) + 1);
                        break;
                    }
                    ++i;
                }
                if (b_contains) continue;
                i = 0;
                while (i < 4) {
                    boolean b_intersects = child_extents[i].isIntersecting(bounding_box);
                    if (b_intersects) {
                        int child_handle = this.get_child_(current_quad_handle, i);
                        if (child_handle == -1) {
                            child_handle = this.create_child_(current_quad_handle, i);
                        }
                        quads_stack.add(child_handle);
                        extents_stack.add(new Envelope2D(child_extents[i].xmin, child_extents[i].ymin, child_extents[i].xmax, child_extents[i].ymax));
                        heights_stack.add(current_height + 1);
                        this.set_sub_tree_element_count_(child_handle, this.get_sub_tree_element_count_(child_handle) + 1);
                    }
                    ++i;
                }
                continue;
            }
            element_handle = this.insert_at_quad_(element, bounding_box, current_height, current_extent, current_quad_handle, b_flushing, quad_handle, flushed_element_handle, element_handle);
            b_flushing = false;
        }
        return 0;
    }

    private int insert_at_quad_(int element, Envelope2D bounding_box, int current_height, Envelope2D current_extent, int current_quad_handle, boolean b_flushing, int quad_handle, int flushed_element_handle, int duplicate_element_handle) {
        int head_element_handle = this.get_first_element_(current_quad_handle);
        int tail_element_handle = this.get_last_element_(current_quad_handle);
        int element_handle = -1;
        if (b_flushing) {
            assert (flushed_element_handle != -1);
            if (current_quad_handle == quad_handle) {
                return flushed_element_handle;
            }
            this.disconnect_element_handle_(flushed_element_handle);
            element_handle = flushed_element_handle;
        } else if (duplicate_element_handle == -1) {
            element_handle = this.create_element_();
            this.set_data_values_(this.get_data_(element_handle), element, bounding_box);
        } else {
            assert (this.m_b_store_duplicates);
            element_handle = this.create_element_from_duplicate_(duplicate_element_handle);
        }
        assert (!b_flushing || element_handle == flushed_element_handle);
        this.set_quad_(element_handle, current_quad_handle);
        if (tail_element_handle != -1) {
            this.set_prev_element_(element_handle, tail_element_handle);
            this.set_next_element_(tail_element_handle, element_handle);
        } else {
            assert (head_element_handle == -1);
            this.set_first_element_(current_quad_handle, element_handle);
        }
        this.set_last_element_(current_quad_handle, element_handle);
        this.set_local_element_count_(current_quad_handle, this.get_local_element_count_(current_quad_handle) + 1);
        if (this.can_flush_(current_quad_handle)) {
            this.flush_(current_height, current_extent, current_quad_handle);
        }
        return element_handle;
    }

    private static void set_child_extents_(Envelope2D current_extent, Envelope2D[] child_extents) {
        double x_mid = 0.5 * (current_extent.xmin + current_extent.xmax);
        double y_mid = 0.5 * (current_extent.ymin + current_extent.ymax);
        child_extents[0].setCoords(x_mid, y_mid, current_extent.xmax, current_extent.ymax);
        child_extents[1].setCoords(current_extent.xmin, y_mid, x_mid, current_extent.ymax);
        child_extents[2].setCoords(current_extent.xmin, current_extent.ymin, x_mid, y_mid);
        child_extents[3].setCoords(x_mid, current_extent.ymin, current_extent.xmax, y_mid);
    }

    private void disconnect_element_handle_(int element_handle) {
        assert (element_handle != -1);
        int quad_handle = this.get_quad_(element_handle);
        int head_element_handle = this.get_first_element_(quad_handle);
        int tail_element_handle = this.get_last_element_(quad_handle);
        int prev_element_handle = this.get_prev_element_(element_handle);
        int next_element_handle = this.get_next_element_(element_handle);
        assert (head_element_handle != -1 && tail_element_handle != -1);
        if (head_element_handle == element_handle) {
            if (next_element_handle != -1) {
                this.set_prev_element_(next_element_handle, -1);
            } else {
                assert (head_element_handle == tail_element_handle);
                assert (this.get_local_element_count_(quad_handle) == 1);
                this.set_last_element_(quad_handle, -1);
            }
            this.set_first_element_(quad_handle, next_element_handle);
        } else if (tail_element_handle == element_handle) {
            assert (prev_element_handle != -1);
            assert (this.get_local_element_count_(quad_handle) >= 2);
            this.set_next_element_(prev_element_handle, -1);
            this.set_last_element_(quad_handle, prev_element_handle);
        } else {
            assert (next_element_handle != -1 && prev_element_handle != -1);
            assert (this.get_local_element_count_(quad_handle) >= 3);
            this.set_prev_element_(next_element_handle, prev_element_handle);
            this.set_next_element_(prev_element_handle, next_element_handle);
        }
        this.set_prev_element_(element_handle, -1);
        this.set_next_element_(element_handle, -1);
        this.set_local_element_count_(quad_handle, this.get_local_element_count_(quad_handle) - 1);
        assert (this.get_local_element_count_(quad_handle) >= 0);
    }

    private boolean can_flush_(int quad_handle) {
        return this.get_local_element_count_(quad_handle) == 5 && !this.has_children_(quad_handle);
    }

    private void flush_(int height, Envelope2D extent, int quad_handle) {
        Envelope2D bounding_box = new Envelope2D();
        assert (quad_handle != -1);
        int element_handle = this.get_first_element_(quad_handle);
        int next_handle = -1;
        int data_handle = -1;
        assert (element_handle != -1);
        do {
            data_handle = this.get_data_(element_handle);
            int element = this.get_element_value_(data_handle);
            bounding_box.setCoords(this.get_bounding_box_value_(data_handle));
            next_handle = this.get_next_element_(element_handle);
            if (!this.m_b_store_duplicates) {
                this.insert_(element, bounding_box, height, extent, quad_handle, true, element_handle);
                continue;
            }
            this.insert_duplicates_(element, bounding_box, height, extent, quad_handle, true, element_handle);
        } while ((element_handle = next_handle) != -1);
    }

    private boolean can_push_down_(int quad_handle) {
        return this.get_local_element_count_(quad_handle) >= 5 || this.has_children_(quad_handle);
    }

    private boolean has_children_(int parent) {
        return this.get_child_(parent, 0) != -1 || this.get_child_(parent, 1) != -1 || this.get_child_(parent, 2) != -1 || this.get_child_(parent, 3) != -1;
    }

    private int create_child_(int parent, int quadrant) {
        int child = this.m_quad_tree_nodes.newElement();
        this.set_child_(parent, quadrant, child);
        this.set_sub_tree_element_count_(child, 0);
        this.set_local_element_count_(child, 0);
        this.set_parent_(child, parent);
        this.set_height_and_quadrant_(child, this.get_height_(parent) + 1, quadrant);
        if (this.m_b_store_duplicates) {
            this.set_contained_sub_tree_element_count_(child, 0);
        }
        return child;
    }

    private void create_root_() {
        this.m_root = this.m_quad_tree_nodes.newElement();
        this.set_sub_tree_element_count_(this.m_root, 0);
        this.set_local_element_count_(this.m_root, 0);
        this.set_height_and_quadrant_(this.m_root, 0, 0);
        if (this.m_b_store_duplicates) {
            this.set_contained_sub_tree_element_count_(this.m_root, 0);
        }
    }

    private int create_element_() {
        int data_handle;
        int element_handle = this.m_element_nodes.newElement();
        if (this.m_free_data.size() > 0) {
            data_handle = this.m_free_data.get(this.m_free_data.size() - 1);
            this.m_free_data.removeLast();
        } else {
            data_handle = this.m_data.size();
            this.m_data.add(null);
        }
        this.set_data_(element_handle, data_handle);
        return element_handle;
    }

    private int create_element_from_duplicate_(int duplicate_element_handle) {
        int element_handle = this.m_element_nodes.newElement();
        int data_handle = this.get_data_(duplicate_element_handle);
        this.set_data_(element_handle, data_handle);
        return element_handle;
    }

    private void free_element_and_box_node_(int element_handle) {
        int data_handle = this.get_data_(element_handle);
        this.m_free_data.add(data_handle);
        this.m_element_nodes.deleteElement(element_handle);
    }

    private int get_child_(int quad_handle, int quadrant) {
        return this.m_quad_tree_nodes.getField(quad_handle, quadrant);
    }

    private void set_child_(int parent, int quadrant, int child) {
        this.m_quad_tree_nodes.setField(parent, quadrant, child);
    }

    private int get_first_element_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 4);
    }

    private void set_first_element_(int quad_handle, int head) {
        this.m_quad_tree_nodes.setField(quad_handle, 4, head);
    }

    private int get_last_element_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 5);
    }

    private void set_last_element_(int quad_handle, int tail) {
        this.m_quad_tree_nodes.setField(quad_handle, 5, tail);
    }

    private int get_quadrant_(int quad_handle) {
        int height_quadrant_hybrid = this.m_quad_tree_nodes.getField(quad_handle, 6);
        int quadrant = height_quadrant_hybrid & 3;
        return quadrant;
    }

    private int get_height_(int quad_handle) {
        int height_quadrant_hybrid = this.m_quad_tree_nodes.getField(quad_handle, 6);
        int height = height_quadrant_hybrid >> 2;
        return height;
    }

    private void set_height_and_quadrant_(int quad_handle, int height, int quadrant) {
        assert (quadrant >= 0 && quadrant <= 3);
        int height_quadrant_hybrid = height << 2 | quadrant;
        this.m_quad_tree_nodes.setField(quad_handle, 6, height_quadrant_hybrid);
    }

    private int get_local_element_count_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 7);
    }

    private void set_local_element_count_(int quad_handle, int count) {
        this.m_quad_tree_nodes.setField(quad_handle, 7, count);
    }

    private int get_sub_tree_element_count_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 8);
    }

    private void set_sub_tree_element_count_(int quad_handle, int count) {
        this.m_quad_tree_nodes.setField(quad_handle, 8, count);
    }

    private int get_parent_(int child) {
        return this.m_quad_tree_nodes.getField(child, 9);
    }

    private void set_parent_(int child, int parent) {
        this.m_quad_tree_nodes.setField(child, 9, parent);
    }

    private int get_contained_sub_tree_element_count_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 10);
    }

    private void set_contained_sub_tree_element_count_(int quad_handle, int count) {
        this.m_quad_tree_nodes.setField(quad_handle, 10, count);
    }

    private int get_data_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 0);
    }

    private void set_data_(int element_handle, int data_handle) {
        this.m_element_nodes.setField(element_handle, 0, data_handle);
    }

    private int get_prev_element_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 1);
    }

    private int get_next_element_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 2);
    }

    private void set_prev_element_(int element_handle, int prev_handle) {
        this.m_element_nodes.setField(element_handle, 1, prev_handle);
    }

    private void set_next_element_(int element_handle, int next_handle) {
        this.m_element_nodes.setField(element_handle, 2, next_handle);
    }

    private int get_quad_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 3);
    }

    private void set_quad_(int element_handle, int parent) {
        this.m_element_nodes.setField(element_handle, 3, parent);
    }

    private int get_element_value_(int data_handle) {
        return this.m_data.get((int)data_handle).element;
    }

    private Envelope2D get_bounding_box_value_(int data_handle) {
        return this.m_data.get((int)data_handle).box;
    }

    private void set_data_values_(int data_handle, int element, Envelope2D bounding_box) {
        this.m_data.set(data_handle, new Data(element, bounding_box));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.m_data.size());
        int i = 0;
        int n = this.m_data.size();
        while (i < n) {
            Data d = this.m_data.get(i);
            if (d != null) {
                stream.writeByte(1);
                stream.writeInt(d.element);
                stream.writeDouble(d.box.xmin);
                stream.writeDouble(d.box.ymin);
                stream.writeDouble(d.box.xmax);
                stream.writeDouble(d.box.ymax);
            } else {
                stream.writeByte(0);
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int dataSize = stream.readInt();
        this.m_data = new ArrayList(dataSize);
        int i = 0;
        int n = dataSize;
        while (i < n) {
            byte b = stream.readByte();
            if (b == 1) {
                int elm = stream.readInt();
                double x1 = stream.readDouble();
                double y1 = stream.readDouble();
                double x2 = stream.readDouble();
                double y2 = stream.readDouble();
                Data d = new Data(elm, x1, y1, x2, y2);
                this.m_data.add(d);
            } else if (b == 0) {
                this.m_data.add(null);
            } else {
                throw new IOException();
            }
            ++i;
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    static /* synthetic */ int access$3(QuadTreeImpl quadTreeImpl, int n) {
        return quadTreeImpl.get_data_(n);
    }

    static /* synthetic */ Envelope2D access$4(QuadTreeImpl quadTreeImpl, int n) {
        return quadTreeImpl.get_bounding_box_value_(n);
    }

    static /* synthetic */ int access$5(QuadTreeImpl quadTreeImpl, int n) {
        return quadTreeImpl.get_next_element_(n);
    }

    static /* synthetic */ void access$6(Envelope2D envelope2D, Envelope2D[] envelope2DArray) {
        QuadTreeImpl.set_child_extents_(envelope2D, envelope2DArray);
    }

    static /* synthetic */ int access$7(QuadTreeImpl quadTreeImpl, int n, int n2) {
        return quadTreeImpl.get_child_(n, n2);
    }

    static /* synthetic */ int access$8(QuadTreeImpl quadTreeImpl) {
        return quadTreeImpl.m_height;
    }

    static final class Data {
        int element;
        Envelope2D box;

        Data(int element_, double x1, double y1, double x2, double y2) {
            this.element = element_;
            this.box = new Envelope2D();
            this.box.setCoords(x1, y1, x2, y2);
        }

        Data(int element_, Envelope2D box_) {
            this.element = element_;
            this.box = new Envelope2D();
            this.box.setCoords(box_);
        }
    }

    static final class QuadTreeIteratorImpl {
        private boolean m_b_linear;
        private Point2D m_query_start;
        private Point2D m_query_end;
        private Envelope2D m_query_box;
        private double m_tolerance;
        private int m_current_element_handle;
        private int m_next_element_handle;
        private QuadTreeImpl m_quad_tree;
        private AttributeStreamOfInt32 m_quads_stack;
        private ArrayList<Envelope2D> m_extents_stack;

        void resetIterator(Geometry query, double tolerance) {
            this.m_quads_stack.resize(0);
            this.m_extents_stack.clear();
            this.m_current_element_handle = -1;
            query.queryLooseEnvelope2D(this.m_query_box);
            this.m_query_box.inflate(tolerance, tolerance);
            if (this.m_quad_tree.m_root != -1 && this.m_query_box.isIntersecting(this.m_quad_tree.m_extent)) {
                int type = query.getType().value();
                this.m_b_linear = Geometry.isSegment(type);
                if (this.m_b_linear) {
                    Segment segment = (Segment)query;
                    this.m_query_start = segment.getStartXY();
                    this.m_query_end = segment.getEndXY();
                    this.m_tolerance = tolerance;
                } else {
                    this.m_tolerance = NumberUtils.NaN();
                }
                this.m_quads_stack.add(this.m_quad_tree.m_root);
                this.m_extents_stack.add(this.m_quad_tree.m_extent);
                this.m_next_element_handle = this.m_quad_tree.get_first_element_(this.m_quad_tree.m_root);
            } else {
                this.m_next_element_handle = -1;
            }
        }

        void resetIterator(Envelope2D query, double tolerance) {
            this.m_quads_stack.resize(0);
            this.m_extents_stack.clear();
            this.m_current_element_handle = -1;
            this.m_query_box.setCoords(query);
            this.m_query_box.inflate(tolerance, tolerance);
            this.m_tolerance = NumberUtils.NaN();
            if (this.m_quad_tree.m_root != -1 && this.m_query_box.isIntersecting(this.m_quad_tree.m_extent)) {
                this.m_quads_stack.add(this.m_quad_tree.m_root);
                this.m_extents_stack.add(this.m_quad_tree.m_extent);
                this.m_next_element_handle = this.m_quad_tree.get_first_element_(this.m_quad_tree.m_root);
                this.m_b_linear = false;
            } else {
                this.m_next_element_handle = -1;
            }
        }

        /*
         * Exception decompiling
         */
        int next() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        QuadTreeIteratorImpl(QuadTreeImpl quad_tree_impl, Geometry query, double tolerance) {
            this.m_quad_tree = quad_tree_impl;
            this.m_query_box = new Envelope2D();
            this.m_quads_stack = new AttributeStreamOfInt32(0);
            this.m_extents_stack = new ArrayList(0);
            this.resetIterator(query, tolerance);
        }

        QuadTreeIteratorImpl(QuadTreeImpl quad_tree_impl, Envelope2D query, double tolerance) {
            this.m_quad_tree = quad_tree_impl;
            this.m_query_box = new Envelope2D();
            this.m_quads_stack = new AttributeStreamOfInt32(0);
            this.m_extents_stack = new ArrayList(0);
            this.resetIterator(query, tolerance);
        }

        QuadTreeIteratorImpl(QuadTreeImpl quad_tree_impl) {
            this.m_quad_tree = quad_tree_impl;
            this.m_query_box = new Envelope2D();
            this.m_quads_stack = new AttributeStreamOfInt32(0);
            this.m_extents_stack = new ArrayList(0);
        }
    }

    static final class QuadTreeSortedIteratorImpl {
        private BucketSort m_bucket_sort = new BucketSort();
        private AttributeStreamOfInt32 m_sorted_handles = new AttributeStreamOfInt32(0);
        private QuadTreeIteratorImpl m_quad_tree_iterator_impl;
        int m_index;

        void resetIterator(Geometry query, double tolerance) {
            this.m_quad_tree_iterator_impl.resetIterator(query, tolerance);
            this.m_sorted_handles.resize(0);
            this.m_index = -1;
        }

        void resetIterator(Envelope2D query, double tolerance) {
            this.m_quad_tree_iterator_impl.resetIterator(query, tolerance);
            this.m_sorted_handles.resize(0);
            this.m_index = -1;
        }

        int next() {
            if (this.m_index == -1) {
                int element_handle = -1;
                while ((element_handle = this.m_quad_tree_iterator_impl.next()) != -1) {
                    this.m_sorted_handles.add(element_handle);
                }
                this.m_bucket_sort.sort(this.m_sorted_handles, 0, this.m_sorted_handles.size(), new Sorter(this.m_quad_tree_iterator_impl.m_quad_tree));
            }
            if (this.m_index == this.m_sorted_handles.size() - 1) {
                return -1;
            }
            ++this.m_index;
            return this.m_sorted_handles.get(this.m_index);
        }

        QuadTreeSortedIteratorImpl(QuadTreeIteratorImpl quad_tree_iterator_impl) {
            this.m_quad_tree_iterator_impl = quad_tree_iterator_impl;
            this.m_index = -1;
        }

        private class Sorter
        extends ClassicSort {
            private QuadTreeImpl m_quad_tree;

            public Sorter(QuadTreeImpl quad_tree) {
                this.m_quad_tree = quad_tree;
            }

            @Override
            public void userSort(int begin, int end, AttributeStreamOfInt32 indices) {
                indices.sort(begin, end);
            }

            @Override
            public double getValue(int e) {
                return this.m_quad_tree.getElement(e);
            }
        }
    }
}

