/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.gdal;

import java.io.BufferedInputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.gdal.gdal.gdal;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class MosaicGDAL$
implements Logging {
    public static MosaicGDAL$ MODULE$;
    private final String GDAL_ENABLED;
    private final Path mosaicGDALPath;
    private final String mosaicGDALAbsolutePath;
    private boolean isEnabled;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new MosaicGDAL$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String GDAL_ENABLED() {
        return this.GDAL_ENABLED;
    }

    private Path mosaicGDALPath() {
        return this.mosaicGDALPath;
    }

    private String mosaicGDALAbsolutePath() {
        return this.mosaicGDALAbsolutePath;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void isEnabled_$eq(boolean x$1) {
        this.isEnabled = x$1;
    }

    public boolean wasEnabled(SparkSession spark) {
        return new StringOps(Predef$.MODULE$.augmentString(spark.conf().get(this.GDAL_ENABLED(), "false"))).toBoolean();
    }

    public void prepareEnvironment(SparkSession spark, String initScriptPath, String sharedObjectsPath) {
        if (!this.wasEnabled(spark) && !this.isEnabled()) {
            Try try_ = Try$.MODULE$.apply((JFunction0$mcV$sp & scala.Serializable)() -> {
                MODULE$.copyInitScript(initScriptPath);
                MODULE$.copySharedObjects(sharedObjectsPath);
            });
            if (try_ instanceof Success) {
                this.logInfo((Function0<String> & Serializable & scala.Serializable)() -> "GDAL environment prepared successfully.");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    this.logError((Function0<String> & Serializable & scala.Serializable)() -> "GDAL environment preparation failed.", exception);
                    throw exception;
                }
                throw new MatchError(try_);
            }
        }
    }

    public void enableGDAL(SparkSession spark) {
        if (!this.wasEnabled(spark) && !this.isEnabled()) {
            Try try_ = Try$.MODULE$.apply((JFunction0$mcV$sp & scala.Serializable)() -> {
                MODULE$.isEnabled_$eq(true);
                MODULE$.loadSharedObjects();
                gdal.AllRegister();
                spark.conf().set(MODULE$.GDAL_ENABLED(), "true");
            });
            if (try_ instanceof Success) {
                this.logInfo((Function0<String> & Serializable & scala.Serializable)() -> "GDAL environment enabled successfully.");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    this.logError((Function0<String> & Serializable & scala.Serializable)() -> "GDAL not enabled. Mosaic with GDAL requires that GDAL be installed on the cluster.");
                    this.logError((Function0<String> & Serializable & scala.Serializable)() -> "Please run setup_gdal() to generate the init script for install GDAL install.");
                    this.logError((Function0<String> & Serializable & scala.Serializable)() -> "After the init script is generated, please restart the cluster with the init script to complete the setup.");
                    this.logError((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(7).append("Error: ").append(exception.getMessage()).toString());
                    this.isEnabled_$eq(false);
                    throw exception;
                }
                throw new MatchError(try_);
            }
        }
    }

    private void copySharedObjects(String path) {
        byte[] so = this.readResourceBytes("/gdal/ubuntu/libgdalalljni.so");
        byte[] so30 = this.readResourceBytes("/gdal/ubuntu/libgdalalljni.so.30");
        Path usrGDALPath = Paths.get("/usr/lib/jni/", new String[0]);
        Object object = !Files.exists(this.mosaicGDALPath(), new LinkOption[0]) ? Files.createDirectories(this.mosaicGDALPath(), new FileAttribute[0]) : BoxedUnit.UNIT;
        Object object2 = !Files.exists(usrGDALPath, new LinkOption[0]) ? Files.createDirectories(usrGDALPath, new FileAttribute[0]) : BoxedUnit.UNIT;
        Files.write(Paths.get(new StringBuilder(17).append(this.mosaicGDALAbsolutePath()).append("/libgdalalljni.so").toString(), new String[0]), so, new OpenOption[0]);
        Files.write(Paths.get(new StringBuilder(20).append(this.mosaicGDALAbsolutePath()).append("/libgdalalljni.so.30").toString(), new String[0]), so30, new OpenOption[0]);
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(43).append("sudo cp ").append(this.mosaicGDALAbsolutePath()).append("/libgdalalljni.so ").append(path).append("/libgdalalljni.so").toString()).$bang$bang();
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(49).append("sudo cp ").append(this.mosaicGDALAbsolutePath()).append("/libgdalalljni.so.30 ").append(path).append("/libgdalalljni.so.30").toString()).$bang$bang();
    }

    private void copyInitScript(String path) {
        Path destPath = Paths.get(path, new String[0]);
        byte[] script = this.readResourceBytes("/scripts/install-gdal-databricks.sh");
        Object object = !Files.exists(this.mosaicGDALPath(), new LinkOption[0]) ? Files.createDirectories(this.mosaicGDALPath(), new FileAttribute[0]) : BoxedUnit.UNIT;
        Object object2 = !Files.exists(destPath, new LinkOption[0]) ? Files.createDirectories(destPath, new FileAttribute[0]) : BoxedUnit.UNIT;
        Files.write(Paths.get(new StringBuilder(20).append(this.mosaicGDALAbsolutePath()).append("/mosaic-gdal-init.sh").toString(), new String[0]), script, new OpenOption[0]);
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(49).append("sudo cp ").append(this.mosaicGDALAbsolutePath()).append("/mosaic-gdal-init.sh ").append(path).append("/mosaic-gdal-init.sh").toString()).$bang$bang();
    }

    private void loadSharedObjects() {
        System.load("/usr/lib/libgdal.so.30");
        Object object = !Files.exists(Paths.get("/usr/lib/libgdal.so", new String[0]), new LinkOption[0]) ? scala.sys.process.package$.MODULE$.stringToProcess("sudo cp /usr/lib/libgdal.so.30 /usr/lib/libgdal.so").$bang$bang() : BoxedUnit.UNIT;
        System.load("/usr/lib/libgdal.so");
        System.load("/usr/lib/libgdal.so.30.0.3");
        System.load("/usr/lib/jni/libgdalalljni.so.30");
        System.load("/usr/lib/ogdi/libgdal.so");
    }

    private byte[] readResourceBytes(String name) {
        byte[] byArray;
        try (BufferedInputStream bis = new BufferedInputStream(this.getClass().getResourceAsStream(name));){
            byArray = (byte[])((TraversableOnce)((Stream)package$.MODULE$.Stream().continually((JFunction0$mcI$sp & scala.Serializable)() -> bis.read()).takeWhile((JFunction1$mcZI$sp & scala.Serializable)x -> -1 != x)).map((Function1<Object, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte(MosaicGDAL$.$anonfun$readResourceBytes$3(BoxesRunTime.unboxToInt(x$1))), Stream$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
        }
        return byArray;
    }

    public static final /* synthetic */ byte $anonfun$readResourceBytes$3(int x$1) {
        return (byte)x$1;
    }

    private MosaicGDAL$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.GDAL_ENABLED = "spark.mosaic.gdal.native.enabled";
        this.mosaicGDALPath = Files.createTempDirectory("mosaic-gdal", new FileAttribute[0]);
        this.mosaicGDALAbsolutePath = ((Object)this.mosaicGDALPath().toAbsolutePath()).toString();
        this.isEnabled = false;
    }
}

