/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.index;

import com.databricks.labs.mosaic.expressions.index.GeometryKRingExplode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.collection.immutable.StringOps;

public final class GeometryKRingExplode$
implements Serializable {
    public static GeometryKRingExplode$ MODULE$;

    static {
        new GeometryKRingExplode$();
    }

    public ExpressionInfo registryExpressionInfo(Option<String> db) {
        return new ExpressionInfo(GeometryKRingExplode.class.getCanonicalName(), (String)db.orNull(Predef$.MODULE$.$conforms()), "grid_cellkringexplode", new StringOps(Predef$.MODULE$.augmentString("\n            |    _FUNC_(cell_id, resolution)) - Generates the geometry based kring cell IDs set for the input\n            |    geometry and the input k value.\n            ")).stripMargin(), "", new StringOps(Predef$.MODULE$.augmentString("\n            |    Examples:\n            |      > SELECT _FUNC_(a, b);\n            |        622236721274716159\n            |        622236721274716160\n            |        622236721274716161\n            |        ...\n            |\n            |  ")).stripMargin(), "", "generator_funcs", "1.0", "", "built-in");
    }

    public GeometryKRingExplode apply(Expression geom, Expression resolution, Expression k, String indexSystemName, String geometryAPIName) {
        return new GeometryKRingExplode(geom, resolution, k, indexSystemName, geometryAPIName);
    }

    public Option<Tuple5<Expression, Expression, Expression, String, String>> unapply(GeometryKRingExplode x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple5<Expression, Expression, Expression, String, String>>(new Tuple5<Expression, Expression, Expression, String, String>(x$0.geom(), x$0.resolution(), x$0.k(), x$0.indexSystemName(), x$0.geometryAPIName()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GeometryKRingExplode$() {
        MODULE$ = this;
    }
}

