/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.format;

import com.databricks.labs.mosaic.codegen.format.ConvertToCodeGen$;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.types.package$;
import com.databricks.labs.mosaic.expressions.format.ConvertTo$;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, dataType) - Converts expr1 to the specified data type.", examples="\n    Examples:\n      > SELECT _FUNC_(a, 'hex');\n       {\"00001005FA...00A\"}\n      > SELECT _FUNC_(a, 'wkt');\n      \"POLYGON ((...))\"\n  ", since="1.0")
@ScalaSignature(bytes="\u0006\u0001\tMc\u0001\u0002\u0015*\u0001ZB\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tU\u0002\u0011\t\u0012)A\u0005O\"A1\u000e\u0001BK\u0002\u0013\u0005A\u000e\u0003\u0005v\u0001\tE\t\u0015!\u0003n\u0011!1\bA!f\u0001\n\u0003a\u0007\u0002C<\u0001\u0005#\u0005\u000b\u0011B7\t\u0011a\u0004!Q3A\u0005\u0002eD\u0001\" \u0001\u0003\u0012\u0003\u0006IA\u001f\u0005\u0006}\u0002!\ta \u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!!\f\u0001\t\u0003\ny\u0003\u0003\u0004\u00022\u0001!\t\u0005\u001c\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!!\u0016\u0001\t#\n9\u0006C\u0003>\u0001\u0011\u0005C\u000e\u0003\u0004\u0002t\u0001!\tE\u001a\u0005\b\u0003k\u0002A\u0011KA<\u0011%\ti\bAA\u0001\n\u0003\ty\bC\u0005\u0002\n\u0002\t\n\u0011\"\u0001\u0002\f\"I\u0011\u0011\u0015\u0001\u0012\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003O\u0003\u0011\u0013!C\u0001\u0003GC\u0011\"!+\u0001#\u0003%\t!a+\t\u0013\u0005=\u0006!!A\u0005B\u0005E\u0006\"CAa\u0001\u0005\u0005I\u0011AAb\u0011%\tY\rAA\u0001\n\u0003\ti\rC\u0005\u0002T\u0002\t\t\u0011\"\u0011\u0002V\"I\u00111\u001d\u0001\u0002\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003_\u0004\u0011\u0011!C!\u0003c<qAa\u0004*\u0011\u0003\u0011\tB\u0002\u0004)S!\u0005!1\u0003\u0005\u0007}\u0002\"\tA!\u0006\t\u000f\t]\u0001\u0005\"\u0001\u0003\u001a!I!\u0011\u0006\u0011\u0002\u0002\u0013\u0005%1\u0006\u0005\n\u0005k\u0001\u0013\u0013!C\u0001\u0003WC\u0011Ba\u000e!\u0003\u0003%\tI!\u000f\t\u0013\t\u001d\u0003%%A\u0005\u0002\u0005-\u0006\"\u0003B%A\u0005\u0005I\u0011\u0002B&\u0005%\u0019uN\u001c<feR$vN\u0003\u0002+W\u00051am\u001c:nCRT!\u0001L\u0017\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003]=\na!\\8tC&\u001c'B\u0001\u00192\u0003\u0011a\u0017MY:\u000b\u0005I\u001a\u0014A\u00033bi\u0006\u0014'/[2lg*\tA'A\u0002d_6\u001c\u0001aE\u0003\u0001o\u0019c&\r\u0005\u00029\t6\t\u0011H\u0003\u0002-u)\u00111\bP\u0001\tG\u0006$\u0018\r\\=ti*\u0011QHP\u0001\u0004gFd'BA A\u0003\u0015\u0019\b/\u0019:l\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015K$aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u001dKfB\u0001%X\u001d\tIeK\u0004\u0002K+:\u00111\n\u0016\b\u0003\u0019Ns!!\u0014*\u000f\u00059\u000bV\"A(\u000b\u0005A+\u0014A\u0002\u001fs_>$h(C\u0001D\u0013\t\t%)\u0003\u0002@\u0001&\u0011QHP\u0005\u0003wqJ!\u0001\f\u001e\n\u0005aK\u0014a\u00029bG.\fw-Z\u0005\u00035n\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002YsA\u0011Q\fY\u0007\u0002=*\tq,A\u0003tG\u0006d\u0017-\u0003\u0002b=\n9\u0001K]8ek\u000e$\bCA/d\u0013\t!gL\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006j]\u001e+w.\\3uef,\u0012a\u001a\t\u0003q!L!![\u001d\u0003\u0015\u0015C\bO]3tg&|g.A\u0006j]\u001e+w.\\3uef\u0004\u0013aC8vi\u0012\u000bG/\u0019+za\u0016,\u0012!\u001c\t\u0003]Jt!a\u001c9\u0011\u00059s\u0016BA9_\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Et\u0016\u0001D8vi\u0012\u000bG/\u0019+za\u0016\u0004\u0013aD4f_6,GO]=B!&s\u0015-\\3\u0002!\u001d,w.\\3uef\f\u0005+\u0013(b[\u0016\u0004\u0013\u0001\u00044v]\u000e$\u0018n\u001c8OC6,W#\u0001>\u0011\u0007u[X.\u0003\u0002}=\n1q\n\u001d;j_:\fQBZ;oGRLwN\u001c(b[\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0006\u0002\u0002\u0005\u0015\u0011qAA\u0005\u0003\u0017\u00012!a\u0001\u0001\u001b\u0005I\u0003\"B3\n\u0001\u00049\u0007\"B6\n\u0001\u0004i\u0007\"\u0002<\n\u0001\u0004i\u0007b\u0002=\n!\u0003\u0005\rA_\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/Q\u0014\u0001C1oC2L8/[:\n\t\u0005m\u0011Q\u0003\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\"A!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(q\nQ\u0001^=qKNLA!a\u000b\u0002&\tAA)\u0019;b)f\u0004X-\u0001\u0005u_N#(/\u001b8h)\u0005i\u0017A\u00039sKR$\u0018PT1nK\u0006aa.\u001e7m'\u00064W-\u0012<bYR!\u0011qGA\u001f!\ri\u0016\u0011H\u0005\u0004\u0003wq&aA!os\"9\u0011q\b\bA\u0002\u0005]\u0012!B5oaV$\u0018\u0001C7bW\u0016\u001cu\u000e]=\u0015\u0007\u001d\f)\u0005C\u0004\u0002H=\u0001\r!!\u0013\u0002\u000f9,w/\u0011:hgB)Q,a\u0013\u0002P%\u0019\u0011Q\n0\u0003\u000b\u0005\u0013(/Y=\u0011\u0007u\u000b\t&C\u0002\u0002Ty\u0013a!\u00118z%\u00164\u0017!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tI&!\u001a\u0002pA!\u00111LA1\u001b\t\tiFC\u0002\u0002`e\nqaY8eK\u001e,g.\u0003\u0003\u0002d\u0005u#\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u001d\u0004\u00031\u0001\u0002j\u0005\u00191\r\u001e=\u0011\t\u0005m\u00131N\u0005\u0005\u0003[\niF\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005E\u0004\u00031\u0001\u0002Z\u0005\u0011QM^\u0001\u0006G\"LG\u000eZ\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007\u001d\fI\b\u0003\u0004\u0002|M\u0001\raZ\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z))\t\t!!!\u0002\u0004\u0006\u0015\u0015q\u0011\u0005\bKR\u0001\n\u00111\u0001h\u0011\u001dYG\u0003%AA\u00025DqA\u001e\u000b\u0011\u0002\u0003\u0007Q\u000eC\u0004y)A\u0005\t\u0019\u0001>\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0012\u0016\u0004O\u0006=5FAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005me,\u0001\u0006b]:|G/\u0019;j_:LA!a(\u0002\u0016\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0015\u0016\u0004[\u0006=\u0015AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tiKK\u0002{\u0003\u001f\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000bA\u0001\\1oO*\u0011\u0011QX\u0001\u0005U\u00064\u0018-C\u0002t\u0003o\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!2\u0011\u0007u\u000b9-C\u0002\u0002Jz\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u000e\u0002P\"I\u0011\u0011[\u000e\u0002\u0002\u0003\u0007\u0011QY\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0007CBAm\u0003?\f9$\u0004\u0002\u0002\\*\u0019\u0011Q\u001c0\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002b\u0006m'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a:\u0002nB\u0019Q,!;\n\u0007\u0005-hLA\u0004C_>dW-\u00198\t\u0013\u0005EW$!AA\u0002\u0005]\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002h\u0006M\b\"CAi=\u0005\u0005\t\u0019AA\u001cQ=\u0001\u0011q_A\u007f\u0003\u007f\u0014\u0019A!\u0002\u0003\n\t-\u0001c\u0001\u001d\u0002z&\u0019\u00111`\u001d\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!\u0011A\u0001E?\u001a+fjQ0)Kb\u0004(/\r\u0017!I\u0006$\u0018\rV=qK&\u0002S\u0006I\"p]Z,'\u000f^:!Kb\u0004(/\r\u0011u_\u0002\"\b.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u0002\"\u0017\r^1!if\u0004XML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qA\u0001\u0002\u0010)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013\r\f\u0011(Q\u0016Dx%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\u0002\u0004\u0007\r\u00192aA*d)\u0011\u0018/]A\u0002\u0014II?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005d\u0003eJ<li\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003E\t)P\u0019f;uJ\u0014\u0011)Q9rc&K\u0015#\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B\u0007\u0003\r\td\u0006M\u0001\n\u0007>tg/\u001a:u)>\u00042!a\u0001!'\u0011\u0001\u0013q\n2\u0015\u0005\tE\u0011A\u0006:fO&\u001cHO]=FqB\u0014Xm]:j_:LeNZ8\u0015\r\tm!\u0011\u0005B\u0013!\rA$QD\u0005\u0004\u0005?I$AD#yaJ,7o]5p]&sgm\u001c\u0005\u0007\u0005G\u0011\u0003\u0019\u0001>\u0002\u0005\u0011\u0014\u0007B\u0002B\u0014E\u0001\u0007Q.\u0001\u0003oC6,\u0017!B1qa2LHCCA\u0001\u0005[\u0011yC!\r\u00034!)Qm\ta\u0001O\")1n\ta\u0001[\")ao\ta\u0001[\"9\u0001p\tI\u0001\u0002\u0004Q\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!1\bB\"!\u0011i6P!\u0010\u0011\u000fu\u0013ydZ7nu&\u0019!\u0011\t0\u0003\rQ+\b\u000f\\35\u0011%\u0011)%JA\u0001\u0002\u0004\t\t!A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0014\u0011\t\u0005U&qJ\u0005\u0005\u0005#\n9L\u0001\u0004PE*,7\r\u001e")
public class ConvertTo
extends UnaryExpression
implements package.NullIntolerant,
scala.Serializable {
    private final Expression inGeometry;
    private final String outDataType;
    private final String geometryAPIName;
    private final Option<String> functionName;

    public static Option<String> $lessinit$greater$default$4() {
        return ConvertTo$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, String, String, Option<String>>> unapply(ConvertTo convertTo) {
        return ConvertTo$.MODULE$.unapply(convertTo);
    }

    public static Option<String> apply$default$4() {
        return ConvertTo$.MODULE$.apply$default$4();
    }

    public static ExpressionInfo registryExpressionInfo(Option<String> option, String string) {
        return ConvertTo$.MODULE$.registryExpressionInfo(option, string);
    }

    public Expression inGeometry() {
        return this.inGeometry;
    }

    public String outDataType() {
        return this.outDataType;
    }

    public String geometryAPIName() {
        return this.geometryAPIName;
    }

    public Option<String> functionName() {
        return this.functionName;
    }

    public TypeCheckResult checkInputDataTypes() {
        Seq inputTypes = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{BinaryType$.MODULE$, StringType$.MODULE$, package$.MODULE$.HexType(), package$.MODULE$.JSONType(), package$.MODULE$.InternalGeometryType()}));
        Seq outputDataTypes = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WKT", "WKB", "COORDS", "HEX", "GEOJSON", "JSONOBJECT"}));
        return inputTypes.contains(this.inGeometry().dataType()) && outputDataTypes.contains(this.outDataType().toUpperCase(Locale.ROOT)) ? TypeCheckResult.TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(24).append("Cannot convert from ").append(this.inGeometry().dataType().sql()).append(" to ").append(this.dataType()).toString());
    }

    public DataType dataType() {
        StringType$ stringType$;
        String string = this.outDataType().toUpperCase(Locale.ROOT);
        if ("WKT".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("WKB".equals(string)) {
            stringType$ = BinaryType$.MODULE$;
        } else if ("HEX".equals(string)) {
            stringType$ = package$.MODULE$.HexType();
        } else if ("COORDS".equals(string)) {
            stringType$ = package$.MODULE$.InternalGeometryType();
        } else if ("GEOJSON".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("JSONOBJECT".equals(string)) {
            stringType$ = package$.MODULE$.JSONType();
        } else {
            throw new Error(new StringBuilder(25).append("Data type not supported: ").append(this.outDataType()).toString());
        }
        return stringType$;
    }

    public String toString() {
        return new StringBuilder(14).append("convert_to(").append(this.inGeometry()).append(", ").append(this.outDataType()).append(")").toString();
    }

    public String prettyName() {
        return (String)this.functionName().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "convert_to");
    }

    public Object nullSafeEval(Object input) {
        Object object;
        String string = this.inGeometry().dataType().simpleString();
        String string2 = this.outDataType();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            object = input;
        } else {
            GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(this.geometryAPIName());
            MosaicGeometry geometry = geometryAPI.geometry(input, this.inGeometry().dataType());
            object = geometryAPI.serialize(geometry, this.outDataType());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Expression makeCopy(Object[] newArgs) {
        void var2_2;
        ConvertTo res = new ConvertTo((Expression)newArgs[0], this.outDataType(), this.geometryAPIName(), this.functionName());
        res.copyTagsFrom((TreeNode)this);
        return var2_2;
    }

    public ExprCode doGenCode(CodegenContext ctx2, ExprCode ev2) {
        GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(this.geometryAPIName());
        return ConvertToCodeGen$.MODULE$.doCodeGen(ctx2, ev2, (Function3<CodegenContext, ExprCode, Function1<String, String>, ExprCode>)(Function3<CodegenContext, ExprCode, Function1, ExprCode> & Serializable & scala.Serializable)(ctx, ev, f) -> this.nullSafeCodeGen((CodegenContext)ctx, (ExprCode)ev, (Function1)f), this.child().dataType(), this.outDataType().toUpperCase(Locale.ROOT), geometryAPI);
    }

    public String sql() {
        String childrenSQL = ((TraversableOnce)this.children().map((Function1<Expression, String> & Serializable & scala.Serializable)x$1 -> x$1.sql(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return new StringBuilder(2).append(this.prettyName()).append("(").append(childrenSQL).append(")").toString();
    }

    public Expression child() {
        return this.inGeometry();
    }

    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public ConvertTo copy(Expression inGeometry, String outDataType, String geometryAPIName, Option<String> functionName) {
        return new ConvertTo(inGeometry, outDataType, geometryAPIName, functionName);
    }

    public Expression copy$default$1() {
        return this.inGeometry();
    }

    public String copy$default$2() {
        return this.outDataType();
    }

    public String copy$default$3() {
        return this.geometryAPIName();
    }

    public Option<String> copy$default$4() {
        return this.functionName();
    }

    public String productPrefix() {
        return "ConvertTo";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.inGeometry();
                break;
            }
            case 1: {
                object = this.outDataType();
                break;
            }
            case 2: {
                object = this.geometryAPIName();
                break;
            }
            case 3: {
                object = this.functionName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)((Object)this));
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ConvertTo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ConvertTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        ConvertTo convertTo = (ConvertTo)x$1;
        Expression expression = this.inGeometry();
        Expression expression2 = convertTo.inGeometry();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        String string = this.outDataType();
        String string2 = convertTo.outDataType();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.geometryAPIName();
        String string4 = convertTo.geometryAPIName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<String> option = this.functionName();
        Option<String> option2 = convertTo.functionName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!convertTo.canEqual(this)) return false;
        return true;
    }

    public ConvertTo(Expression inGeometry, String outDataType, String geometryAPIName, Option<String> functionName) {
        this.inGeometry = inGeometry;
        this.outDataType = outDataType;
        this.geometryAPIName = geometryAPIName;
        this.functionName = functionName;
    }
}

