/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.raster;

import com.databricks.labs.mosaic.core.raster.MosaicRaster;
import com.databricks.labs.mosaic.core.raster.MosaicRasterBand;
import com.databricks.labs.mosaic.core.raster.MosaicRasterBandGDAL;
import com.databricks.labs.mosaic.core.raster.MosaicRasterGDAL$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Hashtable;
import java.util.Vector;
import org.gdal.gdal.Band;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;
import org.gdal.osr.SpatialReference;
import org.locationtech.proj4j.CRSFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.Tuple2$mcII$sp;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001\u0002\u00192\u0001zB\u0001B\r\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t-\u0002\u0011\t\u0012)A\u0005\u001b\"Aq\u000b\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005e\u0001\tE\t\u0015!\u0003Z\u0011!)\u0007A!f\u0001\n\u00031\u0007\u0002\u00036\u0001\u0005#\u0005\u000b\u0011B4\t\u000b-\u0004A\u0011\u00017\t\u000fE\u0004!\u0019!C\u0001e\"11\u0010\u0001Q\u0001\nMDQ\u0001 \u0001\u0005BuDa!a\u0001\u0001\t\u0003j\bbBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\u0007\u0003\u001f\u0001A\u0011\t-\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u0011q\u0004\u0001\u0005B\u0005\u001d\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003{\u0001A\u0011IA\u0004\u0011\u001d\ty\u0004\u0001C!\u0003\u000fAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002B\u0001!\t!a\u0013\t\r\u0005U\u0003\u0001\"\u0011M\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005e\u0005\u0001\"\u0011\u0002\u001c\"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0011Q\u0016\u0005\n\u0003k\u0003\u0011\u0013!C\u0001\u0003oC\u0011\"!4\u0001#\u0003%\t!a4\t\u0013\u0005M\u0007!%A\u0005\u0002\u0005U\u0007\"CAm\u0001\u0005\u0005I\u0011IAn\u0011%\tY\u000fAA\u0001\n\u0003\t9\u0001C\u0005\u0002n\u0002\t\t\u0011\"\u0001\u0002p\"I\u0011Q\u001f\u0001\u0002\u0002\u0013\u0005\u0013q\u001f\u0005\n\u0005\u000b\u0001\u0011\u0011!C\u0001\u0005\u000fA\u0011B!\u0005\u0001\u0003\u0003%\tEa\u0005\t\u0013\tU\u0001!!A\u0005B\t]\u0001\"\u0003B\r\u0001\u0005\u0005I\u0011\tB\u000e\u000f\u001d\u0011y\"\rE\u0001\u0005C1a\u0001M\u0019\t\u0002\t\r\u0002BB6(\t\u0003\u0011\t\u0004C\u0004\u00034\u001d\"\tA!\u000e\t\u000f\t}r\u0005\"\u0011\u0003B!9!qI\u0014\u0005B\t%\u0003b\u0002B)O\u0011\u0005#1\u000b\u0005\b\u0005O:C\u0011\tB5\u0011%\u00119hJA\u0001\n\u0003\u0013I\bC\u0005\u0003\f\u001e\n\t\u0011\"\u0003\u0003\u000e\n\u0001Rj\\:bS\u000e\u0014\u0016m\u001d;fe\u001e#\u0015\t\u0014\u0006\u0003eM\naA]1ti\u0016\u0014(B\u0001\u001b6\u0003\u0011\u0019wN]3\u000b\u0005Y:\u0014AB7pg\u0006L7M\u0003\u00029s\u0005!A.\u00192t\u0015\tQ4(\u0001\u0006eCR\f'M]5dWNT\u0011\u0001P\u0001\u0004G>l7\u0001A\n\u0005\u0001}\u001a\u0015\n\u0005\u0002A\u00036\t\u0011'\u0003\u0002Cc\taQj\\:bS\u000e\u0014\u0016m\u001d;feB\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n9\u0001K]8ek\u000e$\bC\u0001#K\u0013\tYUI\u0001\u0007TKJL\u0017\r\\5{C\ndW-F\u0001N!\tqE+D\u0001P\u0015\t\u0001\u0016+\u0001\u0003hI\u0006d'B\u0001)S\u0015\u0005\u0019\u0016aA8sO&\u0011Qk\u0014\u0002\b\t\u0006$\u0018m]3u\u0003\u001d\u0011\u0018m\u001d;fe\u0002\nA\u0001]1uQV\t\u0011\f\u0005\u0002[C:\u00111l\u0018\t\u00039\u0016k\u0011!\u0018\u0006\u0003=v\na\u0001\u0010:p_Rt\u0014B\u00011F\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001,\u0015!\u00029bi\"\u0004\u0013aB7f[NK'0Z\u000b\u0002OB\u0011A\t[\u0005\u0003S\u0016\u0013A\u0001T8oO\u0006AQ.Z7TSj,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005[:|\u0007\u000f\u0005\u0002A\u0001!)!g\u0002a\u0001\u001b\")qk\u0002a\u00013\")Qm\u0002a\u0001O\u0006Q1M]:GC\u000e$xN]=\u0016\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\rA\u0014xN\u001b\u001bk\u0015\tA(+\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007.\u0003\u0002{k\nQ1IU*GC\u000e$xN]=\u0002\u0017\r\u00148OR1di>\u0014\u0018\u0010I\u0001\t[\u0016$\u0018\rZ1uCV\ta\u0010\u0005\u0003[\u007ffK\u0016bAA\u0001G\n\u0019Q*\u00199\u0002\u0017M,(\rZ1uCN,Go]\u0001\u0005'JKE)\u0006\u0002\u0002\nA\u0019A)a\u0003\n\u0007\u00055QIA\u0002J]R\f1\u0002\u001d:pUR\u001aFO]5oO\u00069q-\u001a;CC:$G\u0003BA\u000b\u00037\u00012\u0001QA\f\u0013\r\tI\"\r\u0002\u0011\u001b>\u001c\u0018-[2SCN$XM\u001d\"b]\u0012Dq!!\b\u000f\u0001\u0004\tI!\u0001\u0004cC:$\u0017\nZ\u0001\t]Vl')\u00198eg\u00061Q\r\u001f;f]R,\"!!\n\u0011\r\u0005\u001d\u0012\u0011GA\u001c\u001d\u0011\tI#!\f\u000f\u0007q\u000bY#C\u0001G\u0013\r\ty#R\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019$!\u000e\u0003\u0007M+\u0017OC\u0002\u00020\u0015\u00032\u0001RA\u001d\u0013\r\tY$\u0012\u0002\u0007\t>,(\r\\3\u0002\u000ba\u001c\u0016N_3\u0002\u000be\u001c\u0016N_3\u0002\u001f\u001d,GoR3p)J\fgn\u001d4pe6,\"!!\u0012\u0011\u000b\u0011\u000b9%a\u000e\n\u0007\u0005%SIA\u0003BeJ\f\u0017\u0010\u0006\u0003\u0002F\u00055\u0003bBA\u0011)\u0001\u0007\u0011q\n\t\f\t\u0006E\u0013\u0011BA\u0005\u0003\u0013\tI!C\u0002\u0002T\u0015\u0013a\u0001V;qY\u0016$\u0014!C4fiJ\u000b7\u000f^3s\u0003)\u0019\b/\u0019;jC2\u0014VMZ\u000b\u0003\u00037\u0002B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003C\n\u0016aA8te&!\u0011QMA0\u0005A\u0019\u0006/\u0019;jC2\u0014VMZ3sK:\u001cW-A\u0004dY\u0016\fg.\u00169\u0015\u0005\u0005-\u0004c\u0001#\u0002n%\u0019\u0011qN#\u0003\tUs\u0017\u000e^\u0001\u000fiJ\fgn\u001d4pe6\u0014\u0015M\u001c3t+\u0011\t)(! \u0015\t\u0005]\u0014q\u0012\t\u0007\u0003O\t\t$!\u001f\u0011\t\u0005m\u0014Q\u0010\u0007\u0001\t\u001d\ty\b\u0007b\u0001\u0003\u0003\u0013\u0011\u0001V\t\u0005\u0003\u0007\u000bI\tE\u0002E\u0003\u000bK1!a\"F\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001RAF\u0013\r\ti)\u0012\u0002\u0004\u0003:L\bbBAI1\u0001\u0007\u00111S\u0001\u0002MB9A)!&\u0002\u0016\u0005e\u0014bAAL\u000b\nIa)\u001e8di&|g.M\u0001\u000fg\u00064Xm\u00115fG.\u0004x.\u001b8u)%I\u0016QTAQ\u0003K\u000b9\u000b\u0003\u0004\u0002 f\u0001\r!W\u0001\bgR\fw-Z%e\u0011\u0019\t\u0019+\u0007a\u0001O\u0006A!/Y:uKJLE\rC\u0004\u0002\"e\u0001\r!a\u0014\t\r\u0005%\u0016\u00041\u0001Z\u00039\u0019\u0007.Z2la>Lg\u000e\u001e)bi\"\fAaY8qsR9Q.a,\u00022\u0006M\u0006b\u0002\u001a\u001b!\u0003\u0005\r!\u0014\u0005\b/j\u0001\n\u00111\u0001Z\u0011\u001d)'\u0004%AA\u0002\u001d\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002:*\u001aQ*a/,\u0005\u0005u\u0006\u0003BA`\u0003\u0013l!!!1\u000b\t\u0005\r\u0017QY\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a2F\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\f\tMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002R*\u001a\u0011,a/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u001b\u0016\u0004O\u0006m\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002^B!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018\u0001\u00027b]\u001eT!!a:\u0002\t)\fg/Y\u0005\u0004E\u0006\u0005\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0013\u000b\t\u0010C\u0005\u0002t\u0002\n\t\u00111\u0001\u0002\n\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!?\u0011\r\u0005m(\u0011AAE\u001b\t\tiPC\u0002\u0002\u0000\u0016\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019!!@\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u0013\u0011y\u0001E\u0002E\u0005\u0017I1A!\u0004F\u0005\u001d\u0011un\u001c7fC:D\u0011\"a=#\u0003\u0003\u0005\r!!#\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0003\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!8\u0002\r\u0015\fX/\u00197t)\u0011\u0011IA!\b\t\u0013\u0005MX%!AA\u0002\u0005%\u0015\u0001E'pg\u0006L7MU1ti\u0016\u0014x\tR!M!\t\u0001ue\u0005\u0004(\u0005K\u0011Y#\u0013\t\u0004\t\n\u001d\u0012b\u0001B\u0015\u000b\n1\u0011I\\=SK\u001a\u00042\u0001\u0011B\u0017\u0013\r\u0011y#\r\u0002\r%\u0006\u001cH/\u001a:SK\u0006$WM\u001d\u000b\u0003\u0005C\tQ!\u00199qYf$r!\u001cB\u001c\u0005w\u0011i\u0004\u0003\u0004\u0003:%\u0002\r!T\u0001\bI\u0006$\u0018m]3u\u0011\u00159\u0016\u00061\u0001Z\u0011\u0015)\u0017\u00061\u0001h\u0003)\u0011X-\u00193SCN$XM\u001d\u000b\u0004\u007f\t\r\u0003B\u0002B#U\u0001\u0007\u0011,\u0001\u0004j]B\u000bG\u000f[\u0001\te\u0016\fGMQ1oIR1\u0011Q\u0003B&\u0005\u001bBQaV\u0016A\u0002eCqAa\u0014,\u0001\u0004\tI!A\u0005cC:$\u0017J\u001c3fq\u0006aAo\\,pe2$7i\\8sIRA!Q\u000bB.\u0005?\u0012\u0019\u0007E\u0004E\u0005/\n9$a\u000e\n\u0007\teSI\u0001\u0004UkBdWM\r\u0005\b\u0005;b\u0003\u0019AA\u0013\u000319Wm\u001c+sC:\u001chm\u001c:n\u0011\u001d\u0011\t\u0007\fa\u0001\u0003\u0013\t\u0011\u0001\u001f\u0005\b\u0005Kb\u0003\u0019AA\u0005\u0003\u0005I\u0018A\u00044s_6<vN\u001d7e\u0007>|'\u000f\u001a\u000b\t\u0005W\u0012iGa\u001c\u0003tA9AIa\u0016\u0002\n\u0005%\u0001b\u0002B/[\u0001\u0007\u0011Q\u0005\u0005\b\u0005cj\u0003\u0019AA\u001c\u0003\u0011Ax)Z8\t\u000f\tUT\u00061\u0001\u00028\u0005!\u0011pR3p\u0003\u001d)h.\u00199qYf$BAa\u001f\u0003\bB)AI! \u0003\u0002&\u0019!qP#\u0003\r=\u0003H/[8o!\u0019!%1Q'ZO&\u0019!QQ#\u0003\rQ+\b\u000f\\34\u0011!\u0011IILA\u0001\u0002\u0004i\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\t\u0005\u0003\u0002`\nE\u0015\u0002\u0002BJ\u0003C\u0014aa\u00142kK\u000e$\b")
public class MosaicRasterGDAL
extends MosaicRaster
implements Product {
    private final Dataset raster;
    private final String path;
    private final long memSize;
    private final CRSFactory crsFactory;

    public static Option<Tuple3<Dataset, String, Object>> unapply(MosaicRasterGDAL mosaicRasterGDAL) {
        return MosaicRasterGDAL$.MODULE$.unapply(mosaicRasterGDAL);
    }

    public static Tuple2<Object, Object> fromWorldCoord(Seq<Object> seq, double d, double d2) {
        return MosaicRasterGDAL$.MODULE$.fromWorldCoord(seq, d, d2);
    }

    public static Tuple2<Object, Object> toWorldCoord(Seq<Object> seq, int n, int n2) {
        return MosaicRasterGDAL$.MODULE$.toWorldCoord(seq, n, n2);
    }

    public static MosaicRasterBand readBand(String string, int n) {
        return MosaicRasterGDAL$.MODULE$.readBand(string, n);
    }

    public static MosaicRaster readRaster(String string) {
        return MosaicRasterGDAL$.MODULE$.readRaster(string);
    }

    public static MosaicRasterGDAL apply(Dataset dataset, String string, long l) {
        return MosaicRasterGDAL$.MODULE$.apply(dataset, string, l);
    }

    public Dataset raster() {
        return this.raster;
    }

    public String path() {
        return this.path;
    }

    public long memSize() {
        return this.memSize;
    }

    public CRSFactory crsFactory() {
        return this.crsFactory;
    }

    @Override
    public Map<String, String> metadata() {
        return (Map)Option$.MODULE$.apply(this.raster().GetMetadata_Dict()).map((Function1<Hashtable, Map> & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.dictionaryAsScalaMapConverter(x$1).asScala()).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0<Map> & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Map<String, String> subdatasets() {
        return (Map)Option$.MODULE$.apply(this.raster().GetMetadata_List("SUBDATASETS")).map((Function1<Vector, Map> & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps(x$2.toArray())).map((Function1<Object, String> & Serializable & scala.Serializable)x$3 -> x$3.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).grouped(2).map((Function1<String[], Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            String[] stringArray = x0$1;
            Option option = Array$.MODULE$.unapplySeq(stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                throw new MatchError(stringArray);
            }
            String p = (String)((SeqLike)option.get()).apply(0);
            String d = (String)((SeqLike)option.get()).apply(1);
            Tuple2<Object, Object> tuple2 = new Tuple2<Object, Object>(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])p.split("="))).last(), new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])d.split("="))).last());
            return tuple2;
        }).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0<Map> & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public int SRID() {
        return new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])((String)Try$.MODULE$.apply((Function0<String> & Serializable & scala.Serializable)() -> this.crsFactory().readEpsgFromParameters(this.proj4String())).filter((Function1<String, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(MosaicRasterGDAL.$anonfun$SRID$2(x$4))).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "EPSG:0")).split(":"))).last())).toInt();
    }

    @Override
    public String proj4String() {
        return (String)Try$.MODULE$.apply((Function0<String> & Serializable & scala.Serializable)() -> this.raster().GetSpatialRef().ExportToProj4()).filter((Function1<String, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(MosaicRasterGDAL.$anonfun$proj4String$2(x$5))).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "");
    }

    @Override
    public MosaicRasterBand getBand(int bandId) {
        if (bandId <= 0 || this.numBands() < bandId) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new MosaicRasterBandGDAL(this.raster().GetRasterBand(bandId), bandId);
    }

    @Override
    public int numBands() {
        return this.raster().GetRasterCount();
    }

    @Override
    public Seq<Object> extent() {
        double minx = this.getGeoTransform()[0];
        double maxy = this.getGeoTransform()[3];
        double maxx = minx + this.getGeoTransform()[1] * (double)this.xSize();
        double miny = maxy + this.getGeoTransform()[5] * (double)this.ySize();
        return (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{minx, miny, maxx, maxy}));
    }

    @Override
    public int xSize() {
        return this.raster().GetRasterXSize();
    }

    @Override
    public int ySize() {
        return this.raster().GetRasterYSize();
    }

    public double[] getGeoTransform() {
        return this.raster().GetGeoTransform();
    }

    public double[] getGeoTransform(Tuple4<Object, Object, Object, Object> extent) {
        double[] gt = this.getGeoTransform();
        Tuple4<Object, Object, Object, Object> tuple4 = extent;
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int xmin = BoxesRunTime.unboxToInt(tuple4._1());
        int ymax = BoxesRunTime.unboxToInt(tuple4._4());
        Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(xmin, ymax);
        Tuple2$mcII$sp tuple2$mcII$sp2 = tuple2$mcII$sp;
        int xmin2 = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
        int ymax2 = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
        Tuple2<Object, Object> tuple2 = MosaicRasterGDAL$.MODULE$.toWorldCoord(Predef$.MODULE$.wrapDoubleArray(gt), xmin2, ymax2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double xUpperLeft = tuple2._1$mcD$sp();
        double yUpperLeft = tuple2._2$mcD$sp();
        Tuple2$mcDD$sp tuple2$mcDD$sp = new Tuple2$mcDD$sp(xUpperLeft, yUpperLeft);
        Tuple2$mcDD$sp tuple2$mcDD$sp2 = tuple2$mcDD$sp;
        double xUpperLeft2 = ((Tuple2)tuple2$mcDD$sp2)._1$mcD$sp();
        double yUpperLeft2 = ((Tuple2)tuple2$mcDD$sp2)._2$mcD$sp();
        return new double[]{xUpperLeft2, gt[1], gt[2], yUpperLeft2, gt[4], gt[5]};
    }

    @Override
    public Dataset getRaster() {
        return this.raster();
    }

    public SpatialReference spatialRef() {
        return this.raster().GetSpatialRef();
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public <T> Seq<T> transformBands(Function1<MosaicRasterBand, T> f) {
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numBands()).map((Function1<Object, Object> & Serializable & scala.Serializable)i -> f.apply(this.getBand(BoxesRunTime.unboxToInt(i))), IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Override
    public String saveCheckpoint(String stageId, long rasterId, Tuple4<Object, Object, Object, Object> extent, String checkpointPath) {
        String tmpDir = Files.createTempDirectory(new StringBuilder(7).append("mosaic_").append(stageId).toString(), new FileAttribute[0]).toFile().getAbsolutePath();
        String outPath = new StringBuilder(12).append(tmpDir).append("/raster_").append(((Object)BoxesRunTime.boxToLong(rasterId)).toString().replace("-", "_")).append(".tif").toString();
        Files.createDirectories(Paths.get(outPath, new String[0]).getParent(), new FileAttribute[0]);
        Tuple4<Object, Object, Object, Object> tuple4 = extent;
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int xmin = BoxesRunTime.unboxToInt(tuple4._1());
        int ymin = BoxesRunTime.unboxToInt(tuple4._2());
        int xmax = BoxesRunTime.unboxToInt(tuple4._3());
        int ymax = BoxesRunTime.unboxToInt(tuple4._4());
        Tuple4<Integer, Integer, Integer, Integer> tuple42 = new Tuple4<Integer, Integer, Integer, Integer>(BoxesRunTime.boxToInteger(xmin), BoxesRunTime.boxToInteger(ymin), BoxesRunTime.boxToInteger(xmax), BoxesRunTime.boxToInteger(ymax));
        Tuple4<Integer, Integer, Integer, Integer> tuple43 = tuple42;
        int xmin2 = BoxesRunTime.unboxToInt(tuple43._1());
        int ymin2 = BoxesRunTime.unboxToInt(tuple43._2());
        int xmax2 = BoxesRunTime.unboxToInt(tuple43._3());
        int ymax2 = BoxesRunTime.unboxToInt(tuple43._4());
        int xSize = xmax2 - xmin2;
        int ySize = ymax2 - ymin2;
        Dataset outputDs = gdal.GetDriverByName("GTiff").Create(outPath, xSize, ySize, this.numBands(), gdalconstConstants.GDT_Float64);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numBands()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            MosaicRasterBand band = this.getBand(i);
            double[] data = band.values(xmin2, ymin2, xSize, ySize);
            double[] maskData = band.maskValues(xmin2, ymin2, xSize, ySize);
            double noDataValue = band.noDataValue();
            Band outBand = outputDs.GetRasterBand(i);
            Band maskBand = outBand.GetMaskBand();
            outBand.SetNoDataValue(noDataValue);
            outBand.WriteRaster(0, 0, xSize, ySize, data);
            maskBand.WriteRaster(0, 0, xSize, ySize, maskData);
            outBand.FlushCache();
            maskBand.FlushCache();
        });
        outputDs.SetGeoTransform(this.getGeoTransform(extent));
        outputDs.FlushCache();
        Path destinationPath = Paths.get(checkpointPath.replace("dbfs:/", "/dbfs/"), new StringBuilder(11).append("raster_").append(rasterId).append(".tif").toString());
        Files.createDirectories(destinationPath, new FileAttribute[0]);
        Files.copy(Paths.get(outPath, new String[0]), destinationPath, StandardCopyOption.REPLACE_EXISTING);
        Files.delete(Paths.get(outPath, new String[0]));
        return ((Object)destinationPath.toAbsolutePath()).toString().replace("dbfs:/", "/dbfs/");
    }

    public MosaicRasterGDAL copy(Dataset raster, String path, long memSize) {
        return new MosaicRasterGDAL(raster, path, memSize);
    }

    public Dataset copy$default$1() {
        return this.raster();
    }

    public String copy$default$2() {
        return this.path();
    }

    public long copy$default$3() {
        return this.memSize();
    }

    @Override
    public String productPrefix() {
        return "MosaicRasterGDAL";
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.raster();
                break;
            }
            case 1: {
                object = this.path();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToLong(this.memSize());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof MosaicRasterGDAL;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, Statics.anyHash(this.raster()));
        n = Statics.mix(n, Statics.anyHash(this.path()));
        n = Statics.mix(n, Statics.longHash(this.memSize()));
        return Statics.finalizeHash(n, 3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MosaicRasterGDAL)) return false;
        boolean bl = true;
        if (!bl) return false;
        MosaicRasterGDAL mosaicRasterGDAL = (MosaicRasterGDAL)x$1;
        Dataset dataset = this.raster();
        Dataset dataset2 = mosaicRasterGDAL.raster();
        if (dataset == null) {
            if (dataset2 != null) {
                return false;
            }
        } else if (!dataset.equals(dataset2)) return false;
        String string = this.path();
        String string2 = mosaicRasterGDAL.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.memSize() != mosaicRasterGDAL.memSize()) return false;
        if (!mosaicRasterGDAL.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$SRID$2(String x$4) {
        return x$4 != null;
    }

    public static final /* synthetic */ boolean $anonfun$proj4String$2(String x$5) {
        return x$5 != null;
    }

    public MosaicRasterGDAL(Dataset raster, String path, long memSize) {
        this.raster = raster;
        this.path = path;
        this.memSize = memSize;
        super(path, memSize);
        Product.$init$(this);
        this.crsFactory = new CRSFactory();
    }
}

