/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.raster;

import com.databricks.labs.mosaic.core.raster.MosaicRaster;
import com.databricks.labs.mosaic.core.raster.MosaicRasterBand;
import com.databricks.labs.mosaic.core.raster.MosaicRasterGDAL;
import com.databricks.labs.mosaic.core.raster.RasterReader;
import java.io.File;
import org.apache.spark.internal.Logging;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.Tuple2$mcII$sp;
import scala.Tuple3;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class MosaicRasterGDAL$
implements RasterReader,
Serializable {
    public static MosaicRasterGDAL$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new MosaicRasterGDAL$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public MosaicRasterGDAL apply(Dataset dataset, String path, long memSize) {
        return new MosaicRasterGDAL(dataset, path, memSize);
    }

    @Override
    public MosaicRaster readRaster(String inPath) {
        String path = inPath.replace("dbfs:/", "/dbfs/").replace("file:/", "/");
        Dataset dataset = gdal.Open(path, gdalconstConstants.GA_ReadOnly);
        long size = new File(path).length();
        return this.apply(dataset, path, size);
    }

    @Override
    public MosaicRasterBand readBand(String path, int bandIndex) {
        MosaicRaster raster = this.readRaster(path);
        return raster.getBand(bandIndex);
    }

    @Override
    public Tuple2<Object, Object> toWorldCoord(Seq<Object> geoTransform, int x, int y) {
        double Xp = BoxesRunTime.unboxToDouble(geoTransform.apply(false)) + (double)x * BoxesRunTime.unboxToDouble(geoTransform.apply(true)) + (double)y * BoxesRunTime.unboxToDouble(geoTransform.apply(2));
        double Yp = BoxesRunTime.unboxToDouble(geoTransform.apply(3)) + (double)x * BoxesRunTime.unboxToDouble(geoTransform.apply(4)) + (double)y * BoxesRunTime.unboxToDouble(geoTransform.apply(5));
        return new Tuple2$mcDD$sp(Xp, Yp);
    }

    @Override
    public Tuple2<Object, Object> fromWorldCoord(Seq<Object> geoTransform, double xGeo, double yGeo) {
        int x = (int)((xGeo - BoxesRunTime.unboxToDouble(geoTransform.apply(false))) / BoxesRunTime.unboxToDouble(geoTransform.apply(true)));
        int y = (int)((yGeo - BoxesRunTime.unboxToDouble(geoTransform.apply(3))) / BoxesRunTime.unboxToDouble(geoTransform.apply(5)));
        return new Tuple2$mcII$sp(x, y);
    }

    public Option<Tuple3<Dataset, String, Object>> unapply(MosaicRasterGDAL x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Dataset, String, Long>>(new Tuple3<Dataset, String, Long>(x$0.raster(), x$0.path(), BoxesRunTime.boxToLong(x$0.memSize())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MosaicRasterGDAL$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

