/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.polygon;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryESRI$;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineString;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineStringESRI;
import com.databricks.labs.mosaic.core.geometry.multipolygon.MosaicMultiPolygonESRI$;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointESRI;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointESRI$;
import com.databricks.labs.mosaic.core.geometry.polygon.MosaicPolygonESRI;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalCoord;
import com.databricks.labs.mosaic.core.types.model.InternalCoord$;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import com.esri.core.geometry.ogc.OGCPolygon;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.locationtech.jts.geom.Coordinate;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class MosaicPolygonESRI$
implements GeometryReader,
scala.Serializable {
    public static MosaicPolygonESRI$ MODULE$;
    private final int defaultSpatialReferenceId;

    static {
        new MosaicPolygonESRI$();
    }

    @Override
    public int defaultSpatialReferenceId() {
        return this.defaultSpatialReferenceId;
    }

    @Override
    public void com$databricks$labs$mosaic$core$geometry$GeometryReader$_setter_$defaultSpatialReferenceId_$eq(int x$1) {
        this.defaultSpatialReferenceId = x$1;
    }

    public MosaicPolygonESRI apply(OGCGeometry ogcGeometry) {
        return new MosaicPolygonESRI((OGCPolygon)ogcGeometry);
    }

    public Seq<MosaicPoint> getPoints(OGCLineString lineString) {
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), lineString.numPoints()).map((Function1<Object, MosaicPointESRI> & Serializable & scala.Serializable)i -> MosaicPointESRI$.MODULE$.apply(lineString.pointN(BoxesRunTime.unboxToInt(i))), IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Override
    public MosaicGeometry fromInternal(InternalRow row) {
        InternalGeometry internalGeom = InternalGeometry$.MODULE$.apply(row);
        Polygon polygon = MosaicMultiPolygonESRI$.MODULE$.createPolygon(internalGeom.boundaries(), internalGeom.holes());
        SpatialReference spatialReference = internalGeom.srid() != 0 ? SpatialReference.create(internalGeom.srid()) : MosaicGeometryESRI$.MODULE$.defaultSpatialReference();
        return MosaicGeometryESRI$.MODULE$.apply(new OGCPolygon(polygon, spatialReference));
    }

    @Override
    public <T extends MosaicGeometry> MosaicPolygonESRI fromSeq(Seq<T> geomSeq, Enumeration.Value geomType) {
        OGCPolygon oGCPolygon;
        if (geomSeq.isEmpty()) {
            return this.apply(new OGCPolygon(new Polygon(), MosaicGeometryESRI$.MODULE$.defaultSpatialReference()));
        }
        SpatialReference spatialReference = SpatialReference.create(((MosaicGeometry)geomSeq.head()).getSpatialReference());
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(((MosaicGeometry)geomSeq.head()).getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            Seq extractedPoints = geomSeq.map((Function1<MosaicGeometry, MosaicPointESRI> & Serializable & scala.Serializable)x$5 -> (MosaicPointESRI)x$5, Seq$.MODULE$.canBuildFrom());
            InternalCoord[] exteriorRing = (InternalCoord[])((TraversableOnce)((TraversableLike)extractedPoints.map((Function1<MosaicPointESRI, Coordinate> & Serializable & scala.Serializable)x$6 -> x$6.coord(), Seq$.MODULE$.canBuildFrom())).map((Function1<Coordinate, InternalCoord> & Serializable & scala.Serializable)x$7 -> InternalCoord$.MODULE$.apply((Coordinate)x$7), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InternalCoord.class));
            Polygon polygon = MosaicMultiPolygonESRI$.MODULE$.createPolygon((InternalCoord[][])((Object[])new InternalCoord[][]{exteriorRing}), (InternalCoord[][][])((Object[])new InternalCoord[][][]{(InternalCoord[][])((Object[])new InternalCoord[][]{(InternalCoord[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.apply(InternalCoord.class))})}));
            oGCPolygon = new OGCPolygon(polygon, spatialReference);
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.LINESTRING();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                Seq extractedLines = geomSeq.map((Function1<MosaicGeometry, MosaicLineStringESRI> & Serializable & scala.Serializable)x$8 -> (MosaicLineStringESRI)x$8, Seq$.MODULE$.canBuildFrom());
                InternalCoord[] exteriorRing = (InternalCoord[])((TraversableOnce)((TraversableLike)((MosaicLineString)extractedLines.head()).asSeq().map((Function1<MosaicPoint, Coordinate> & Serializable & scala.Serializable)x$9 -> x$9.coord(), Seq$.MODULE$.canBuildFrom())).map((Function1<Coordinate, InternalCoord> & Serializable & scala.Serializable)x$10 -> InternalCoord$.MODULE$.apply((Coordinate)x$10), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InternalCoord.class));
                InternalCoord[][] holes = (InternalCoord[][])((TraversableOnce)((TraversableLike)extractedLines.tail()).map((Function1<MosaicLineStringESRI, InternalCoord[]> & Serializable & scala.Serializable)h -> (InternalCoord[])((TraversableOnce)((TraversableLike)h.asSeq().map((Function1<MosaicPoint, Coordinate> & Serializable & scala.Serializable)x$11 -> x$11.coord(), Seq$.MODULE$.canBuildFrom())).map((Function1<Coordinate, InternalCoord> & Serializable & scala.Serializable)x$12 -> InternalCoord$.MODULE$.apply((Coordinate)x$12), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InternalCoord.class)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(InternalCoord.class)));
                Polygon polygon = MosaicMultiPolygonESRI$.MODULE$.createPolygon((InternalCoord[][])((Object[])new InternalCoord[][]{exteriorRing}), (InternalCoord[][][])((Object[])new InternalCoord[][][]{holes}));
                oGCPolygon = new OGCPolygon(polygon, spatialReference);
            } else {
                if (value != null) {
                    Enumeration.Value value6 = value;
                    throw new UnsupportedOperationException(new StringBuilder(57).append("MosaicGeometry.fromSeq() cannot create ").append(geomType.toString()).append(" from ").append(value6.toString()).append(" geometries.").toString());
                }
                throw new MatchError(value);
            }
        }
        OGCPolygon newGeom = oGCPolygon;
        return this.apply(newGeom);
    }

    public <T extends MosaicGeometry> Enumeration.Value fromSeq$default$2() {
        return GeometryTypeEnum$.MODULE$.POLYGON();
    }

    @Override
    public MosaicGeometry fromWKB(byte[] wkb) {
        return MosaicGeometryESRI$.MODULE$.fromWKB(wkb);
    }

    @Override
    public MosaicGeometry fromWKT(String wkt) {
        return MosaicGeometryESRI$.MODULE$.fromWKT(wkt);
    }

    @Override
    public MosaicGeometry fromJSON(String geoJson) {
        return MosaicGeometryESRI$.MODULE$.fromJSON(geoJson);
    }

    @Override
    public MosaicGeometry fromHEX(String hex) {
        return MosaicGeometryESRI$.MODULE$.fromHEX(hex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MosaicPolygonESRI$() {
        MODULE$ = this;
        GeometryReader.$init$(this);
    }
}

