/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.multipolygon;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryESRI$;
import com.databricks.labs.mosaic.core.geometry.multilinestring.MosaicMultiLineStringESRI$;
import com.databricks.labs.mosaic.core.geometry.multipolygon.MosaicMultiPolygonESRI;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalCoord;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCMultiPolygon;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class MosaicMultiPolygonESRI$
implements GeometryReader,
scala.Serializable {
    public static MosaicMultiPolygonESRI$ MODULE$;
    private final int defaultSpatialReferenceId;

    static {
        new MosaicMultiPolygonESRI$();
    }

    @Override
    public int defaultSpatialReferenceId() {
        return this.defaultSpatialReferenceId;
    }

    @Override
    public void com$databricks$labs$mosaic$core$geometry$GeometryReader$_setter_$defaultSpatialReferenceId_$eq(int x$1) {
        this.defaultSpatialReferenceId = x$1;
    }

    @Override
    public MosaicGeometry fromInternal(InternalRow row) {
        InternalGeometry internalGeom = InternalGeometry$.MODULE$.apply(row);
        Polygon polygon = this.createPolygon(internalGeom.boundaries(), internalGeom.holes());
        SpatialReference spatialReference = internalGeom.srid() != 0 ? SpatialReference.create(internalGeom.srid()) : MosaicGeometryESRI$.MODULE$.defaultSpatialReference();
        OGCMultiPolygon ogcMultiLineString = new OGCMultiPolygon(polygon, spatialReference);
        return this.apply(ogcMultiLineString);
    }

    public Polygon createPolygon(InternalCoord[][] shellCollection, InternalCoord[][][] holesCollection) {
        Polyline boundariesPath = MosaicMultiLineStringESRI$.MODULE$.createPolyline(shellCollection, true);
        Polyline[] holesPathsCollection = (Polyline[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])holesCollection)).map((Function1<InternalCoord[][], Polyline> & Serializable & scala.Serializable)x$7 -> MosaicMultiLineStringESRI$.MODULE$.createPolyline((InternalCoord[][])x$7, true), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Polyline.class)));
        Polygon polygon = new Polygon();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), boundariesPath.getPathCount()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            Polygon tmpPolygon = new Polygon();
            tmpPolygon.addPath(boundariesPath, i, true);
            if (tmpPolygon.calculateArea2D() < 0.0) {
                polygon.addPath(boundariesPath, i, false);
            } else {
                polygon.addPath(boundariesPath, i, true);
            }
        });
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])holesPathsCollection)).foreach((Function1<Polyline, Object> & Serializable & scala.Serializable)holesPath -> {
            MosaicMultiPolygonESRI$.$anonfun$createPolygon$3(polygon, holesPath);
            return BoxedUnit.UNIT;
        });
        return polygon;
    }

    public MosaicMultiPolygonESRI apply(OGCGeometry multiPolygon) {
        return new MosaicMultiPolygonESRI((OGCMultiPolygon)multiPolygon);
    }

    @Override
    public <T extends MosaicGeometry> MosaicMultiPolygonESRI fromSeq(Seq<T> geomSeq, Enumeration.Value geomType) {
        if (geomSeq.isEmpty()) {
            return this.apply(new OGCMultiPolygon(MosaicGeometryESRI$.MODULE$.defaultSpatialReference()));
        }
        SpatialReference spatialReference = SpatialReference.create(((MosaicGeometry)geomSeq.head()).getSpatialReference());
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(((MosaicGeometry)geomSeq.head()).getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POLYGON();
        Enumeration.Value value3 = value;
        if (value2 != null ? !((Object)value2).equals(value3) : value3 != null) {
            if (value != null) {
                Enumeration.Value value4 = value;
                throw new UnsupportedOperationException(new StringBuilder(57).append("MosaicGeometry.fromSeq() cannot create ").append(geomType.toString()).append(" from ").append(value4.toString()).append(" geometries.").toString());
            }
            throw new MatchError(value);
        }
        Seq extractedPolys = geomSeq.map((Function1<MosaicGeometry, InternalGeometry> & Serializable & scala.Serializable)x$8 -> x$8.toInternal(), Seq$.MODULE$.canBuildFrom());
        Polygon newMultiPolygon = this.createPolygon((InternalCoord[][])((TraversableOnce)extractedPolys.flatMap((Function1<InternalGeometry, Object> & Serializable & scala.Serializable)x$9 -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])x$9.boundaries())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(InternalCoord.class))), (InternalCoord[][][])((TraversableOnce)extractedPolys.flatMap((Function1<InternalGeometry, Object> & Serializable & scala.Serializable)x$10 -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])x$10.holes())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(InternalCoord.class)))));
        OGCMultiPolygon oGCMultiPolygon = new OGCMultiPolygon(newMultiPolygon, spatialReference);
        OGCMultiPolygon newGeom = oGCMultiPolygon;
        return this.apply(newGeom);
    }

    public <T extends MosaicGeometry> Enumeration.Value fromSeq$default$2() {
        return GeometryTypeEnum$.MODULE$.MULTIPOLYGON();
    }

    @Override
    public MosaicGeometry fromWKB(byte[] wkb) {
        return MosaicGeometryESRI$.MODULE$.fromWKB(wkb);
    }

    @Override
    public MosaicGeometry fromWKT(String wkt) {
        return MosaicGeometryESRI$.MODULE$.fromWKT(wkt);
    }

    @Override
    public MosaicGeometry fromJSON(String geoJson) {
        return MosaicGeometryESRI$.MODULE$.fromJSON(geoJson);
    }

    @Override
    public MosaicGeometry fromHEX(String hex) {
        return MosaicGeometryESRI$.MODULE$.fromHEX(hex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$createPolygon$3(Polygon polygon$1, Polyline holesPath) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), holesPath.getPathCount()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            Polygon tmpPolygon = new Polygon();
            tmpPolygon.addPath(holesPath, i, true);
            if (tmpPolygon.calculateArea2D() < 0.0) {
                polygon$1.addPath(holesPath, i, true);
            } else {
                polygon$1.addPath(holesPath, i, false);
            }
        });
    }

    private MosaicMultiPolygonESRI$() {
        MODULE$ = this;
        GeometryReader.$init$(this);
    }
}

