/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.linestring;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryESRI$;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineStringESRI;
import com.databricks.labs.mosaic.core.geometry.multilinestring.MosaicMultiLineStringESRI$;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointESRI;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointESRI$;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalCoord;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class MosaicLineStringESRI$
implements GeometryReader,
scala.Serializable {
    public static MosaicLineStringESRI$ MODULE$;
    private final int defaultSpatialReferenceId;

    static {
        new MosaicLineStringESRI$();
    }

    @Override
    public int defaultSpatialReferenceId() {
        return this.defaultSpatialReferenceId;
    }

    @Override
    public void com$databricks$labs$mosaic$core$geometry$GeometryReader$_setter_$defaultSpatialReferenceId_$eq(int x$1) {
        this.defaultSpatialReferenceId = x$1;
    }

    public Seq<MosaicPoint> getPoints(OGCLineString lineString) {
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), lineString.numPoints()).map((Function1<Object, MosaicPointESRI> & Serializable & scala.Serializable)i -> MosaicPointESRI$.MODULE$.apply(lineString.pointN(BoxesRunTime.unboxToInt(i))), IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Override
    public MosaicGeometry fromInternal(InternalRow row) {
        InternalGeometry internalGeom = InternalGeometry$.MODULE$.apply(row);
        Polyline polyline = MosaicMultiLineStringESRI$.MODULE$.createPolyline(internalGeom.boundaries(), MosaicMultiLineStringESRI$.MODULE$.createPolyline$default$2());
        SpatialReference spatialReference = internalGeom.srid() != 0 ? SpatialReference.create(internalGeom.srid()) : MosaicGeometryESRI$.MODULE$.defaultSpatialReference();
        OGCLineString ogcLineString = new OGCLineString(polyline, 0, spatialReference);
        return this.apply(ogcLineString);
    }

    @Override
    public <T extends MosaicGeometry> MosaicLineStringESRI fromSeq(Seq<T> geomSeq, Enumeration.Value geomType) {
        if (geomSeq.isEmpty()) {
            return this.apply(new OGCLineString(new Polyline(), 0, MosaicGeometryESRI$.MODULE$.defaultSpatialReference()));
        }
        SpatialReference spatialReference = SpatialReference.create(((MosaicGeometry)geomSeq.head()).getSpatialReference());
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(((MosaicGeometry)geomSeq.head()).getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (value2 != null ? !((Object)value2).equals(value3) : value3 != null) {
            if (value != null) {
                Enumeration.Value value4;
                Enumeration.Value value5 = value4 = value;
                Enumeration.Value value6 = GeometryTypeEnum$.MODULE$.LINESTRING();
                if (!(value5 != null ? !((Object)value5).equals(value6) : value6 != null)) {
                    throw new Error(new StringBuilder(65).append("Joining a sequence of ").append(value4.toString()).append(" to create a ").append(geomType.toString()).append(" geometry is not yet supported").toString());
                }
            }
            if (value != null) {
                Enumeration.Value value7 = value;
                throw new UnsupportedOperationException(new StringBuilder(57).append("MosaicGeometry.fromSeq() cannot create ").append(geomType.toString()).append(" from ").append(value7.toString()).append(" geometries.").toString());
            }
            throw new MatchError(value);
        }
        Seq extractedPoints = geomSeq.map((Function1<MosaicGeometry, MosaicPointESRI> & Serializable & scala.Serializable)x$2 -> (MosaicPointESRI)x$2, Seq$.MODULE$.canBuildFrom());
        OGCLineString oGCLineString = new OGCLineString(MosaicMultiLineStringESRI$.MODULE$.createPolyline((InternalCoord[][])((Object[])new InternalCoord[][]{(InternalCoord[])((TraversableOnce)extractedPoints.map((Function1<MosaicPointESRI, InternalCoord> & Serializable & scala.Serializable)c -> new InternalCoord((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{c.coord().getX(), c.coord().getY()}))), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InternalCoord.class))}), true), 0, spatialReference);
        OGCLineString newGeom = oGCLineString;
        return this.apply(newGeom);
    }

    public <T extends MosaicGeometry> Enumeration.Value fromSeq$default$2() {
        return GeometryTypeEnum$.MODULE$.LINESTRING();
    }

    public MosaicLineStringESRI apply(OGCGeometry ogcGeometry) {
        return new MosaicLineStringESRI((OGCLineString)ogcGeometry);
    }

    @Override
    public MosaicGeometry fromWKB(byte[] wkb) {
        return MosaicGeometryESRI$.MODULE$.fromWKB(wkb);
    }

    @Override
    public MosaicGeometry fromWKT(String wkt) {
        return MosaicGeometryESRI$.MODULE$.fromWKT(wkt);
    }

    @Override
    public MosaicGeometry fromJSON(String geoJson) {
        return MosaicGeometryESRI$.MODULE$.fromJSON(geoJson);
    }

    @Override
    public MosaicGeometry fromHEX(String hex) {
        return MosaicGeometryESRI$.MODULE$.fromHEX(hex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MosaicLineStringESRI$() {
        MODULE$ = this;
        GeometryReader.$init$(this);
    }
}

