/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryESRI$;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointESRI$;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.esotericsoftware.kryo.Kryo;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCMultiLineString;
import com.esri.core.geometry.ogc.OGCMultiPoint;
import com.esri.core.geometry.ogc.OGCMultiPolygon;
import org.apache.spark.sql.catalyst.InternalRow;
import org.locationtech.jts.io.WKBWriter;
import scala.Enumeration;
import scala.MatchError;
import scala.Option;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tee!\u0002\u001c8\u0003\u0003!\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u000bi\u0003A\u0011A.\t\u000by\u0003A\u0011I0\t\u000b\r\u0004A\u0011\t3\t\u000b1\u0004A\u0011I7\t\u000b9\u0004A\u0011I8\t\u000bI\u0004A\u0011I:\t\u000bY\u0004A\u0011I<\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u0019\t\t\u0004\u0001C![\"9\u00111\u0007\u0001\u0005B\u0005U\u0002bBA\u001a\u0001\u0011%\u00111\b\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Bq!!\u0014\u0001\t\u0003\ny\u0005C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u0011q\f\u0001\u0005B\u0005e\u0001BBA1\u0001\u0011\u0005s\u000fC\u0004\u0002d\u0001!\t%!\u001a\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u0011q\r\u0001\u0005B\u00055\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\u0007\u0003\u000f\u0003A\u0011I0\t\r\u0005%\u0005\u0001\"\u0011n\u0011\u001d\t9\u0003\u0001C!\u0003\u0017Cq!a$\u0001\t\u0003\n\t\n\u0003\u0004\u0002\u0014\u0002!\t%\u001c\u0005\u0007\u0003+\u0003A\u0011I<\t\r\u0005]\u0005\u0001\"\u0011x\u0011\u0019\tI\n\u0001C!o\"9\u00111\u0014\u0001\u0005B\u0005u\u0005BBAV\u0001\u0011\u0005s\fC\u0004\u0002.\u0002!\t%a,\b\u000f\u0005mv\u0007#\u0001\u0002>\u001a1ag\u000eE\u0001\u0003\u007fCaAW\u0014\u0005\u0002\u00055\u0007\"CAhO\t\u0007I\u0011AAi\u0011!\tYn\nQ\u0001\n\u0005M\u0007\"CAoO\t\u0007I\u0011AAp\u0011!\tyo\nQ\u0001\n\u0005\u0005\bbBA}O\u0011\u0005\u00131 \u0005\b\u0005\u00039C\u0011\u0001B\u0002\u0011\u001d\u00119a\nC!\u0005\u0013AqAa\u0004(\t\u0003\u0012\t\u0002C\u0004\u0003\u0018\u001d\"\tE!\u0007\t\u000f\t}q\u0005\"\u0011\u0003\"!9!\u0011N\u0014\u0005\u0002\t-\u0004b\u0002B9O\u0011\u0005#1\u000f\u0005\n\u0005+;\u0013\u0011!C\u0005\u0005/\u0013!#T8tC&\u001cw)Z8nKR\u0014\u00180R*S\u0013*\u0011\u0001(O\u0001\tO\u0016|W.\u001a;ss*\u0011!hO\u0001\u0005G>\u0014XM\u0003\u0002={\u00051Qn\\:bS\u000eT!AP \u0002\t1\f'm\u001d\u0006\u0003\u0001\u0006\u000b!\u0002Z1uC\n\u0014\u0018nY6t\u0015\u0005\u0011\u0015aA2p[\u000e\u00011c\u0001\u0001F\u0017B\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n1\u0011I\\=SK\u001a\u0004\"\u0001T'\u000e\u0003]J!AT\u001c\u0003\u001d5{7/Y5d\u000f\u0016|W.\u001a;ss\u0006!q-Z8n!\t\t\u0006,D\u0001S\u0015\t\u0019F+A\u0002pO\u000eT!\u0001O+\u000b\u0005i2&BA,B\u0003\u0011)7O]5\n\u0005e\u0013&aC(H\u0007\u001e+w.\\3uef\fa\u0001P5oSRtDC\u0001/^!\ta\u0005\u0001C\u0003P\u0005\u0001\u0007\u0001+\u0001\thKRtU/\\$f_6,GO]5fgV\t\u0001\r\u0005\u0002GC&\u0011!m\u0012\u0002\u0004\u0013:$\u0018!\u0003;sC:\u001cH.\u0019;f)\rYUM\u001b\u0005\u0006M\u0012\u0001\raZ\u0001\u0003q\u0012\u0004\"A\u00125\n\u0005%<%A\u0002#pk\ndW\rC\u0003l\t\u0001\u0007q-\u0001\u0002zI\u0006y!/\u001a3vG\u00164%o\\7Nk2$\u0018.F\u0001L\u0003\u0015\u00198-\u00197f)\rY\u0005/\u001d\u0005\u0006M\u001a\u0001\ra\u001a\u0005\u0006W\u001a\u0001\raZ\u0001\u0007e>$\u0018\r^3\u0015\u0005-#\b\"B;\b\u0001\u00049\u0017A\u0001;e\u0003\u00199W\r^!Q\u0013V\t\u0001\u0010E\u0002z\u0003\u0003q!A\u001f@\u0011\u0005m<U\"\u0001?\u000b\u0005u\u001c\u0015A\u0002\u001fs_>$h(\u0003\u0002\u0000\u000f\u00061\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t11\u000b\u001e:j]\u001eT!a`$\u0002\u0017\u001d,GoQ3oiJ|\u0017\u000eZ\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#9\u0014!\u00029pS:$\u0018\u0002BA\u000b\u0003\u001f\u00111\"T8tC&\u001c\u0007k\\5oi\u00069\u0011n]#naRLXCAA\u000e!\r1\u0015QD\u0005\u0004\u0003?9%a\u0002\"p_2,\u0017M\\\u0001\u0007EV4g-\u001a:\u0015\u0007-\u000b)\u0003\u0003\u0004\u0002(-\u0001\raZ\u0001\tI&\u001cH/\u00198dK\u0006A1/[7qY&4\u0017\u0010F\u0002L\u0003[Aa!a\f\r\u0001\u00049\u0017!\u0003;pY\u0016\u0014\u0018M\\2f\u0003!)gN^3m_B,\u0017\u0001D5oi\u0016\u00148/Z2uS>tGcA&\u00028!1\u0011\u0011\b\bA\u0002-\u000bQa\u001c;iKJ$2\u0001UA\u001f\u0011\u0019\tyd\u0004a\u0001!\u00069\u0011M\\8uQ\u0016\u0014\u0018AC5oi\u0016\u00148/Z2ugR!\u00111DA#\u0011\u0019\tI\u0004\u0005a\u0001\u0017\u0006QA-\u001b4gKJ,gnY3\u0015\u0007-\u000bY\u0005\u0003\u0004\u0002:E\u0001\raS\u0001\u0006k:LwN\u001c\u000b\u0004\u0017\u0006E\u0003BBA\u001d%\u0001\u00071*A\u0004hKR<Um\\7\u0016\u0003A\u000b\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u00037\tY\u0006\u0003\u0004\u0002^Q\u0001\raS\u0001\u0006O\u0016|WNM\u0001\bSN4\u0016\r\\5e\u0003=9W\r^$f_6,GO]=UsB,\u0017aB4fi\u0006\u0013X-Y\u000b\u0002O\u00061Q-];bYN$B!a\u0007\u0002l!1\u0011\u0011\b\rA\u0002-#B!a\u0007\u0002p!9\u0011\u0011H\rA\u0002\u0005E\u0004\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\u0005Y\u0006twM\u0003\u0002\u0002|\u0005!!.\u0019<b\u0013\u0011\ty(!\u001e\u0003\r=\u0013'.Z2u\u0003))\u0017/^1mgR{\u0007o\u001c\u000b\u0005\u00037\t)\t\u0003\u0004\u0002:i\u0001\raS\u0001\tQ\u0006\u001c\bnQ8eK\u0006A!m\\;oI\u0006\u0014\u0018\u0010F\u0002h\u0003\u001bCa!!\u0018\u001e\u0001\u0004Y\u0015AC2p]Z,\u0007\u0010S;mYV\tA,\u0001\u0006v]\u0006\u0014\u00180\u00168j_:\fQ\u0001^8X\u0017R\u000ba\u0001^8K'>s\u0015!\u0002;p\u0011\u0016C\u0016!\u0002;p/.\u0013UCAAP!\u00151\u0015\u0011UAS\u0013\r\t\u0019k\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\r\u0006\u001d\u0016bAAU\u000f\n!!)\u001f;f\u0003M9W\r^*qCRL\u0017\r\u001c*fM\u0016\u0014XM\\2f\u0003M\u0019X\r^*qCRL\u0017\r\u001c*fM\u0016\u0014XM\\2f)\u0011\t\t,a.\u0011\u0007\u0019\u000b\u0019,C\u0002\u00026\u001e\u0013A!\u00168ji\"1\u0011\u0011X\u0013A\u0002\u0001\fAa\u001d:jI\u0006\u0011Rj\\:bS\u000e<Um\\7fiJLXi\u0015*J!\taue\u0005\u0004(\u000b\u0006\u0005\u0017q\u0019\t\u0004\u0019\u0006\r\u0017bAAco\tqq)Z8nKR\u0014\u0018PU3bI\u0016\u0014\bc\u0001$\u0002J&\u0019\u00111Z$\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005u\u0016a\u00063fM\u0006,H\u000e^*qCRL\u0017\r\u001c*fM\u0016\u0014XM\\2f+\t\t\u0019\u000e\u0005\u0003\u0002V\u0006]W\"\u0001+\n\u0007\u0005eGK\u0001\tTa\u0006$\u0018.\u00197SK\u001a,'/\u001a8dK\u0006AB-\u001a4bk2$8\u000b]1uS\u0006d'+\u001a4fe\u0016t7-\u001a\u0011\u0002\t-\u0014\u0018p\\\u000b\u0003\u0003C\u0004B!a9\u0002l6\u0011\u0011Q\u001d\u0006\u0005\u0003;\f9OC\u0002\u0002j\u0006\u000b\u0001#Z:pi\u0016\u0014\u0018nY:pMR<\u0018M]3\n\t\u00055\u0018Q\u001d\u0002\u0005\u0017JLx.A\u0003lef|\u0007\u0005K\u0002-\u0003g\u00042ARA{\u0013\r\t9p\u0012\u0002\niJ\fgn]5f]R\fqA\u001a:p[^[E\u000bF\u0002L\u0003{Da!a@.\u0001\u0004A\u0018aA<li\u0006)\u0011\r\u001d9msR\u0019AL!\u0002\t\u000b=s\u0003\u0019\u0001)\u0002\u000f\u0019\u0014x.\u001c%F1R\u00191Ja\u0003\t\r\t5q\u00061\u0001y\u0003\rAW\r_\u0001\bMJ|WnV&C)\ra&1\u0003\u0005\b\u0005+\u0001\u0004\u0019AAP\u0003\r98NY\u0001\tMJ|WNS*P\u001dR\u00191Ja\u0007\t\r\tu\u0011\u00071\u0001y\u0003\u001d9Wm\u001c&t_:\fqA\u001a:p[N+\u0017/\u0006\u0003\u0003$\t}B#\u0002/\u0003&\t-\u0003b\u0002B\u0014e\u0001\u0007!\u0011F\u0001\bO\u0016|WnU3r!\u0019\u0011YC!\u000e\u0003<9!!Q\u0006B\u0019\u001d\rY(qF\u0005\u0002\u0011&\u0019!1G$\u0002\u000fA\f7m[1hK&!!q\u0007B\u001d\u0005\r\u0019V-\u001d\u0006\u0004\u0005g9\u0005\u0003\u0002B\u001f\u0005\u007fa\u0001\u0001B\u0004\u0003BI\u0012\rAa\u0011\u0003\u0003Q\u000b2A!\u0012L!\r1%qI\u0005\u0004\u0005\u0013:%a\u0002(pi\"Lgn\u001a\u0005\b\u0005\u001b\u0012\u0004\u0019\u0001B(\u0003!9Wm\\7UsB,\u0007\u0003\u0002B)\u0005CrAAa\u0015\u0003^5\u0011!Q\u000b\u0006\u0005\u0005/\u0012I&A\u0003n_\u0012,GNC\u0002\u0003\\e\nQ\u0001^=qKNLAAa\u0018\u0003V\u0005\u0001r)Z8nKR\u0014\u0018\u0010V=qK\u0016sW/\\\u0005\u0005\u0005G\u0012)GA\u0003WC2,X-C\u0002\u0003h\u001d\u00131\"\u00128v[\u0016\u0014\u0018\r^5p]\u00061!/Z1eKJ$B!!1\u0003n!1!qN\u001aA\u0002\u0001\f!bZ3p[RK\b/Z%e\u000311'o\\7J]R,'O\\1m)\rY%Q\u000f\u0005\b\u0005o\"\u0004\u0019\u0001B=\u0003\r\u0011xn\u001e\t\u0005\u0005w\u0012\t*\u0004\u0002\u0003~)!!q\u0010BA\u0003!\u0019\u0017\r^1msN$(\u0002\u0002BB\u0005\u000b\u000b1a]9m\u0015\u0011\u00119I!#\u0002\u000bM\u0004\u0018M]6\u000b\t\t-%QR\u0001\u0007CB\f7\r[3\u000b\u0005\t=\u0015aA8sO&!!1\u0013B?\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003c\u0002")
public abstract class MosaicGeometryESRI
implements MosaicGeometry {
    private final OGCGeometry geom;

    public static MosaicGeometry fromInternal(InternalRow internalRow) {
        return MosaicGeometryESRI$.MODULE$.fromInternal(internalRow);
    }

    public static GeometryReader reader(int n) {
        return MosaicGeometryESRI$.MODULE$.reader(n);
    }

    public static <T extends MosaicGeometry> MosaicGeometryESRI fromSeq(Seq<T> seq, Enumeration.Value value) {
        return MosaicGeometryESRI$.MODULE$.fromSeq((Seq)seq, value);
    }

    public static MosaicGeometry fromJSON(String string) {
        return MosaicGeometryESRI$.MODULE$.fromJSON(string);
    }

    public static MosaicGeometryESRI fromWKB(byte[] byArray) {
        return MosaicGeometryESRI$.MODULE$.fromWKB(byArray);
    }

    public static MosaicGeometry fromHEX(String string) {
        return MosaicGeometryESRI$.MODULE$.fromHEX(string);
    }

    public static MosaicGeometryESRI apply(OGCGeometry oGCGeometry) {
        return MosaicGeometryESRI$.MODULE$.apply(oGCGeometry);
    }

    public static MosaicGeometry fromWKT(String string) {
        return MosaicGeometryESRI$.MODULE$.fromWKT(string);
    }

    public static Kryo kryo() {
        return MosaicGeometryESRI$.MODULE$.kryo();
    }

    public static SpatialReference defaultSpatialReference() {
        return MosaicGeometryESRI$.MODULE$.defaultSpatialReference();
    }

    public static int defaultSpatialReferenceId() {
        return MosaicGeometryESRI$.MODULE$.defaultSpatialReferenceId();
    }

    @Override
    public double minMaxCoord(String dimension, String func) {
        return MosaicGeometry.minMaxCoord$(this, dimension, func);
    }

    @Override
    public MosaicGeometry transformCRSXY(int sridTo, Option<Object> sridFrom) {
        return MosaicGeometry.transformCRSXY$(this, sridTo, sridFrom);
    }

    @Override
    public Option<Object> transformCRSXY$default$2() {
        return MosaicGeometry.transformCRSXY$default$2$(this);
    }

    @Override
    public int getNumGeometries() {
        int n;
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(this.geom.geometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            n = 1;
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.MULTIPOINT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                n = ((OGCMultiPoint)this.geom).numGeometries();
            } else {
                Enumeration.Value value6 = GeometryTypeEnum$.MODULE$.LINESTRING();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null)) {
                    n = 1;
                } else {
                    Enumeration.Value value8 = GeometryTypeEnum$.MODULE$.MULTILINESTRING();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !((Object)value8).equals(value9) : value9 != null)) {
                        n = ((OGCMultiLineString)this.geom).numGeometries();
                    } else {
                        Enumeration.Value value10 = GeometryTypeEnum$.MODULE$.POLYGON();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !((Object)value10).equals(value11) : value11 != null)) {
                            n = 1;
                        } else {
                            Enumeration.Value value12 = GeometryTypeEnum$.MODULE$.MULTIPOLYGON();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !((Object)value12).equals(value13) : value13 != null)) {
                                n = ((OGCMultiPolygon)this.geom).numGeometries();
                            } else {
                                throw new MatchError(value);
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public MosaicGeometry translate(double xd, double yd) {
        Transformation2D tr = new Transformation2D();
        tr.setShift(xd, yd);
        Geometry esriGeom = this.geom.getEsriGeometry();
        esriGeom.applyTransformation(tr);
        return MosaicGeometryESRI$.MODULE$.apply(OGCGeometry.createFromEsriGeometry(esriGeom, this.geom.getEsriSpatialReference()));
    }

    @Override
    public MosaicGeometry reduceFromMulti() {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.reduceFromMulti());
    }

    @Override
    public MosaicGeometry scale(double xd, double yd) {
        Transformation2D tr = new Transformation2D();
        tr.setScale(xd, yd);
        Geometry esriGeom = this.geom.getEsriGeometry();
        esriGeom.applyTransformation(tr);
        return MosaicGeometryESRI$.MODULE$.apply(OGCGeometry.createFromEsriGeometry(esriGeom, this.geom.getEsriSpatialReference()));
    }

    @Override
    public MosaicGeometry rotate(double td) {
        Transformation2D tr = new Transformation2D();
        tr.setRotate(td);
        Geometry esriGeom = this.geom.getEsriGeometry();
        esriGeom.applyTransformation(tr);
        return MosaicGeometryESRI$.MODULE$.apply(OGCGeometry.createFromEsriGeometry(esriGeom, this.geom.getEsriSpatialReference()));
    }

    @Override
    public String getAPI() {
        return "OGC";
    }

    @Override
    public MosaicPoint getCentroid() {
        return MosaicPointESRI$.MODULE$.apply(this.geom.centroid());
    }

    @Override
    public boolean isEmpty() {
        return this.geom.isEmpty();
    }

    @Override
    public MosaicGeometry buffer(double distance) {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.buffer(distance));
    }

    @Override
    public MosaicGeometry simplify(double tolerance) {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.makeSimple());
    }

    @Override
    public MosaicGeometry envelope() {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.envelope());
    }

    @Override
    public MosaicGeometry intersection(MosaicGeometry other) {
        OGCGeometry otherGeom = ((MosaicGeometryESRI)other).getGeom();
        return MosaicGeometryESRI$.MODULE$.apply(this.intersection(otherGeom));
    }

    private OGCGeometry intersection(OGCGeometry another) {
        OperatorIntersection op = (OperatorIntersection)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Intersection);
        GeometryCursor cursor = op.execute(this.geom.getEsriGeometryCursor(), another.getEsriGeometryCursor(), this.geom.getEsriSpatialReference(), null, -1);
        return OGCGeometry.createFromEsriCursor(cursor, this.geom.getEsriSpatialReference(), true);
    }

    @Override
    public boolean intersects(MosaicGeometry other) {
        OGCGeometry otherGeom = ((MosaicGeometryESRI)other).getGeom();
        return this.geom.intersects(otherGeom);
    }

    @Override
    public MosaicGeometry difference(MosaicGeometry other) {
        OGCGeometry otherGeom = ((MosaicGeometryESRI)other).getGeom();
        OGCGeometry difference = this.getGeom().difference(otherGeom);
        return MosaicGeometryESRI$.MODULE$.apply(difference);
    }

    @Override
    public MosaicGeometry union(MosaicGeometry other) {
        OGCGeometry otherGeom = ((MosaicGeometryESRI)other).getGeom();
        return MosaicGeometryESRI$.MODULE$.apply(this.getGeom().union(otherGeom));
    }

    public OGCGeometry getGeom() {
        return this.geom;
    }

    @Override
    public boolean contains(MosaicGeometry geom2) {
        return this.geom.contains(((MosaicGeometryESRI)geom2).getGeom());
    }

    @Override
    public boolean isValid() {
        return this.geom.isSimple();
    }

    @Override
    public String getGeometryType() {
        return this.geom.geometryType();
    }

    @Override
    public double getArea() {
        return this.geom.getEsriGeometry().calculateArea2D();
    }

    @Override
    public boolean equals(MosaicGeometry other) {
        OGCGeometry otherGeom = ((MosaicGeometryESRI)other).getGeom();
        return this.getGeom().equals((Object)otherGeom) || this.getGeom().Equals(otherGeom);
    }

    @Override
    public boolean equals(Object other) {
        return false;
    }

    @Override
    public boolean equalsTopo(MosaicGeometry other) {
        OGCGeometry otherGeom = ((MosaicGeometryESRI)other).getGeom();
        return this.getGeom().Equals(otherGeom);
    }

    @Override
    public int hashCode() {
        return this.geom.hashCode();
    }

    @Override
    public MosaicGeometry boundary() {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.boundary());
    }

    @Override
    public double distance(MosaicGeometry geom2) {
        return this.getGeom().distance(((MosaicGeometryESRI)geom2).getGeom());
    }

    @Override
    public MosaicGeometryESRI convexHull() {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.convexHull());
    }

    @Override
    public MosaicGeometry unaryUnion() {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.union(this.geom));
    }

    @Override
    public String toWKT() {
        return this.geom.asText();
    }

    @Override
    public String toJSON() {
        return this.geom.asGeoJson();
    }

    @Override
    public String toHEX() {
        return WKBWriter.toHex(this.geom.asBinary().array());
    }

    @Override
    public byte[] toWKB() {
        return this.geom.asBinary().array();
    }

    @Override
    public int getSpatialReference() {
        return this.geom.esriSR == null ? 0 : this.geom.getEsriSpatialReference().getID();
    }

    @Override
    public void setSpatialReference(int srid) {
        SpatialReference sr = SpatialReference.create(srid);
        this.geom.setSpatialReference(sr);
    }

    public MosaicGeometryESRI(OGCGeometry geom) {
        this.geom = geom;
        MosaicGeometry.$init$(this);
    }
}

