/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineString;
import com.databricks.labs.mosaic.core.geometry.multilinestring.MosaicMultiLineString;
import com.databricks.labs.mosaic.core.geometry.multipoint.MosaicMultiPoint;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.MosaicChip;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcZJ$sp;

public final class Mosaic$ {
    public static Mosaic$ MODULE$;

    static {
        new Mosaic$();
    }

    public Seq<MosaicChip> getChips(MosaicGeometry geometry, int resolution, boolean keepCoreGeom, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        Seq<MosaicChip> seq;
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(geometry.getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            seq = this.pointChip(geometry, resolution, keepCoreGeom, indexSystem);
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.MULTIPOINT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                seq = this.multiPointChips(geometry, resolution, keepCoreGeom, indexSystem);
            } else {
                Enumeration.Value value6 = GeometryTypeEnum$.MODULE$.LINESTRING();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null)) {
                    seq = this.lineFill(geometry, resolution, indexSystem, geometryAPI);
                } else {
                    Enumeration.Value value8 = GeometryTypeEnum$.MODULE$.MULTILINESTRING();
                    Enumeration.Value value9 = value;
                    seq = !(value8 != null ? !((Object)value8).equals(value9) : value9 != null) ? this.lineFill(geometry, resolution, indexSystem, geometryAPI) : this.mosaicFill(geometry, resolution, keepCoreGeom, indexSystem, geometryAPI);
                }
            }
        }
        return seq;
    }

    public Seq<MosaicChip> multiPointChips(MosaicGeometry geometry, int resolution, boolean keepCoreGeom, IndexSystem indexSystem) {
        Seq<MosaicPoint> points = ((MosaicMultiPoint)geometry).asSeq();
        return points.flatMap((Function1<MosaicPoint, Seq> & Serializable & scala.Serializable)point -> MODULE$.pointChip((MosaicGeometry)point, resolution, keepCoreGeom, indexSystem), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<MosaicChip> pointChip(MosaicGeometry geometry, int resolution, boolean keepCoreGeom, IndexSystem indexSystem) {
        MosaicPoint point = (MosaicPoint)geometry;
        MosaicPoint chipGeom = keepCoreGeom ? point : null;
        long cellId = indexSystem.pointToIndex(point.getX(), point.getY(), resolution);
        MosaicChip chip = new MosaicChip(false, package$.MODULE$.Left().apply(BoxesRunTime.boxToLong(cellId)), chipGeom);
        return (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new MosaicChip[]{chip.formatCellId(indexSystem)}));
    }

    public Seq<MosaicChip> mosaicFill(MosaicGeometry geometry, int resolution, boolean keepCoreGeom, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        double radius = indexSystem.getBufferRadius(geometry, resolution, geometryAPI);
        MosaicGeometry carvedGeometry = geometry.buffer(-radius);
        MosaicGeometry borderGeometry = carvedGeometry.isEmpty() ? geometry.buffer(radius * 1.01).simplify(0.01 * radius) : geometry.boundary().buffer(radius * 1.01).simplify(0.01 * radius);
        Seq<Object> coreIndices = indexSystem.polyfill(carvedGeometry, resolution, new Some<GeometryAPI>(geometryAPI));
        Seq borderIndices = (Seq)indexSystem.polyfill(borderGeometry, resolution, new Some<GeometryAPI>(geometryAPI)).diff(coreIndices);
        Seq<MosaicChip> coreChips = indexSystem.getCoreChips(coreIndices, keepCoreGeom, geometryAPI);
        Seq<MosaicChip> borderChips = indexSystem.getBorderChips(geometry, borderIndices, keepCoreGeom, geometryAPI);
        return coreChips.$plus$plus(borderChips, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<MosaicChip> lineFill(MosaicGeometry geometry, int resolution, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        Seq<MosaicChip> seq;
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(geometry.getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.LINESTRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            seq = this.lineDecompose((MosaicLineString)geometry, resolution, indexSystem, geometryAPI);
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.MULTILINESTRING();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                MosaicMultiLineString multiLine = (MosaicMultiLineString)geometry;
                seq = multiLine.flatten().flatMap((Function1<MosaicGeometry, Seq> & Serializable & scala.Serializable)line -> MODULE$.lineDecompose((MosaicLineString)line, resolution, indexSystem, geometryAPI), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new Error(new StringBuilder(49).append(value).append(" not supported for line fill/decompose operation.").toString());
            }
        }
        return seq;
    }

    public Set<Object> geometryKRing(MosaicGeometry geometry, int resolution, int k, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        Tuple2<Set<Object>, Set<Object>> tuple2 = this.getCellSets(geometry, resolution, indexSystem, geometryAPI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set<Object> coreCells = tuple2._1();
        Set<Object> borderCells = tuple2._2();
        Tuple2<Set<Object>, Set<Object>> tuple22 = new Tuple2<Set<Object>, Set<Object>>(coreCells, borderCells);
        Tuple2<Set<Object>, Set<Object>> tuple23 = tuple22;
        Set<Object> coreCells2 = tuple23._1();
        Set<Object> borderCells2 = tuple23._2();
        Set borderKRing = borderCells2.flatMap((Function1<Object, Seq> & Serializable & scala.Serializable)x$2 -> indexSystem.kRing(BoxesRunTime.unboxToLong(x$2), k), Set$.MODULE$.canBuildFrom());
        Set kRing = (Set)coreCells2.$plus$plus(borderKRing);
        return kRing;
    }

    public Set<Object> geometryKLoop(MosaicGeometry geometry, int resolution, int k, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        int n = k - 1;
        Tuple2<Set<Object>, Set<Object>> tuple2 = this.getCellSets(geometry, resolution, indexSystem, geometryAPI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set<Object> coreCells = tuple2._1();
        Set<Object> borderCells = tuple2._2();
        Tuple2<Set<Object>, Set<Object>> tuple22 = new Tuple2<Set<Object>, Set<Object>>(coreCells, borderCells);
        Tuple2<Set<Object>, Set<Object>> tuple23 = tuple22;
        Set<Object> coreCells2 = tuple23._1();
        Set<Object> borderCells2 = tuple23._2();
        Set borderNRing = borderCells2.flatMap((Function1<Object, Seq> & Serializable & scala.Serializable)x$4 -> indexSystem.kRing(BoxesRunTime.unboxToLong(x$4), n), Set$.MODULE$.canBuildFrom());
        Set nRing = (Set)coreCells2.$plus$plus(borderNRing);
        Set borderKLoop = borderCells2.flatMap((Function1<Object, Seq> & Serializable & scala.Serializable)x$5 -> indexSystem.kLoop(BoxesRunTime.unboxToLong(x$5), k), Set$.MODULE$.canBuildFrom());
        Set kLoop = (Set)borderKLoop.$minus$minus(nRing);
        return kLoop;
    }

    private Seq<MosaicChip> lineDecompose(MosaicLineString line, int resolution, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        MosaicPoint start = (MosaicPoint)((MosaicLineString)line.getShells().head()).asSeq().head();
        long startIndex = indexSystem.pointToIndex(start.getX(), start.getY(), resolution);
        Seq result = this.traverseLine$1(line, (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapLongArray(new long[]{startIndex})), (Set)Predef$.MODULE$.Set().empty(), (Seq)Seq$.MODULE$.empty(), indexSystem, geometryAPI);
        return result;
    }

    private Tuple2<Set<Object>, Set<Object>> getCellSets(MosaicGeometry geometry, int resolution, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        Seq<MosaicChip> chips = this.getChips(geometry, resolution, false, indexSystem, geometryAPI);
        Tuple2 tuple2 = chips.partition((Function1<MosaicChip, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.isCore()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq coreChips = (Seq)tuple2._1();
        Seq borderChips = (Seq)tuple2._2();
        Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(coreChips, borderChips);
        Tuple2<Seq, Seq> tuple23 = tuple22;
        Seq coreChips2 = tuple23._1();
        Seq borderChips2 = tuple23._2();
        Set coreCells = ((TraversableOnce)coreChips2.map((Function1<MosaicChip, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong(x$9.cellIdAsLong(indexSystem)), Seq$.MODULE$.canBuildFrom())).toSet();
        Set borderCells = ((TraversableOnce)borderChips2.map((Function1<MosaicChip, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong(x$10.cellIdAsLong(indexSystem)), Seq$.MODULE$.canBuildFrom())).toSet();
        return new Tuple2<Set<Object>, Set<Object>>(coreCells, borderCells);
    }

    public static final /* synthetic */ Tuple2 $anonfun$lineDecompose$1(IndexSystem indexSystem$5, GeometryAPI geometryAPI$2, MosaicLineString line$1, Set newTraversed$1, Tuple2 accumulator, long current) {
        Tuple2 tuple2;
        MosaicGeometry indexGeom = indexSystem$5.indexToGeometry(current, geometryAPI$2);
        MosaicGeometry lineSegment = line$1.intersection(indexGeom);
        if (!lineSegment.isEmpty()) {
            MosaicChip chip = new MosaicChip(false, package$.MODULE$.Left().apply(BoxesRunTime.boxToLong(current)), lineSegment);
            Seq<Object> kRing = indexSystem$5.kRing(current, 1);
            Seq toQueue = (Seq)kRing.filterNot((JFunction1$mcZJ$sp & scala.Serializable)elem -> newTraversed$1.contains(BoxesRunTime.boxToLong(elem)));
            tuple2 = new Tuple2(toQueue, ((TraversableLike)accumulator._2()).$plus$plus(Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new MosaicChip[]{chip})), Seq$.MODULE$.canBuildFrom()));
        } else if (newTraversed$1.size() == 1) {
            Seq<Object> kRing = indexSystem$5.kRing(current, 1);
            Seq toQueue = (Seq)kRing.filterNot((JFunction1$mcZJ$sp & scala.Serializable)elem -> newTraversed$1.contains(BoxesRunTime.boxToLong(elem)));
            tuple2 = new Tuple2(toQueue, accumulator._2());
        } else {
            tuple2 = accumulator;
        }
        return tuple2;
    }

    private final Seq traverseLine$1(MosaicLineString line, Seq queue, Set traversed, Seq chips, IndexSystem indexSystem$5, GeometryAPI geometryAPI$2) {
        Seq newChips;
        while (true) {
            Set newTraversed = (Set)traversed.$plus$plus(queue);
            Tuple2 tuple2 = queue.foldLeft(new Tuple2(Seq$.MODULE$.empty(), chips), (Function2<Tuple2, Object, Tuple2> & Serializable & scala.Serializable)(accumulator, current) -> Mosaic$.$anonfun$lineDecompose$1(indexSystem$5, geometryAPI$2, line, newTraversed, accumulator, BoxesRunTime.unboxToLong(current)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq newQueue = (Seq)tuple2._1();
            Seq newChips2 = tuple2._2();
            Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(newQueue, newChips2);
            Tuple2<Seq, Seq> tuple23 = tuple22;
            Seq newQueue2 = tuple23._1();
            newChips = tuple23._2();
            if (newQueue2.isEmpty()) break;
            chips = newChips;
            traversed = newTraversed;
            queue = newQueue2;
        }
        return newChips;
    }

    private Mosaic$() {
        MODULE$ = this;
    }
}

