import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description for this ACL role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_role#description AclRole#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_role#id AclRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique name for this ACL role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_role#name AclRole#name}
    */
    readonly name: string;
    /**
    * policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_role#policy AclRole#policy}
    */
    readonly policy: AclRolePolicy[] | cdktf.IResolvable;
}
export interface AclRolePolicy {
    /**
    * The name of the ACL policy to link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_role#name AclRole#name}
    */
    readonly name: string;
}
export declare function aclRolePolicyToTerraform(struct?: AclRolePolicy | cdktf.IResolvable): any;
export declare class AclRolePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AclRolePolicy | cdktf.IResolvable | undefined;
    set internalValue(value: AclRolePolicy | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class AclRolePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AclRolePolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AclRolePolicyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/r/acl_role nomad_acl_role}
*/
export declare class AclRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_acl_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/r/acl_role nomad_acl_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclRoleConfig
    */
    constructor(scope: Construct, id: string, config: AclRoleConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policy;
    get policy(): AclRolePolicyList;
    putPolicy(value: AclRolePolicy[] | cdktf.IResolvable): void;
    get policyInput(): cdktf.IResolvable | AclRolePolicy[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
