# Zoom Toolkit


This is a simple yet useful toolkit implemented for working on zoom records. There exists 3 functionalities that 
 automates the video processing procedure designed specifically for Zoom videos.

## Features

 - Silence Cut
    - Detecting and eliminating high amount and long duration silent parts in videos.
 - Face Removal
     - Automatically detects and blurs the portrait of the speaker that shares screen.
 - Scene Detect
    - Detects important frames.

## Installation

You can simple use pip,

```console
pip install zoom-toolkit
```

Download the source code from <a href="https://github.com/OnurArdaB/Zoom-Toolkit/">here</a> and then just type the command below inside the project folder.

```console
python setup.py install
```

## Quick Start Guide

- Silence Cut

```python
from zoom_toolkit.silencecut import SilenceCut
SilenceCut.operate(FRAME_RATE=30,SAMPLE_RATE=44100,SILENT_THRESHOLD=0.03,FRAME_SPREADAGE=1,NEW_SPEED=[5.00,1.00],FRAME_QUALITY=3,"path to the file","path to output file")
```
- Face Removal

```python
from zoom_toolkit.face_remove import FaceRemover
FaceRemover().face_remove("path to the file",False,1000,1050)
```
Module also allows users to state manual time zones for face removal with blurring or darkening option.

- Scene Detect
```python
from zoom_toolkit.scene_detector import SceneDetect
SceneDetect.Detect(input_vid_name = "video.mp4")
```

Further documentations will be announced soon.

This project has been developed under the supervision of Berrin Yanıkoğlu for ENS-492 (Graduation Project).
