"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogRetention = void 0;
const logs = require("@aws-cdk/aws-logs");
/**
 * Creates a custom resource to control the retention policy of a CloudWatch Logs
 * log group. The log group is created if it doesn't already exist. The policy
 * is removed when `retentionDays` is `undefined` or equal to `Infinity`.
 *
 * @deprecated use `LogRetention` from '@aws-cdk/aws-logs' instead
 */
class LogRetention extends logs.LogRetention {
    constructor(scope, id, props) {
        super(scope, id, { ...props });
    }
}
exports.LogRetention = LogRetention;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9nLXJldGVudGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxvZy1yZXRlbnRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsMENBQTBDO0FBbUIxQzs7Ozs7O0dBTUc7QUFDSCxNQUFhLFlBQWEsU0FBUSxJQUFJLENBQUMsWUFBWTtJQUNqRCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXdCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsR0FBRyxLQUFLLEVBQUUsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7Q0FDRjtBQUpELG9DQUlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgbG9ncyBmcm9tICdAYXdzLWNkay9hd3MtbG9ncyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKlxuICogUmV0cnkgb3B0aW9ucyBmb3IgYWxsIEFXUyBBUEkgY2FsbHMuXG4gKlxuICogQGRlcHJlY2F0ZWQgdXNlIGBMb2dSZXRlbnRpb25SZXRyeU9wdGlvbnNgIGZyb20gJ0Bhd3MtY2RrL2F3cy1sb2dzJyBpbnN0ZWFkXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTG9nUmV0ZW50aW9uUmV0cnlPcHRpb25zIGV4dGVuZHMgbG9ncy5Mb2dSZXRlbnRpb25SZXRyeU9wdGlvbnMge1xufVxuXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBhIExvZ1JldGVudGlvbi5cbiAqXG4gKiBAZGVwcmVjYXRlZCB1c2UgYExvZ1JldGVudGlvblByb3BzYCBmcm9tICdAYXdzLWNkay9hd3MtbG9ncycgaW5zdGVhZFxuICovXG5leHBvcnQgaW50ZXJmYWNlIExvZ1JldGVudGlvblByb3BzIGV4dGVuZHMgbG9ncy5Mb2dSZXRlbnRpb25Qcm9wcyB7XG59XG5cbi8qKlxuICogQ3JlYXRlcyBhIGN1c3RvbSByZXNvdXJjZSB0byBjb250cm9sIHRoZSByZXRlbnRpb24gcG9saWN5IG9mIGEgQ2xvdWRXYXRjaCBMb2dzXG4gKiBsb2cgZ3JvdXAuIFRoZSBsb2cgZ3JvdXAgaXMgY3JlYXRlZCBpZiBpdCBkb2Vzbid0IGFscmVhZHkgZXhpc3QuIFRoZSBwb2xpY3lcbiAqIGlzIHJlbW92ZWQgd2hlbiBgcmV0ZW50aW9uRGF5c2AgaXMgYHVuZGVmaW5lZGAgb3IgZXF1YWwgdG8gYEluZmluaXR5YC5cbiAqXG4gKiBAZGVwcmVjYXRlZCB1c2UgYExvZ1JldGVudGlvbmAgZnJvbSAnQGF3cy1jZGsvYXdzLWxvZ3MnIGluc3RlYWRcbiAqL1xuZXhwb3J0IGNsYXNzIExvZ1JldGVudGlvbiBleHRlbmRzIGxvZ3MuTG9nUmV0ZW50aW9uIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBMb2dSZXRlbnRpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgeyAuLi5wcm9wcyB9KTtcbiAgfVxufVxuIl19