# codat-bankfeeds

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install codat-bankfeeds
```
<!-- End SDK Installation -->

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import codat
from codat.models import operations, shared

s = codat.Codat()
s.config_security(
    security=shared.Security(
        api_key="YOUR_API_KEY_HERE",
    )
)
   
req = operations.GetBankAccountPushOptionsRequest(
    security=operations.GetBankAccountPushOptionsSecurity(
        api_key="YOUR_API_KEY_HERE",
    ),
    path_params=operations.GetBankAccountPushOptionsPathParams(
        account_id="unde",
        company_id="deserunt",
        connection_id="porro",
    ),
    query_params=operations.GetBankAccountPushOptionsQueryParams(
        order_by="nulla",
        page=6027.63,
        page_size=8579.46,
        query="perspiciatis",
    ),
)
    
res = s.bank_account_transactions.get_bank_account_push_options(req)

if res.push_option is not None:
    # handle response
```
<!-- End SDK Example Usage -->

<!-- Start SDK Available Operations -->
## SDK Available Operations


### bank_account_transactions

* `get_bank_account_push_options` - List push options for bank account bank transactions
* `list_all_bank_transactionscount` - List bank transactions for bank account
* `post_bank_transactions` - Create bank transactions

### bank_feed_accounts

* `get_bank_feeds` - List bank feed bank accounts
* `put_bank_feeds` - Update bank feed bank accounts
* `update_bank_feed` - Update bank feed bank account
<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
