# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nomad_pilot_cli.api_client import ApiClient
from nomad_pilot_cli.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ShipApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_ship(self, carrier, order_ref, **kwargs):  # noqa: E501
        """cancelShip  # noqa: E501

        Attempts to cancel a created waybill, success will depend on carrier support.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_ship(carrier, order_ref, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str carrier: String name of carrier (required)
        :param str order_ref: String name of order ref (by Odoo) (required)
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_ship_with_http_info(carrier, order_ref, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_ship_with_http_info(carrier, order_ref, **kwargs)  # noqa: E501
            return data

    def cancel_ship_with_http_info(self, carrier, order_ref, **kwargs):  # noqa: E501
        """cancelShip  # noqa: E501

        Attempts to cancel a created waybill, success will depend on carrier support.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_ship_with_http_info(carrier, order_ref, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str carrier: String name of carrier (required)
        :param str order_ref: String name of order ref (by Odoo) (required)
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'order_ref']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_ship" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if ('carrier' not in local_var_params or
                local_var_params['carrier'] is None):
            raise ApiValueError("Missing the required parameter `carrier` when calling `cancel_ship`")  # noqa: E501
        # verify the required parameter 'order_ref' is set
        if ('order_ref' not in local_var_params or
                local_var_params['order_ref'] is None):
            raise ApiValueError("Missing the required parameter `order_ref` when calling `cancel_ship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501
        if 'order_ref' in local_var_params:
            path_params['order_ref'] = local_var_params['order_ref']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/ship/{carrier}/order/{order_ref}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_ship(self, carrier, order_ref, **kwargs):  # noqa: E501
        """queryShip  # noqa: E501

        Query the status of an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_ship(carrier, order_ref, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str carrier: String name of carrier (required)
        :param str order_ref: order ref (by Odoo) (required)
        :param str seller_order_ref: order ref (by third party retailers, e.g. Youzan)
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_ship_with_http_info(carrier, order_ref, **kwargs)  # noqa: E501
        else:
            (data) = self.query_ship_with_http_info(carrier, order_ref, **kwargs)  # noqa: E501
            return data

    def query_ship_with_http_info(self, carrier, order_ref, **kwargs):  # noqa: E501
        """queryShip  # noqa: E501

        Query the status of an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_ship_with_http_info(carrier, order_ref, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str carrier: String name of carrier (required)
        :param str order_ref: order ref (by Odoo) (required)
        :param str seller_order_ref: order ref (by third party retailers, e.g. Youzan)
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'order_ref', 'seller_order_ref']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_ship" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if ('carrier' not in local_var_params or
                local_var_params['carrier'] is None):
            raise ApiValueError("Missing the required parameter `carrier` when calling `query_ship`")  # noqa: E501
        # verify the required parameter 'order_ref' is set
        if ('order_ref' not in local_var_params or
                local_var_params['order_ref'] is None):
            raise ApiValueError("Missing the required parameter `order_ref` when calling `query_ship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501
        if 'order_ref' in local_var_params:
            path_params['order_ref'] = local_var_params['order_ref']  # noqa: E501

        query_params = []
        if 'seller_order_ref' in local_var_params:
            query_params.append(('seller_order_ref', local_var_params['seller_order_ref']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/ship/{carrier}/order/{order_ref}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ship(self, carrier, package, **kwargs):  # noqa: E501
        """ship  # noqa: E501

        Requests waybill creation from specified carrier. Receives waybill details in return, most carriers provide id and PDF packing label  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ship(carrier, package, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str carrier: Carrier to ship with (required)
        :param Package package: Package to ship (required)
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ship_with_http_info(carrier, package, **kwargs)  # noqa: E501
        else:
            (data) = self.ship_with_http_info(carrier, package, **kwargs)  # noqa: E501
            return data

    def ship_with_http_info(self, carrier, package, **kwargs):  # noqa: E501
        """ship  # noqa: E501

        Requests waybill creation from specified carrier. Receives waybill details in return, most carriers provide id and PDF packing label  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ship_with_http_info(carrier, package, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str carrier: Carrier to ship with (required)
        :param Package package: Package to ship (required)
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'package']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ship" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if ('carrier' not in local_var_params or
                local_var_params['carrier'] is None):
            raise ApiValueError("Missing the required parameter `carrier` when calling `ship`")  # noqa: E501
        # verify the required parameter 'package' is set
        if ('package' not in local_var_params or
                local_var_params['package'] is None):
            raise ApiValueError("Missing the required parameter `package` when calling `ship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'package' in local_var_params:
            body_params = local_var_params['package']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/ship/{carrier}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
