# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._inputs import *
import pulumi_kubernetes

__all__ = ['IngressNginxArgs', 'IngressNginx']

@pulumi.input_type
class IngressNginxArgs:
    def __init__(__self__, *,
                 class_name: pulumi.Input[str],
                 public: Optional[pulumi.Input[bool]] = None,
                 tls: Optional[pulumi.Input['IngressNginxTlsArgsArgs']] = None,
                 whitelist: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a IngressNginx resource.
        :param pulumi.Input[str] class_name: The Ingress class name.
        :param pulumi.Input[bool] public: Expose the IngressController with a public Load Balancer.
        :param pulumi.Input['IngressNginxTlsArgsArgs'] tls: The domain associated to the IngressController.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelist: The whitelist of CIDR to access to the Ingress Controller.
        """
        pulumi.set(__self__, "class_name", class_name)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if whitelist is not None:
            pulumi.set(__self__, "whitelist", whitelist)

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> pulumi.Input[str]:
        """
        The Ingress class name.
        """
        return pulumi.get(self, "class_name")

    @class_name.setter
    def class_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "class_name", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[bool]]:
        """
        Expose the IngressController with a public Load Balancer.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input['IngressNginxTlsArgsArgs']]:
        """
        The domain associated to the IngressController.
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input['IngressNginxTlsArgsArgs']]):
        pulumi.set(self, "tls", value)

    @property
    @pulumi.getter
    def whitelist(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The whitelist of CIDR to access to the Ingress Controller.
        """
        return pulumi.get(self, "whitelist")

    @whitelist.setter
    def whitelist(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "whitelist", value)


class IngressNginx(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 class_name: Optional[pulumi.Input[str]] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 tls: Optional[pulumi.Input[pulumi.InputType['IngressNginxTlsArgsArgs']]] = None,
                 whitelist: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        IngressNginx is a component that deploy the Nginx IngressController to expose applications over HTTP/HTTPS.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] class_name: The Ingress class name.
        :param pulumi.Input[bool] public: Expose the IngressController with a public Load Balancer.
        :param pulumi.Input[pulumi.InputType['IngressNginxTlsArgsArgs']] tls: The domain associated to the IngressController.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelist: The whitelist of CIDR to access to the Ingress Controller.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IngressNginxArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        IngressNginx is a component that deploy the Nginx IngressController to expose applications over HTTP/HTTPS.

        :param str resource_name: The name of the resource.
        :param IngressNginxArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IngressNginxArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 class_name: Optional[pulumi.Input[str]] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 tls: Optional[pulumi.Input[pulumi.InputType['IngressNginxTlsArgsArgs']]] = None,
                 whitelist: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IngressNginxArgs.__new__(IngressNginxArgs)

            if class_name is None and not opts.urn:
                raise TypeError("Missing required property 'class_name'")
            __props__.__dict__["class_name"] = class_name
            __props__.__dict__["public"] = public
            __props__.__dict__["tls"] = tls
            __props__.__dict__["whitelist"] = whitelist
            __props__.__dict__["application"] = None
            __props__.__dict__["certificate"] = None
            __props__.__dict__["namespace"] = None
        super(IngressNginx, __self__).__init__(
            'cloud-toolkit-aws:kubernetes:IngressNginx',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def application(self) -> pulumi.Output['pulumi_kubernetes.apiextensions.CustomResource']:
        """
        The ArgoCD Application to deploy the component.
        """
        return pulumi.get(self, "application")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional[Any]]:
        """
        The ACM Certificates used for TLS encryption.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional['pulumi_kubernetes.core.v1.Namespace']]:
        """
        The Namespace used to deploy the component.
        """
        return pulumi.get(self, "namespace")

