# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *
from ._inputs import *
import pulumi_aws
import pulumi_kubernetes

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input['AddonsArgsArgs']] = None,
                 api: Optional[pulumi.Input['ClusterApiArgsArgs']] = None,
                 base_domain: Optional[pulumi.Input[str]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgsArgs']]]] = None,
                 oidc_providers: Optional[pulumi.Input['ClusterOidcProvidersArgsArgs']] = None,
                 private_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input['AddonsArgsArgs'] addons: The addons installed in the cluster.
        :param pulumi.Input['ClusterApiArgsArgs'] api: Configure the Kubernetes cluster API.
        :param pulumi.Input[str] base_domain: The base domain.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgsArgs']]] node_groups: The NodeGroups to be assigned to this cluster.
        :param pulumi.Input['ClusterOidcProvidersArgsArgs'] oidc_providers: The OIDC Providers configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_subnet_ids: The list of private subnet ids where for the EKS cluster. These subnets will be tagged for Kubernetes purposes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_ids: The list of public subnet ids where for the EKS cluster. These subnets will be tagged for Kubernetes purposes.
        :param pulumi.Input[str] version: Desired Kubernetes version for control plane. Defaults to '1.22'.
        :param pulumi.Input[str] vpc_id: The VPC ID where the cluster will be deployed
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if api is not None:
            pulumi.set(__self__, "api", api)
        if base_domain is not None:
            pulumi.set(__self__, "base_domain", base_domain)
        if node_groups is not None:
            pulumi.set(__self__, "node_groups", node_groups)
        if oidc_providers is not None:
            pulumi.set(__self__, "oidc_providers", oidc_providers)
        if private_subnet_ids is not None:
            pulumi.set(__self__, "private_subnet_ids", private_subnet_ids)
        if public_subnet_ids is not None:
            pulumi.set(__self__, "public_subnet_ids", public_subnet_ids)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input['AddonsArgsArgs']]:
        """
        The addons installed in the cluster.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input['AddonsArgsArgs']]):
        pulumi.set(self, "addons", value)

    @property
    @pulumi.getter
    def api(self) -> Optional[pulumi.Input['ClusterApiArgsArgs']]:
        """
        Configure the Kubernetes cluster API.
        """
        return pulumi.get(self, "api")

    @api.setter
    def api(self, value: Optional[pulumi.Input['ClusterApiArgsArgs']]):
        pulumi.set(self, "api", value)

    @property
    @pulumi.getter(name="baseDomain")
    def base_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The base domain.
        """
        return pulumi.get(self, "base_domain")

    @base_domain.setter
    def base_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_domain", value)

    @property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgsArgs']]]]:
        """
        The NodeGroups to be assigned to this cluster.
        """
        return pulumi.get(self, "node_groups")

    @node_groups.setter
    def node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgsArgs']]]]):
        pulumi.set(self, "node_groups", value)

    @property
    @pulumi.getter(name="oidcProviders")
    def oidc_providers(self) -> Optional[pulumi.Input['ClusterOidcProvidersArgsArgs']]:
        """
        The OIDC Providers configuration.
        """
        return pulumi.get(self, "oidc_providers")

    @oidc_providers.setter
    def oidc_providers(self, value: Optional[pulumi.Input['ClusterOidcProvidersArgsArgs']]):
        pulumi.set(self, "oidc_providers", value)

    @property
    @pulumi.getter(name="privateSubnetIds")
    def private_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of private subnet ids where for the EKS cluster. These subnets will be tagged for Kubernetes purposes.
        """
        return pulumi.get(self, "private_subnet_ids")

    @private_subnet_ids.setter
    def private_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_subnet_ids", value)

    @property
    @pulumi.getter(name="publicSubnetIds")
    def public_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of public subnet ids where for the EKS cluster. These subnets will be tagged for Kubernetes purposes.
        """
        return pulumi.get(self, "public_subnet_ids")

    @public_subnet_ids.setter
    def public_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_subnet_ids", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Desired Kubernetes version for control plane. Defaults to '1.22'.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID where the cluster will be deployed
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Cluster(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[pulumi.InputType['AddonsArgsArgs']]] = None,
                 api: Optional[pulumi.Input[pulumi.InputType['ClusterApiArgsArgs']]] = None,
                 base_domain: Optional[pulumi.Input[str]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeGroupArgsArgs']]]]] = None,
                 oidc_providers: Optional[pulumi.Input[pulumi.InputType['ClusterOidcProvidersArgsArgs']]] = None,
                 private_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Cluster is a component that deploys a production-ready Kubernetes cluster. It setups the AWS IAM and netwokring, as well many Kubernetes services to run application in production.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AddonsArgsArgs']] addons: The addons installed in the cluster.
        :param pulumi.Input[pulumi.InputType['ClusterApiArgsArgs']] api: Configure the Kubernetes cluster API.
        :param pulumi.Input[str] base_domain: The base domain.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeGroupArgsArgs']]]] node_groups: The NodeGroups to be assigned to this cluster.
        :param pulumi.Input[pulumi.InputType['ClusterOidcProvidersArgsArgs']] oidc_providers: The OIDC Providers configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_subnet_ids: The list of private subnet ids where for the EKS cluster. These subnets will be tagged for Kubernetes purposes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_ids: The list of public subnet ids where for the EKS cluster. These subnets will be tagged for Kubernetes purposes.
        :param pulumi.Input[str] version: Desired Kubernetes version for control plane. Defaults to '1.22'.
        :param pulumi.Input[str] vpc_id: The VPC ID where the cluster will be deployed
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cluster is a component that deploys a production-ready Kubernetes cluster. It setups the AWS IAM and netwokring, as well many Kubernetes services to run application in production.

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[pulumi.InputType['AddonsArgsArgs']]] = None,
                 api: Optional[pulumi.Input[pulumi.InputType['ClusterApiArgsArgs']]] = None,
                 base_domain: Optional[pulumi.Input[str]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeGroupArgsArgs']]]]] = None,
                 oidc_providers: Optional[pulumi.Input[pulumi.InputType['ClusterOidcProvidersArgsArgs']]] = None,
                 private_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["addons"] = addons
            __props__.__dict__["api"] = api
            __props__.__dict__["base_domain"] = base_domain
            __props__.__dict__["node_groups"] = node_groups
            __props__.__dict__["oidc_providers"] = oidc_providers
            __props__.__dict__["private_subnet_ids"] = private_subnet_ids
            __props__.__dict__["public_subnet_ids"] = public_subnet_ids
            __props__.__dict__["version"] = version
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["cluster"] = None
            __props__.__dict__["cluster_addons"] = None
            __props__.__dict__["cni_chart"] = None
            __props__.__dict__["default_oidc_provider"] = None
            __props__.__dict__["domain"] = None
            __props__.__dict__["kubeconfig"] = None
            __props__.__dict__["provider"] = None
            __props__.__dict__["provisioner_provider"] = None
            __props__.__dict__["provisioner_role"] = None
            __props__.__dict__["provisioner_role_policy"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["role_policy_attachment"] = None
            __props__.__dict__["security_group"] = None
            __props__.__dict__["subnet_tags"] = None
        super(Cluster, __self__).__init__(
            'cloud-toolkit-aws:kubernetes:Cluster',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output['pulumi_aws.eks.Cluster']:
        """
        The EKS Cluster.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="clusterAddons")
    def cluster_addons(self) -> pulumi.Output[Optional[Any]]:
        """
        The VPC CNI Chart installed in the cluster.
        """
        return pulumi.get(self, "cluster_addons")

    @property
    @pulumi.getter(name="cniChart")
    def cni_chart(self) -> pulumi.Output['pulumi_kubernetes.helm.v3.Release']:
        """
        The VPC CNI Chart installed in the cluster.
        """
        return pulumi.get(self, "cni_chart")

    @property
    @pulumi.getter(name="defaultOidcProvider")
    def default_oidc_provider(self) -> pulumi.Output[Optional['pulumi_aws.iam.OpenIdConnectProvider']]:
        """
        The default OIDC Provider.
        """
        return pulumi.get(self, "default_oidc_provider")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The VPC CNI Chart installed in the cluster.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def kubeconfig(self) -> pulumi.Output[str]:
        """
        The kubeconfig content for this cluster.
        """
        return pulumi.get(self, "kubeconfig")

    @property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> pulumi.Output[Sequence[Any]]:
        """
        The Node Groups associated to the cluster.
        """
        return pulumi.get(self, "node_groups")

    @property
    @pulumi.getter
    def provider(self) -> pulumi.Output['pulumi_kubernetes.Provider']:
        """
        The Kubernetes provider for this cluster.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter(name="provisionerProvider")
    def provisioner_provider(self) -> pulumi.Output['pulumi_aws.Provider']:
        """
        The Provider to provision EKS cluster.
        """
        return pulumi.get(self, "provisioner_provider")

    @property
    @pulumi.getter(name="provisionerRole")
    def provisioner_role(self) -> pulumi.Output['pulumi_aws.iam.Role']:
        """
        The IAM Role to provision EKS cluster.
        """
        return pulumi.get(self, "provisioner_role")

    @property
    @pulumi.getter(name="provisionerRolePolicy")
    def provisioner_role_policy(self) -> pulumi.Output['pulumi_aws.iam.RolePolicy']:
        """
        The IAM Role Polity to provision EKS cluster.
        """
        return pulumi.get(self, "provisioner_role_policy")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output['pulumi_aws.iam.Role']:
        """
        The IAM Role assumed by the EKS Cluster.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="rolePolicyAttachment")
    def role_policy_attachment(self) -> pulumi.Output['pulumi_aws.iam.RolePolicyAttachment']:
        """
        The IAM Role Policy Attachment to assign the IAM Policies to the IAM Role.
        """
        return pulumi.get(self, "role_policy_attachment")

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> pulumi.Output['pulumi_aws.ec2.SecurityGroup']:
        """
        The Security Group associated to the EKS Cluster.
        """
        return pulumi.get(self, "security_group")

    @property
    @pulumi.getter(name="subnetTags")
    def subnet_tags(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.Tag']]:
        """
        EC2 Tags used for provisioning Load Balancers.
        """
        return pulumi.get(self, "subnet_tags")

