# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import serverless
from .. import serverless as _serverless
from ._inputs import *
import pulumi_aws

__all__ = ['EmailSenderArgs', 'EmailSender']

@pulumi.input_type
class EmailSenderArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input[str],
                 bounce: Optional[pulumi.Input['NotificationTypeArgsArgs']] = None,
                 complaint: Optional[pulumi.Input['NotificationTypeArgsArgs']] = None,
                 configure_dns: Optional[pulumi.Input[bool]] = None,
                 delivery: Optional[pulumi.Input['NotificationTypeArgsArgs']] = None):
        """
        The set of arguments for constructing a EmailSender resource.
        :param pulumi.Input[str] identity: Address of the Domain or Email used to send the emails through Email Sender.
               If an Email address is provided, Email Sender will set a Simple Email Service Email Identity. Verification will need to be manual.
               Else, if a Domain address is configured, Email Sender will create a Simple Email Service Domain Identity. 
               By default, it will attempt to verify the Domain by looking the Route 53 Domain Registry in the AWS account that is applying the infrastructure changes.
               If the Domain is registered elsewhere, verification needs to be manual.
        :param pulumi.Input['NotificationTypeArgsArgs'] bounce: Arguments to manage incoming Bounce notifications.
        :param pulumi.Input['NotificationTypeArgsArgs'] complaint: Arguments to manage incoming Complaint notifications.
        :param pulumi.Input[bool] configure_dns: In the case of a Domain Identity, enables automatic verification by creating DKIM DNS Records in the domain registration on Route 53.
               If the domain is not registered in the Route 53 on the same AWS account that is applying the infrastructure changes, the process will fail unless this flag is set to False.
        :param pulumi.Input['NotificationTypeArgsArgs'] delivery: Arguments to manage incoming Delivery notifications.
        """
        pulumi.set(__self__, "identity", identity)
        if bounce is not None:
            pulumi.set(__self__, "bounce", bounce)
        if complaint is not None:
            pulumi.set(__self__, "complaint", complaint)
        if configure_dns is not None:
            pulumi.set(__self__, "configure_dns", configure_dns)
        if delivery is not None:
            pulumi.set(__self__, "delivery", delivery)

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Input[str]:
        """
        Address of the Domain or Email used to send the emails through Email Sender.
        If an Email address is provided, Email Sender will set a Simple Email Service Email Identity. Verification will need to be manual.
        Else, if a Domain address is configured, Email Sender will create a Simple Email Service Domain Identity. 
        By default, it will attempt to verify the Domain by looking the Route 53 Domain Registry in the AWS account that is applying the infrastructure changes.
        If the Domain is registered elsewhere, verification needs to be manual.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def bounce(self) -> Optional[pulumi.Input['NotificationTypeArgsArgs']]:
        """
        Arguments to manage incoming Bounce notifications.
        """
        return pulumi.get(self, "bounce")

    @bounce.setter
    def bounce(self, value: Optional[pulumi.Input['NotificationTypeArgsArgs']]):
        pulumi.set(self, "bounce", value)

    @property
    @pulumi.getter
    def complaint(self) -> Optional[pulumi.Input['NotificationTypeArgsArgs']]:
        """
        Arguments to manage incoming Complaint notifications.
        """
        return pulumi.get(self, "complaint")

    @complaint.setter
    def complaint(self, value: Optional[pulumi.Input['NotificationTypeArgsArgs']]):
        pulumi.set(self, "complaint", value)

    @property
    @pulumi.getter(name="configureDNS")
    def configure_dns(self) -> Optional[pulumi.Input[bool]]:
        """
        In the case of a Domain Identity, enables automatic verification by creating DKIM DNS Records in the domain registration on Route 53.
        If the domain is not registered in the Route 53 on the same AWS account that is applying the infrastructure changes, the process will fail unless this flag is set to False.
        """
        return pulumi.get(self, "configure_dns")

    @configure_dns.setter
    def configure_dns(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "configure_dns", value)

    @property
    @pulumi.getter
    def delivery(self) -> Optional[pulumi.Input['NotificationTypeArgsArgs']]:
        """
        Arguments to manage incoming Delivery notifications.
        """
        return pulumi.get(self, "delivery")

    @delivery.setter
    def delivery(self, value: Optional[pulumi.Input['NotificationTypeArgsArgs']]):
        pulumi.set(self, "delivery", value)


class EmailSender(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bounce: Optional[pulumi.Input[pulumi.InputType['NotificationTypeArgsArgs']]] = None,
                 complaint: Optional[pulumi.Input[pulumi.InputType['NotificationTypeArgsArgs']]] = None,
                 configure_dns: Optional[pulumi.Input[bool]] = None,
                 delivery: Optional[pulumi.Input[pulumi.InputType['NotificationTypeArgsArgs']]] = None,
                 identity: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Cloud Toolkit component for an Email Sender. Creates a Simple Email Service Email or Domain Identity alongside Simple Notification Service Topics and Simple Queue Service Queues to manage bounce, complaints or delivered messages.
        In the case of building a Domain Identity, if it is registered in the Route 53 on the AWS account that is applying the infrastructure changes, Cloud Toolkit can verify it automatically by creating the DKIM DNS Records.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['NotificationTypeArgsArgs']] bounce: Arguments to manage incoming Bounce notifications.
        :param pulumi.Input[pulumi.InputType['NotificationTypeArgsArgs']] complaint: Arguments to manage incoming Complaint notifications.
        :param pulumi.Input[bool] configure_dns: In the case of a Domain Identity, enables automatic verification by creating DKIM DNS Records in the domain registration on Route 53.
               If the domain is not registered in the Route 53 on the same AWS account that is applying the infrastructure changes, the process will fail unless this flag is set to False.
        :param pulumi.Input[pulumi.InputType['NotificationTypeArgsArgs']] delivery: Arguments to manage incoming Delivery notifications.
        :param pulumi.Input[str] identity: Address of the Domain or Email used to send the emails through Email Sender.
               If an Email address is provided, Email Sender will set a Simple Email Service Email Identity. Verification will need to be manual.
               Else, if a Domain address is configured, Email Sender will create a Simple Email Service Domain Identity. 
               By default, it will attempt to verify the Domain by looking the Route 53 Domain Registry in the AWS account that is applying the infrastructure changes.
               If the Domain is registered elsewhere, verification needs to be manual.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmailSenderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cloud Toolkit component for an Email Sender. Creates a Simple Email Service Email or Domain Identity alongside Simple Notification Service Topics and Simple Queue Service Queues to manage bounce, complaints or delivered messages.
        In the case of building a Domain Identity, if it is registered in the Route 53 on the AWS account that is applying the infrastructure changes, Cloud Toolkit can verify it automatically by creating the DKIM DNS Records.

        :param str resource_name: The name of the resource.
        :param EmailSenderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmailSenderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bounce: Optional[pulumi.Input[pulumi.InputType['NotificationTypeArgsArgs']]] = None,
                 complaint: Optional[pulumi.Input[pulumi.InputType['NotificationTypeArgsArgs']]] = None,
                 configure_dns: Optional[pulumi.Input[bool]] = None,
                 delivery: Optional[pulumi.Input[pulumi.InputType['NotificationTypeArgsArgs']]] = None,
                 identity: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmailSenderArgs.__new__(EmailSenderArgs)

            __props__.__dict__["bounce"] = bounce
            __props__.__dict__["complaint"] = complaint
            __props__.__dict__["configure_dns"] = configure_dns
            __props__.__dict__["delivery"] = delivery
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["address"] = None
            __props__.__dict__["bounce_additional_queues"] = None
            __props__.__dict__["bounce_additional_queues_policies"] = None
            __props__.__dict__["bounce_identity_notification_topic"] = None
            __props__.__dict__["bounce_queues"] = None
            __props__.__dict__["bounce_topic"] = None
            __props__.__dict__["bounce_topic_subscriptions"] = None
            __props__.__dict__["complaint_additional_queues"] = None
            __props__.__dict__["complaint_additional_queues_policies"] = None
            __props__.__dict__["complaint_identity_notification_topic"] = None
            __props__.__dict__["complaint_queues"] = None
            __props__.__dict__["complaint_topic"] = None
            __props__.__dict__["complaint_topic_subscriptions"] = None
            __props__.__dict__["delivery_additional_queues"] = None
            __props__.__dict__["delivery_additional_queues_policies"] = None
            __props__.__dict__["delivery_identity_notification_topic"] = None
            __props__.__dict__["delivery_queues"] = None
            __props__.__dict__["delivery_topic"] = None
            __props__.__dict__["delivery_topic_subscriptions"] = None
            __props__.__dict__["dns_dkim_records"] = None
            __props__.__dict__["dns_records"] = None
            __props__.__dict__["dns_zone_id"] = None
            __props__.__dict__["domain_dkim"] = None
            __props__.__dict__["domain_identity"] = None
            __props__.__dict__["email_identity"] = None
            __props__.__dict__["notifications_policy"] = None
            __props__.__dict__["resource_groups"] = None
            __props__.__dict__["sender_policy"] = None
        super(EmailSender, __self__).__init__(
            'cloud-toolkit-aws:email:EmailSender',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        Address of the Identity, regardless if it is a Domain or an Email.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="bounceAdditionalQueues")
    def bounce_additional_queues(self) -> pulumi.Output[Sequence['outputs.AdditionalQueueArgs']]:
        """
        Additional SQS Queues subscribed to the SNS Topic that receives bounced emails. These Queues were created outside the Email Sender component.
        """
        return pulumi.get(self, "bounce_additional_queues")

    @property
    @pulumi.getter(name="bounceAdditionalQueuesPolicies")
    def bounce_additional_queues_policies(self) -> pulumi.Output[Sequence['pulumi_aws.sqs.QueuePolicy']]:
        """
        Queue Policies attached to the externally provided Bounce SQS Queues.
        """
        return pulumi.get(self, "bounce_additional_queues_policies")

    @property
    @pulumi.getter(name="bounceIdentityNotificationTopic")
    def bounce_identity_notification_topic(self) -> pulumi.Output[Optional['pulumi_aws.ses.IdentityNotificationTopic']]:
        """
        Identity Notification Topic for bounced emails.
        """
        return pulumi.get(self, "bounce_identity_notification_topic")

    @property
    @pulumi.getter(name="bounceQueues")
    def bounce_queues(self) -> pulumi.Output[Sequence[Any]]:
        """
        SQS Queues subscribed to the SNS Topic that receives bounced emails. These Queues were created automatically by the Email Sender component.
        """
        return pulumi.get(self, "bounce_queues")

    @property
    @pulumi.getter(name="bounceTopic")
    def bounce_topic(self) -> pulumi.Output[Optional['pulumi_aws.sns.Topic']]:
        """
        SNS Topic for bounced emails.
        """
        return pulumi.get(self, "bounce_topic")

    @property
    @pulumi.getter(name="bounceTopicSubscriptions")
    def bounce_topic_subscriptions(self) -> pulumi.Output[Sequence['pulumi_aws.sns.TopicSubscription']]:
        """
        SNS subscriptions of the SQS Queues to the Bounce SNS Topic.
        """
        return pulumi.get(self, "bounce_topic_subscriptions")

    @property
    @pulumi.getter(name="complaintAdditionalQueues")
    def complaint_additional_queues(self) -> pulumi.Output[Sequence['outputs.AdditionalQueueArgs']]:
        """
        Additional SQS Queues subscribed to the SNS Topic that receives complained emails. These Queues were created outside the Email Sender component.
        """
        return pulumi.get(self, "complaint_additional_queues")

    @property
    @pulumi.getter(name="complaintAdditionalQueuesPolicies")
    def complaint_additional_queues_policies(self) -> pulumi.Output[Sequence['pulumi_aws.sqs.QueuePolicy']]:
        """
        Queue Policies attached to the externally provided Complaint SQS Queues.
        """
        return pulumi.get(self, "complaint_additional_queues_policies")

    @property
    @pulumi.getter(name="complaintIdentityNotificationTopic")
    def complaint_identity_notification_topic(self) -> pulumi.Output[Optional['pulumi_aws.ses.IdentityNotificationTopic']]:
        """
        Identity Notification Topic for complained emails.
        """
        return pulumi.get(self, "complaint_identity_notification_topic")

    @property
    @pulumi.getter(name="complaintQueues")
    def complaint_queues(self) -> pulumi.Output[Sequence[Any]]:
        """
        SQS Queues subscribed to the SNS Topic that receives complained emails. These Queues were created automatically by the Email Sender component.
        """
        return pulumi.get(self, "complaint_queues")

    @property
    @pulumi.getter(name="complaintTopic")
    def complaint_topic(self) -> pulumi.Output[Optional['pulumi_aws.sns.Topic']]:
        """
        SNS Topic for complained emails.
        """
        return pulumi.get(self, "complaint_topic")

    @property
    @pulumi.getter(name="complaintTopicSubscriptions")
    def complaint_topic_subscriptions(self) -> pulumi.Output[Sequence['pulumi_aws.sns.TopicSubscription']]:
        """
        SNS subscriptions of the SQS Queues to the Complaint SNS Topic.
        """
        return pulumi.get(self, "complaint_topic_subscriptions")

    @property
    @pulumi.getter(name="deliveryAdditionalQueues")
    def delivery_additional_queues(self) -> pulumi.Output[Sequence['outputs.AdditionalQueueArgs']]:
        """
        Additional SQS Queues subscribed to the SNS Topic that receives delivered emails. These Queues were created outside the Email Sender component.
        """
        return pulumi.get(self, "delivery_additional_queues")

    @property
    @pulumi.getter(name="deliveryAdditionalQueuesPolicies")
    def delivery_additional_queues_policies(self) -> pulumi.Output[Sequence['pulumi_aws.sqs.QueuePolicy']]:
        """
        Queue Policies attached to the externally provided Delivery SQS Queues.
        """
        return pulumi.get(self, "delivery_additional_queues_policies")

    @property
    @pulumi.getter(name="deliveryIdentityNotificationTopic")
    def delivery_identity_notification_topic(self) -> pulumi.Output[Optional['pulumi_aws.ses.IdentityNotificationTopic']]:
        """
        Identity Notification Topic for delivered emails.
        """
        return pulumi.get(self, "delivery_identity_notification_topic")

    @property
    @pulumi.getter(name="deliveryQueues")
    def delivery_queues(self) -> pulumi.Output[Sequence[Any]]:
        """
        SQS Queues subscribed to the SNS Topic that receives delivered emails. These Queues were created automatically by the Email Sender component.
        """
        return pulumi.get(self, "delivery_queues")

    @property
    @pulumi.getter(name="deliveryTopic")
    def delivery_topic(self) -> pulumi.Output[Optional['pulumi_aws.sns.Topic']]:
        """
        SNS Topic for delivered emails.
        """
        return pulumi.get(self, "delivery_topic")

    @property
    @pulumi.getter(name="deliveryTopicSubscriptions")
    def delivery_topic_subscriptions(self) -> pulumi.Output[Sequence['pulumi_aws.sns.TopicSubscription']]:
        """
        SNS subscriptions of the SQS Queues to the Delivery SNS Topic.
        """
        return pulumi.get(self, "delivery_topic_subscriptions")

    @property
    @pulumi.getter(name="dnsDkimRecords")
    def dns_dkim_records(self) -> pulumi.Output[Sequence['outputs.DnsDkimRecordArgs']]:
        """
        DNS DKIM Records. Only applies for Domain Identities.
        """
        return pulumi.get(self, "dns_dkim_records")

    @property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> pulumi.Output[Sequence['pulumi_aws.route53.Record']]:
        """
        DNS records stored in the Domain registration in Route 53. Only applies for Domain Identities that are registered using Route 53.
        """
        return pulumi.get(self, "dns_records")

    @property
    @pulumi.getter(name="dnsZoneId")
    def dns_zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        DNS zone identifier in Route 53 for the Domain. Only applies for Domain Identities that are registered using Route 53.
        """
        return pulumi.get(self, "dns_zone_id")

    @property
    @pulumi.getter(name="domainDKIM")
    def domain_dkim(self) -> pulumi.Output[Optional['pulumi_aws.ses.DomainDkim']]:
        """
        Domain DKIM. Only applies for Domain Identities.
        """
        return pulumi.get(self, "domain_dkim")

    @property
    @pulumi.getter(name="domainIdentity")
    def domain_identity(self) -> pulumi.Output[Optional['pulumi_aws.ses.DomainIdentity']]:
        """
        Domain Identity component. Left blank if an Email Identity was used instead.
        """
        return pulumi.get(self, "domain_identity")

    @property
    @pulumi.getter(name="emailIdentity")
    def email_identity(self) -> pulumi.Output[Optional['pulumi_aws.ses.EmailIdentity']]:
        """
        Email Identity component. Left blank if a Domain Identity was used instead.
        """
        return pulumi.get(self, "email_identity")

    @property
    @pulumi.getter(name="notificationsPolicy")
    def notifications_policy(self) -> pulumi.Output[Optional['pulumi_aws.iam.Policy']]:
        """
        Policy that when attached to an user, allows them to read the notification messages in the Queues.
        """
        return pulumi.get(self, "notifications_policy")

    @property
    @pulumi.getter(name="resourceGroups")
    def resource_groups(self) -> pulumi.Output[Sequence['pulumi_aws.resourcegroups.Group']]:
        """
        Resource Groups that contain the underlying components such as Topics or Queues that belong to the Email Sender.
        """
        return pulumi.get(self, "resource_groups")

    @property
    @pulumi.getter(name="senderPolicy")
    def sender_policy(self) -> pulumi.Output['pulumi_aws.iam.Policy']:
        """
        Policy that when attached to an user, allows them to send messages using the Email Sender Identity.
        """
        return pulumi.get(self, "sender_policy")

