"""
This file is a collection of Step7 Communication error.
"""
from . import constants as const

class CommTypeError(Exception):
    """
    Communication type error.
    """
    def __init__(self, message:str):
        self.msg = message

    def __str__(self):
        return f'{self.msg}'


class DataTypeError(Exception):
    """
    This data type is not supported by the module you connected.
    """
    def __init__(self, message:str):
        self.msg = message

    def __str__(self):
        return f'{self.msg}'


class ErrorCode(Exception):
    """
    Parameter error
    """
    def __init__(self, Code:int):
        self.code = Code

    def __str__(self):
        if self.code == 0x0000: return "No error"
        elif self.code == 0x0110: return "Invalid block number"
        elif self.code == 0x0111: return "Invalid request length"
        elif self.code == 0x0112: return "Invalid parameter"
        elif self.code == 0x0113: return "Invalid block type"
        elif self.code == 0x0114: return "Block not found"
        elif self.code == 0x0115: return "Block already exists"
        elif self.code == 0x0116: return "Block is write-protected"
        elif self.code == 0x0117: return "The block/operating system update is too large"
        elif self.code == 0x0118: return "Invalid block number"
        elif self.code == 0x0119: return "Incorrect password entered"
        elif self.code == 0x011A: return "PG resource error"
        elif self.code == 0x011B: return "PLC resource error"
        elif self.code == 0x011C: return "Protocol error"
        elif self.code == 0x011D: return "Too many blocks (module-related restriction)"
        elif self.code == 0x011E: return "There is no longer a connection to the database, or S7DOS handle is invalid"
        elif self.code == 0x011F: return "Result buffer too small"
        elif self.code == 0x0120: return "End of block list"
        elif self.code == 0x0140: return "Insufficient memory available"
        elif self.code == 0x0141: return "Job cannot be processed because of a lack of resources"
        elif self.code == 0x8001: return "The requested service cannot be performed while the block is in the current status"
        elif self.code == 0x8003: return "S7 protocol error: Error occurred while transferring the block"
        elif self.code == 0x8100: return "Application, general error: Service unknown to remote module"
        elif self.code == 0x8104: return "This service is not implemented on the module or a frame error was reported"
        elif self.code == 0x8204: return "The type specification for the object is inconsistent"
        elif self.code == 0x8205: return "A copied block already exists and is not linked"
        elif self.code == 0x8301: return "Insufficient memory space or work memory on the module, or specified storage medium not accessible"
        elif self.code == 0x8302: return "Too few resources available or the processor resources are not available"
        elif self.code == 0x8304: return "No further parallel upload possible. There is a resource bottleneck"
        elif self.code == 0x8305: return "Function not available"
        elif self.code == 0x8306: return "Insufficient work memory (for copying, linking, loading AWP)"
        elif self.code == 0x8307: return "Not enough retentive work memory (for copying, linking, loading AWP)"
        elif self.code == 0x8401: return "S7 protocol error: Invalid service sequence (for example, loading or uploading a block)"
        elif self.code == 0x8402: return "Service cannot execute owing to status of the addressed object"
        elif self.code == 0x8404: return "S7 protocol: The function cannot be performed"
        elif self.code == 0x8405: return "Remote block is in DISABLE state (CFB). The function cannot be performed"
        elif self.code == 0x8500: return "S7 protocol error: Wrong frames"
        elif self.code == 0x8503: return "Alarm from the module: Service canceled prematurely"
        elif self.code == 0x8701: return "Error addressing the object on the communications partner (for example, area length error)"
        elif self.code == 0x8702: return "The requested service is not supported by the module"
        elif self.code == 0x8703: return "Access to object refused"
        elif self.code == 0x8704: return "Access error: Object damaged"
        elif self.code == 0xD001: return "Protocol error: Illegal job number"
        elif self.code == 0xD002: return "Parameter error: Illegal job variant"
        elif self.code == 0xD003: return "Parameter error: Debugging function not supported by module"
        elif self.code == 0xD004: return "Parameter error: Illegal job status"
        elif self.code == 0xD005: return "Parameter error: Illegal job termination"
        elif self.code == 0xD006: return "Parameter error: Illegal link disconnection ID"
        elif self.code == 0xD007: return "Parameter error: Illegal number of buffer elements"
        elif self.code == 0xD008: return "Parameter error: Illegal scan rate"
        elif self.code == 0xD009: return "Parameter error: Illegal number of executions"
        elif self.code == 0xD00A: return "Parameter error: Illegal trigger event"
        elif self.code == 0xD00B: return "Parameter error: Illegal trigger condition"
        elif self.code == 0xD011: return "Parameter error in path of the call environment: Block does not exist"
        elif self.code == 0xD012: return "Parameter error: Wrong address in block"
        elif self.code == 0xD014: return "Parameter error: Block being deleted/overwritten"
        elif self.code == 0xD015: return "Parameter error: Illegal tag address"
        elif self.code == 0xD016: return "Parameter error: Test jobs not possible, because of errors in user program"
        elif self.code == 0xD017: return "Parameter error: Illegal trigger number"
        elif self.code == 0xD025: return "Parameter error: Invalid path"
        elif self.code == 0xD026: return "Parameter error: Illegal access type"
        elif self.code == 0xD027: return "Parameter error: This number of data blocks is not permitted"
        elif self.code == 0xD031: return "Internal protocol error"
        elif self.code == 0xD032: return "Parameter error: Wrong result buffer length"
        elif self.code == 0xD033: return "Protocol error: Wrong job length"
        elif self.code == 0xD03F: return "Coding error: Error in parameter section (for example, reserve bytes not equal to 0)"
        elif self.code == 0xD041: return "Data error: Illegal status list ID"
        elif self.code == 0xD042: return "Data error: Illegal tag address"
        elif self.code == 0xD043: return "Data error: Referenced job not found, check job data"
        elif self.code == 0xD044: return "Data error: Illegal tag self.code, check job data"
        elif self.code == 0xD045: return "Data error: Exiting the ODIS control is not allowed in HOLD"
        elif self.code == 0xD046: return "Data error: Illegal measuring stage during run-time measurement"
        elif self.code == 0xD047: return "Data error: Illegal hierarchy in 'Read job list'"
        elif self.code == 0xD048: return "Data error: Illegal deletion ID in 'Delete job'"
        elif self.code == 0xD049: return "Invalid substitute ID in 'Replace job'"
        elif self.code == 0xD04A: return "Error executing 'program status'"
        elif self.code == 0xD05F: return "Coding error: Error in data section (for example, reserve bytes not equal to 0, ...)"
        elif self.code == 0xD061: return "Resource error: No memory space for job"
        elif self.code == 0xD062: return "Resource error: Job list full"
        elif self.code == 0xD063: return "Resource error: Trigger event occupied"
        elif self.code == 0xD064: return "Resource error: Not enough memory space for one result buffer element"
        elif self.code == 0xD065: return "Resource error: Not enough memory space for several  result buffer elements"
        elif self.code == 0xD066: return "Resource error: The timer available for run-time measurement is occupied by another job"
        elif self.code == 0xD067: return "Resource error: Too many 'modify tag' jobs active (in particular multi-processor operation)"
        elif self.code == 0xD081: return "Function not permitted in current mode"
        elif self.code == 0xD082: return "Mode error: Cannot exit HOLD mode"
        elif self.code == 0xD0A1: return "Function not permitted in current protection level"
        elif self.code == 0xD0A2: return "Function not possible at present, because a function is running that modifies memory"
        elif self.code == 0xD0A3: return "Too many 'modify tag' jobs active on the I/O (in particular multi-processor operation)"
        elif self.code == 0xD0A4: return "'Forcing' has already been established"
        elif self.code == 0xD0A5: return "Referenced job not found"
        elif self.code == 0xD0A6: return "Job cannot be disabled/enabled"
        elif self.code == 0xD0A7: return "Job cannot be deleted, for example because it is currently being read"
        elif self.code == 0xD0A8: return "Job cannot be replaced, for example because it is currently being read or deleted"
        elif self.code == 0xD0A9: return "Job cannot be read, for example because it is currently being deleted"
        elif self.code == 0xD0AA: return "Time limit exceeded in processing operation"
        elif self.code == 0xD0AB: return "Invalid job parameters in process operation"
        elif self.code == 0xD0AC: return "Invalid job data in process operation"
        elif self.code == 0xD0AD: return "Operating mode already set"
        elif self.code == 0xD0AE: return "The job was set up over a different connection and can only be handled over this connection"
        elif self.code == 0xD0C1: return "At least one error has been detected while accessing the tag(s)"
        elif self.code == 0xD0C2: return "Change to STOP/HOLD mode"
        elif self.code == 0xD0C3: return "At least one error was detected while accessing the tag(s). Mode change to STOP/HOLD"
        elif self.code == 0xD0C4: return "Timeout during run-time measurement"
        elif self.code == 0xD0C5: return "Display of block stack inconsistent, because blocks were deleted/reloaded"
        elif self.code == 0xD0C6: return "Job was automatically deleted as the jobs it referenced have been deleted"
        elif self.code == 0xD0C7: return "The job was automatically deleted because STOP mode was exited"
        elif self.code == 0xD0C8: return "'Block status' aborted because of inconsistencies between test job and running program"
        elif self.code == 0xD0C9: return "Exit the status area by resetting OB90"
        elif self.code == 0xD0CA: return "Exiting the status range by resetting OB90 and access error reading tags before exiting"
        elif self.code == 0xD0CB: return "The output disable for the peripheral outputs has been activated again"
        elif self.code == 0xD0CC: return "The amount of data for the debugging functions is restricted by the time limit"
        elif self.code == 0xD201: return "Syntax error in block name"
        elif self.code == 0xD202: return "Syntax error in function parameters"
        elif self.code == 0xD205: return "Linked block already exists in RAM: Conditional copying is not possible"
        elif self.code == 0xD206: return "Linked block already exists in EPROM: Conditional copying is not possible"
        elif self.code == 0xD208: return "Maximum number of copied (not linked) blocks on module exceeded"
        elif self.code == 0xD209: return "(At least) one of the given blocks not found on the module"
        elif self.code == 0xD20A: return "The maximum number of blocks that can be linked with one job was exceeded"
        elif self.code == 0xD20B: return "The maximum number of blocks that can be deleted with one job was exceeded"
        elif self.code == 0xD20C: return "OB cannot be copied because the associated priority class does not exist"
        elif self.code == 0xD20D: return "SDB cannot be interpreted (for example, unknown number)"
        elif self.code == 0xD20E: return "No (further) block available"
        elif self.code == 0xD20F: return "Module-specific maximum block size exceeded"
        elif self.code == 0xD210: return "Invalid block number"
        elif self.code == 0xD212: return "Incorrect header attribute (run-time relevant)"
        elif self.code == 0xD213: return "Too many SDBs. Note the restrictions on the module being used"
        elif self.code == 0xD216: return "Invalid user program - reset module"
        elif self.code == 0xD217: return "Protection level specified in module properties not permitted"
        elif self.code == 0xD218: return "Incorrect attribute (active/passive)"
        elif self.code == 0xD219: return "Incorrect block lengths (for example, incorrect length of first section or of the whole block)"
        elif self.code == 0xD21A: return "Incorrect local data length or write-protection code faulty"
        elif self.code == 0xD21B: return "Module cannot compress or compression was interrupted early"
        elif self.code == 0xD21D: return "The volume of dynamic project data transferred is illegal"
        elif self.code == 0xD21E: return "Unable to assign parameters to a module (such as FM, CP). The system data could not be linked"
        elif self.code == 0xD220: return "Invalid programming language. Note the restrictions on the module being used"
        elif self.code == 0xD221: return "The system data for connections or routing are not valid"
        elif self.code == 0xD222: return "The system data of the global data definition contain invalid parameters"
        elif self.code == 0xD223: return "Error in instance data block for communication function block or maximum number of instance DBs exceeded"
        elif self.code == 0xD224: return "The SCAN system data block contains invalid parameters"
        elif self.code == 0xD225: return "The DP system data block contains invalid parameters"
        elif self.code == 0xD226: return "A structural error occurred in a block"
        elif self.code == 0xD230: return "A structural error occurred in a block"
        elif self.code == 0xD231: return "At least one loaded OB cannot be copied because the associated priority class does not exist"
        elif self.code == 0xD232: return "At least one block number of a loaded block is illegal"
        elif self.code == 0xD234: return "Block exists twice in the specified memory medium or in the job"
        elif self.code == 0xD235: return "The block contains an incorrect checksum"
        elif self.code == 0xD236: return "The block does not contain a checksum"
        elif self.code == 0xD237: return "You are about to load the block twice, i.e. a block with the same time stamp already exists on the CPU"
        elif self.code == 0xD238: return "At least one of the blocks specified is not a DB"
        elif self.code == 0xD239: return "At least one of the DBs specified is not available as a linked variant in the load memory"
        elif self.code == 0xD23A: return "At least one of the specified DBs is considerably different from the copied and linked variant"
        elif self.code == 0xD240: return "Coordination rules violated"
        elif self.code == 0xD241: return "The function is not permitted in the current protection level"
        elif self.code == 0xD242: return "Protection violation while processing F blocks"
        elif self.code == 0xD250: return "Update and module ID or version do not match"
        elif self.code == 0xD251: return "Incorrect sequence of operating system components"
        elif self.code == 0xD252: return "Checksum error"
        elif self.code == 0xD253: return "No executable loader available; update only possible using a memory card"
        elif self.code == 0xD254: return "Storage error in operating system"
        elif self.code == 0xD280: return "Error compiling block in S7-300 CPU"
        elif self.code == 0xD2A1: return "Another block function or a trigger on a block is active"
        elif self.code == 0xD2A2: return "A trigger is active on a block. Complete the debugging function first"
        elif self.code == 0xD2A3: return "The block is not active (linked), the block is occupied or the block is currently marked for deletion"
        elif self.code == 0xD2A4: return "The block is already being processed by another block function"
        elif self.code == 0xD2A6: return "It is not possible to save and change the user program simultaneously"
        elif self.code == 0xD2A7: return "The block has the attribute 'unlinked' or is not processed"
        elif self.code == 0xD2A8: return "An active debugging function is preventing parameters from being assigned to the CPU"
        elif self.code == 0xD2A9: return "New parameters are being assigned to the CPU"
        elif self.code == 0xD2AA: return "New parameters are currently being assigned to the modules"
        elif self.code == 0xD2AB: return "The dynamic configuration limits are currently being changed"
        elif self.code == 0xD2AC: return "A running active or deactivate assignment (SFC 12) is temporarily preventing R-KiR process"
        elif self.code == 0xD2B0: return "An error occurred while configuring in RUN (CiR)"
        elif self.code == 0xD2C0: return "The maximum number of technological objects has been exceeded"
        elif self.code == 0xD2C1: return "The same technology data block already exists on the module"
        elif self.code == 0xD2C2: return "Downloading the user program or downloading the hardware configuration is not possible"
        elif self.code == 0xD401: return "Information function unavailable"
        elif self.code == 0xD402: return "Information function unavailable"
        elif self.code == 0xD403: return "Service has already been logged on/off (Diagnostics/PMC)"
        elif self.code == 0xD404: return "Maximum number of nodes reached. No more logons possible for diagnostics/PMC"
        elif self.code == 0xD405: return "Service not supported or syntax error in function parameters"
        elif self.code == 0xD406: return "Required information currently unavailable"
        elif self.code == 0xD407: return "Diagnostics error occurred"
        elif self.code == 0xD408: return "Update aborted"
        elif self.code == 0xD409: return "Error on DP bus"
        elif self.code == 0xD601: return "Syntax error in function parameter"
        elif self.code == 0xD602: return "Incorrect password entered"
        elif self.code == 0xD603: return "The connection has already been legitimized"
        elif self.code == 0xD604: return "The connection has already been enabled"
        elif self.code == 0xD605: return "Legitimization not possible because password does not exist"
        elif self.code == 0xD801: return "At least one tag address is invalid"
        elif self.code == 0xD802: return "Specified job does not exist"
        elif self.code == 0xD803: return "Illegal job status"
        elif self.code == 0xD804: return "Illegal cycle time (illegal time base or multiple)"
        elif self.code == 0xD805: return "No more cyclic read jobs can be set up"
        elif self.code == 0xD806: return "The referenced job is in a state in which the requested function cannot be performed"
        elif self.code == 0xD807: return "Function aborted due to overload, meaning executing the read cycle takes longer than the set scan cycle time"
        elif self.code == 0xDC01: return "Date and/or time invalid"
        elif self.code == 0xE201: return "CPU is already the master"
        elif self.code == 0xE202: return "Connect and update not possible due to different user program in flash module"
        elif self.code == 0xE203: return "Connect and update not possible due to different firmware"
        elif self.code == 0xE204: return "Connect and update not possible due to different memory configuration"
        elif self.code == 0xE205: return "Connect/update aborted due to synchronization error"
        elif self.code == 0xE206: return "Connect/update denied due to coordination violation"
        elif self.code == 0xEF01: return "S7 protocol error: Error at ID2; only 00H permitted in job"
        elif self.code == 0xEF02: return "S7 protocol error: Error at ID2; set of resources does not exist"
        else: return "Undefined"


class ErrorClass(Exception):
    """
    Parameter error
    """
    def __init__(self, Code:int):
        self.code = Code

    def __str__(self):
        if self.code == const.ErrorClass.NO_ERROR: return "No error"
        elif self.code == const.ErrorClass.APPLICATION_RELATIONSHIP: return "Application relationship"
        elif self.code == const.ErrorClass.OBJECT_DEFINITION: return "Object definition"
        elif self.code == const.ErrorClass.NO_RESOURCE_AVAILABLE: return "No resources available"
        elif self.code == const.ErrorClass.ERROR_ON_SERVICE_PROCESSING: return "Error on service processing"
        elif self.code == const.ErrorClass.ERROR_ON_SUPPLIES: return "Error on supplies"
        elif self.code == const.ErrorClass.ACCESS_ERROR: return "Access error"
        else: return "Undefined"


class ReturnCode(Exception):
    """
    Parameter error
    """
    def __init__(self, Code:int):
        self.code = Code

    def __str__(self):
        if self.code == const.ReturnCode.RESERVED: return "Reserved"
        elif self.code == const.ReturnCode.HARDWARE_ERROR: return "Hardware error"
        elif self.code == const.ReturnCode.ACCESSING_OBJECT_NOT_ALLOWED: return "Accessing the object not allowed"
        elif self.code == const.ReturnCode.INVALID_ADDRESS: return "Invalid address"
        elif self.code == const.ReturnCode.DATATYPE_NOT_SUPPORTED: return  "Data type not supported"
        elif self.code == const.ReturnCode.DATATYPE_INCONSISTENT: return "Data type inconsistent"
        elif self.code == const.ReturnCode.OBJECT_NOT_EXIST: return "Object does not exist"
        elif self.code == const.ReturnCode.SUCCESS: return "Success"
        else: return "Undefined"