import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { CfnVirtualService } from './appmesh.generated';
import { IMesh } from './mesh';
import { IVirtualNode } from './virtual-node';
import { IVirtualRouter } from './virtual-router';
/**
 * Represents the interface which all VirtualService based classes MUST implement.
 *
 * @stability stable
 */
export interface IVirtualService extends cdk.IResource {
    /**
     * The name of the VirtualService.
     *
     * @stability stable
     * @attribute true
     */
    readonly virtualServiceName: string;
    /**
     * The Amazon Resource Name (ARN) for the virtual service.
     *
     * @stability stable
     * @attribute true
     */
    readonly virtualServiceArn: string;
    /**
     * The Mesh which the VirtualService belongs to.
     *
     * @stability stable
     */
    readonly mesh: IMesh;
}
/**
 * The properties applied to the VirtualService being defined.
 *
 * @stability stable
 */
export interface VirtualServiceProps {
    /**
     * The name of the VirtualService.
     *
     * It is recommended this follows the fully-qualified domain name format,
     * such as "my-service.default.svc.cluster.local".
     *
     * @default - A name is automatically generated
     * @stability stable
     * @example
     *
     * service.domain.local
     */
    readonly virtualServiceName?: string;
    /**
     * The VirtualNode or VirtualRouter which the VirtualService uses as its provider.
     *
     * @stability stable
     */
    readonly virtualServiceProvider: VirtualServiceProvider;
}
/**
 * VirtualService represents a service inside an AppMesh.
 *
 * It routes traffic either to a Virtual Node or to a Virtual Router.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html
 * @stability stable
 */
export declare class VirtualService extends cdk.Resource implements IVirtualService {
    /**
     * Import an existing VirtualService given an ARN.
     *
     * @stability stable
     */
    static fromVirtualServiceArn(scope: Construct, id: string, virtualServiceArn: string): IVirtualService;
    /**
     * Import an existing VirtualService given its attributes.
     *
     * @stability stable
     */
    static fromVirtualServiceAttributes(scope: Construct, id: string, attrs: VirtualServiceAttributes): IVirtualService;
    /**
     * The name of the VirtualService, it is recommended this follows the fully-qualified domain name format.
     *
     * @stability stable
     */
    readonly virtualServiceName: string;
    /**
     * The Amazon Resource Name (ARN) for the virtual service.
     *
     * @stability stable
     */
    readonly virtualServiceArn: string;
    /**
     * The Mesh which the VirtualService belongs to.
     *
     * @stability stable
     */
    readonly mesh: IMesh;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: VirtualServiceProps);
}
/**
 * Interface with properties ncecessary to import a reusable VirtualService.
 *
 * @stability stable
 */
export interface VirtualServiceAttributes {
    /**
     * The name of the VirtualService, it is recommended this follows the fully-qualified domain name format.
     *
     * @stability stable
     */
    readonly virtualServiceName: string;
    /**
     * The Mesh which the VirtualService belongs to.
     *
     * @stability stable
     */
    readonly mesh: IMesh;
}
/**
 * Properties for a VirtualService provider.
 *
 * @stability stable
 */
export interface VirtualServiceProviderConfig {
    /**
     * Virtual Node based provider.
     *
     * @default - none
     * @stability stable
     */
    readonly virtualNodeProvider?: CfnVirtualService.VirtualNodeServiceProviderProperty;
    /**
     * Virtual Router based provider.
     *
     * @default - none
     * @stability stable
     */
    readonly virtualRouterProvider?: CfnVirtualService.VirtualRouterServiceProviderProperty;
    /**
     * Mesh the Provider is using.
     *
     * @default - none
     * @stability stable
     */
    readonly mesh: IMesh;
}
/**
 * Represents the properties needed to define the provider for a VirtualService.
 *
 * @stability stable
 */
export declare abstract class VirtualServiceProvider {
    /**
     * Returns a VirtualNode based Provider for a VirtualService.
     *
     * @stability stable
     */
    static virtualNode(virtualNode: IVirtualNode): VirtualServiceProvider;
    /**
     * Returns a VirtualRouter based Provider for a VirtualService.
     *
     * @stability stable
     */
    static virtualRouter(virtualRouter: IVirtualRouter): VirtualServiceProvider;
    /**
     * Returns an Empty Provider for a VirtualService.
     *
     * This provides no routing capabilities
     * and should only be used as a placeholder
     *
     * @stability stable
     */
    static none(mesh: IMesh): VirtualServiceProvider;
    /**
     * Enforces mutual exclusivity for VirtualService provider types.
     *
     * @stability stable
     */
    abstract bind(_construct: Construct): VirtualServiceProviderConfig;
}
