import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export interface CfnGatewayRouteProps {
    /**
     * `AWS::AppMesh::GatewayRoute.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-spec
     */
    readonly spec: CfnGatewayRoute.GatewayRouteSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::GatewayRoute.VirtualGatewayName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-virtualgatewayname
     */
    readonly virtualGatewayName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.GatewayRouteName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-gatewayroutename
     */
    readonly gatewayRouteName?: string;
    /**
     * `AWS::AppMesh::GatewayRoute.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshowner
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::GatewayRoute.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare class CfnGatewayRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::GatewayRoute";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGatewayRoute;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute GatewayRouteName
     */
    readonly attrGatewayRouteName: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualGatewayName
     */
    readonly attrVirtualGatewayName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-spec
     */
    spec: CfnGatewayRoute.GatewayRouteSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::GatewayRoute.VirtualGatewayName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-virtualgatewayname
     */
    virtualGatewayName: string;
    /**
     * `AWS::AppMesh::GatewayRoute.GatewayRouteName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-gatewayroutename
     */
    gatewayRouteName: string | undefined;
    /**
     * `AWS::AppMesh::GatewayRoute.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshowner
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::GatewayRoute.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::GatewayRoute`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGatewayRouteProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamematch.html
     */
    interface GatewayRouteHostnameMatchProperty {
        /**
         * `CfnGatewayRoute.GatewayRouteHostnameMatchProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamematch.html#cfn-appmesh-gatewayroute-gatewayroutehostnamematch-exact
         */
        readonly exact?: string;
        /**
         * `CfnGatewayRoute.GatewayRouteHostnameMatchProperty.Suffix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamematch.html#cfn-appmesh-gatewayroute-gatewayroutehostnamematch-suffix
         */
        readonly suffix?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamerewrite.html
     */
    interface GatewayRouteHostnameRewriteProperty {
        /**
         * `CfnGatewayRoute.GatewayRouteHostnameRewriteProperty.DefaultTargetHostname`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamerewrite.html#cfn-appmesh-gatewayroute-gatewayroutehostnamerewrite-defaulttargethostname
         */
        readonly defaultTargetHostname?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html
     */
    interface GatewayRouteMetadataMatchProperty {
        /**
         * `CfnGatewayRoute.GatewayRouteMetadataMatchProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-exact
         */
        readonly exact?: string;
        /**
         * `CfnGatewayRoute.GatewayRouteMetadataMatchProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnGatewayRoute.GatewayRouteMetadataMatchProperty.Range`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-range
         */
        readonly range?: CfnGatewayRoute.GatewayRouteRangeMatchProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GatewayRouteMetadataMatchProperty.Regex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-regex
         */
        readonly regex?: string;
        /**
         * `CfnGatewayRoute.GatewayRouteMetadataMatchProperty.Suffix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-suffix
         */
        readonly suffix?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayrouterangematch.html
     */
    interface GatewayRouteRangeMatchProperty {
        /**
         * `CfnGatewayRoute.GatewayRouteRangeMatchProperty.End`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayrouterangematch.html#cfn-appmesh-gatewayroute-gatewayrouterangematch-end
         */
        readonly end: number;
        /**
         * `CfnGatewayRoute.GatewayRouteRangeMatchProperty.Start`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayrouterangematch.html#cfn-appmesh-gatewayroute-gatewayrouterangematch-start
         */
        readonly start: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html
     */
    interface GatewayRouteSpecProperty {
        /**
         * `CfnGatewayRoute.GatewayRouteSpecProperty.GrpcRoute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-grpcroute
         */
        readonly grpcRoute?: CfnGatewayRoute.GrpcGatewayRouteProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GatewayRouteSpecProperty.Http2Route`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-http2route
         */
        readonly http2Route?: CfnGatewayRoute.HttpGatewayRouteProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GatewayRouteSpecProperty.HttpRoute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-httproute
         */
        readonly httpRoute?: CfnGatewayRoute.HttpGatewayRouteProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutetarget.html
     */
    interface GatewayRouteTargetProperty {
        /**
         * `CfnGatewayRoute.GatewayRouteTargetProperty.VirtualService`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutetarget.html#cfn-appmesh-gatewayroute-gatewayroutetarget-virtualservice
         */
        readonly virtualService: CfnGatewayRoute.GatewayRouteVirtualServiceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutevirtualservice.html
     */
    interface GatewayRouteVirtualServiceProperty {
        /**
         * `CfnGatewayRoute.GatewayRouteVirtualServiceProperty.VirtualServiceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutevirtualservice.html#cfn-appmesh-gatewayroute-gatewayroutevirtualservice-virtualservicename
         */
        readonly virtualServiceName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html
     */
    interface GrpcGatewayRouteProperty {
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html#cfn-appmesh-gatewayroute-grpcgatewayroute-action
         */
        readonly action: CfnGatewayRoute.GrpcGatewayRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html#cfn-appmesh-gatewayroute-grpcgatewayroute-match
         */
        readonly match: CfnGatewayRoute.GrpcGatewayRouteMatchProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html
     */
    interface GrpcGatewayRouteActionProperty {
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteActionProperty.Rewrite`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html#cfn-appmesh-gatewayroute-grpcgatewayrouteaction-rewrite
         */
        readonly rewrite?: CfnGatewayRoute.GrpcGatewayRouteRewriteProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteActionProperty.Target`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html#cfn-appmesh-gatewayroute-grpcgatewayrouteaction-target
         */
        readonly target: CfnGatewayRoute.GatewayRouteTargetProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html
     */
    interface GrpcGatewayRouteMatchProperty {
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteMatchProperty.Hostname`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-hostname
         */
        readonly hostname?: CfnGatewayRoute.GatewayRouteHostnameMatchProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteMatchProperty.Metadata`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-metadata
         */
        readonly metadata?: Array<CfnGatewayRoute.GrpcGatewayRouteMetadataProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteMatchProperty.ServiceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-servicename
         */
        readonly serviceName?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html
     */
    interface GrpcGatewayRouteMetadataProperty {
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteMetadataProperty.Invert`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html#cfn-appmesh-gatewayroute-grpcgatewayroutemetadata-invert
         */
        readonly invert?: boolean | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteMetadataProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html#cfn-appmesh-gatewayroute-grpcgatewayroutemetadata-match
         */
        readonly match?: CfnGatewayRoute.GatewayRouteMetadataMatchProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteMetadataProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html#cfn-appmesh-gatewayroute-grpcgatewayroutemetadata-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouterewrite.html
     */
    interface GrpcGatewayRouteRewriteProperty {
        /**
         * `CfnGatewayRoute.GrpcGatewayRouteRewriteProperty.Hostname`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouterewrite.html#cfn-appmesh-gatewayroute-grpcgatewayrouterewrite-hostname
         */
        readonly hostname?: CfnGatewayRoute.GatewayRouteHostnameRewriteProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html
     */
    interface HttpGatewayRouteProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRouteProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html#cfn-appmesh-gatewayroute-httpgatewayroute-action
         */
        readonly action: CfnGatewayRoute.HttpGatewayRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html#cfn-appmesh-gatewayroute-httpgatewayroute-match
         */
        readonly match: CfnGatewayRoute.HttpGatewayRouteMatchProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html
     */
    interface HttpGatewayRouteActionProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRouteActionProperty.Rewrite`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html#cfn-appmesh-gatewayroute-httpgatewayrouteaction-rewrite
         */
        readonly rewrite?: CfnGatewayRoute.HttpGatewayRouteRewriteProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteActionProperty.Target`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html#cfn-appmesh-gatewayroute-httpgatewayrouteaction-target
         */
        readonly target: CfnGatewayRoute.GatewayRouteTargetProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html
     */
    interface HttpGatewayRouteHeaderProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRouteHeaderProperty.Invert`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html#cfn-appmesh-gatewayroute-httpgatewayrouteheader-invert
         */
        readonly invert?: boolean | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteHeaderProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html#cfn-appmesh-gatewayroute-httpgatewayrouteheader-match
         */
        readonly match?: CfnGatewayRoute.HttpGatewayRouteHeaderMatchProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteHeaderProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html#cfn-appmesh-gatewayroute-httpgatewayrouteheader-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html
     */
    interface HttpGatewayRouteHeaderMatchProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRouteHeaderMatchProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-exact
         */
        readonly exact?: string;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteHeaderMatchProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteHeaderMatchProperty.Range`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-range
         */
        readonly range?: CfnGatewayRoute.GatewayRouteRangeMatchProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteHeaderMatchProperty.Regex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-regex
         */
        readonly regex?: string;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteHeaderMatchProperty.Suffix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-suffix
         */
        readonly suffix?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html
     */
    interface HttpGatewayRouteMatchProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRouteMatchProperty.Headers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-headers
         */
        readonly headers?: Array<CfnGatewayRoute.HttpGatewayRouteHeaderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteMatchProperty.Hostname`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-hostname
         */
        readonly hostname?: CfnGatewayRoute.GatewayRouteHostnameMatchProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteMatchProperty.Method`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-method
         */
        readonly method?: string;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteMatchProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-path
         */
        readonly path?: CfnGatewayRoute.HttpPathMatchProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteMatchProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteMatchProperty.QueryParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-queryparameters
         */
        readonly queryParameters?: Array<CfnGatewayRoute.QueryParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutepathrewrite.html
     */
    interface HttpGatewayRoutePathRewriteProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutepathrewrite.html#cfn-appmesh-gatewayroute-httpgatewayroutepathrewrite-exact
         */
        readonly exact?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteprefixrewrite.html
     */
    interface HttpGatewayRoutePrefixRewriteProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty.DefaultPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteprefixrewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouteprefixrewrite-defaultprefix
         */
        readonly defaultPrefix?: string;
        /**
         * `CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteprefixrewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouteprefixrewrite-value
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html
     */
    interface HttpGatewayRouteRewriteProperty {
        /**
         * `CfnGatewayRoute.HttpGatewayRouteRewriteProperty.Hostname`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouterewrite-hostname
         */
        readonly hostname?: CfnGatewayRoute.GatewayRouteHostnameRewriteProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteRewriteProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouterewrite-path
         */
        readonly path?: CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.HttpGatewayRouteRewriteProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouterewrite-prefix
         */
        readonly prefix?: CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httppathmatch.html
     */
    interface HttpPathMatchProperty {
        /**
         * `CfnGatewayRoute.HttpPathMatchProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httppathmatch.html#cfn-appmesh-gatewayroute-httppathmatch-exact
         */
        readonly exact?: string;
        /**
         * `CfnGatewayRoute.HttpPathMatchProperty.Regex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httppathmatch.html#cfn-appmesh-gatewayroute-httppathmatch-regex
         */
        readonly regex?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpqueryparametermatch.html
     */
    interface HttpQueryParameterMatchProperty {
        /**
         * `CfnGatewayRoute.HttpQueryParameterMatchProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpqueryparametermatch.html#cfn-appmesh-gatewayroute-httpqueryparametermatch-exact
         */
        readonly exact?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::GatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::GatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html
 */
export declare namespace CfnGatewayRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-queryparameter.html
     */
    interface QueryParameterProperty {
        /**
         * `CfnGatewayRoute.QueryParameterProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-queryparameter.html#cfn-appmesh-gatewayroute-queryparameter-match
         */
        readonly match?: CfnGatewayRoute.HttpQueryParameterMatchProperty | cdk.IResolvable;
        /**
         * `CfnGatewayRoute.QueryParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-queryparameter.html#cfn-appmesh-gatewayroute-queryparameter-name
         */
        readonly name: string;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::Mesh`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html
 */
export interface CfnMeshProps {
    /**
     * `AWS::AppMesh::Mesh.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-meshname
     */
    readonly meshName?: string;
    /**
     * `AWS::AppMesh::Mesh.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-spec
     */
    readonly spec?: CfnMesh.MeshSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::Mesh.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::Mesh`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Mesh
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html
 */
export declare class CfnMesh extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::Mesh";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMesh;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * `AWS::AppMesh::Mesh.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-meshname
     */
    meshName: string | undefined;
    /**
     * `AWS::AppMesh::Mesh.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-spec
     */
    spec: CfnMesh.MeshSpecProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppMesh::Mesh.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::Mesh`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnMeshProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::Mesh`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Mesh
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html
 */
export declare namespace CfnMesh {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-egressfilter.html
     */
    interface EgressFilterProperty {
        /**
         * `CfnMesh.EgressFilterProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-egressfilter.html#cfn-appmesh-mesh-egressfilter-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Mesh`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Mesh
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html
 */
export declare namespace CfnMesh {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-meshspec.html
     */
    interface MeshSpecProperty {
        /**
         * `CfnMesh.MeshSpecProperty.EgressFilter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-meshspec.html#cfn-appmesh-mesh-meshspec-egressfilter
         */
        readonly egressFilter?: CfnMesh.EgressFilterProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::Route`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export interface CfnRouteProps {
    /**
     * `AWS::AppMesh::Route.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::Route.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec
     */
    readonly spec: CfnRoute.RouteSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::Route.VirtualRouterName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-virtualroutername
     */
    readonly virtualRouterName: string;
    /**
     * `AWS::AppMesh::Route.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshowner
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::Route.RouteName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-routename
     */
    readonly routeName?: string;
    /**
     * `AWS::AppMesh::Route.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare class CfnRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::Route";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRoute;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute RouteName
     */
    readonly attrRouteName: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualRouterName
     */
    readonly attrVirtualRouterName: string;
    /**
     * `AWS::AppMesh::Route.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::Route.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec
     */
    spec: CfnRoute.RouteSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::Route.VirtualRouterName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-virtualroutername
     */
    virtualRouterName: string;
    /**
     * `AWS::AppMesh::Route.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshowner
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::Route.RouteName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-routename
     */
    routeName: string | undefined;
    /**
     * `AWS::AppMesh::Route.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::Route`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html
     */
    interface DurationProperty {
        /**
         * `CfnRoute.DurationProperty.Unit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html#cfn-appmesh-route-duration-unit
         */
        readonly unit: string;
        /**
         * `CfnRoute.DurationProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html#cfn-appmesh-route-duration-value
         */
        readonly value: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html
     */
    interface GrpcRetryPolicyProperty {
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.GrpcRetryEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-grpcretryevents
         */
        readonly grpcRetryEvents?: string[];
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.HttpRetryEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-httpretryevents
         */
        readonly httpRetryEvents?: string[];
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.MaxRetries`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-maxretries
         */
        readonly maxRetries: number;
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.PerRetryTimeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-perretrytimeout
         */
        readonly perRetryTimeout: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.TcpRetryEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-tcpretryevents
         */
        readonly tcpRetryEvents?: string[];
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html
     */
    interface GrpcRouteProperty {
        /**
         * `CfnRoute.GrpcRouteProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-action
         */
        readonly action: CfnRoute.GrpcRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-match
         */
        readonly match: CfnRoute.GrpcRouteMatchProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteProperty.RetryPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-retrypolicy
         */
        readonly retryPolicy?: CfnRoute.GrpcRetryPolicyProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteProperty.Timeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-timeout
         */
        readonly timeout?: CfnRoute.GrpcTimeoutProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcrouteaction.html
     */
    interface GrpcRouteActionProperty {
        /**
         * `CfnRoute.GrpcRouteActionProperty.WeightedTargets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcrouteaction.html#cfn-appmesh-route-grpcrouteaction-weightedtargets
         */
        readonly weightedTargets: Array<CfnRoute.WeightedTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html
     */
    interface GrpcRouteMatchProperty {
        /**
         * `CfnRoute.GrpcRouteMatchProperty.Metadata`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-metadata
         */
        readonly metadata?: Array<CfnRoute.GrpcRouteMetadataProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMatchProperty.MethodName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-methodname
         */
        readonly methodName?: string;
        /**
         * `CfnRoute.GrpcRouteMatchProperty.ServiceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-servicename
         */
        readonly serviceName?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html
     */
    interface GrpcRouteMetadataProperty {
        /**
         * `CfnRoute.GrpcRouteMetadataProperty.Invert`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-invert
         */
        readonly invert?: boolean | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMetadataProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-match
         */
        readonly match?: CfnRoute.GrpcRouteMetadataMatchMethodProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMetadataProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html
     */
    interface GrpcRouteMetadataMatchMethodProperty {
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-exact
         */
        readonly exact?: string;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Range`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-range
         */
        readonly range?: CfnRoute.MatchRangeProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Regex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-regex
         */
        readonly regex?: string;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Suffix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-suffix
         */
        readonly suffix?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html
     */
    interface GrpcTimeoutProperty {
        /**
         * `CfnRoute.GrpcTimeoutProperty.Idle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html#cfn-appmesh-route-grpctimeout-idle
         */
        readonly idle?: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcTimeoutProperty.PerRequest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html#cfn-appmesh-route-grpctimeout-perrequest
         */
        readonly perRequest?: CfnRoute.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html
     */
    interface HeaderMatchMethodProperty {
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-exact
         */
        readonly exact?: string;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Range`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-range
         */
        readonly range?: CfnRoute.MatchRangeProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Regex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-regex
         */
        readonly regex?: string;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Suffix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-suffix
         */
        readonly suffix?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httppathmatch.html
     */
    interface HttpPathMatchProperty {
        /**
         * `CfnRoute.HttpPathMatchProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httppathmatch.html#cfn-appmesh-route-httppathmatch-exact
         */
        readonly exact?: string;
        /**
         * `CfnRoute.HttpPathMatchProperty.Regex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httppathmatch.html#cfn-appmesh-route-httppathmatch-regex
         */
        readonly regex?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpqueryparametermatch.html
     */
    interface HttpQueryParameterMatchProperty {
        /**
         * `CfnRoute.HttpQueryParameterMatchProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpqueryparametermatch.html#cfn-appmesh-route-httpqueryparametermatch-exact
         */
        readonly exact?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html
     */
    interface HttpRetryPolicyProperty {
        /**
         * `CfnRoute.HttpRetryPolicyProperty.HttpRetryEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-httpretryevents
         */
        readonly httpRetryEvents?: string[];
        /**
         * `CfnRoute.HttpRetryPolicyProperty.MaxRetries`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-maxretries
         */
        readonly maxRetries: number;
        /**
         * `CfnRoute.HttpRetryPolicyProperty.PerRetryTimeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-perretrytimeout
         */
        readonly perRetryTimeout: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRetryPolicyProperty.TcpRetryEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-tcpretryevents
         */
        readonly tcpRetryEvents?: string[];
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html
     */
    interface HttpRouteProperty {
        /**
         * `CfnRoute.HttpRouteProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-action
         */
        readonly action: CfnRoute.HttpRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-match
         */
        readonly match: CfnRoute.HttpRouteMatchProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteProperty.RetryPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-retrypolicy
         */
        readonly retryPolicy?: CfnRoute.HttpRetryPolicyProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteProperty.Timeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-timeout
         */
        readonly timeout?: CfnRoute.HttpTimeoutProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteaction.html
     */
    interface HttpRouteActionProperty {
        /**
         * `CfnRoute.HttpRouteActionProperty.WeightedTargets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteaction.html#cfn-appmesh-route-httprouteaction-weightedtargets
         */
        readonly weightedTargets: Array<CfnRoute.WeightedTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html
     */
    interface HttpRouteHeaderProperty {
        /**
         * `CfnRoute.HttpRouteHeaderProperty.Invert`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-invert
         */
        readonly invert?: boolean | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteHeaderProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-match
         */
        readonly match?: CfnRoute.HeaderMatchMethodProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteHeaderProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html
     */
    interface HttpRouteMatchProperty {
        /**
         * `CfnRoute.HttpRouteMatchProperty.Headers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-headers
         */
        readonly headers?: Array<CfnRoute.HttpRouteHeaderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteMatchProperty.Method`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-method
         */
        readonly method?: string;
        /**
         * `CfnRoute.HttpRouteMatchProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-path
         */
        readonly path?: CfnRoute.HttpPathMatchProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteMatchProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnRoute.HttpRouteMatchProperty.QueryParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-queryparameters
         */
        readonly queryParameters?: Array<CfnRoute.QueryParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteMatchProperty.Scheme`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-scheme
         */
        readonly scheme?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html
     */
    interface HttpTimeoutProperty {
        /**
         * `CfnRoute.HttpTimeoutProperty.Idle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html#cfn-appmesh-route-httptimeout-idle
         */
        readonly idle?: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpTimeoutProperty.PerRequest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html#cfn-appmesh-route-httptimeout-perrequest
         */
        readonly perRequest?: CfnRoute.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html
     */
    interface MatchRangeProperty {
        /**
         * `CfnRoute.MatchRangeProperty.End`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html#cfn-appmesh-route-matchrange-end
         */
        readonly end: number;
        /**
         * `CfnRoute.MatchRangeProperty.Start`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html#cfn-appmesh-route-matchrange-start
         */
        readonly start: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-queryparameter.html
     */
    interface QueryParameterProperty {
        /**
         * `CfnRoute.QueryParameterProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-queryparameter.html#cfn-appmesh-route-queryparameter-match
         */
        readonly match?: CfnRoute.HttpQueryParameterMatchProperty | cdk.IResolvable;
        /**
         * `CfnRoute.QueryParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-queryparameter.html#cfn-appmesh-route-queryparameter-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html
     */
    interface RouteSpecProperty {
        /**
         * `CfnRoute.RouteSpecProperty.GrpcRoute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-grpcroute
         */
        readonly grpcRoute?: CfnRoute.GrpcRouteProperty | cdk.IResolvable;
        /**
         * `CfnRoute.RouteSpecProperty.Http2Route`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-http2route
         */
        readonly http2Route?: CfnRoute.HttpRouteProperty | cdk.IResolvable;
        /**
         * `CfnRoute.RouteSpecProperty.HttpRoute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-httproute
         */
        readonly httpRoute?: CfnRoute.HttpRouteProperty | cdk.IResolvable;
        /**
         * `CfnRoute.RouteSpecProperty.Priority`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-priority
         */
        readonly priority?: number;
        /**
         * `CfnRoute.RouteSpecProperty.TcpRoute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-tcproute
         */
        readonly tcpRoute?: CfnRoute.TcpRouteProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html
     */
    interface TcpRouteProperty {
        /**
         * `CfnRoute.TcpRouteProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-action
         */
        readonly action: CfnRoute.TcpRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnRoute.TcpRouteProperty.Timeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-timeout
         */
        readonly timeout?: CfnRoute.TcpTimeoutProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcprouteaction.html
     */
    interface TcpRouteActionProperty {
        /**
         * `CfnRoute.TcpRouteActionProperty.WeightedTargets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcprouteaction.html#cfn-appmesh-route-tcprouteaction-weightedtargets
         */
        readonly weightedTargets: Array<CfnRoute.WeightedTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcptimeout.html
     */
    interface TcpTimeoutProperty {
        /**
         * `CfnRoute.TcpTimeoutProperty.Idle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcptimeout.html#cfn-appmesh-route-tcptimeout-idle
         */
        readonly idle?: CfnRoute.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::Route`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare namespace CfnRoute {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html
     */
    interface WeightedTargetProperty {
        /**
         * `CfnRoute.WeightedTargetProperty.VirtualNode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-virtualnode
         */
        readonly virtualNode: string;
        /**
         * `CfnRoute.WeightedTargetProperty.Weight`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-weight
         */
        readonly weight: number;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export interface CfnVirtualGatewayProps {
    /**
     * `AWS::AppMesh::VirtualGateway.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualGateway.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-spec
     */
    readonly spec: CfnVirtualGateway.VirtualGatewaySpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualGateway.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshowner
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::AppMesh::VirtualGateway.VirtualGatewayName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-virtualgatewayname
     */
    readonly virtualGatewayName?: string;
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare class CfnVirtualGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVirtualGateway;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualGatewayName
     */
    readonly attrVirtualGatewayName: string;
    /**
     * `AWS::AppMesh::VirtualGateway.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualGateway.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-spec
     */
    spec: CfnVirtualGateway.VirtualGatewaySpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualGateway.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshowner
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AppMesh::VirtualGateway.VirtualGatewayName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-virtualgatewayname
     */
    virtualGatewayName: string | undefined;
    /**
     * Create a new `AWS::AppMesh::VirtualGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualGatewayProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenamematchers.html
     */
    interface SubjectAlternativeNameMatchersProperty {
        /**
         * `CfnVirtualGateway.SubjectAlternativeNameMatchersProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenamematchers.html#cfn-appmesh-virtualgateway-subjectalternativenamematchers-exact
         */
        readonly exact?: string[];
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenames.html
     */
    interface SubjectAlternativeNamesProperty {
        /**
         * `CfnVirtualGateway.SubjectAlternativeNamesProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenames.html#cfn-appmesh-virtualgateway-subjectalternativenames-match
         */
        readonly match: CfnVirtualGateway.SubjectAlternativeNameMatchersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayaccesslog.html
     */
    interface VirtualGatewayAccessLogProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayAccessLogProperty.File`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayaccesslog.html#cfn-appmesh-virtualgateway-virtualgatewayaccesslog-file
         */
        readonly file?: CfnVirtualGateway.VirtualGatewayFileAccessLogProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaybackenddefaults.html
     */
    interface VirtualGatewayBackendDefaultsProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayBackendDefaultsProperty.ClientPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaybackenddefaults.html#cfn-appmesh-virtualgateway-virtualgatewaybackenddefaults-clientpolicy
         */
        readonly clientPolicy?: CfnVirtualGateway.VirtualGatewayClientPolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicy.html
     */
    interface VirtualGatewayClientPolicyProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayClientPolicyProperty.TLS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicy-tls
         */
        readonly tls?: CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html
     */
    interface VirtualGatewayClientPolicyTlsProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty.Certificate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-certificate
         */
        readonly certificate?: CfnVirtualGateway.VirtualGatewayClientTlsCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty.Enforce`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-enforce
         */
        readonly enforce?: boolean | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty.Ports`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-ports
         */
        readonly ports?: number[] | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty.Validation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-validation
         */
        readonly validation: CfnVirtualGateway.VirtualGatewayTlsValidationContextProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclienttlscertificate.html
     */
    interface VirtualGatewayClientTlsCertificateProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayClientTlsCertificateProperty.File`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclienttlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewayclienttlscertificate-file
         */
        readonly file?: CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayClientTlsCertificateProperty.SDS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclienttlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewayclienttlscertificate-sds
         */
        readonly sds?: CfnVirtualGateway.VirtualGatewayListenerTlsSdsCertificateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html
     */
    interface VirtualGatewayConnectionPoolProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayConnectionPoolProperty.GRPC`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayconnectionpool-grpc
         */
        readonly grpc?: CfnVirtualGateway.VirtualGatewayGrpcConnectionPoolProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayConnectionPoolProperty.HTTP`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayconnectionpool-http
         */
        readonly http?: CfnVirtualGateway.VirtualGatewayHttpConnectionPoolProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayConnectionPoolProperty.HTTP2`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayconnectionpool-http2
         */
        readonly http2?: CfnVirtualGateway.VirtualGatewayHttp2ConnectionPoolProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayfileaccesslog.html
     */
    interface VirtualGatewayFileAccessLogProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayFileAccessLogProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayfileaccesslog.html#cfn-appmesh-virtualgateway-virtualgatewayfileaccesslog-path
         */
        readonly path: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaygrpcconnectionpool.html
     */
    interface VirtualGatewayGrpcConnectionPoolProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayGrpcConnectionPoolProperty.MaxRequests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaygrpcconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewaygrpcconnectionpool-maxrequests
         */
        readonly maxRequests: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html
     */
    interface VirtualGatewayHealthCheckPolicyProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.HealthyThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-healthythreshold
         */
        readonly healthyThreshold: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.IntervalMillis`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-intervalmillis
         */
        readonly intervalMillis: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-path
         */
        readonly path?: string;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-port
         */
        readonly port?: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-protocol
         */
        readonly protocol: string;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.TimeoutMillis`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-timeoutmillis
         */
        readonly timeoutMillis: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty.UnhealthyThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-unhealthythreshold
         */
        readonly unhealthyThreshold: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttp2connectionpool.html
     */
    interface VirtualGatewayHttp2ConnectionPoolProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayHttp2ConnectionPoolProperty.MaxRequests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttp2connectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayhttp2connectionpool-maxrequests
         */
        readonly maxRequests: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttpconnectionpool.html
     */
    interface VirtualGatewayHttpConnectionPoolProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayHttpConnectionPoolProperty.MaxConnections`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttpconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayhttpconnectionpool-maxconnections
         */
        readonly maxConnections: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayHttpConnectionPoolProperty.MaxPendingRequests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttpconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayhttpconnectionpool-maxpendingrequests
         */
        readonly maxPendingRequests?: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html
     */
    interface VirtualGatewayListenerProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerProperty.ConnectionPool`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-connectionpool
         */
        readonly connectionPool?: CfnVirtualGateway.VirtualGatewayConnectionPoolProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerProperty.HealthCheck`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-healthcheck
         */
        readonly healthCheck?: CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerProperty.PortMapping`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-portmapping
         */
        readonly portMapping: CfnVirtualGateway.VirtualGatewayPortMappingProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerProperty.TLS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-tls
         */
        readonly tls?: CfnVirtualGateway.VirtualGatewayListenerTlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html
     */
    interface VirtualGatewayListenerTlsProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsProperty.Certificate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-certificate
         */
        readonly certificate: CfnVirtualGateway.VirtualGatewayListenerTlsCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsProperty.Mode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-mode
         */
        readonly mode: string;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsProperty.Validation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-validation
         */
        readonly validation?: CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate.html
     */
    interface VirtualGatewayListenerTlsAcmCertificateProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsAcmCertificateProperty.CertificateArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate-certificatearn
         */
        readonly certificateArn: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html
     */
    interface VirtualGatewayListenerTlsCertificateProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsCertificateProperty.ACM`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-acm
         */
        readonly acm?: CfnVirtualGateway.VirtualGatewayListenerTlsAcmCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsCertificateProperty.File`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-file
         */
        readonly file?: CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsCertificateProperty.SDS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-sds
         */
        readonly sds?: CfnVirtualGateway.VirtualGatewayListenerTlsSdsCertificateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html
     */
    interface VirtualGatewayListenerTlsFileCertificateProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty.CertificateChain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate-certificatechain
         */
        readonly certificateChain: string;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty.PrivateKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate-privatekey
         */
        readonly privateKey: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlssdscertificate.html
     */
    interface VirtualGatewayListenerTlsSdsCertificateProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsSdsCertificateProperty.SecretName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlssdscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlssdscertificate-secretname
         */
        readonly secretName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext.html
     */
    interface VirtualGatewayListenerTlsValidationContextProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextProperty.SubjectAlternativeNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext-subjectalternativenames
         */
        readonly subjectAlternativeNames?: CfnVirtualGateway.SubjectAlternativeNamesProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextProperty.Trust`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext-trust
         */
        readonly trust: CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextTrustProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust.html
     */
    interface VirtualGatewayListenerTlsValidationContextTrustProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextTrustProperty.File`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust-file
         */
        readonly file?: CfnVirtualGateway.VirtualGatewayTlsValidationContextFileTrustProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextTrustProperty.SDS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust-sds
         */
        readonly sds?: CfnVirtualGateway.VirtualGatewayTlsValidationContextSdsTrustProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylogging.html
     */
    interface VirtualGatewayLoggingProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayLoggingProperty.AccessLog`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylogging.html#cfn-appmesh-virtualgateway-virtualgatewaylogging-accesslog
         */
        readonly accessLog?: CfnVirtualGateway.VirtualGatewayAccessLogProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html
     */
    interface VirtualGatewayPortMappingProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayPortMappingProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html#cfn-appmesh-virtualgateway-virtualgatewayportmapping-port
         */
        readonly port: number;
        /**
         * `CfnVirtualGateway.VirtualGatewayPortMappingProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html#cfn-appmesh-virtualgateway-virtualgatewayportmapping-protocol
         */
        readonly protocol: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html
     */
    interface VirtualGatewaySpecProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewaySpecProperty.BackendDefaults`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-backenddefaults
         */
        readonly backendDefaults?: CfnVirtualGateway.VirtualGatewayBackendDefaultsProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewaySpecProperty.Listeners`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-listeners
         */
        readonly listeners: Array<CfnVirtualGateway.VirtualGatewayListenerProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewaySpecProperty.Logging`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-logging
         */
        readonly logging?: CfnVirtualGateway.VirtualGatewayLoggingProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html
     */
    interface VirtualGatewayTlsValidationContextProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextProperty.SubjectAlternativeNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext-subjectalternativenames
         */
        readonly subjectAlternativeNames?: CfnVirtualGateway.SubjectAlternativeNamesProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextProperty.Trust`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext-trust
         */
        readonly trust: CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust.html
     */
    interface VirtualGatewayTlsValidationContextAcmTrustProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextAcmTrustProperty.CertificateAuthorityArns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust-certificateauthorityarns
         */
        readonly certificateAuthorityArns: string[];
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust.html
     */
    interface VirtualGatewayTlsValidationContextFileTrustProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextFileTrustProperty.CertificateChain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust-certificatechain
         */
        readonly certificateChain: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextsdstrust.html
     */
    interface VirtualGatewayTlsValidationContextSdsTrustProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextSdsTrustProperty.SecretName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextsdstrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextsdstrust-secretname
         */
        readonly secretName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualGateway`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html
 */
export declare namespace CfnVirtualGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html
     */
    interface VirtualGatewayTlsValidationContextTrustProperty {
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty.ACM`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-acm
         */
        readonly acm?: CfnVirtualGateway.VirtualGatewayTlsValidationContextAcmTrustProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty.File`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-file
         */
        readonly file?: CfnVirtualGateway.VirtualGatewayTlsValidationContextFileTrustProperty | cdk.IResolvable;
        /**
         * `CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty.SDS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-sds
         */
        readonly sds?: CfnVirtualGateway.VirtualGatewayTlsValidationContextSdsTrustProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export interface CfnVirtualNodeProps {
    /**
     * `AWS::AppMesh::VirtualNode.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualNode.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-spec
     */
    readonly spec: CfnVirtualNode.VirtualNodeSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualNode.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshowner
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualNode.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::AppMesh::VirtualNode.VirtualNodeName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-virtualnodename
     */
    readonly virtualNodeName?: string;
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare class CfnVirtualNode extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualNode";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVirtualNode;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualNodeName
     */
    readonly attrVirtualNodeName: string;
    /**
     * `AWS::AppMesh::VirtualNode.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualNode.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-spec
     */
    spec: CfnVirtualNode.VirtualNodeSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualNode.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshowner
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualNode.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AppMesh::VirtualNode.VirtualNodeName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-virtualnodename
     */
    virtualNodeName: string | undefined;
    /**
     * Create a new `AWS::AppMesh::VirtualNode`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualNodeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-accesslog.html
     */
    interface AccessLogProperty {
        /**
         * `CfnVirtualNode.AccessLogProperty.File`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-accesslog.html#cfn-appmesh-virtualnode-accesslog-file
         */
        readonly file?: CfnVirtualNode.FileAccessLogProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapinstanceattribute.html
     */
    interface AwsCloudMapInstanceAttributeProperty {
        /**
         * `CfnVirtualNode.AwsCloudMapInstanceAttributeProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapinstanceattribute.html#cfn-appmesh-virtualnode-awscloudmapinstanceattribute-key
         */
        readonly key: string;
        /**
         * `CfnVirtualNode.AwsCloudMapInstanceAttributeProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapinstanceattribute.html#cfn-appmesh-virtualnode-awscloudmapinstanceattribute-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html
     */
    interface AwsCloudMapServiceDiscoveryProperty {
        /**
         * `CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html#cfn-appmesh-virtualnode-awscloudmapservicediscovery-attributes
         */
        readonly attributes?: Array<CfnVirtualNode.AwsCloudMapInstanceAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty.NamespaceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html#cfn-appmesh-virtualnode-awscloudmapservicediscovery-namespacename
         */
        readonly namespaceName: string;
        /**
         * `CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty.ServiceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html#cfn-appmesh-virtualnode-awscloudmapservicediscovery-servicename
         */
        readonly serviceName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backend.html
     */
    interface BackendProperty {
        /**
         * `CfnVirtualNode.BackendProperty.VirtualService`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backend.html#cfn-appmesh-virtualnode-backend-virtualservice
         */
        readonly virtualService?: CfnVirtualNode.VirtualServiceBackendProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backenddefaults.html
     */
    interface BackendDefaultsProperty {
        /**
         * `CfnVirtualNode.BackendDefaultsProperty.ClientPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backenddefaults.html#cfn-appmesh-virtualnode-backenddefaults-clientpolicy
         */
        readonly clientPolicy?: CfnVirtualNode.ClientPolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicy.html
     */
    interface ClientPolicyProperty {
        /**
         * `CfnVirtualNode.ClientPolicyProperty.TLS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicy.html#cfn-appmesh-virtualnode-clientpolicy-tls
         */
        readonly tls?: CfnVirtualNode.ClientPolicyTlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html
     */
    interface ClientPolicyTlsProperty {
        /**
         * `CfnVirtualNode.ClientPolicyTlsProperty.Certificate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html#cfn-appmesh-virtualnode-clientpolicytls-certificate
         */
        readonly certificate?: CfnVirtualNode.ClientTlsCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ClientPolicyTlsProperty.Enforce`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html#cfn-appmesh-virtualnode-clientpolicytls-enforce
         */
        readonly enforce?: boolean | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ClientPolicyTlsProperty.Ports`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html#cfn-appmesh-virtualnode-clientpolicytls-ports
         */
        readonly ports?: number[] | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ClientPolicyTlsProperty.Validation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html#cfn-appmesh-virtualnode-clientpolicytls-validation
         */
        readonly validation: CfnVirtualNode.TlsValidationContextProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clienttlscertificate.html
     */
    interface ClientTlsCertificateProperty {
        /**
         * `CfnVirtualNode.ClientTlsCertificateProperty.File`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clienttlscertificate.html#cfn-appmesh-virtualnode-clienttlscertificate-file
         */
        readonly file?: CfnVirtualNode.ListenerTlsFileCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ClientTlsCertificateProperty.SDS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clienttlscertificate.html#cfn-appmesh-virtualnode-clienttlscertificate-sds
         */
        readonly sds?: CfnVirtualNode.ListenerTlsSdsCertificateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-dnsservicediscovery.html
     */
    interface DnsServiceDiscoveryProperty {
        /**
         * `CfnVirtualNode.DnsServiceDiscoveryProperty.Hostname`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-dnsservicediscovery.html#cfn-appmesh-virtualnode-dnsservicediscovery-hostname
         */
        readonly hostname: string;
        /**
         * `CfnVirtualNode.DnsServiceDiscoveryProperty.ResponseType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-dnsservicediscovery.html#cfn-appmesh-virtualnode-dnsservicediscovery-responsetype
         */
        readonly responseType?: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-duration.html
     */
    interface DurationProperty {
        /**
         * `CfnVirtualNode.DurationProperty.Unit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-duration.html#cfn-appmesh-virtualnode-duration-unit
         */
        readonly unit: string;
        /**
         * `CfnVirtualNode.DurationProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-duration.html#cfn-appmesh-virtualnode-duration-value
         */
        readonly value: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-fileaccesslog.html
     */
    interface FileAccessLogProperty {
        /**
         * `CfnVirtualNode.FileAccessLogProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-fileaccesslog.html#cfn-appmesh-virtualnode-fileaccesslog-path
         */
        readonly path: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-grpctimeout.html
     */
    interface GrpcTimeoutProperty {
        /**
         * `CfnVirtualNode.GrpcTimeoutProperty.Idle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-grpctimeout.html#cfn-appmesh-virtualnode-grpctimeout-idle
         */
        readonly idle?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.GrpcTimeoutProperty.PerRequest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-grpctimeout.html#cfn-appmesh-virtualnode-grpctimeout-perrequest
         */
        readonly perRequest?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html
     */
    interface HealthCheckProperty {
        /**
         * `CfnVirtualNode.HealthCheckProperty.HealthyThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-healthythreshold
         */
        readonly healthyThreshold: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.IntervalMillis`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-intervalmillis
         */
        readonly intervalMillis: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-path
         */
        readonly path?: string;
        /**
         * `CfnVirtualNode.HealthCheckProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-port
         */
        readonly port?: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-protocol
         */
        readonly protocol: string;
        /**
         * `CfnVirtualNode.HealthCheckProperty.TimeoutMillis`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-timeoutmillis
         */
        readonly timeoutMillis: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.UnhealthyThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-unhealthythreshold
         */
        readonly unhealthyThreshold: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-httptimeout.html
     */
    interface HttpTimeoutProperty {
        /**
         * `CfnVirtualNode.HttpTimeoutProperty.Idle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-httptimeout.html#cfn-appmesh-virtualnode-httptimeout-idle
         */
        readonly idle?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.HttpTimeoutProperty.PerRequest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-httptimeout.html#cfn-appmesh-virtualnode-httptimeout-perrequest
         */
        readonly perRequest?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html
     */
    interface ListenerProperty {
        /**
         * `CfnVirtualNode.ListenerProperty.ConnectionPool`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-connectionpool
         */
        readonly connectionPool?: CfnVirtualNode.VirtualNodeConnectionPoolProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.HealthCheck`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-healthcheck
         */
        readonly healthCheck?: CfnVirtualNode.HealthCheckProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.OutlierDetection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-outlierdetection
         */
        readonly outlierDetection?: CfnVirtualNode.OutlierDetectionProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.PortMapping`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-portmapping
         */
        readonly portMapping: CfnVirtualNode.PortMappingProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.TLS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-tls
         */
        readonly tls?: CfnVirtualNode.ListenerTlsProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.Timeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-timeout
         */
        readonly timeout?: CfnVirtualNode.ListenerTimeoutProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html
     */
    interface ListenerTimeoutProperty {
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.GRPC`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-grpc
         */
        readonly grpc?: CfnVirtualNode.GrpcTimeoutProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.HTTP`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-http
         */
        readonly http?: CfnVirtualNode.HttpTimeoutProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.HTTP2`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-http2
         */
        readonly http2?: CfnVirtualNode.HttpTimeoutProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.TCP`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-tcp
         */
        readonly tcp?: CfnVirtualNode.TcpTimeoutProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertls.html
     */
    interface ListenerTlsProperty {
        /**
         * `CfnVirtualNode.ListenerTlsProperty.Certificate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertls.html#cfn-appmesh-virtualnode-listenertls-certificate
         */
        readonly certificate: CfnVirtualNode.ListenerTlsCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTlsProperty.Mode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertls.html#cfn-appmesh-virtualnode-listenertls-mode
         */
        readonly mode: string;
        /**
         * `CfnVirtualNode.ListenerTlsProperty.Validation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertls.html#cfn-appmesh-virtualnode-listenertls-validation
         */
        readonly validation?: CfnVirtualNode.ListenerTlsValidationContextProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsacmcertificate.html
     */
    interface ListenerTlsAcmCertificateProperty {
        /**
         * `CfnVirtualNode.ListenerTlsAcmCertificateProperty.CertificateArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsacmcertificate.html#cfn-appmesh-virtualnode-listenertlsacmcertificate-certificatearn
         */
        readonly certificateArn: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlscertificate.html
     */
    interface ListenerTlsCertificateProperty {
        /**
         * `CfnVirtualNode.ListenerTlsCertificateProperty.ACM`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlscertificate.html#cfn-appmesh-virtualnode-listenertlscertificate-acm
         */
        readonly acm?: CfnVirtualNode.ListenerTlsAcmCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTlsCertificateProperty.File`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlscertificate.html#cfn-appmesh-virtualnode-listenertlscertificate-file
         */
        readonly file?: CfnVirtualNode.ListenerTlsFileCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTlsCertificateProperty.SDS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlscertificate.html#cfn-appmesh-virtualnode-listenertlscertificate-sds
         */
        readonly sds?: CfnVirtualNode.ListenerTlsSdsCertificateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsfilecertificate.html
     */
    interface ListenerTlsFileCertificateProperty {
        /**
         * `CfnVirtualNode.ListenerTlsFileCertificateProperty.CertificateChain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsfilecertificate.html#cfn-appmesh-virtualnode-listenertlsfilecertificate-certificatechain
         */
        readonly certificateChain: string;
        /**
         * `CfnVirtualNode.ListenerTlsFileCertificateProperty.PrivateKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsfilecertificate.html#cfn-appmesh-virtualnode-listenertlsfilecertificate-privatekey
         */
        readonly privateKey: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlssdscertificate.html
     */
    interface ListenerTlsSdsCertificateProperty {
        /**
         * `CfnVirtualNode.ListenerTlsSdsCertificateProperty.SecretName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlssdscertificate.html#cfn-appmesh-virtualnode-listenertlssdscertificate-secretname
         */
        readonly secretName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsvalidationcontext.html
     */
    interface ListenerTlsValidationContextProperty {
        /**
         * `CfnVirtualNode.ListenerTlsValidationContextProperty.SubjectAlternativeNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsvalidationcontext.html#cfn-appmesh-virtualnode-listenertlsvalidationcontext-subjectalternativenames
         */
        readonly subjectAlternativeNames?: CfnVirtualNode.SubjectAlternativeNamesProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTlsValidationContextProperty.Trust`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsvalidationcontext.html#cfn-appmesh-virtualnode-listenertlsvalidationcontext-trust
         */
        readonly trust: CfnVirtualNode.ListenerTlsValidationContextTrustProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsvalidationcontexttrust.html
     */
    interface ListenerTlsValidationContextTrustProperty {
        /**
         * `CfnVirtualNode.ListenerTlsValidationContextTrustProperty.File`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsvalidationcontexttrust.html#cfn-appmesh-virtualnode-listenertlsvalidationcontexttrust-file
         */
        readonly file?: CfnVirtualNode.TlsValidationContextFileTrustProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTlsValidationContextTrustProperty.SDS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsvalidationcontexttrust.html#cfn-appmesh-virtualnode-listenertlsvalidationcontexttrust-sds
         */
        readonly sds?: CfnVirtualNode.TlsValidationContextSdsTrustProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-logging.html
     */
    interface LoggingProperty {
        /**
         * `CfnVirtualNode.LoggingProperty.AccessLog`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-logging.html#cfn-appmesh-virtualnode-logging-accesslog
         */
        readonly accessLog?: CfnVirtualNode.AccessLogProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-outlierdetection.html
     */
    interface OutlierDetectionProperty {
        /**
         * `CfnVirtualNode.OutlierDetectionProperty.BaseEjectionDuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-outlierdetection.html#cfn-appmesh-virtualnode-outlierdetection-baseejectionduration
         */
        readonly baseEjectionDuration: CfnVirtualNode.DurationProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.OutlierDetectionProperty.Interval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-outlierdetection.html#cfn-appmesh-virtualnode-outlierdetection-interval
         */
        readonly interval: CfnVirtualNode.DurationProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.OutlierDetectionProperty.MaxEjectionPercent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-outlierdetection.html#cfn-appmesh-virtualnode-outlierdetection-maxejectionpercent
         */
        readonly maxEjectionPercent: number;
        /**
         * `CfnVirtualNode.OutlierDetectionProperty.MaxServerErrors`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-outlierdetection.html#cfn-appmesh-virtualnode-outlierdetection-maxservererrors
         */
        readonly maxServerErrors: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-portmapping.html
     */
    interface PortMappingProperty {
        /**
         * `CfnVirtualNode.PortMappingProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-portmapping.html#cfn-appmesh-virtualnode-portmapping-port
         */
        readonly port: number;
        /**
         * `CfnVirtualNode.PortMappingProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-portmapping.html#cfn-appmesh-virtualnode-portmapping-protocol
         */
        readonly protocol: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-servicediscovery.html
     */
    interface ServiceDiscoveryProperty {
        /**
         * `CfnVirtualNode.ServiceDiscoveryProperty.AWSCloudMap`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-servicediscovery.html#cfn-appmesh-virtualnode-servicediscovery-awscloudmap
         */
        readonly awsCloudMap?: CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ServiceDiscoveryProperty.DNS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-servicediscovery.html#cfn-appmesh-virtualnode-servicediscovery-dns
         */
        readonly dns?: CfnVirtualNode.DnsServiceDiscoveryProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-subjectalternativenamematchers.html
     */
    interface SubjectAlternativeNameMatchersProperty {
        /**
         * `CfnVirtualNode.SubjectAlternativeNameMatchersProperty.Exact`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-subjectalternativenamematchers.html#cfn-appmesh-virtualnode-subjectalternativenamematchers-exact
         */
        readonly exact?: string[];
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-subjectalternativenames.html
     */
    interface SubjectAlternativeNamesProperty {
        /**
         * `CfnVirtualNode.SubjectAlternativeNamesProperty.Match`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-subjectalternativenames.html#cfn-appmesh-virtualnode-subjectalternativenames-match
         */
        readonly match: CfnVirtualNode.SubjectAlternativeNameMatchersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tcptimeout.html
     */
    interface TcpTimeoutProperty {
        /**
         * `CfnVirtualNode.TcpTimeoutProperty.Idle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tcptimeout.html#cfn-appmesh-virtualnode-tcptimeout-idle
         */
        readonly idle?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontext.html
     */
    interface TlsValidationContextProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextProperty.SubjectAlternativeNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontext.html#cfn-appmesh-virtualnode-tlsvalidationcontext-subjectalternativenames
         */
        readonly subjectAlternativeNames?: CfnVirtualNode.SubjectAlternativeNamesProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.TlsValidationContextProperty.Trust`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontext.html#cfn-appmesh-virtualnode-tlsvalidationcontext-trust
         */
        readonly trust: CfnVirtualNode.TlsValidationContextTrustProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextacmtrust.html
     */
    interface TlsValidationContextAcmTrustProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextAcmTrustProperty.CertificateAuthorityArns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextacmtrust.html#cfn-appmesh-virtualnode-tlsvalidationcontextacmtrust-certificateauthorityarns
         */
        readonly certificateAuthorityArns: string[];
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextfiletrust.html
     */
    interface TlsValidationContextFileTrustProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextFileTrustProperty.CertificateChain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextfiletrust.html#cfn-appmesh-virtualnode-tlsvalidationcontextfiletrust-certificatechain
         */
        readonly certificateChain: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextsdstrust.html
     */
    interface TlsValidationContextSdsTrustProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextSdsTrustProperty.SecretName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextsdstrust.html#cfn-appmesh-virtualnode-tlsvalidationcontextsdstrust-secretname
         */
        readonly secretName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontexttrust.html
     */
    interface TlsValidationContextTrustProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextTrustProperty.ACM`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontexttrust.html#cfn-appmesh-virtualnode-tlsvalidationcontexttrust-acm
         */
        readonly acm?: CfnVirtualNode.TlsValidationContextAcmTrustProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.TlsValidationContextTrustProperty.File`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontexttrust.html#cfn-appmesh-virtualnode-tlsvalidationcontexttrust-file
         */
        readonly file?: CfnVirtualNode.TlsValidationContextFileTrustProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.TlsValidationContextTrustProperty.SDS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontexttrust.html#cfn-appmesh-virtualnode-tlsvalidationcontexttrust-sds
         */
        readonly sds?: CfnVirtualNode.TlsValidationContextSdsTrustProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodeconnectionpool.html
     */
    interface VirtualNodeConnectionPoolProperty {
        /**
         * `CfnVirtualNode.VirtualNodeConnectionPoolProperty.GRPC`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodeconnectionpool.html#cfn-appmesh-virtualnode-virtualnodeconnectionpool-grpc
         */
        readonly grpc?: CfnVirtualNode.VirtualNodeGrpcConnectionPoolProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeConnectionPoolProperty.HTTP`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodeconnectionpool.html#cfn-appmesh-virtualnode-virtualnodeconnectionpool-http
         */
        readonly http?: CfnVirtualNode.VirtualNodeHttpConnectionPoolProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeConnectionPoolProperty.HTTP2`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodeconnectionpool.html#cfn-appmesh-virtualnode-virtualnodeconnectionpool-http2
         */
        readonly http2?: CfnVirtualNode.VirtualNodeHttp2ConnectionPoolProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeConnectionPoolProperty.TCP`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodeconnectionpool.html#cfn-appmesh-virtualnode-virtualnodeconnectionpool-tcp
         */
        readonly tcp?: CfnVirtualNode.VirtualNodeTcpConnectionPoolProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodegrpcconnectionpool.html
     */
    interface VirtualNodeGrpcConnectionPoolProperty {
        /**
         * `CfnVirtualNode.VirtualNodeGrpcConnectionPoolProperty.MaxRequests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodegrpcconnectionpool.html#cfn-appmesh-virtualnode-virtualnodegrpcconnectionpool-maxrequests
         */
        readonly maxRequests: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodehttp2connectionpool.html
     */
    interface VirtualNodeHttp2ConnectionPoolProperty {
        /**
         * `CfnVirtualNode.VirtualNodeHttp2ConnectionPoolProperty.MaxRequests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodehttp2connectionpool.html#cfn-appmesh-virtualnode-virtualnodehttp2connectionpool-maxrequests
         */
        readonly maxRequests: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodehttpconnectionpool.html
     */
    interface VirtualNodeHttpConnectionPoolProperty {
        /**
         * `CfnVirtualNode.VirtualNodeHttpConnectionPoolProperty.MaxConnections`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodehttpconnectionpool.html#cfn-appmesh-virtualnode-virtualnodehttpconnectionpool-maxconnections
         */
        readonly maxConnections: number;
        /**
         * `CfnVirtualNode.VirtualNodeHttpConnectionPoolProperty.MaxPendingRequests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodehttpconnectionpool.html#cfn-appmesh-virtualnode-virtualnodehttpconnectionpool-maxpendingrequests
         */
        readonly maxPendingRequests?: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html
     */
    interface VirtualNodeSpecProperty {
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.BackendDefaults`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-backenddefaults
         */
        readonly backendDefaults?: CfnVirtualNode.BackendDefaultsProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.Backends`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-backends
         */
        readonly backends?: Array<CfnVirtualNode.BackendProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.Listeners`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-listeners
         */
        readonly listeners?: Array<CfnVirtualNode.ListenerProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.Logging`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-logging
         */
        readonly logging?: CfnVirtualNode.LoggingProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.ServiceDiscovery`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-servicediscovery
         */
        readonly serviceDiscovery?: CfnVirtualNode.ServiceDiscoveryProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodetcpconnectionpool.html
     */
    interface VirtualNodeTcpConnectionPoolProperty {
        /**
         * `CfnVirtualNode.VirtualNodeTcpConnectionPoolProperty.MaxConnections`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodetcpconnectionpool.html#cfn-appmesh-virtualnode-virtualnodetcpconnectionpool-maxconnections
         */
        readonly maxConnections: number;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare namespace CfnVirtualNode {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualservicebackend.html
     */
    interface VirtualServiceBackendProperty {
        /**
         * `CfnVirtualNode.VirtualServiceBackendProperty.ClientPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualservicebackend.html#cfn-appmesh-virtualnode-virtualservicebackend-clientpolicy
         */
        readonly clientPolicy?: CfnVirtualNode.ClientPolicyProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualServiceBackendProperty.VirtualServiceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualservicebackend.html#cfn-appmesh-virtualnode-virtualservicebackend-virtualservicename
         */
        readonly virtualServiceName: string;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualRouter`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 */
export interface CfnVirtualRouterProps {
    /**
     * `AWS::AppMesh::VirtualRouter.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-spec
     */
    readonly spec: CfnVirtualRouter.VirtualRouterSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualRouter.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshowner
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualRouter.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::AppMesh::VirtualRouter.VirtualRouterName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-virtualroutername
     */
    readonly virtualRouterName?: string;
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualRouter`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualRouter
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 */
export declare class CfnVirtualRouter extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualRouter";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVirtualRouter;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualRouterName
     */
    readonly attrVirtualRouterName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-spec
     */
    spec: CfnVirtualRouter.VirtualRouterSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualRouter.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshowner
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualRouter.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AppMesh::VirtualRouter.VirtualRouterName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-virtualroutername
     */
    virtualRouterName: string | undefined;
    /**
     * Create a new `AWS::AppMesh::VirtualRouter`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualRouterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualRouter`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualRouter
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 */
export declare namespace CfnVirtualRouter {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-portmapping.html
     */
    interface PortMappingProperty {
        /**
         * `CfnVirtualRouter.PortMappingProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-portmapping.html#cfn-appmesh-virtualrouter-portmapping-port
         */
        readonly port: number;
        /**
         * `CfnVirtualRouter.PortMappingProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-portmapping.html#cfn-appmesh-virtualrouter-portmapping-protocol
         */
        readonly protocol: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualRouter`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualRouter
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 */
export declare namespace CfnVirtualRouter {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterlistener.html
     */
    interface VirtualRouterListenerProperty {
        /**
         * `CfnVirtualRouter.VirtualRouterListenerProperty.PortMapping`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterlistener.html#cfn-appmesh-virtualrouter-virtualrouterlistener-portmapping
         */
        readonly portMapping: CfnVirtualRouter.PortMappingProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualRouter`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualRouter
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 */
export declare namespace CfnVirtualRouter {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterspec.html
     */
    interface VirtualRouterSpecProperty {
        /**
         * `CfnVirtualRouter.VirtualRouterSpecProperty.Listeners`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterspec.html#cfn-appmesh-virtualrouter-virtualrouterspec-listeners
         */
        readonly listeners: Array<CfnVirtualRouter.VirtualRouterListenerProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualService`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 */
export interface CfnVirtualServiceProps {
    /**
     * `AWS::AppMesh::VirtualService.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualService.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-spec
     */
    readonly spec: CfnVirtualService.VirtualServiceSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualService.VirtualServiceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-virtualservicename
     */
    readonly virtualServiceName: string;
    /**
     * `AWS::AppMesh::VirtualService.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshowner
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualService.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualService
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 */
export declare class CfnVirtualService extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualService";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVirtualService;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @external
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @external
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @external
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @external
     * @cloudformationAttribute VirtualServiceName
     */
    readonly attrVirtualServiceName: string;
    /**
     * `AWS::AppMesh::VirtualService.MeshName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualService.Spec`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-spec
     */
    spec: CfnVirtualService.VirtualServiceSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualService.VirtualServiceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-virtualservicename
     */
    virtualServiceName: string;
    /**
     * `AWS::AppMesh::VirtualService.MeshOwner`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshowner
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualService.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::VirtualService`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualServiceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualService
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 */
export declare namespace CfnVirtualService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualnodeserviceprovider.html
     */
    interface VirtualNodeServiceProviderProperty {
        /**
         * `CfnVirtualService.VirtualNodeServiceProviderProperty.VirtualNodeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualnodeserviceprovider.html#cfn-appmesh-virtualservice-virtualnodeserviceprovider-virtualnodename
         */
        readonly virtualNodeName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualService
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 */
export declare namespace CfnVirtualService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualrouterserviceprovider.html
     */
    interface VirtualRouterServiceProviderProperty {
        /**
         * `CfnVirtualService.VirtualRouterServiceProviderProperty.VirtualRouterName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualrouterserviceprovider.html#cfn-appmesh-virtualservice-virtualrouterserviceprovider-virtualroutername
         */
        readonly virtualRouterName: string;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualService
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 */
export declare namespace CfnVirtualService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualserviceprovider.html
     */
    interface VirtualServiceProviderProperty {
        /**
         * `CfnVirtualService.VirtualServiceProviderProperty.VirtualNode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualserviceprovider.html#cfn-appmesh-virtualservice-virtualserviceprovider-virtualnode
         */
        readonly virtualNode?: CfnVirtualService.VirtualNodeServiceProviderProperty | cdk.IResolvable;
        /**
         * `CfnVirtualService.VirtualServiceProviderProperty.VirtualRouter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualserviceprovider.html#cfn-appmesh-virtualservice-virtualserviceprovider-virtualrouter
         */
        readonly virtualRouter?: CfnVirtualService.VirtualRouterServiceProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`.
 *
 * @external
 * @cloudformationResource AWS::AppMesh::VirtualService
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 */
export declare namespace CfnVirtualService {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualservicespec.html
     */
    interface VirtualServiceSpecProperty {
        /**
         * `CfnVirtualService.VirtualServiceSpecProperty.Provider`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualservicespec.html#cfn-appmesh-virtualservice-virtualservicespec-provider
         */
        readonly provider?: CfnVirtualService.VirtualServiceProviderProperty | cdk.IResolvable;
    }
}
